/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.PlotText;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.VisADLineArray;
import visad.java2d.DisplayImplJ2D;
import visad.util.HersheyFont;

public class WeatherSymbols {
    private static HersheyFont wmoFont = new HersheyFont("wmo");
    private static final int numMetSymbols = 205;
    private static VisADLineArray[] metSymbols = new VisADLineArray[205];
    private static final int PRESENTWX_INDEX = 0;
    private static final int LOCLD_INDEX = 104;
    private static final int MIDCLD_INDEX = 113;
    private static final int HICLD_INDEX = 122;
    private static final int TNDCY_INDEX = 142;
    private static final int SKY_INDEX = 131;
    private static final int TURB_INDEX = 151;
    private static final int ICING_INDEX = 160;
    private static final int MISC_INDEX = 171;
    public static final int PRESENTWX_NUM = 104;
    public static final int LOCLD_NUM = 9;
    public static final int MIDCLD_NUM = 9;
    public static final int HICLD_NUM = 9;
    public static final int TNDCY_NUM = 9;
    public static final int SKY_NUM = 11;
    public static final int ICING_NUM = 9;
    public static final int TURB_NUM = 11;
    public static final int MISC_NUM = 34;
    public static final int LIGHTNING_NUM = 2;
    private static VisADLineArray[] lightningSymbols = new VisADLineArray[2];

    public static VisADLineArray[] getPresentWeatherSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 0, 104);
    }

    public static VisADLineArray[] getAllMetSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 0, 205);
    }

    public static VisADLineArray getPresentWeatherSymbol(int wxCode) {
        if (wxCode < 0 || wxCode > 104) {
            throw new IllegalArgumentException("unknown weather symbol: " + wxCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 0 + wxCode);
    }

    public static VisADLineArray[] getPressureTendencySymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 142, 9);
    }

    public static VisADLineArray getPressureTendencySymbol(int tendencyCode) {
        if (tendencyCode < 0 || tendencyCode >= 9) {
            throw new IllegalArgumentException("unknown pressure tendency symbol: " + tendencyCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 142 + tendencyCode);
    }

    public static VisADLineArray[] getCloudCoverageSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 131, 11);
    }

    public static VisADLineArray getCloudCoverageSymbol(int ccCode) {
        if (ccCode < 0 || ccCode >= 11) {
            throw new IllegalArgumentException("unknown cloud coverage symbol: " + ccCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 131 + ccCode);
    }

    public static VisADLineArray[] getLowCloudSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 104, 9);
    }

    public static VisADLineArray getLowCloudSymbol(int lcCode) {
        if (lcCode < 1 || lcCode > 9) {
            throw new IllegalArgumentException("unknown low cloud symbol: " + lcCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 104 + lcCode - 1);
    }

    public static VisADLineArray[] getMidCloudSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 113, 9);
    }

    public static VisADLineArray getMidCloudSymbol(int mcCode) {
        if (mcCode < 1 || mcCode > 9) {
            throw new IllegalArgumentException("unknown mid cloud symbol: " + mcCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 113 + mcCode - 1);
    }

    public static VisADLineArray[] getHighCloudSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 122, 9);
    }

    public static VisADLineArray getHighCloudSymbol(int hcCode) {
        if (hcCode < 1 || hcCode > 9) {
            throw new IllegalArgumentException("unknown high cloud symbol: " + hcCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 122 + hcCode - 1);
    }

    public static VisADLineArray[] getIcingSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 160, 9);
    }

    public static VisADLineArray getIcingSymbol(int icingCode) {
        if (icingCode < 0 || icingCode >= 9) {
            throw new IllegalArgumentException("unknown icing symbol: " + icingCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 160 + icingCode);
    }

    public static VisADLineArray[] getTurbulenceSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 151, 11);
    }

    public static VisADLineArray getTurbulenceSymbol(int turbCode) {
        if (turbCode < 0 || turbCode >= 11) {
            throw new IllegalArgumentException("unknown turbulence symbol: " + turbCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 151 + turbCode);
    }

    public static VisADLineArray[] getMiscSymbols() {
        return WeatherSymbols.subsetArray(metSymbols, 171, 34);
    }

    public static VisADLineArray getMiscSymbol(int miscCode) {
        if (miscCode < 0 || miscCode >= 34) {
            throw new IllegalArgumentException("unknown turbulence symbol: " + miscCode);
        }
        return WeatherSymbols.getVLAClone(metSymbols, 171 + miscCode);
    }

    public static VisADLineArray[] getLightningSymbols() {
        return WeatherSymbols.subsetArray(lightningSymbols, 0, 2);
    }

    public static VisADLineArray getLightningSymbol(int lghtCode) {
        if (lghtCode < 1 || lghtCode > 2) {
            throw new IllegalArgumentException("unknown lightning symbol: " + lghtCode);
        }
        return WeatherSymbols.getVLAClone(lightningSymbols, lghtCode);
    }

    private static VisADLineArray[] subsetArray(VisADLineArray[] array, int start, int number) {
        VisADLineArray[] retArray = new VisADLineArray[number];
        int i = 0;
        while (i < number) {
            retArray[i] = (VisADLineArray)array[start + i].clone();
            ++i;
        }
        return retArray;
    }

    private static VisADLineArray getVLAClone(VisADLineArray[] array, int index) {
        return (VisADLineArray)array[index].clone();
    }

    public static void main(String[] args) throws Exception {
        DisplayImplJ2D display = new DisplayImplJ2D("display");
        display.getDisplayRenderer().setBoxOn(false);
        double[] matrix = ((DisplayImpl)display).getProjectionControl().getMatrix();
        matrix[0] = 1.25;
        matrix[3] = -1.25;
        ((DisplayImpl)display).getProjectionControl().setMatrix(matrix);
        display.addMap(new ScalarMap(RealType.YAxis, Display.YAxis));
        display.addMap(new ScalarMap(RealType.XAxis, Display.XAxis));
        float[][] values = new float[3][220];
        int l = 0;
        int x = 0;
        while (x < 11) {
            int y = 0;
            while (y < 20) {
                values[0][l] = -1.0f + (float)y / 10.0f;
                values[1][l] = 1.0f - (float)x / 4.0f;
                values[2][l] = l++;
                ++y;
            }
            ++x;
        }
        Gridded3DSet set = new Gridded3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, values, l);
        ScalarMap shapeMap = new ScalarMap(RealType.ZAxis, Display.Shape);
        display.addMap(shapeMap);
        ShapeControl sc = (ShapeControl)shapeMap.getControl();
        sc.setShapeSet(new Integer1DSet(l));
        sc.setShapes(WeatherSymbols.getAllMetSymbols());
        sc.setScale(0.1f);
        DataReferenceImpl ref = new DataReferenceImpl("ref");
        ref.setData(set);
        display.addReference(ref);
        JFrame frame = new JFrame("Weather Symbol Plot Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(display.getComponent());
        frame.pack();
        frame.setSize(500, 500);
        frame.show();
    }

    static {
        double[] start = new double[]{0.0, -0.5, 0.0};
        double[] base = new double[]{1.0, 0.0, 0.0};
        double[] up = new double[]{0.0, 1.0, 0.0};
        try {
            int i = 0;
            while (i < 205) {
                WeatherSymbols.metSymbols[i] = PlotText.render_font(new String(new byte[]{(byte)(i + 32)}, 0), wmoFont, start, base, up, true);
                ++i;
            }
        }
        catch (Exception excp) {
            System.err.println("Unable to intialize symbols properly");
        }
        VisADLineArray flash = new VisADLineArray();
        flash.coordinates = new float[]{0.25f, 0.8f, 0.0f, -0.25f, 0.0f, 0.0f, -0.25f, 0.0f, 0.0f, 0.25f, -0.8f, 0.0f, 0.0f, -0.8f, 0.0f, 0.25f, -0.8f, 0.0f, 0.25f, -0.8f, 0.0f, 0.25f, -0.55f, 0.0f};
        flash.vertexCount = flash.coordinates.length / 3;
        WeatherSymbols.lightningSymbols[0] = flash;
        flash = new VisADLineArray();
        flash.coordinates = new float[]{-0.25f, 0.8f, 0.0f, 0.25f, 0.0f, 0.0f, 0.25f, 0.0f, 0.0f, -0.25f, -0.8f, 0.0f, 0.0f, -0.8f, 0.0f, -0.25f, -0.8f, 0.0f, -0.25f, -0.8f, 0.0f, -0.25f, -0.55f, 0.0f};
        flash.vertexCount = flash.coordinates.length / 3;
        WeatherSymbols.lightningSymbols[1] = flash;
    }
}

