/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import visad.Control;
import visad.ValueControl;
import visad.VisADException;
import visad.browser.Convert;
import visad.java3d.AVControlJ3D;
import visad.java3d.DisplayImplJ3D;

public class ValueControlJ3D
extends AVControlJ3D
implements ValueControl {
    private double Value = 0.0;

    public ValueControlJ3D(DisplayImplJ3D d) {
        super(d);
    }

    public void setValue(double value) throws VisADException, RemoteException {
        this.Value = value;
        this.selectSwitches(this.Value, null);
        this.changeControl(true);
    }

    public void init() throws VisADException {
        this.selectSwitches(this.Value, null);
    }

    public double getValue() {
        return this.Value;
    }

    public String getSaveString() {
        return "" + this.Value;
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        this.setValue(Convert.getDouble(save.trim()));
    }

    public void syncControl(Control rmt) throws VisADException {
        double rv;
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof ValueControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        ValueControl vc = (ValueControl)((Object)rmt);
        boolean changed = false;
        double v = this.getValue();
        if (Math.abs(v - (rv = vc.getValue())) > 0.001) {
            try {
                this.setValue(rv);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not set value: " + re.getMessage());
            }
        }
    }

    public boolean equals(Object o) {
        double rv;
        if (!super.equals(o)) {
            return false;
        }
        ValueControlJ3D vc = (ValueControlJ3D)o;
        double v = this.getValue();
        return !(Math.abs(v - (rv = vc.getValue())) > 0.001);
    }
}

