/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;
import visad.georef.NavigatedCoordinateSystem;

public abstract class MapProjection
extends NavigatedCoordinateSystem {
    public MapProjection(RealTupleType reference, Unit[] units) throws VisADException {
        super(reference, units);
        if (!reference.equals(RealTupleType.LatitudeLongitudeTuple) && !reference.equals(RealTupleType.SpatialEarth2DTuple)) {
            throw new CoordinateSystemException("MapProjection: Reference must be LatitudeLongitudeTuple or SpatialEarth2DTuple");
        }
    }

    public abstract Rectangle2D getDefaultMapArea();

    public boolean isXYOrder() {
        return true;
    }

    public boolean isLatLonOrder() {
        return this.getLatitudeIndex() == 0;
    }

    public LatLonPoint getCenterLatLon() throws VisADException {
        double[][] dArrayArray;
        Rectangle2D rect = this.getDefaultMapArea();
        if (this.isXYOrder()) {
            double[][] dArrayArray2 = new double[2][];
            dArrayArray2[0] = new double[]{rect.getCenterX()};
            dArrayArray = dArrayArray2;
            dArrayArray2[1] = new double[]{rect.getCenterY()};
        } else {
            double[][] dArrayArray3 = new double[2][];
            dArrayArray3[0] = new double[]{rect.getCenterY()};
            dArrayArray = dArrayArray3;
            dArrayArray3[1] = new double[]{rect.getCenterX()};
        }
        double[][] xy = dArrayArray;
        double[][] latlon = this.toReference(xy);
        double lat = this.isLatLonOrder() ? CommonUnit.degree.toThis(latlon[0][0], this.getReferenceUnits()[0]) : CommonUnit.degree.toThis(latlon[1][0], this.getReferenceUnits()[1]);
        double lon = this.isLatLonOrder() ? CommonUnit.degree.toThis(latlon[1][0], this.getReferenceUnits()[1]) : CommonUnit.degree.toThis(latlon[0][0], this.getReferenceUnits()[0]);
        LatLonTuple llp = null;
        try {
            llp = new LatLonTuple(lat, lon);
        }
        catch (RemoteException re) {}
        return llp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MapProjection: \n");
        buf.append("  Reference = ");
        buf.append(this.getReference());
        buf.append("\n");
        buf.append("  DefaultMapArea = ");
        buf.append(this.getDefaultMapArea());
        return buf.toString();
    }
}

