/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;

public class VisADForm
extends Form
implements FormFileInformer {
    private static int num = 0;
    private boolean allowBinary = false;

    public VisADForm(boolean allowBinary) {
        this();
        this.allowBinary = allowBinary;
    }

    public VisADForm() {
        super("VisADForm" + num++);
    }

    public boolean isThisType(String name) {
        return name.endsWith(".vad") || name.endsWith(".VAD");
    }

    public boolean isThisType(byte[] block) {
        return BinaryReader.isMagic(block);
    }

    public String[] getDefaultSuffixes() {
        String[] suff = new String[]{"vad"};
        return suff;
    }

    public synchronized void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("VisADForm.add");
    }

    public synchronized FormNode getForms(Data data) {
        return null;
    }

    public synchronized DataImpl open(String id) throws BadFormException, IOException, VisADException {
        IOException savedIOE = null;
        VisADException savedVE = null;
        try {
            return this.readData(new BinaryReader(id));
        }
        catch (IOException ioe) {
            savedIOE = ioe;
        }
        catch (VisADException ve) {
            savedVE = ve;
        }
        try {
            return this.readSerial(new FileInputStream(id));
        }
        catch (ClassNotFoundException cnfe) {
            if (savedIOE != null) {
                throw savedIOE;
            }
            if (savedVE != null) {
                throw savedVE;
            }
            throw new BadFormException("Could not read file \"" + id + "\": " + cnfe.getMessage());
        }
        catch (IOException ioe) {
            if (savedIOE != null) {
                throw savedIOE;
            }
            if (savedVE != null) {
                throw savedVE;
            }
            throw ioe;
        }
    }

    public synchronized DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        IOException savedIOE = null;
        VisADException savedVE = null;
        try {
            return this.readData(new BinaryReader(url.openStream()));
        }
        catch (IOException ioe) {
            savedIOE = ioe;
        }
        catch (VisADException ve) {
            savedVE = ve;
        }
        try {
            return this.readSerial(url.openStream());
        }
        catch (ClassNotFoundException cnfe) {
            if (savedIOE != null) {
                throw savedIOE;
            }
            if (savedVE != null) {
                throw savedVE;
            }
            throw new BadFormException("Could not read URL " + url + ": " + cnfe.getMessage());
        }
        catch (IOException ioe) {
            if (savedIOE != null) {
                throw savedIOE;
            }
            if (savedVE != null) {
                throw savedVE;
            }
            throw ioe;
        }
    }

    public DataImpl readData(BinaryReader rdr) throws IOException, VisADException {
        DataImpl di = rdr.getData();
        try {
            rdr.close();
        }
        catch (IOException ioe) {}
        return di;
    }

    public DataImpl readSerial(InputStream inputStream) throws ClassNotFoundException, IOException {
        BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
        ObjectInputStream objectStream = new ObjectInputStream(bufferedStream);
        return (DataImpl)objectStream.readObject();
    }

    private synchronized void saveBinary(String id, Data data, boolean replace, boolean bigObject) throws BadFormException, IOException, RemoteException, VisADException {
        File file = new File(id);
        if (!replace && file.exists()) {
            throw new IllegalArgumentException("File \"" + id + "\" exists");
        }
        BinaryWriter writer = new BinaryWriter(file);
        writer.save((DataImpl)data, bigObject);
        writer.close();
    }

    private synchronized void saveSerial(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        FileOutputStream fileStream = null;
        if (replace) {
            fileStream = new FileOutputStream(id);
        } else {
            File file = new File(id);
            if (file.exists()) {
                throw new BadFormException("VisADSerialForm.save(" + id + "): exists");
            }
            fileStream = new FileOutputStream(file);
        }
        BufferedOutputStream bufferedStream = new BufferedOutputStream(fileStream);
        ObjectOutputStream objectStream = new ObjectOutputStream(bufferedStream);
        DataImpl local_data = data.local();
        objectStream.writeObject(local_data);
        objectStream.flush();
        fileStream.close();
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        this.save(id, data, replace, false);
    }

    public synchronized void save(String id, Data data, boolean replace, boolean bigObject) throws BadFormException, IOException, RemoteException, VisADException {
        if (this.allowBinary) {
            this.saveBinary(id, data, replace, bigObject);
        } else {
            this.saveSerial(id, data, replace);
        }
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("to convert a file to a VisAD binary file, run:");
            System.out.println("  java visad.data.visad.VisADForm in_file out_file");
            System.out.println("to test read a binary or serial VisAD file, run:");
            System.out.println("or  'java visad.data.visad.VisADForm in_file'");
        } else if (args.length == 1) {
            VisADForm form = new VisADForm();
            if (args[0].startsWith("http://")) {
                URL url = new URL(args[0]);
                form.open(url);
            } else {
                form.open(args[0]);
            }
        } else if (args.length == 2) {
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            VisADForm form = new VisADForm();
            form.save(args[1], data, true);
        }
        System.exit(0);
    }
}

