/*
 * Decompiled with CFR 0.152.
 */
package visad.data.tiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BitBuffer {
    private static final int BUFFER_SIZE = 8192;
    private InputStream in;
    private int currentByte;
    private int currentBit;
    private byte[] byteBuffer = new byte[8192];
    private int eofByte;
    private int[] backMask;
    private int[] frontMask;
    private boolean eofFlag;

    public BitBuffer(InputStream i) throws IOException {
        this.in = i;
        this.currentByte = 0;
        this.currentBit = 0;
        this.eofByte = this.in.read(this.byteBuffer);
        this.eofFlag = false;
        if (this.eofByte < 1) {
            this.eofFlag = true;
        }
        this.backMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
        this.frontMask = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
    }

    public long skipBits(long bitsToSkip) throws IOException {
        long skipBytes = bitsToSkip / 8L;
        long skipBits = bitsToSkip % 8L;
        long newByte = (long)this.currentByte + skipBytes;
        long newBit = (long)this.currentBit + skipBits;
        long toReturn = bitsToSkip;
        if (newBit > 8L) {
            newBit -= 8L;
            ++newByte;
        }
        if (newByte >= (long)this.eofByte) {
            if (this.eofByte != 8192) {
                this.eofFlag = true;
                this.currentByte = this.eofByte;
                this.currentBit = 0;
                toReturn = 8 - this.currentBit + 8 * (this.eofByte - this.currentByte);
            } else {
                newByte -= 8192L;
                long skipped = -1L;
                while (skipped != 0L) {
                    skipped = this.in.skip(newByte);
                    newByte -= skipped;
                }
                if (newByte != 0L) {
                    this.eofFlag = true;
                } else {
                    this.currentByte = 0;
                    this.currentBit = (int)newBit;
                    this.eofByte = this.in.read(this.byteBuffer);
                }
            }
        } else {
            this.currentByte = (int)newByte;
            this.currentBit = (int)newBit;
        }
        return toReturn;
    }

    public int getBits(int bitsToRead) throws IOException, FileNotFoundException {
        if (bitsToRead == 0) {
            return 0;
        }
        if (this.eofFlag) {
            return -1;
        }
        int toStore = 0;
        while (bitsToRead != 0 && !this.eofFlag) {
            int cb;
            if (bitsToRead >= 8 - this.currentBit) {
                if (this.currentBit == 0) {
                    toStore <<= 8;
                    cb = this.byteBuffer[this.currentByte];
                    toStore += cb < 0 ? 256 + cb : cb;
                    bitsToRead -= 8;
                    ++this.currentByte;
                } else {
                    toStore <<= 8 - this.currentBit;
                    toStore += this.byteBuffer[this.currentByte] & this.backMask[8 - this.currentBit];
                    bitsToRead -= 8 - this.currentBit;
                    this.currentBit = 0;
                    ++this.currentByte;
                }
            } else {
                toStore <<= bitsToRead;
                cb = this.byteBuffer[this.currentByte];
                cb = cb < 0 ? 256 + cb : cb;
                toStore += (cb & 255 - this.frontMask[this.currentBit]) >> 8 - (this.currentBit + bitsToRead);
                this.currentBit += bitsToRead;
                bitsToRead = 0;
            }
            if (this.currentByte == 8192) {
                this.eofByte = this.in.read(this.byteBuffer);
                this.currentByte = 0;
            }
            if (this.currentByte != this.eofByte) continue;
            this.eofFlag = true;
            return toStore;
        }
        return toStore;
    }

    public static void main(String[] args) throws Exception {
        BitBuffer b = new BitBuffer(new FileInputStream(new File(args[0])));
        int i = 1;
        int current = 0;
        int numBits = Integer.parseInt(args[1]);
        while (current != -1) {
            current = b.getBits(numBits);
            System.out.println(i + ": " + current);
            ++i;
        }
    }
}

