/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.Plain;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.StandardQuantityDB;

public class InputNetcdf
implements Serializable {
    private String pathname = null;
    private DataImpl data = null;
    private QuantityDB quantityDB;
    private final PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public InputNetcdf() {
        this.quantityDB = StandardQuantityDB.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuantityDB(QuantityDB db) throws BadFormException, IOException, VisADException {
        String name;
        DataImpl oldData;
        QuantityDB oldDB;
        if (db == null) {
            throw new NullPointerException();
        }
        InputNetcdf inputNetcdf = this;
        synchronized (inputNetcdf) {
            oldDB = this.quantityDB;
            oldData = this.data;
            name = this.pathname;
        }
        DataImpl newData = new Plain(db).open(name);
        InputNetcdf inputNetcdf2 = this;
        synchronized (inputNetcdf2) {
            this.quantityDB = db;
            this.data = newData;
        }
        this.changes.firePropertyChange("quantityDB", oldDB, db);
        this.changes.firePropertyChange("data", oldData, newData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathname(String name) throws IOException, VisADException, BadFormException {
        DataImpl newData;
        DataImpl oldData;
        String oldName;
        if (name == null) {
            InputNetcdf inputNetcdf = this;
            synchronized (inputNetcdf) {
                oldName = this.pathname;
                oldData = this.data;
            }
            newData = null;
        } else {
            QuantityDB db;
            InputNetcdf inputNetcdf = this;
            synchronized (inputNetcdf) {
                db = this.quantityDB;
                oldData = this.data;
                oldName = this.pathname;
            }
            newData = new Plain(db).open(name);
            InputNetcdf inputNetcdf2 = this;
            synchronized (inputNetcdf2) {
                this.pathname = name;
                this.data = newData;
            }
        }
        this.changes.firePropertyChange("pathname", oldName, name);
        this.changes.firePropertyChange("data", oldData, newData);
    }

    public synchronized String getPathname() {
        return this.pathname;
    }

    public synchronized DataImpl getData() {
        return this.data;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener p) {
        this.changes.addPropertyChangeListener(p);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener p) {
        this.changes.removePropertyChangeListener(p);
    }
}

