/*
 * Decompiled with CFR 0.152.
 */
package visad.data.ij;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class ImageJForm
extends Form
implements FormFileInformer,
FormBlockReader,
FormProgressInformer {
    private static int num = 0;
    private static final String[] suffixes = new String[]{"tif", "tiff", "dicom", "fits", "pgm", "jpg", "jpeg", "gif", "lut", "bmp", "zip", "roi"};
    private static final String NO_IJ = "This feature requires ImageJ, avialable online at http://rsb.info.nih.gov/ij/download.html";
    private ReflectedUniverse r = new ReflectedUniverse();
    private boolean noImageJ = false;
    private double percent = -1.0;

    public ImageJForm() {
        super("ImageJForm" + num++);
        try {
            this.r.exec("import ij.ImagePlus");
            this.r.exec("import ij.ImageStack");
            this.r.exec("import ij.io.Opener");
            this.r.exec("import ij.process.ImageProcessor");
            this.r.exec("opener = new Opener()");
        }
        catch (VisADException exc) {
            this.noImageJ = true;
        }
    }

    public boolean isThisType(String name) {
        int i = 0;
        while (i < suffixes.length) {
            if (name.toLowerCase().endsWith(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[suffixes.length];
        System.arraycopy(suffixes, 0, s, 0, suffixes.length);
        return s;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new BadFormException("ImageJForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("ImageJForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        if (this.noImageJ) {
            throw new BadFormException(NO_IJ);
        }
        this.percent = 0.0;
        File file = new File(id);
        this.r.setVar("dir", file.getParent() + System.getProperty("file.separator"));
        this.r.setVar("name", file.getName());
        this.r.exec("image = opener.openImage(dir, name)");
        this.r.exec("size = image.getStackSize()");
        int size = (Integer)this.r.getVar("size");
        if (size == 1) {
            return DataUtility.makeField((Image)this.r.exec("image.getImage()"));
        }
        this.r.exec("stack = image.getStack()");
        Data[] fields = new FieldImpl[size];
        int i = 0;
        while (i < size) {
            this.r.setVar("i1", i + 1);
            this.r.exec("ip = stack.getProcessor(i1)");
            fields[i] = DataUtility.makeField((Image)this.r.exec("ip.createImage()"));
            ++i;
        }
        RealType time = RealType.getRealType("time");
        FunctionType time_function = new FunctionType(time, fields[0].getType());
        Integer1DSet time_set = new Integer1DSet(size);
        FieldImpl time_field = new FieldImpl(time_function, time_set);
        time_field.setSamples(fields, false);
        this.percent = -1.0;
        return time_field;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        if (this.noImageJ) {
            throw new BadFormException(NO_IJ);
        }
        this.r.setVar("url", url.toString());
        this.r.exec("image = opener.openURL(url)");
        return DataUtility.makeField((Image)this.r.exec("image.getImage()"));
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("To test read an image file, run:");
            System.out.println("  java visad.data.ij.ImageJForm in_file");
            System.exit(2);
        }
        ImageJForm form = new ImageJForm();
        System.out.print("Reading " + args[0] + " ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType().prettyString());
        System.exit(0);
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        if (block_number != 0) {
            throw new BadFormException("Invalid image number: " + block_number);
        }
        return this.open(id);
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        return 1;
    }

    public void close() throws BadFormException, IOException, VisADException {
    }

    public double getPercentComplete() {
        return this.percent;
    }
}

