/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.MathType;
import visad.Set;
import visad.VisADException;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.HdfeosData;
import visad.data.hdfeos.HdfeosDomain;

public class HdfeosField
extends HdfeosData {
    HdfeosDomain domain;
    HdfeosData range;
    FunctionType mathtype;
    EosStruct struct;

    HdfeosField(HdfeosDomain domain, HdfeosData range) throws VisADException, RemoteException {
        this.domain = domain;
        this.range = range;
        this.struct = domain.getStruct();
        this.mathtype = this.makeType();
    }

    public MathType getType() throws VisADException {
        return this.mathtype;
    }

    public DataImpl getData() throws VisADException, RemoteException {
        Set domain = this.domain.getData();
        int length = domain.getLength();
        FieldImpl new_field = new FieldImpl(this.mathtype, domain);
        int ii = 0;
        while (ii < length) {
            int[] indexes = new int[]{ii};
            new_field.setSample(ii, (Data)this.range.getData(indexes));
            ++ii;
        }
        return new_field;
    }

    public DataImpl getData(int[] indexes) throws VisADException, RemoteException {
        Set domain = this.domain.getData(indexes);
        int length = domain.getLength();
        int n_indexes = indexes.length;
        int[] new_indexes = new int[n_indexes + 1];
        System.arraycopy(indexes, 0, new_indexes, 0, n_indexes);
        FieldImpl new_field = new FieldImpl(this.mathtype, domain);
        int ii = 0;
        while (ii < length) {
            new_indexes[n_indexes] = ii;
            new_field.setSample(ii, (Data)this.range.getData(new_indexes));
            ++ii;
        }
        return new_field;
    }

    public DataImpl getAdaptedData() throws VisADException, RemoteException {
        Set domain = this.domain.getData();
        int length = domain.getLength();
        FieldImpl new_field = new FieldImpl(this.mathtype, domain);
        int ii = 0;
        while (ii < length) {
            int[] indexes = new int[]{ii};
            new_field.setSample(ii, (Data)this.range.getAdaptedData(indexes), false);
            ++ii;
        }
        return new_field;
    }

    public DataImpl getAdaptedData(int[] indexes) throws VisADException, RemoteException {
        Set domain = this.domain.getData(indexes);
        int length = domain.getLength();
        int n_indexes = indexes.length;
        int[] new_indexes = new int[n_indexes + 1];
        System.arraycopy(indexes, 0, new_indexes, 0, n_indexes);
        FieldImpl new_field = new FieldImpl(this.mathtype, domain);
        int ii = 0;
        while (ii < length) {
            new_indexes[n_indexes] = ii;
            new_field.setSample(ii, (Data)this.range.getAdaptedData(new_indexes), false);
            ++ii;
        }
        return new_field;
    }

    private FunctionType makeType() throws VisADException, RemoteException {
        MathType domain_type = this.domain.getType();
        MathType range_type = this.range.getType();
        FunctionType f_type = new FunctionType(domain_type, range_type);
        return f_type;
    }
}

