/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.data.MetadataReader;
import visad.data.tiff.BitBuffer;
import visad.data.tiff.TiffTools;

public class MetamorphForm
extends Form
implements FormBlockReader,
FormFileInformer,
FormProgressInformer,
MetadataReader {
    private static final int TIFF_MAGIC_NUMBER = 42;
    private static final int LITTLE_ENDIAN = 73;
    private static final int BITS_PER_SAMPLE_FIELD = 258;
    private static final int STRIP_OFFSET_FIELD = 273;
    private static final int METAMORPH_ID = 33629;
    private static final int UIC1TAG = 33628;
    private static final int UIC2TAG = 33629;
    private static final int UIC3TAG = 33630;
    private static final int UIC4TAG = 33631;
    private static int formCount = 0;
    private static RealTupleType domainTuple;
    private static FunctionType funcRowColPix;
    private static FunctionType funcRowColRGB;
    private String currentId;
    private RandomAccessFile r;
    private Hashtable ifdHash;
    private int[] dimensions;
    private Linear2DSet pixelSet;
    private double percent;

    public MetamorphForm() {
        super("MetamorphForm" + formCount++);
    }

    public boolean isThisType(String name) {
        return name.toLowerCase().endsWith(".stk");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block[0] != 73) {
            return false;
        }
        if (block[1] != 73) {
            return false;
        }
        if (block[2] != 42) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        int ifdlocation = MetamorphForm.batoi(new byte[]{block[4], block[5], block[6], block[7]});
        if (ifdlocation + 1 > block.length) {
            return true;
        }
        int ifdnumber = MetamorphForm.batoi(new byte[]{block[ifdlocation], block[ifdlocation + 1]});
        int i = 0;
        while (i < ifdnumber) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return true;
            }
            int ifdtag = MetamorphForm.batoi(new byte[]{block[ifdlocation + 2 + i * 12], block[ifdlocation + 3 + i * 12]});
            if (ifdtag == 33629) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"stk"};
    }

    public void save(String id, Data data, boolean replace) throws UnimplementedException {
        throw new UnimplementedException("MetamorphForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("MetamorphForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType index = RealType.getRealType("index");
            FunctionType indexFunction = new FunctionType(index, fields[0].getType());
            Integer1DSet indexSet = new Integer1DSet(nImages);
            FieldImpl indexField = new FieldImpl(indexFunction, indexSet);
            indexField.setSamples(fields, false);
            data = indexField;
        }
        this.close();
        this.percent = Double.NaN;
        return data;
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        throw new BadFormException("MetamorphForm.open(URL)");
    }

    public DataImpl open(String id, int blockNumber) throws BadFormException, IOException, VisADException {
        if (id != this.currentId) {
            this.initFile(id);
        }
        int[] bitsPerPixel = null;
        int photoInterp = TiffTools.getPhotometricInterpretation(this.r);
        Vector v = (Vector)this.ifdHash.get(new Integer(258));
        if (v == null) {
            throw new BadFormException("Bits per sample field not found");
        }
        bitsPerPixel = photoInterp == 2 ? TiffTools.getIFDArray(this.r, v) : new int[]{(Integer)v.get(2)};
        v = (Vector)this.ifdHash.get(new Integer(273));
        if (v == null) {
            throw new BadFormException("Strip offset field not found");
        }
        this.r.seek(TiffTools.getIFDArray(this.r, v)[0]);
        BitBuffer bb = new BitBuffer(new FileInputStream(this.currentId));
        bb.skipBits(8L * this.r.getFilePointer());
        FlatField frameField = null;
        if (photoInterp == 2) {
            long toSkip = this.dimensions[0] * this.dimensions[1];
            toSkip *= (long)(bitsPerPixel[0] + bitsPerPixel[1] + bitsPerPixel[2]);
            bb.skipBits(toSkip *= (long)blockNumber);
            float[][] flatSamples = new float[3][this.dimensions[0] * this.dimensions[1]];
            int y = 0;
            while (y < this.dimensions[1]) {
                int x = 0;
                while (x < this.dimensions[0]) {
                    int c = 0;
                    while (c < 3) {
                        flatSamples[c][x + y * this.dimensions[0]] = bb.getBits(bitsPerPixel[c]);
                        ++c;
                    }
                    ++x;
                }
                ++y;
            }
            frameField = new FlatField(funcRowColRGB, this.pixelSet);
            frameField.setSamples(flatSamples);
        } else {
            long toSkip = this.dimensions[0] * this.dimensions[1] * bitsPerPixel[0] * blockNumber;
            bb.skipBits(toSkip);
            float[][] flatSamples = new float[1][this.dimensions[0] * this.dimensions[1]];
            if (bitsPerPixel[0] == 8) {
                int y = 0;
                while (y < this.dimensions[1]) {
                    int x = 0;
                    while (x < this.dimensions[0]) {
                        flatSamples[0][x + y * this.dimensions[0]] = bb.getBits(bitsPerPixel[0]);
                        ++x;
                    }
                    ++y;
                }
            } else if (bitsPerPixel[0] % 8 == 0) {
                int bytesPerPixel = bitsPerPixel[0] / 8;
                int y = 0;
                while (y < this.dimensions[1]) {
                    int x = 0;
                    while (x < this.dimensions[0]) {
                        int[] thisPixel = new int[bytesPerPixel];
                        int b = 0;
                        while (b < bytesPerPixel) {
                            thisPixel[b] = bb.getBits(8);
                            ++b;
                        }
                        int b2 = bytesPerPixel - 1;
                        while (b2 >= 0) {
                            float[] fArray = flatSamples[0];
                            int n = x + y * this.dimensions[0];
                            fArray[n] = fArray[n] * 256.0f;
                            float[] fArray2 = flatSamples[0];
                            int n2 = x + y * this.dimensions[0];
                            fArray2[n2] = fArray2[n2] + (float)thisPixel[b2];
                            --b2;
                        }
                        ++x;
                    }
                    ++y;
                }
            } else {
                int y = 0;
                while (y < this.dimensions[1]) {
                    int x = 0;
                    while (x < this.dimensions[0]) {
                        flatSamples[0][x + y * this.dimensions[0]] = bb.getBits(bitsPerPixel[0]);
                        ++x;
                    }
                    ++y;
                }
            }
            frameField = new FlatField(funcRowColPix, this.pixelSet);
            frameField.setSamples(flatSamples);
        }
        return frameField;
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (id != this.currentId) {
            this.initFile(id);
        }
        return this.dimensions[2];
    }

    public void close() throws BadFormException, IOException, VisADException {
        if (this.r != null) {
            this.r.close();
            this.r = null;
        }
    }

    public double getPercentComplete() {
        return this.percent;
    }

    public Hashtable getMetadata(String id) throws BadFormException, IOException, VisADException {
        int offset;
        Hashtable<String, Object> metadata = new Hashtable<String, Object>();
        if (id != this.currentId) {
            this.initFile(id);
        }
        if ((offset = TiffTools.getIFDValue(this.ifdHash, 33631)) < 0) {
            throw new BadFormException("UIC4TAG not found");
        }
        this.r.seek(offset);
        int currentcode = -1;
        Vector v = (Vector)this.ifdHash.get(new Integer(33629));
        if (v == null) {
            throw new BadFormException("Metamorph ID not found");
        }
        int planes = (Integer)v.get(1);
        block47: while (currentcode != 0) {
            byte[] toread = new byte[2];
            this.r.read(toread);
            currentcode = TiffTools.batoi(toread);
            toread = new byte[4];
            switch (currentcode) {
                case 0: {
                    this.r.read(toread);
                    metadata.put("AutoScale", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 1: {
                    this.r.read(toread);
                    metadata.put("MinScale", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 2: {
                    this.r.read(toread);
                    metadata.put("MaxScale", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 3: {
                    this.r.read(toread);
                    metadata.put("Spatial Calibration", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 4: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    this.r.read(toread);
                    int denom = MetamorphForm.batoi(toread);
                    metadata.put("XCalibration", new Double((double)num / (double)denom));
                    break;
                }
                case 5: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    this.r.read(toread);
                    int denom = MetamorphForm.batoi(toread);
                    metadata.put("YCalibration", new Double((double)num / (double)denom));
                    break;
                }
                case 6: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    toread = new byte[num];
                    this.r.read(toread);
                    metadata.put("CalibrationUnits", new String(toread));
                    break;
                }
                case 7: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    toread = new byte[num];
                    this.r.read(toread);
                    metadata.put("Name", new String(toread));
                    break;
                }
                case 8: {
                    this.r.read(toread);
                    metadata.put("ThreshState", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 9: {
                    this.r.read(toread);
                    metadata.put("ThreshStateRed", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 11: {
                    this.r.read(toread);
                    metadata.put("ThreshStateGreen", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 12: {
                    this.r.read(toread);
                    metadata.put("ThreshStateBlue", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 13: {
                    this.r.read(toread);
                    metadata.put("ThreshStateLo", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 14: {
                    this.r.read(toread);
                    metadata.put("ThreshStateHi", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 15: {
                    this.r.read(toread);
                    metadata.put("Zoom", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 16: {
                    long alpha;
                    long a;
                    this.r.read(toread);
                    int julian = MetamorphForm.batoi(toread);
                    long z = julian + 1;
                    if (z < 2299161L) {
                        a = z;
                    } else {
                        alpha = (long)(((double)z - 1867216.25) / 36524.25);
                        a = z + 1L + alpha - alpha / 4L;
                    }
                    long b = a > 1721423L ? a + 1524L : a + 1158L;
                    long c = (long)(((double)b - 122.1) / 365.25);
                    long d = (long)(365.25 * (double)c);
                    long e = (long)((double)(b - d) / 30.6001);
                    short day = (short)(b - d - (long)(30.6001 * (double)e));
                    short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
                    short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
                    String thedate = new String(day + "/" + month + "/" + year);
                    this.r.read(toread);
                    int millis = MetamorphForm.batoi(toread);
                    int ms = millis % 1000;
                    millis -= ms;
                    int seconds = (millis /= 1000) % 60;
                    millis -= seconds;
                    int minutes = (millis /= 60) % 60;
                    millis -= minutes;
                    int hours = millis /= 60;
                    String thetime = new String(hours + ":" + minutes + ":" + seconds + "." + ms);
                    metadata.put("CreateTime", thedate + " " + thetime);
                    break;
                }
                case 17: {
                    long alpha;
                    long a;
                    this.r.read(toread);
                    int julian = MetamorphForm.batoi(toread);
                    long z = julian + 1;
                    if (z < 2299161L) {
                        a = z;
                    } else {
                        alpha = (long)(((double)z - 1867216.25) / 36524.25);
                        a = z + 1L + alpha - alpha / 4L;
                    }
                    long b = a > 1721423L ? a + 1524L : a + 1158L;
                    long c = (long)(((double)b - 122.1) / 365.25);
                    long d = (long)(365.25 * (double)c);
                    long e = (long)((double)(b - d) / 30.6001);
                    short day = (short)(b - d - (long)(30.6001 * (double)e));
                    short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
                    short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
                    String thedate = new String(day + "/" + month + "/" + year);
                    this.r.read(toread);
                    int millis = MetamorphForm.batoi(toread);
                    int ms = millis % 1000;
                    millis -= ms;
                    int seconds = (millis /= 1000) % 60;
                    millis -= seconds;
                    int minutes = (millis /= 60) % 60;
                    millis -= minutes;
                    int hours = millis /= 60;
                    String thetime = new String(hours + ":" + minutes + ":" + seconds + "." + ms);
                    metadata.put("LastSavedTime", thedate + " " + thetime);
                    break;
                }
                case 18: {
                    this.r.read(toread);
                    metadata.put("currentBuffer", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 19: {
                    this.r.read(toread);
                    metadata.put("grayFit", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 20: {
                    this.r.read(toread);
                    metadata.put("grayPointCount", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 21: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    this.r.read(toread);
                    int denom = MetamorphForm.batoi(toread);
                    metadata.put("grayX", new Double((double)num / (double)denom));
                    break;
                }
                case 22: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    this.r.read(toread);
                    int denom = MetamorphForm.batoi(toread);
                    metadata.put("gray", new Double((double)num / (double)denom));
                    break;
                }
                case 23: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    this.r.read(toread);
                    int denom = MetamorphForm.batoi(toread);
                    metadata.put("grayMin", new Double((double)num / (double)denom));
                    break;
                }
                case 24: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    this.r.read(toread);
                    int denom = MetamorphForm.batoi(toread);
                    metadata.put("grayMax", new Double((double)num / (double)denom));
                    break;
                }
                case 25: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    toread = new byte[num];
                    this.r.read(toread);
                    metadata.put("grayUnitName", new String(toread));
                    break;
                }
                case 26: {
                    this.r.read(toread);
                    metadata.put("StandardLUT", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 27: {
                    this.r.read(toread);
                    metadata.put("Wavelength", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 28: {
                    double ypos;
                    double xpos;
                    int ydenom;
                    int ynum;
                    int xdenom;
                    int xnum;
                    int i = 0;
                    while (i < planes) {
                        this.r.read(toread);
                        xnum = MetamorphForm.batoi(toread);
                        this.r.read(toread);
                        xdenom = MetamorphForm.batoi(toread);
                        this.r.read(toread);
                        ynum = MetamorphForm.batoi(toread);
                        this.r.read(toread);
                        ydenom = MetamorphForm.batoi(toread);
                        xpos = xnum / xdenom;
                        ypos = ynum / ydenom;
                        metadata.put("Stage Position Plane " + i, "(" + xpos + ", " + ypos + ")");
                        ++i;
                    }
                    continue block47;
                }
                case 29: {
                    double ypos;
                    double xpos;
                    int ydenom;
                    int ynum;
                    int xdenom;
                    int xnum;
                    int i = 0;
                    while (i < planes) {
                        this.r.read(toread);
                        xnum = MetamorphForm.batoi(toread);
                        this.r.read(toread);
                        xdenom = MetamorphForm.batoi(toread);
                        this.r.read(toread);
                        ynum = MetamorphForm.batoi(toread);
                        this.r.read(toread);
                        ydenom = MetamorphForm.batoi(toread);
                        xpos = xnum / xdenom;
                        ypos = ynum / ydenom;
                        metadata.put("Camera Offset Plane " + i, "(" + xpos + ", " + ypos + ")");
                        ++i;
                    }
                    continue block47;
                }
                case 30: {
                    this.r.read(toread);
                    metadata.put("OverlayMask", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 31: {
                    this.r.read(toread);
                    metadata.put("OverlayCompress", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 32: {
                    this.r.read(toread);
                    metadata.put("Overlay", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 33: {
                    this.r.read(toread);
                    metadata.put("SpecialOverlayMask", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 34: {
                    this.r.read(toread);
                    metadata.put("SpecialOverlayCompress", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 35: {
                    this.r.read(toread);
                    metadata.put("SpecialOverlay", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 36: {
                    this.r.read(toread);
                    metadata.put("ImageProperty", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 37: {
                    int num;
                    int i = 0;
                    while (i < planes) {
                        toread = new byte[4];
                        this.r.read(toread);
                        num = MetamorphForm.batoi(toread);
                        toread = new byte[num];
                        this.r.read(toread);
                        metadata.put("StageLabel Plane " + i, new String(toread));
                        ++i;
                    }
                    continue block47;
                }
                case 38: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    this.r.read(toread);
                    int denom = MetamorphForm.batoi(toread);
                    metadata.put("AutoScaleLoInfo", new Double((double)num / (double)denom));
                    break;
                }
                case 39: {
                    this.r.read(toread);
                    int num = MetamorphForm.batoi(toread);
                    this.r.read(toread);
                    int denom = MetamorphForm.batoi(toread);
                    metadata.put("AutoScaleHiInfo", new Double((double)num / (double)denom));
                    break;
                }
                case 40: {
                    int denom;
                    int num;
                    int i = 0;
                    while (i < planes) {
                        this.r.read(toread);
                        num = MetamorphForm.batoi(toread);
                        this.r.read(toread);
                        denom = MetamorphForm.batoi(toread);
                        metadata.put("AbsoluteZ Plane " + i, new Double((double)num / (double)denom));
                        ++i;
                    }
                    continue block47;
                }
                case 41: {
                    int i = 0;
                    while (i < planes) {
                        this.r.read(toread);
                        metadata.put("AbsoluteZValid Plane " + i, new Integer(MetamorphForm.batoi(toread)));
                        ++i;
                    }
                    continue block47;
                }
                case 42: {
                    this.r.read(toread);
                    metadata.put("Gamma", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 43: {
                    this.r.read(toread);
                    metadata.put("GammaRed", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 44: {
                    this.r.read(toread);
                    metadata.put("GammaGreen", new Integer(MetamorphForm.batoi(toread)));
                    break;
                }
                case 45: {
                    this.r.read(toread);
                    metadata.put("GammaBlue", new Integer(MetamorphForm.batoi(toread)));
                }
            }
        }
        return metadata;
    }

    public Object getMetadataValue(String id, String field) throws BadFormException, IOException, VisADException {
        Hashtable h = this.getMetadata(id);
        try {
            return h.get(field);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private static int batoi(byte[] inp) {
        int len = inp.length > 4 ? 4 : inp.length;
        int total = 0;
        int i = 0;
        while (i < len) {
            total += (inp[i] < 0 ? 256 + inp[i] : inp[i]) << i * 8;
            ++i;
        }
        return total;
    }

    private void initFile(String id) throws IOException, VisADException, BadFormException {
        this.r = new RandomAccessFile(id, "r");
        this.currentId = id;
        this.ifdHash = TiffTools.getIFDHash(this.r);
        this.dimensions = TiffTools.getTIFFDimensions(this.r);
        if (this.dimensions == null) {
            throw new BadFormException("Metamorph dimensions not found");
        }
        Vector v = (Vector)this.ifdHash.get(new Integer(33629));
        if (v == null) {
            throw new BadFormException("Metamorph ID not found");
        }
        this.dimensions[2] = (Integer)v.get(1);
        this.pixelSet = new Linear2DSet((MathType)domainTuple, 0.0, (double)(this.dimensions[0] - 1), this.dimensions[0], this.dimensions[1] - 1, 0.0, this.dimensions[1]);
    }

    public static void main(String[] args) throws VisADException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("To test read a Metamorph STK file, run:");
            System.out.println("  java visad.data.bio.MetamorphForm in_file");
            System.exit(2);
        }
        MetamorphForm form = new MetamorphForm();
        System.out.print("Reading " + args[0] + " metadata ");
        Hashtable meta = form.getMetadata(args[0]);
        System.out.println("[done]");
        System.out.println();
        Enumeration e = meta.keys();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        Object[] keys = new String[v.size()];
        v.copyInto(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            System.out.println((String)keys[i] + ": " + meta.get(keys[i]));
            ++i;
        }
        System.out.println();
        System.out.print("Reading " + args[0] + " pixel data ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType());
        System.exit(0);
    }

    static {
        try {
            RealType column = RealType.getRealType("ImageElement");
            RealType row = RealType.getRealType("ImageLine");
            domainTuple = new RealTupleType(column, row);
            RealType pixel = RealType.getRealType("intensity");
            funcRowColPix = new FunctionType(domainTuple, pixel);
            RealType red = RealType.getRealType("Red");
            RealType green = RealType.getRealType("Green");
            RealType blue = RealType.getRealType("Blue");
            RealType[] rgb = new RealType[]{red, green, blue};
            RealTupleType rgbPixelData = new RealTupleType(rgb);
            funcRowColRGB = new FunctionType(domainTuple, rgbPixelData);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
    }
}

