/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.data.MetadataReader;
import visad.data.bio.BioRadNote;

public class BioRadForm
extends Form
implements FormBlockReader,
FormFileInformer,
FormProgressInformer,
MetadataReader {
    static final boolean DEBUG = false;
    static final int DEBUG_LEVEL = 1;
    private static final int PIC_FILE_ID = 12345;
    private static final int MERGE_OFF = 0;
    private static final int MERGE_16 = 1;
    private static final int MERGE_ALTERNATE = 2;
    private static final int MERGE_COLUMN = 3;
    private static final int MERGE_ROW = 4;
    private static final int MERGE_MAXIMUM = 5;
    private static final int MERGE_OPT12 = 6;
    private static final int MERGE_OPT12_V2 = 7;
    private static final String[] MERGE_NAMES = new String[]{"MERGE_OFF", "MERGE_16", "MERGE_ALTERNATE", "MERGE_COLUMN", "MERGE_ROW", "MERGE_MAXIMUM", "MERGE_OPT12", "MERGE_OPT12_V2"};
    private static final int RED_LUT = 1;
    private static final int GREEN_LUT = 2;
    private static final int BLUE_LUT = 4;
    private static final RealType NOTE_INDEX = RealType.getRealType("NoteIndex");
    private static final RealType RT_RAMP1_MIN = RealType.getRealType("ramp1_min");
    private static final RealType RT_RAMP1_MAX = RealType.getRealType("ramp1_max");
    private static final RealType RT_BYTE_FORMAT = RealType.getRealType("byte_format");
    private static final TextType TT_NAME = TextType.getTextType("name");
    private static final RealType RT_RAMP2_MIN = RealType.getRealType("ramp2_min");
    private static final RealType RT_RAMP2_MAX = RealType.getRealType("ramp2_max");
    private static final RealType RT_LENS = RealType.getRealType("lens");
    private static final RealType RT_MAG_FACTOR = RealType.getRealType("mag_factor");
    private static final String[] NOTE_VAR_NAMES = new String[]{"SCALE_FACTOR", "LENS_MAGNIFICATION", "RAMP_GAMMA1", "RAMP_GAMMA2", "RAMP_GAMMA3", "RAMP1_MIN", "RAMP2_MIN", "RAMP3_MIN", "RAMP1_MAX", "RAMP2_MAX", "RAMP3_MAX", "PIC_FF_VERSION", "Z_CORRECT_FACTOR"};
    private static int formCount = 0;
    private static MathType image;
    private static MathType imageSequence;
    private static MathType table;
    private static MathType tableSequence;
    private static FunctionType noteFunction;
    private String currentId;
    private RandomAccessFile in;
    private Hashtable metadata;
    private int nx;
    private int ny;
    private int npic;
    private boolean byteFormat;
    private FunctionType imageFunction;
    private Linear2DSet imageSet;
    private double percent;

    public BioRadForm() {
        super("BioRadForm" + formCount++);
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        int index;
        int j;
        double[] samp;
        double[][] samples;
        FlatField d;
        int i;
        byte[] imageBytes;
        float magFactor;
        int numTables;
        FlatField d2;
        Set set;
        data = data.local();
        Vector<Data> v = new Vector<Data>();
        if (data instanceof Tuple) {
            Tuple t = (Tuple)data;
            int i2 = 0;
            while (i2 < t.getDimension()) {
                v.add(t.getComponent(i2));
                ++i2;
            }
        } else {
            v.add(data);
        }
        Vector<Data> vImages = new Vector<Data>();
        Vector<Data> vTables = new Vector<Data>();
        Vector<BioRadNote> vNotes = new Vector<BioRadNote>();
        Real ramp1minType = null;
        Real ramp1maxType = null;
        Real byteFormatType = null;
        Text nameType = null;
        Real ramp2minType = null;
        Real ramp2maxType = null;
        Real lensType = null;
        Real magFactorType = null;
        boolean hasNoteTuple = false;
        int len = v.size();
        int i3 = 0;
        while (i3 < len) {
            DataImpl d3 = (DataImpl)v.elementAt(i3);
            MathType mt = d3.getType();
            if (mt.equalsExceptName(image)) {
                vImages.add(d3);
            } else if (mt.equalsExceptName(imageSequence)) {
                FieldImpl f = (FieldImpl)d3;
                int flen = f.getLength();
                int j2 = 0;
                while (j2 < flen) {
                    vImages.add(f.getSample(j2));
                    ++j2;
                }
            } else if (mt.equalsExceptName(table)) {
                vTables.add(d3);
            } else if (mt.equalsExceptName(tableSequence)) {
                FieldImpl f = (FieldImpl)d3;
                int flen = f.getLength();
                int j3 = 0;
                while (j3 < flen) {
                    vTables.add(f.getSample(j3));
                    ++j3;
                }
            } else if (mt.equalsExceptName(noteFunction)) {
                vNotes.removeAllElements();
                FieldImpl f = (FieldImpl)d3;
                int flen = f.getLength();
                int j4 = 0;
                while (j4 < flen) {
                    Tuple t = (Tuple)f.getSample(j4);
                    Real rtLevel = (Real)t.getComponent(0);
                    Real rtNum = (Real)t.getComponent(1);
                    Real rtStatus = (Real)t.getComponent(2);
                    Real rtType = (Real)t.getComponent(3);
                    Real rtX = (Real)t.getComponent(4);
                    Real rtY = (Real)t.getComponent(5);
                    Text ttText = (Text)t.getComponent(6);
                    int level = (int)rtLevel.getValue();
                    int num = (int)rtNum.getValue();
                    int status = (int)rtStatus.getValue();
                    int type = (int)rtType.getValue();
                    int x = (int)rtX.getValue();
                    int y = (int)rtY.getValue();
                    String text = ttText.getValue();
                    BioRadNote note = new BioRadNote(level, num, status, type, x, y, text);
                    vNotes.add(note);
                    ++j4;
                }
                hasNoteTuple = true;
            } else if (mt.equals(RT_RAMP1_MIN)) {
                ramp1minType = (Real)d3;
            } else if (mt.equals(RT_RAMP1_MAX)) {
                ramp1maxType = (Real)d3;
            } else if (mt.equals(RT_BYTE_FORMAT)) {
                byteFormatType = (Real)d3;
            } else if (mt.equals(TT_NAME)) {
                nameType = (Text)d3;
            } else if (mt.equals(RT_RAMP2_MIN)) {
                ramp2minType = (Real)d3;
            } else if (mt.equals(RT_RAMP2_MAX)) {
                ramp2maxType = (Real)d3;
            } else if (mt.equals(RT_LENS)) {
                lensType = (Real)d3;
            } else if (mt.equals(RT_MAG_FACTOR)) {
                magFactorType = (Real)d3;
            } else {
                boolean ok = false;
                if (mt instanceof RealType) {
                    if (hasNoteTuple) {
                        ok = true;
                    } else {
                        RealType rt = (RealType)mt;
                        String rtName = rt.getName();
                        int j5 = 0;
                        while (j5 < NOTE_VAR_NAMES.length) {
                            if (rtName.equals(NOTE_VAR_NAMES[j5])) {
                                BioRadNote note = new BioRadNote(1, 0, 1280, 20, 0, 0, rtName + " " + ((Real)d3).getValue());
                                vNotes.add(note);
                                ok = true;
                            }
                            ++j5;
                        }
                    }
                }
                if (!ok) {
                    throw new BadFormException("Unsupported data object");
                }
            }
            ++i3;
        }
        int xlen = -1;
        int ylen = -1;
        int numImages = vImages.size();
        int i4 = 0;
        while (i4 < numImages) {
            Object o = vImages.elementAt(i4);
            if (!(o instanceof FlatField)) {
                throw new BadFormException("Invalid image data");
            }
            FlatField d4 = (FlatField)o;
            Set set2 = d4.getDomainSet();
            if (!(set2 instanceof GriddedSet)) {
                throw new BadFormException("Invalid image set");
            }
            GriddedSet gset = (GriddedSet)set2;
            if (gset.getDimension() != 2) {
                throw new BadFormException("Invalid domain dimension");
            }
            if (gset.getManifoldDimension() != 2) {
                throw new BadFormException("Invalid manifold dimension");
            }
            int[] l = gset.getLengths();
            if (xlen < 0) {
                xlen = l[0];
                ylen = l[1];
            } else if (xlen != l[0] || ylen != l[1]) {
                throw new BadFormException("All images must have same width and height");
            }
            double[][] samples2 = d4.getValues(false);
            if (samples2.length != 1 || samples2[0].length != xlen * ylen) {
                throw new BadFormException("Invalid image samples");
            }
            ++i4;
        }
        if (!hasNoteTuple && (set = (d2 = (FlatField)vImages.elementAt(0)).getDomainSet()) instanceof Linear2DSet) {
            Linear2DSet lset = (Linear2DSet)set;
            Linear1DSet xset = lset.getX();
            Linear1DSet yset = lset.getY();
            Unit[] u = set.getSetUnits();
            Unit xu = u[0];
            Unit yu = u[1];
            BioRadNote xNote = BioRadNote.getUnitNote(xu, xset, true);
            BioRadNote yNote = BioRadNote.getUnitNote(yu, yset, false);
            if (xNote != null) {
                vNotes.add(xNote);
            }
            if (yNote != null) {
                vNotes.add(yNote);
            }
        }
        if ((numTables = vTables.size()) > 3) {
            throw new BadFormException("Too many color tables");
        }
        int i5 = 0;
        while (i5 < numTables) {
            Object o = vTables.elementAt(i5);
            if (!(o instanceof FlatField)) {
                throw new BadFormException("Invalid color table data");
            }
            FlatField d5 = (FlatField)o;
            Set set3 = d5.getDomainSet();
            if (!(set3 instanceof Gridded1DSet)) {
                throw new BadFormException("Invalid color table set");
            }
            Gridded1DSet gset = (Gridded1DSet)set3;
            int[] l = gset.getLengths();
            if (l[0] != 256) {
                throw new BadFormException("Invalid color table length");
            }
            ++i5;
        }
        int numX = xlen;
        int numY = ylen;
        int numPic = numImages;
        int ramp1min = ramp1minType == null ? 0 : (int)ramp1minType.getValue();
        int ramp1max = ramp1maxType == null ? 255 : (int)ramp1maxType.getValue();
        int notes = vNotes.size();
        int format = byteFormatType == null ? 1 : (int)byteFormatType.getValue();
        int imageNumber = 0;
        String name = nameType == null ? id : nameType.getValue();
        int merged = 0;
        int color1 = 7;
        int fileId = 12345;
        int ramp2min = ramp2minType == null ? 0 : (int)ramp2minType.getValue();
        int ramp2max = ramp2maxType == null ? 255 : (int)ramp2maxType.getValue();
        int color2 = 7;
        int edited = 1;
        int lens = lensType == null ? 0 : (int)lensType.getValue();
        float f = magFactor = magFactorType == null ? 0.0f : (float)magFactorType.getValue();
        if (format == 0) {
            imageBytes = new byte[2 * numPic * numX * numY];
            i = 0;
            while (i < numPic) {
                d = (FlatField)vImages.elementAt(i);
                samples = d.getValues(false);
                samp = samples[0];
                j = 0;
                while (j < samp.length) {
                    index = 2 * (samp.length * i + j);
                    int q = (int)samp[j];
                    int qhi = (0xFF00 & q) >> 8;
                    int qlo = 0xFF & q;
                    imageBytes[index] = (byte)qhi;
                    imageBytes[index + 1] = (byte)qlo;
                    ++j;
                }
                ++i;
            }
        } else {
            imageBytes = new byte[numPic * numX * numY];
            i = 0;
            while (i < numPic) {
                d = (FlatField)vImages.elementAt(i);
                samples = d.getValues(false);
                samp = samples[0];
                j = 0;
                while (j < samp.length) {
                    index = samp.length * i + j;
                    imageBytes[index] = (byte)samp[j];
                    ++j;
                }
                ++i;
            }
        }
        byte[] tableBytes = new byte[numTables * 768];
        int i6 = 0;
        while (i6 < numTables) {
            FlatField d6 = (FlatField)vTables.elementAt(i6);
            double[][] samples3 = d6.getValues(false);
            double[] sr = samples3[0];
            double[] sg = samples3[1];
            double[] sb = samples3[2];
            int j6 = 0;
            while (j6 < 256) {
                int index2 = 768 * i6 + j6;
                tableBytes[index2] = (byte)sr[j6];
                tableBytes[index2 + 256] = (byte)sg[j6];
                tableBytes[index2 + 512] = (byte)sb[j6];
                ++j6;
            }
            ++i6;
        }
        DataOutputStream fout = new DataOutputStream(new FileOutputStream(id));
        BioRadForm.writeShort(fout, numX);
        BioRadForm.writeShort(fout, numY);
        BioRadForm.writeShort(fout, numPic);
        BioRadForm.writeShort(fout, ramp1min);
        BioRadForm.writeShort(fout, ramp1max);
        BioRadForm.writeInt(fout, notes);
        BioRadForm.writeShort(fout, format);
        BioRadForm.writeShort(fout, imageNumber);
        BioRadForm.writeString(fout, name, 32);
        BioRadForm.writeShort(fout, merged);
        BioRadForm.writeShort(fout, color1);
        BioRadForm.writeShort(fout, fileId);
        BioRadForm.writeShort(fout, ramp2min);
        BioRadForm.writeShort(fout, ramp2max);
        BioRadForm.writeShort(fout, color2);
        BioRadForm.writeShort(fout, edited);
        BioRadForm.writeShort(fout, lens);
        BioRadForm.writeFloat(fout, magFactor);
        fout.write(new byte[]{0, 0, 0, 0, 0, 0}, 0, 6);
        fout.write(imageBytes, 0, imageBytes.length);
        int i7 = 0;
        while (i7 < notes) {
            BioRadNote note = (BioRadNote)vNotes.elementAt(i7);
            note.write(fout, i7 != notes - 1);
            ++i7;
        }
        fout.write(tableBytes, 0, tableBytes.length);
        fout.close();
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("BioRadForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType index = RealType.getRealType("index");
            FunctionType indexFunction = new FunctionType(index, fields[0].getType());
            Integer1DSet indexSet = new Integer1DSet(nImages);
            FieldImpl indexField = new FieldImpl(indexFunction, indexSet);
            indexField.setSamples(fields, false);
            data = indexField;
        }
        this.close();
        this.percent = Double.NaN;
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        throw new BadFormException("BioRadForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int blockNumber) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        if (blockNumber < 0 || blockNumber >= this.npic) {
            throw new BadFormException("Invalid image number: " + blockNumber);
        }
        int imageLen = this.nx * this.ny;
        float[][] samples = new float[1][imageLen];
        if (this.byteFormat) {
            this.in.seek(blockNumber * imageLen + 76);
            byte[] buf = new byte[imageLen];
            this.in.readFully(buf);
            int l = 0;
            while (l < imageLen) {
                int q = 0xFF & buf[l];
                samples[0][l] = q;
                ++l;
            }
        } else {
            this.in.seek(blockNumber * 2 * imageLen + 76);
            int dataLen = 2 * imageLen;
            byte[] buf = new byte[dataLen];
            this.in.readFully(buf);
            int l = 0;
            while (l < dataLen) {
                int q = BioRadForm.getUnsignedShort(buf[l], buf[l + 1]);
                samples[0][l / 2] = q;
                l += 2;
            }
        }
        FlatField field = new FlatField(this.imageFunction, this.imageSet);
        field.setSamples(samples, false);
        return field;
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        return this.npic;
    }

    public void close() throws BadFormException, IOException, VisADException {
        if (this.currentId == null) {
            return;
        }
        this.in.close();
        this.currentId = null;
        this.in = null;
        this.metadata = null;
    }

    public boolean isThisType(String name) {
        return name.toLowerCase().endsWith(".pic");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 56) {
            return false;
        }
        return BioRadForm.getUnsignedShort(block[54], block[55]) == 12345;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"pic"};
    }

    public double getPercentComplete() {
        return this.percent;
    }

    public Object getMetadataValue(String id, String field) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        return this.metadata.get(id);
    }

    public Hashtable getMetadata(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        return this.metadata;
    }

    public static int getUnsignedShort(byte b1, byte b2) {
        int i1 = 0xFF & b1;
        int i2 = 0xFF & b2;
        return i2 << 8 | i1;
    }

    public static float getFloat(byte b1, byte b2, byte b3, byte b4) {
        int i1 = 0xFF & b1;
        int i2 = 0xFF & b2;
        int i3 = 0xFF & b3;
        int i4 = 0xFF & b4;
        int bits = i4 << 24 | i3 << 16 | i2 << 8 | i1;
        return Float.intBitsToFloat(bits);
    }

    public static void writeShort(DataOutputStream out, int val) throws IOException {
        int q0 = 0xFF & val;
        int q1 = (0xFF00 & val) >> 8;
        byte[] b = new byte[]{(byte)q0, (byte)q1};
        out.write(b, 0, 2);
    }

    public static void writeInt(DataOutputStream out, int val) throws IOException {
        int q0 = 0xFF & val;
        int q1 = (0xFF00 & val) >> 8;
        int q2 = (0xFF0000 & val) >> 16;
        int q3 = (0xFF000000 & val) >> 24;
        byte[] b = new byte[]{(byte)q0, (byte)q1, (byte)q2, (byte)q3};
        out.write(b, 0, 4);
    }

    public static void writeFloat(DataOutputStream out, float val) throws IOException {
        int q = Float.floatToIntBits(val);
        int q0 = (0xFF & q) << 24;
        int q1 = (0xFF00 & q) << 8;
        int q2 = (0xFF0000 & q) >> 8;
        int q3 = (0xFF000000 & q) >> 24;
        byte[] b = new byte[]{(byte)q0, (byte)q1, (byte)q2, (byte)q3};
        out.write(b, 0, 4);
    }

    public static void writeString(DataOutputStream out, String s, int len) throws IOException {
        byte[] b = s.getBytes();
        byte[] bytes = new byte[len];
        System.arraycopy(b, 0, bytes, 0, b.length < len ? b.length : len);
        out.write(bytes, 0, len);
    }

    private void initFile(String id) throws BadFormException, IOException, VisADException {
        this.close();
        this.currentId = id;
        this.in = new RandomAccessFile(id, "r");
        this.metadata = new Hashtable();
        byte[] header = new byte[76];
        this.in.readFully(header);
        this.nx = BioRadForm.getUnsignedShort(header[0], header[1]);
        this.ny = BioRadForm.getUnsignedShort(header[2], header[3]);
        this.npic = BioRadForm.getUnsignedShort(header[4], header[5]);
        this.byteFormat = BioRadForm.getUnsignedShort(header[14], header[15]) != 0;
        int ramp1min = BioRadForm.getUnsignedShort(header[6], header[7]);
        int ramp1max = BioRadForm.getUnsignedShort(header[8], header[9]);
        boolean notes = (header[10] | header[11] | header[12] | header[13]) != 0;
        int imageNumber = BioRadForm.getUnsignedShort(header[16], header[17]);
        String name = new String(header, 18, 32);
        int merged = BioRadForm.getUnsignedShort(header[50], header[51]);
        int color1 = BioRadForm.getUnsignedShort(header[52], header[53]);
        int fileId = BioRadForm.getUnsignedShort(header[54], header[55]);
        int ramp2min = BioRadForm.getUnsignedShort(header[56], header[57]);
        int ramp2max = BioRadForm.getUnsignedShort(header[58], header[59]);
        int color2 = BioRadForm.getUnsignedShort(header[60], header[61]);
        int edited = BioRadForm.getUnsignedShort(header[62], header[63]);
        int lens = BioRadForm.getUnsignedShort(header[64], header[65]);
        float magFactor = BioRadForm.getFloat(header[66], header[67], header[68], header[69]);
        if (fileId != 12345) {
            throw new BadFormException("Invalid file header: " + fileId);
        }
        this.metadata.put("nx", new Integer(this.nx));
        this.metadata.put("ny", new Integer(this.ny));
        this.metadata.put("npic", new Integer(this.npic));
        this.metadata.put("ramp1_min", new Integer(ramp1min));
        this.metadata.put("ramp1_max", new Integer(ramp1max));
        this.metadata.put("notes", new Boolean(notes));
        this.metadata.put("byte_format", new Boolean(this.byteFormat));
        this.metadata.put("image_number", new Integer(imageNumber));
        this.metadata.put("name", name);
        this.metadata.put("merged", MERGE_NAMES[merged]);
        this.metadata.put("color1", new Integer(color1));
        this.metadata.put("file_id", new Integer(fileId));
        this.metadata.put("ramp2_min", new Integer(ramp2min));
        this.metadata.put("ramp2_max", new Integer(ramp2max));
        this.metadata.put("color2", new Integer(color2));
        this.metadata.put("edited", new Integer(edited));
        this.metadata.put("lens", new Integer(lens));
        this.metadata.put("mag_factor", new Float(magFactor));
        int imageLen = this.nx * this.ny;
        int bpp = this.byteFormat ? 1 : 2;
        this.in.skipBytes(bpp * this.npic * imageLen);
        Vector<BioRadNote> noteList = new Vector<BioRadNote>();
        int noteCount = 0;
        while (notes) {
            byte[] note = new byte[96];
            this.in.readFully(note);
            int level = BioRadForm.getUnsignedShort(note[0], note[1]);
            notes = (note[2] | note[3] | note[4] | note[5]) != 0;
            int num = BioRadForm.getUnsignedShort(note[6], note[7]);
            int status = BioRadForm.getUnsignedShort(note[8], note[9]);
            int type = BioRadForm.getUnsignedShort(note[10], note[11]);
            int x = BioRadForm.getUnsignedShort(note[12], note[13]);
            int y = BioRadForm.getUnsignedShort(note[14], note[15]);
            String text = new String(note, 16, 80);
            BioRadNote bioRadNote = new BioRadNote(level, num, status, type, x, y, text);
            noteList.add(bioRadNote);
            this.metadata.put("note" + ++noteCount, bioRadNote);
        }
        int numLuts = 0;
        byte[][] lut = new byte[3][768];
        boolean eof = false;
        while (!eof && numLuts < 3) {
            try {
                this.in.readFully(lut[numLuts]);
                ++numLuts;
            }
            catch (IOException exc) {
                eof = true;
            }
        }
        float[][][] colors = new float[numLuts][3][256];
        int i = 0;
        while (i < numLuts) {
            int l = 0;
            while (l < 256) {
                int qr = 0xFF & lut[i][l];
                int qg = 0xFF & lut[i][l + 256];
                int qb = 0xFF & lut[i][l + 512];
                colors[i][0][l] = qr;
                colors[i][1][l] = qg;
                colors[i][2][l] = qb;
                ++l;
            }
            ++i;
        }
        this.metadata.put("luts", colors);
        double horizOffset = 0.0;
        double vertOffset = 0.0;
        double horizStep = 0.0;
        double vertStep = 0.0;
        Unit horizUnit = null;
        Unit vertUnit = null;
        int ndx = 0;
        while (ndx < noteList.size()) {
            BioRadNote note = (BioRadNote)noteList.elementAt(ndx);
            if (note.hasUnitInfo()) {
                int rval = note.analyze();
                if (rval == 2) {
                    if (horizStep == 0.0) {
                        horizOffset = note.origin;
                        horizStep = note.step;
                        horizUnit = BioRadNote.MICRON;
                    }
                    noteList.remove(ndx);
                    continue;
                }
                if (rval == 3) {
                    if (vertStep == 0.0) {
                        vertOffset = note.getOrigin();
                        vertStep = note.getStep();
                        vertUnit = note.getTime() ? BioRadNote.SECOND : BioRadNote.MICRON;
                    }
                    noteList.remove(ndx);
                    continue;
                }
                if (rval == -1 || rval == 0) {
                    noteList.remove(ndx);
                    continue;
                }
                ++ndx;
                continue;
            }
            ++ndx;
        }
        if (horizStep == 0.0) {
            horizStep = 1.0;
        }
        if (vertStep == 0.0) {
            vertStep = 1.0;
        }
        RealType x = RealType.getRealType("ImageElement", horizUnit);
        RealType y = RealType.getRealType("ImageLine", vertUnit);
        RealType value = RealType.getRealType("intensity");
        RealTupleType xy = new RealTupleType(x, y);
        this.imageFunction = new FunctionType(xy, value);
        this.imageSet = new Linear2DSet(xy, horizOffset, horizOffset + (double)(this.nx - 1) * horizStep, this.nx, vertOffset, vertOffset + (double)(this.ny - 1) * vertStep, this.ny, null, new Unit[]{horizUnit, vertUnit}, null);
    }

    public static void main(String[] args) throws VisADException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to Bio-Rad PIC, run:");
            System.out.println("  java visad.data.bio.BioRadForm in_file out_file");
            System.out.println("To test read a Bio-Rad PIC file, run:");
            System.out.println("  java visad.data.bio.BioRadForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            BioRadForm form = new BioRadForm();
            System.out.print("Reading " + args[0] + " metadata ");
            Hashtable meta = form.getMetadata(args[0]);
            System.out.println("[done]");
            System.out.println();
            Enumeration e = meta.keys();
            Vector v = new Vector();
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
            Object[] keys = new String[v.size()];
            v.copyInto(keys);
            Arrays.sort(keys);
            int i = 0;
            while (i < keys.length) {
                System.out.println((String)keys[i] + ": " + meta.get(keys[i]));
                ++i;
            }
            System.out.println();
            System.out.print("Reading " + args[0] + " pixel data ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            BioRadForm form = new BioRadForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }

    static {
        try {
            image = MathType.stringToType("((x, y) -> a)");
            imageSequence = MathType.stringToType("(t -> ((x, y) -> a))");
            table = MathType.stringToType("(value -> (r, g, b))");
            tableSequence = MathType.stringToType("(t -> (value -> (r, g, b)))");
            noteFunction = new FunctionType(NOTE_INDEX, BioRadNote.NOTE_TUPLE);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
    }
}

