/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import visad.ConstantMap;
import visad.Control;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.RemoteDataReference;
import visad.RemoteDisplayImpl;
import visad.RemoteReferenceLink;
import visad.RemoteVisADException;
import visad.ScalarMap;
import visad.VisADException;
import visad.collab.ControlMonitorEvent;
import visad.collab.DisplayMonitor;
import visad.collab.DisplaySync;
import visad.collab.MapMonitorEvent;
import visad.collab.MessageMonitorEvent;
import visad.collab.MonitorEvent;
import visad.collab.ReferenceMonitorEvent;
import visad.collab.RemoteEventProvider;

public class DisplaySyncImpl
implements Comparator,
DisplaySync,
Runnable {
    private String Name;
    private DisplayImpl myDisplay;
    private DisplayMonitor monitor;
    private Object mapClearSync = new Object();
    private int mapClearCount = 0;
    private boolean dead = false;
    private Object tableLock = new Object();
    private Thread thisThread = null;
    private HashMap current = new HashMap();
    private HashMap diverted = null;

    public DisplaySyncImpl(DisplayImpl dpy) throws RemoteException {
        this.Name = dpy.getName() + ":Sync";
        this.myDisplay = dpy;
        this.monitor = dpy.getDisplayMonitor();
        this.monitor.setDisplaySync(this);
    }

    private void addLink(RemoteReferenceLink link) throws VisADException {
        RemoteDataReference ref;
        ConstantMap[] cm = null;
        try {
            Vector v = link.getConstantMapVector();
            int len = v.size();
            if (len > 0) {
                cm = new ConstantMap[len];
                int i = 0;
                while (i < len) {
                    ConstantMap tmp = (ConstantMap)v.elementAt(i);
                    cm[i] = (ConstantMap)tmp.clone();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new VisADException("Couldn't copy ConstantMaps for remote DataReference");
        }
        try {
            ref = link.getReference();
        }
        catch (Exception e) {
            throw new VisADException("Couldn't copy remote DataReference");
        }
        if (ref != null) {
            DataRenderer renderer;
            DataRenderer dr = this.myDisplay.getDisplayRenderer().makeDefaultRenderer();
            String defaultClass = dr.getClass().getName();
            try {
                String newClass = link.getRendererClassName();
                if (newClass == defaultClass) {
                    renderer = null;
                } else {
                    Object obj = Class.forName(newClass).newInstance();
                    renderer = (DataRenderer)obj;
                }
            }
            catch (Exception e) {
                throw new VisADException("Couldn't copy remote DataRenderer name; using " + defaultClass);
            }
            try {
                RemoteDisplayImpl rd = new RemoteDisplayImpl(this.myDisplay);
                if (renderer == null) {
                    rd.addReference(ref, cm);
                } else {
                    rd.addReferences(renderer, ref, cm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new VisADException("Couldn't add remote DataReference " + ref + ": " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    public int compare(Object o1, Object o2) {
        return ((MonitorEvent)o1).getSequenceNumber() - ((MonitorEvent)o2).getSequenceNumber();
    }

    public void destroy() {
        this.monitor = null;
        this.myDisplay = null;
    }

    private ScalarMap findMap(ScalarMap map) {
        boolean isConstMap;
        Vector v;
        ScalarMap found = null;
        if (map instanceof ConstantMap) {
            v = this.myDisplay.getConstantMapVector();
            isConstMap = true;
        } else {
            v = this.myDisplay.getMapVector();
            isConstMap = false;
        }
        ListIterator iter = v.listIterator();
        while (iter.hasNext()) {
            ScalarMap sm = (ScalarMap)iter.next();
            if (!sm.equals(map)) continue;
            found = sm;
            break;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventReady(RemoteEventProvider provider, Object key) {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.thisThread != null) {
                if (this.diverted == null) {
                    this.diverted = new HashMap();
                }
                this.diverted.put(key, provider);
            } else {
                this.current.put(key, provider);
                this.thisThread = new Thread(this);
                this.thisThread.start();
            }
        }
    }

    public String getName() {
        return this.Name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalClear() {
        boolean result = true;
        Object object = this.mapClearSync;
        synchronized (object) {
            if (this.mapClearCount > 0) {
                --this.mapClearCount;
                result = false;
            }
        }
        return result;
    }

    public boolean isThreadRunning() {
        return this.thisThread != null;
    }

    private void processMap(HashMap map) {
        MonitorEvent[] list = new MonitorEvent[map.size()];
        Iterator iter = map.keySet().iterator();
        int i = list.length - 1;
        while (i >= 0) {
            if (iter.hasNext()) {
                String key = (String)iter.next();
                list[i] = (MonitorEvent)map.get(key);
            } else {
                list[i] = null;
            }
            --i;
        }
        Arrays.sort(list, this);
        int attempts = 0;
        int i2 = 0;
        while (i2 < list.length) {
            try {
                this.processOneEvent(list[i2]);
                ++i2;
            }
            catch (RemoteException re) {
                if (attempts++ < 5) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {}
                    continue;
                }
                this.dead = true;
                break;
            }
            catch (RemoteVisADException rve) {
                System.err.println("While processing " + list[i2] + ":");
                ++i2;
                rve.printStackTrace();
            }
        }
    }

    private void processOneEvent(MonitorEvent evt) throws RemoteException, RemoteVisADException {
        switch (evt.getType()) {
            case 1: {
                ScalarMap rmtMap = ((MapMonitorEvent)evt).getMap();
                if (this.findMap(rmtMap) != null) break;
                try {
                    this.myDisplay.addMap(rmtMap, evt.getOriginator());
                    break;
                }
                catch (VisADException ve) {
                    ve.printStackTrace();
                    throw new RemoteVisADException("Map " + rmtMap + " not added: " + ve);
                }
            }
            case 4: {
                ScalarMap rmtMap = ((MapMonitorEvent)evt).getMap();
                if (this.findMap(rmtMap) == null) break;
                try {
                    this.myDisplay.removeMap(rmtMap, evt.getOriginator());
                    break;
                }
                catch (VisADException ve) {
                    ve.printStackTrace();
                    throw new RemoteVisADException("Map " + rmtMap + " not removed: " + ve);
                }
            }
            case 2: {
                double[] lclRng;
                ScalarMap rmtMap = ((MapMonitorEvent)evt).getMap();
                ScalarMap lclMap = this.findMap(rmtMap);
                if (lclMap == null) {
                    throw new RemoteVisADException("ScalarMap " + rmtMap + " not found");
                }
                double[] rng = rmtMap.getRange();
                if (rng[0] == (lclRng = lclMap.getRange())[0] && rng[1] == lclRng[1]) break;
                try {
                    lclMap.setRange(rng[0], rng[1], evt.getOriginator());
                    break;
                }
                catch (VisADException ve) {
                    throw new RemoteVisADException("Map not changed: " + ve);
                }
            }
            case 3: {
                try {
                    this.myDisplay.removeAllReferences();
                    this.myDisplay.clearMaps();
                    break;
                }
                catch (VisADException ve) {
                    throw new RemoteVisADException("Maps not cleared: " + ve);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    throw new RemoteVisADException("Maps not cleared");
                }
            }
            case 10: {
                RemoteReferenceLink ref = ((ReferenceMonitorEvent)evt).getLink();
                try {
                    this.addLink(ref);
                    break;
                }
                catch (VisADException ve) {
                    throw new RemoteVisADException("DataReference " + ref + " not found by " + this.Name + ": " + ve.getMessage());
                }
            }
            case 20: {
                Control rmtCtl = ((ControlMonitorEvent)evt).getControl();
                Control lclCtl = this.myDisplay.getControl(rmtCtl.getClass(), rmtCtl.getInstanceNumber());
                if (lclCtl == null) break;
                try {
                    ControlMonitorEvent cme = new ControlMonitorEvent(21, (Control)lclCtl.clone());
                    this.monitor.notifyListeners(cme);
                    break;
                }
                catch (VisADException ve) {
                    throw new RemoteVisADException("Control " + rmtCtl + " not changed by " + this.Name + ": " + ve);
                }
            }
            case 21: {
                Control rmtCtl = ((ControlMonitorEvent)evt).getControl();
                Control lclCtl = this.myDisplay.getControl(rmtCtl.getClass(), rmtCtl.getInstanceNumber());
                if (lclCtl == null || this.monitor.hasEventQueued(evt.getOriginator(), lclCtl)) break;
                try {
                    lclCtl.syncControl(rmtCtl);
                    break;
                }
                catch (VisADException ve) {
                    throw new RemoteVisADException("Control " + lclCtl + " not changed by " + this.Name + ": " + ve.getMessage());
                }
            }
            case 22: {
                this.myDisplay.sendMessage(((MessageMonitorEvent)evt).getMessage());
                break;
            }
            default: {
                throw new RemoteVisADException("Event " + evt + " not handled");
            }
        }
    }

    private HashMap requestEventTable(HashMap table) throws RemoteException {
        HashMap<String, MonitorEvent> map = null;
        Iterator iter = table.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            RemoteEventProvider provider = (RemoteEventProvider)table.get(key);
            iter.remove();
            MonitorEvent evt = this.requestOneEvent(key, provider);
            if (evt == null) continue;
            if (map == null) {
                map = new HashMap<String, MonitorEvent>();
            }
            map.put(key, evt);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MonitorEvent requestOneEvent(String key, RemoteEventProvider provider) throws RemoteException {
        MonitorEvent evt;
        try {
            evt = provider.getEvent(key);
        }
        catch (RemoteVisADException rve) {
            rve.printStackTrace();
            throw new RemoteException(rve.getMessage());
        }
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 3: {
                Object object = this.mapClearSync;
                synchronized (object) {
                    ++this.mapClearCount;
                    break;
                }
            }
            case 21: {
                boolean result;
                try {
                    result = this.monitor.hasEventQueued(evt.getOriginator(), ((ControlMonitorEvent)evt).getControl());
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                    result = false;
                }
                if (!result) break;
                return null;
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HashMap map = null;
        boolean done = false;
        try {
            int attempts = 0;
            while (!done) {
                HashMap newMap;
                try {
                    newMap = this.requestEventTable(this.current);
                    done = true;
                }
                catch (RemoteException re) {
                    if (attempts++ >= 5) {
                        this.dead = true;
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    newMap = null;
                }
                if (map == null) {
                    map = newMap;
                } else if (newMap != null) {
                    map.putAll(newMap);
                }
                if (!done) continue;
                Object object = this.tableLock;
                synchronized (object) {
                    if (!this.undivertEvents()) {
                        break;
                    }
                    done = false;
                }
            }
        }
        finally {
            if (map != null) {
                this.processMap(map);
            }
            Object object = this.tableLock;
            synchronized (object) {
                this.thisThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean undivertEvents() {
        boolean undivert;
        Object object = this.tableLock;
        synchronized (object) {
            boolean bl = undivert = this.diverted != null;
            if (undivert) {
                this.current = this.diverted;
                this.diverted = null;
            }
        }
        return undivert;
    }
}

