/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.swing.JFrame;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Field;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.ShadowFunctionOrSetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.VisADQuadArray;
import visad.VisADTriangleStripArray;
import visad.bom.ImageRendererJ3D;
import visad.data.gif.GIFForm;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.AVControlJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.java3d.VisADBranchGroup;

public class ShadowImageFunctionTypeJ3D
extends ShadowFunctionTypeJ3D {
    private static final int MISSING1 = -128;
    private static DisplayImpl display;
    private static BaseMapAdapter baseMap;
    private static ScalarMap lat_map;
    private static ScalarMap lon_map;
    private static ScalarMap xaxis;
    private static ScalarMap yaxis;

    public ShadowImageFunctionTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        int domain_length;
        DataDisplayLink link = renderer.getLink();
        if (data.isMissing()) {
            ((ImageRendererJ3D)renderer).markMissingVisADBranch();
            return false;
        }
        if (this.getLevelOfDifficulty() == 6) {
            return false;
        }
        ShadowFunctionOrSetType adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        DisplayImpl display = this.getDisplay();
        GraphicsModeControl mode = (GraphicsModeControl)display.getGraphicsModeControl().clone();
        boolean anyContour = adaptedShadowType.getAnyContour();
        boolean anyFlow = adaptedShadowType.getAnyFlow();
        boolean anyShape = adaptedShadowType.getAnyShape();
        boolean anyText = adaptedShadowType.getAnyText();
        if (anyContour || anyFlow || anyShape || anyText) {
            throw new BadMappingException("no contour, flow, shape or text allowed");
        }
        int valueArrayLength = display.getValueArrayLength();
        int[] valueToScalar = display.getValueToScalar();
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int[] inherited_values = adaptedShadowType.getInheritedValues();
        int i = 0;
        while (i < valueArrayLength) {
            if (inherited_values[i] > 0) {
                display_values[i] = new float[1];
                display_values[i][0] = value_array[i];
            }
            ++i;
        }
        Set domain_set = ((Field)data).getDomainSet();
        Unit[] dataUnits = ((Function)data).getDomainUnits();
        CoordinateSystem dataCoordinateSystem = ((Function)data).getDomainCoordinateSystem();
        Object domain_values = null;
        Object domain_doubles = null;
        ShadowRealTupleType Domain2 = adaptedShadowType.getDomain();
        Unit[] domain_units = ((RealTupleType)Domain2.getType()).getDefaultUnits();
        try {
            domain_length = domain_set.getLength();
            int domain_dimension = domain_set.getDimension();
        }
        catch (SetException e) {
            return false;
        }
        ShadowRealType[] DomainComponents = adaptedShadowType.getDomainComponents();
        if (adaptedShadowType.getIsTerminal()) {
            int[] lens;
            float constant_alpha = Float.NaN;
            float[] constant_color = null;
            ShadowRealType[] RangeComponents = adaptedShadowType.getRangeComponents();
            int rangesize = RangeComponents.length;
            if (rangesize != 1 && rangesize != 3) {
                throw new BadMappingException("image values must single or triple");
            }
            ScalarMap cmap = null;
            ScalarMap[] cmaps = null;
            int[] permute = new int[]{-1, -1, -1};
            int color_length = 3;
            if (rangesize == 1) {
                Vector mvector = RangeComponents[0].getSelectedMapVector();
                if (mvector.size() != 1) {
                    throw new BadMappingException("image values must be mapped to RGB only");
                }
                cmap = (ScalarMap)mvector.elementAt(0);
                if (Display.RGB.equals(cmap.getDisplayScalar())) {
                    color_length = 3;
                } else {
                    if (!Display.RGBA.equals(cmap.getDisplayScalar())) throw new BadMappingException("image values must be mapped to RGB or RGBA");
                    color_length = 4;
                }
            } else {
                cmaps = new ScalarMap[3];
                int i2 = 0;
                while (i2 < 3) {
                    Vector vector = RangeComponents[i2].getSelectedMapVector();
                    if (vector.size() != 1) {
                        throw new BadMappingException("image values must be mapped to color only");
                    }
                    cmaps[i2] = (ScalarMap)vector.elementAt(0);
                    if (Display.Red.equals(cmaps[i2].getDisplayScalar())) {
                        permute[0] = i2;
                    } else if (Display.Green.equals(cmaps[i2].getDisplayScalar())) {
                        permute[1] = i2;
                    } else {
                        if (!Display.Blue.equals(cmaps[i2].getDisplayScalar())) throw new BadMappingException("image values must be mapped to Red, Green or Blue only");
                        permute[2] = i2;
                    }
                    ++i2;
                }
                if (permute[0] < 0 || permute[1] < 0 || permute[2] < 0) {
                    throw new BadMappingException("image values must be mapped to Red, Green and Blue");
                }
            }
            constant_alpha = default_values[display.getDisplayScalarIndex(Display.Alpha)];
            int[] color_ints = new int[domain_length];
            if (cmap != null) {
                BaseColorControl baseColorControl = (BaseColorControl)cmap.getControl();
                float[][] table = baseColorControl.getTable();
                byte[][] bytes = null;
                Set rset = null;
                boolean is_default_unit = false;
                if (data instanceof FlatField) {
                    RealType rtype;
                    Unit def_unit;
                    bytes = ((FlatField)data).grabBytes();
                    Set[] rsets = ((FlatField)data).getRangeSets();
                    if (rsets != null) {
                        rset = rsets[0];
                    }
                    if ((def_unit = (rtype = (RealType)RangeComponents[0].getType()).getDefaultUnit()) == null) {
                        is_default_unit = true;
                    } else {
                        Unit[][] data_units = ((FlatField)data).getRangeUnits();
                        Unit data_unit = data_units == null ? null : data_units[0][0];
                        is_default_unit = def_unit.equals(data_unit);
                    }
                }
                if (table != null) {
                    int[] itable = new int[table[0].length];
                    int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                    int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                    int j = 0;
                    while (j < table[0].length) {
                        int b;
                        c = (int)(255.0 * (double)table[0][j]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)table[1][j]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)table[2][j]);
                        int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                        if (color_length == 4) {
                            c = (int)(255.0 * (double)table[3][j]);
                            a = c < 0 ? 0 : (c > 255 ? 255 : c);
                        }
                        itable[j] = a << 24 | r << 16 | g << 8 | b;
                        ++j;
                    }
                    int tblEnd = table[0].length - 1;
                    double table_scale = table[0].length;
                    if (bytes != null && bytes[0] != null && is_default_unit && rset != null && rset instanceof Linear1DSet) {
                        double first = ((Linear1DSet)rset).getFirst();
                        double step = ((Linear1DSet)rset).getStep();
                        double[] so = new double[2];
                        double[] da = new double[2];
                        double[] di = new double[2];
                        cmap.getScale(so, da, di);
                        double scale = so[0];
                        double offset = so[1];
                        float mult = (float)(table_scale * scale * step);
                        float add = (float)(table_scale * (offset + scale * first));
                        int[] fast_table = new int[256];
                        int j2 = 0;
                        while (j2 < 256) {
                            int k;
                            int index = j2 - 1;
                            fast_table[j2] = index < 0 ? 0 : ((k = (int)(add + mult * (float)index)) < 0 ? itable[0] : (k > tblEnd ? itable[tblEnd] : itable[k]));
                            ++j2;
                        }
                        byte[] bytes0 = bytes[0];
                        int i3 = 0;
                        while (i3 < domain_length) {
                            color_ints[i3] = fast_table[bytes0[i3] - -128];
                            ++i3;
                        }
                        bytes = null;
                    } else {
                        bytes = null;
                        float[][] values = ((Field)data).getFloats(false);
                        values[0] = cmap.scaleValues(values[0]);
                        float[] values0 = values[0];
                        int i4 = 0;
                        while (i4 < domain_length) {
                            int j3;
                            color_ints[i4] = values0[i4] != values0[i4] ? 0 : ((j3 = (int)(table_scale * (double)values0[i4])) < 0 ? itable[0] : (j3 > tblEnd ? itable[tblEnd] : itable[j3]));
                            ++i4;
                        }
                        values = null;
                    }
                } else {
                    bytes = null;
                    float[][] values = ((Field)data).getFloats(false);
                    values[0] = cmap.scaleValues(values[0]);
                    float[][] color_values = baseColorControl.lookupValues(values[0]);
                    int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                    int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                    int i5 = 0;
                    while (i5 < domain_length) {
                        if (values[0][i5] != values[0][i5]) {
                            color_ints[i5] = 0;
                        } else {
                            int b;
                            c = (int)(255.0 * (double)color_values[0][i5]);
                            int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                            c = (int)(255.0 * (double)color_values[1][i5]);
                            int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                            c = (int)(255.0 * (double)color_values[2][i5]);
                            int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                            if (color_length == 4) {
                                c = (int)(255.0 * (double)color_values[3][i5]);
                                a = c < 0 ? 0 : (c > 255 ? 255 : c);
                            }
                            color_ints[i5] = a << 24 | r << 16 | g << 8 | b;
                        }
                        ++i5;
                    }
                    values = null;
                    color_values = null;
                }
            } else {
                if (cmaps == null) throw new BadMappingException("cmap == null and cmaps == null ??");
                float[][] fArray = ((Field)data).getFloats(false);
                float[][] new_values = new float[][]{cmaps[permute[0]].scaleValues(fArray[permute[0]]), cmaps[permute[1]].scaleValues(fArray[permute[1]]), cmaps[permute[2]].scaleValues(fArray[permute[2]])};
                float[][] fArrayArray = new_values;
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                int i6 = 0;
                while (i6 < domain_length) {
                    if (fArrayArray[0][i6] != fArrayArray[0][i6] || fArrayArray[1][i6] != fArrayArray[1][i6] || fArrayArray[2][i6] != fArrayArray[2][i6]) {
                        color_ints[i6] = 0;
                    } else {
                        c = (int)(255.0 * (double)fArrayArray[0][i6]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)fArrayArray[1][i6]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)fArrayArray[2][i6]);
                        int b = c < 0 ? 0 : (c > 255 ? 255 : c);
                        color_ints[i6] = a << 24 | r << 16 | g << 8 | b;
                    }
                    ++i6;
                }
                Object var40_55 = null;
            }
            if (!Domain2.getAllSpatial() || Domain2.getMultipleDisplayScalar()) {
                throw new BadMappingException("domain must be only spatial");
            }
            boolean bl = adaptedShadowType.getIsTextureMap() && (domain_set instanceof Linear2DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
            int cMapCurveSize = (int)default_values[display.getDisplayScalarIndex(Display.CurvedSize)];
            int curved_size = cMapCurveSize > 0 ? cMapCurveSize : display.getGraphicsModeControl().getCurvedSize();
            boolean curvedTexture = adaptedShadowType.getCurvedTexture() && !bl && curved_size > 0 && (domain_set instanceof Gridded2DSet || domain_set instanceof GriddedSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
            Object coordinates = null;
            Object texCoords = null;
            Object normals = null;
            Object colors = null;
            boolean data_width = false;
            boolean data_height = false;
            boolean texture_width = true;
            boolean texture_height = true;
            Object coordinatesX = null;
            Object texCoordsX = null;
            Object normalsX = null;
            Object colorsX = null;
            Object coordinatesY = null;
            Object texCoordsY = null;
            Object normalsY = null;
            Object colorsY = null;
            if (color_length == 4) {
                constant_alpha = Float.NaN;
            }
            if (bl) {
                lens = ((GriddedSet)domain_set).getLengths();
                int limit = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
                int y_sub_len = lens[1];
                int n_y_sub = 1;
                while (y_sub_len >= limit) {
                    y_sub_len /= 2;
                    n_y_sub *= 2;
                }
                int[][] y_start_stop = new int[n_y_sub][2];
                int k = 0;
                while (k < n_y_sub - 1) {
                    y_start_stop[k][0] = k * y_sub_len;
                    y_start_stop[k][1] = (k + 1) * y_sub_len - 1;
                    ++k;
                }
                int k2 = n_y_sub - 1;
                y_start_stop[k2][0] = k2 * y_sub_len;
                y_start_stop[k2][1] = lens[1] - 1;
                int x_sub_len = lens[0];
                int n_x_sub = 1;
                while (x_sub_len >= limit) {
                    x_sub_len /= 2;
                    n_x_sub *= 2;
                }
                int[][] x_start_stop = new int[n_x_sub][2];
                k2 = 0;
                while (k2 < n_x_sub - 1) {
                    x_start_stop[k2][0] = k2 * x_sub_len;
                    x_start_stop[k2][1] = (k2 + 1) * x_sub_len - 1;
                    ++k2;
                }
                k2 = n_x_sub - 1;
                x_start_stop[k2][0] = k2 * x_sub_len;
                x_start_stop[k2][1] = lens[0] - 1;
                if (n_y_sub == 1 && n_x_sub == 1) {
                    this.buildLinearTexture(group, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_ints, display);
                } else {
                    BranchGroup branch = new BranchGroup();
                    branch.setCapability(17);
                    branch.setCapability(14);
                    branch.setCapability(12);
                    branch.setCapability(13);
                    int start = 0;
                    int i_total = 0;
                    int i7 = 0;
                    while (i7 < n_y_sub) {
                        int leny = y_start_stop[i7][1] - y_start_stop[i7][0] + 1;
                        int j = 0;
                        while (j < n_x_sub) {
                            int lenx = x_start_stop[j][1] - x_start_stop[j][0] + 1;
                            float[][] g00 = ((GriddedSet)domain_set).gridToValue(new float[][]{{x_start_stop[j][0]}, {y_start_stop[i7][0]}});
                            float[][] g11 = ((GriddedSet)domain_set).gridToValue(new float[][]{{x_start_stop[j][1]}, {y_start_stop[i7][1]}});
                            double x0 = g00[0][0];
                            double x1 = g11[0][0];
                            double y0 = g00[1][0];
                            double y1 = g11[1][0];
                            Linear2DSet dset = new Linear2DSet(x0, x1, lenx, y0, y1, leny);
                            int[] color_intsW = new int[lenx * leny];
                            int cnt = 0;
                            k2 = 0;
                            while (k2 < leny) {
                                start = x_start_stop[j][0] + i_total * lens[0] + k2 * lens[0];
                                System.arraycopy(color_ints, start, color_intsW, cnt, lenx);
                                cnt += lenx;
                                ++k2;
                            }
                            BranchGroup branch1 = new BranchGroup();
                            branch1.setCapability(17);
                            branch1.setCapability(14);
                            branch1.setCapability(12);
                            branch1.setCapability(13);
                            this.buildLinearTexture(branch1, dset, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_intsW, display);
                            branch.addChild((Node)branch1);
                            ++j;
                        }
                        i_total += leny;
                        ++i7;
                    }
                    if (((Group)group).numChildren() > 0) {
                        ((Group)group).setChild((Node)branch, 0);
                    } else {
                        ((Group)group).addChild((Node)branch);
                    }
                }
            } else {
                if (!curvedTexture) throw new BadMappingException("must be texture map or curved texture map");
                lens = ((GriddedSet)domain_set).getLengths();
                int limit = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
                int y_sub_len = lens[1];
                int n_y_sub = 1;
                while (y_sub_len >= limit) {
                    y_sub_len /= 2;
                    n_y_sub *= 2;
                }
                int[][] y_start_stop = new int[n_y_sub][2];
                int k = 0;
                while (k < n_y_sub - 1) {
                    y_start_stop[k][0] = k * y_sub_len;
                    y_start_stop[k][1] = (k + 1) * y_sub_len - 1;
                    ++k;
                }
                int k3 = n_y_sub - 1;
                y_start_stop[k3][0] = k3 * y_sub_len;
                y_start_stop[k3][1] = lens[1] - 1;
                int x_sub_len = lens[0];
                int n_x_sub = 1;
                while (x_sub_len >= limit) {
                    x_sub_len /= 2;
                    n_x_sub *= 2;
                }
                int[][] x_start_stop = new int[n_x_sub][2];
                k3 = 0;
                while (k3 < n_x_sub - 1) {
                    x_start_stop[k3][0] = k3 * x_sub_len;
                    x_start_stop[k3][1] = (k3 + 1) * x_sub_len - 1;
                    ++k3;
                }
                k3 = n_x_sub - 1;
                x_start_stop[k3][0] = k3 * x_sub_len;
                x_start_stop[k3][1] = lens[0] - 1;
                if (n_y_sub == 1 && n_x_sub == 1) {
                    this.buildCurvedTexture(group, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_ints, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{0, 0}, lens[0], lens[1], null, lens[0], lens[1]);
                } else {
                    float[][] samples = ((GriddedSet)domain_set).getSamples(false);
                    BranchGroup branch = new BranchGroup();
                    branch.setCapability(17);
                    branch.setCapability(14);
                    branch.setCapability(12);
                    branch.setCapability(13);
                    int start = 0;
                    int i_total = 0;
                    int i8 = 0;
                    while (i8 < n_y_sub) {
                        int leny = y_start_stop[i8][1] - y_start_stop[i8][0] + 1;
                        int j = 0;
                        while (j < n_x_sub) {
                            float[][] samplesC;
                            int lenx = x_start_stop[j][1] - x_start_stop[j][0] + 1;
                            if (j > 0) {
                                samplesC = new float[2][4 * leny];
                                int[] color_intsC = new int[4 * leny];
                                int cntv = 0;
                                int startv = x_start_stop[j][0] + i_total * lens[0];
                                int iv = 0;
                                while (iv < leny) {
                                    samplesC[0][cntv] = samples[0][startv - 2];
                                    samplesC[0][cntv + 1] = samples[0][startv - 1];
                                    samplesC[0][cntv + 2] = samples[0][startv];
                                    samplesC[0][cntv + 3] = samples[0][startv + 1];
                                    samplesC[1][cntv] = samples[1][startv - 2];
                                    samplesC[1][cntv + 1] = samples[1][startv - 1];
                                    samplesC[1][cntv + 2] = samples[1][startv];
                                    samplesC[1][cntv + 3] = samples[1][startv + 1];
                                    color_intsC[cntv] = color_ints[startv - 2];
                                    color_intsC[cntv + 1] = color_ints[startv - 1];
                                    color_intsC[cntv + 2] = color_ints[startv];
                                    color_intsC[cntv + 3] = color_ints[startv + 1];
                                    cntv += 4;
                                    startv += lens[0];
                                    ++iv;
                                }
                                Gridded2DSet gsetv = new Gridded2DSet(domain_set.getType(), samplesC, 4, leny);
                                BranchGroup branchv = new BranchGroup();
                                branchv.setCapability(17);
                                branchv.setCapability(14);
                                branchv.setCapability(12);
                                branchv.setCapability(13);
                                this.buildCurvedTexture(branchv, gsetv, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_intsC, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j][0], y_start_stop[i8][0]}, lenx, leny, samples, lens[0], lens[1]);
                                branch.addChild((Node)branchv);
                            }
                            if (i8 > 0) {
                                samplesC = new float[2][4 * lenx];
                                int[] color_intsC = new int[4 * lenx];
                                int starth = x_start_stop[j][0] + i_total * lens[0];
                                int cnth = 0;
                                System.arraycopy(samples[0], starth - 2 * lens[0], samplesC[0], cnth, lenx);
                                System.arraycopy(samples[1], starth - 2 * lens[0], samplesC[1], cnth, lenx);
                                System.arraycopy(samples[0], starth - 1 * lens[0], samplesC[0], cnth += lenx, lenx);
                                System.arraycopy(samples[1], starth - 1 * lens[0], samplesC[1], cnth, lenx);
                                System.arraycopy(samples[0], starth, samplesC[0], cnth += lenx, lenx);
                                System.arraycopy(samples[1], starth, samplesC[1], cnth, lenx);
                                System.arraycopy(samples[0], starth + 1 * lens[0], samplesC[0], cnth += lenx, lenx);
                                System.arraycopy(samples[1], starth + 1 * lens[0], samplesC[1], cnth, lenx);
                                cnth = 0;
                                System.arraycopy(color_ints, starth - 2 * lens[0], color_intsC, cnth, lenx);
                                System.arraycopy(color_ints, starth - 1 * lens[0], color_intsC, cnth += lenx, lenx);
                                System.arraycopy(color_ints, starth, color_intsC, cnth += lenx, lenx);
                                System.arraycopy(color_ints, starth + 1 * lens[0], color_intsC, cnth += lenx, lenx);
                                Gridded2DSet gseth = new Gridded2DSet(domain_set.getType(), samplesC, lenx, 4);
                                BranchGroup branchh = new BranchGroup();
                                branchh.setCapability(17);
                                branchh.setCapability(14);
                                branchh.setCapability(12);
                                branchh.setCapability(13);
                                this.buildCurvedTexture(branchh, gseth, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_intsC, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j][0], y_start_stop[i8][0]}, lenx, leny, samples, lens[0], lens[1]);
                                branch.addChild((Node)branchh);
                            }
                            int[] color_intsW = new int[lenx * leny];
                            int cnt = 0;
                            k3 = 0;
                            while (k3 < leny) {
                                start = x_start_stop[j][0] + i_total * lens[0] + k3 * lens[0];
                                System.arraycopy(color_ints, start, color_intsW, cnt, lenx);
                                cnt += lenx;
                                ++k3;
                            }
                            Set gset1 = null;
                            BranchGroup branch1 = new BranchGroup();
                            branch1.setCapability(17);
                            branch1.setCapability(14);
                            branch1.setCapability(12);
                            branch1.setCapability(13);
                            this.buildCurvedTexture(branch1, gset1, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_intsW, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j][0], y_start_stop[i8][0]}, lenx, leny, samples, lens[0], lens[1]);
                            branch.addChild((Node)branch1);
                            ++j;
                        }
                        i_total += leny;
                        ++i8;
                    }
                    color_ints = null;
                    if (((Group)group).numChildren() > 0) {
                        ((Group)group).setChild((Node)branch, 0);
                    } else {
                        ((Group)group).addChild((Node)branch);
                    }
                }
            }
        } else {
            int j;
            Node node;
            ScalarMap map;
            Vector domain_maps = DomainComponents[0].getSelectedMapVector();
            ScalarMap amap = null;
            if (domain_set.getDimension() == 1 && domain_maps.size() == 1 && Display.Animation.equals((map = (ScalarMap)domain_maps.elementAt(0)).getDisplayScalar())) {
                amap = map;
            }
            if (amap == null) {
                throw new BadMappingException("time must be mapped to Animation");
            }
            AnimationControlJ3D control = (AnimationControlJ3D)amap.getControl();
            Switch old_swit = null;
            BranchGroup[] old_nodes = null;
            double[] old_times = null;
            boolean[] old_mark = null;
            int old_len = 0;
            boolean reuse = ((ImageRendererJ3D)renderer).getReUseFrames();
            if (group instanceof BranchGroup && ((BranchGroup)group).numChildren() > 0 && (node = ((BranchGroup)group).getChild(0)) instanceof Switch && (old_len = (old_swit = (Switch)node).numChildren()) > 0) {
                old_nodes = new BranchGroup[old_len];
                int i9 = 0;
                while (i9 < old_len) {
                    old_nodes[i9] = (BranchGroup)old_swit.getChild(i9);
                    ++i9;
                }
                int i10 = 0;
                while (i10 < old_len) {
                    old_nodes[i10].detach();
                    ++i10;
                }
                old_times = new double[old_len];
                old_mark = new boolean[old_len];
                int i11 = 0;
                while (i11 < old_len) {
                    old_mark[i11] = false;
                    old_times[i11] = old_nodes[i11] instanceof VisADBranchGroup && reuse ? ((VisADBranchGroup)old_nodes[i11]).getTime() : Double.NaN;
                    ++i11;
                }
            }
            double[][] dArray = domain_set.getDoubles();
            double[] times = dArray[0];
            int len = times.length;
            double delta = Math.abs((times[len - 1] - times[0]) / (1000.0 * (double)len));
            Switch swit = null;
            if (old_swit != null) {
                swit = old_swit;
                control.addPair(swit, domain_set, renderer);
                ((AVControlJ3D)control).init();
            } else {
                swit = (Switch)this.makeSwitch();
                swit.setCapability(14);
                swit.setCapability(12);
                swit.setCapability(13);
                this.addSwitch(group, swit, control, domain_set, renderer);
            }
            VisADBranchGroup[] nodes = new VisADBranchGroup[len];
            boolean[] mark = new boolean[len];
            int i12 = 0;
            while (i12 < len) {
                j = 0;
                while (j < old_len) {
                    if (!old_mark[j] && Math.abs(times[i12] - old_times[j]) < delta) {
                        old_mark[j] = true;
                        nodes[i12] = (VisADBranchGroup)old_nodes[j];
                        break;
                    }
                    ++j;
                }
                if (nodes[i12] != null) {
                    mark[i12] = true;
                } else {
                    mark[i12] = false;
                    nodes[i12] = new VisADBranchGroup(times[i12]);
                    nodes[i12].setCapability(17);
                    nodes[i12].setCapability(14);
                    nodes[i12].setCapability(12);
                    nodes[i12].setCapability(13);
                    this.ensureNotEmpty((Object)nodes[i12]);
                }
                this.addToSwitch(swit, (Object)nodes[i12]);
                ++i12;
            }
            j = 0;
            while (j < old_len) {
                if (!old_mark[j]) {
                    ((RendererJ3D)renderer).flush((Group)old_nodes[j]);
                }
                ++j;
            }
            if (group instanceof BranchGroup) {
                ((ImageRendererJ3D)renderer).setBranchEarly((BranchGroup)group);
            }
            if (((ImageRendererJ3D)renderer).getReUseFrames() && ((ImageRendererJ3D)renderer).getSetSetOnReUseFrames()) {
                control.setSet(domain_set, true);
            }
            int i13 = 0;
            while (i13 < len) {
                if (!mark[i13]) {
                    BranchGroup branch = (BranchGroup)this.makeBranch();
                    ((ImageRendererJ3D)renderer).setVisADBranch(nodes[i13]);
                    this.recurseRange(branch, ((Field)data).getSample(i13), value_array, default_values, renderer);
                    ((ImageRendererJ3D)renderer).setVisADBranch(null);
                    nodes[i13].addChild((Node)branch);
                }
                ++i13;
            }
        }
        this.ensureNotEmpty(group);
        return false;
    }

    public void buildCurvedTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, int[] color_ints, DisplayImpl display, int curved_size, ShadowRealTupleType Domain2, CoordinateSystem dataCoordinateSystem, DataRenderer renderer, ShadowFunctionOrSetType adaptedShadowType, int[] start, int lenX, int lenY, float[][] samples, int bigX, int bigY) throws VisADException, DisplayException {
        int len;
        RealTupleType ref;
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        int[] lengths = null;
        lengths = domain_set != null ? ((GriddedSet)domain_set).getLengths() : new int[]{lenX, lenY};
        data_width = lengths[0];
        data_height = lengths[1];
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        int size = (data_width + data_height) / 2;
        curved_size = Math.max(2, Math.min(curved_size, size / 32));
        int nwidth = 2 + (data_width - 1) / curved_size;
        int nheight = 2 + (data_height - 1) / curved_size;
        int nn = nwidth * nheight;
        int[] is = new int[nwidth];
        int[] js = new int[nheight];
        int i = 0;
        while (i < nwidth) {
            is[i] = Math.min(i * curved_size, data_width - 1);
            ++i;
        }
        int j = 0;
        while (j < nheight) {
            js[j] = Math.min(j * curved_size, data_height - 1);
            ++j;
        }
        int[] indices = new int[nn];
        int k = 0;
        int j2 = 0;
        while (j2 < nheight) {
            int i2 = 0;
            while (i2 < nwidth) {
                indices[k] = is[i2] + data_width * js[j2];
                ++k;
                ++i2;
            }
            ++j2;
        }
        float[][] spline_domain = null;
        if (domain_set == null) {
            int kk = 0;
            while (kk < indices.length) {
                int x = indices[kk] % lenX;
                int y = indices[kk] / lenX;
                indices[kk] = start[0] + x + (start[1] + y) * bigX;
                ++kk;
            }
            spline_domain = new float[2][indices.length];
            int kk2 = 0;
            while (kk2 < indices.length) {
                spline_domain[0][kk2] = samples[0][indices[kk2]];
                spline_domain[1][kk2] = samples[1][indices[kk2]];
                ++kk2;
            }
        } else {
            spline_domain = domain_set.indexToValue(indices);
        }
        spline_domain = Unit.convertTuple(spline_domain, dataUnits, domain_units, false);
        ShadowRealTupleType domain_reference = Domain2.getReference();
        ShadowRealType[] DC = DomainComponents;
        if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
            ref = (RealTupleType)domain_reference.getType();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref.getDefaultUnits(), (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
            spline_domain = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)Domain2.getType(), dataCoordinateSystem, domain_units, null, spline_domain);
            DC = adaptedShadowType.getDomainReferenceComponents();
        } else {
            ref = domain_reference == null ? null : (RealTupleType)domain_reference.getType();
            Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref_units, (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
        }
        int[] tuple_index = new int[3];
        int[] spatial_value_indices = new int[]{-1, -1, -1};
        ScalarMap[] spatial_maps = new ScalarMap[3];
        DisplayTupleType spatial_tuple = null;
        int i3 = 0;
        while (i3 < DC.length) {
            Enumeration maps = DC[i3].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            DisplayRealType real = map.getDisplayScalar();
            spatial_tuple = real.getTuple();
            if (spatial_tuple == null) {
                throw new DisplayException("texture with bad tuple: ShadowImageFunctionTypeJ3D.doTransform");
            }
            tuple_index[i3] = real.getTupleIndex();
            spatial_value_indices[tuple_index[i3]] = map.getValueIndex();
            spatial_maps[tuple_index[i3]] = map;
            if (maps.hasMoreElements()) {
                throw new DisplayException("texture with multiple spatial: ShadowImageFunctionTypeJ3D.doTransform");
            }
            ++i3;
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)spatial_tuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        int i4 = 0;
        while (i4 < valueArrayLength) {
            if (inherited_values[i4] > 0 && real.equals(display.getDisplayScalar(valueToScalar[i4]))) {
                value2 = value_array[i4];
                break;
            }
            ++i4;
        }
        Object spatial_values = new float[3][];
        spatial_values[tuple_index[0]] = spline_domain[0];
        spatial_values[tuple_index[1]] = spline_domain[1];
        spatial_values[tuple_index[2]] = new float[nn];
        int i5 = 0;
        while (i5 < nn) {
            spatial_values[tuple_index[2]][i5] = value2;
            ++i5;
        }
        int i6 = 0;
        while (i6 < 3) {
            if (spatial_maps[i6] != null) {
                spatial_values[i6] = spatial_maps[i6].scaleValues(spatial_values[i6]);
            }
            ++i6;
        }
        if (spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
            renderer.setEarthSpatialDisplay(null, spatial_tuple, display, spatial_value_indices, default_values, null);
        } else {
            CoordinateSystem coord = spatial_tuple.getCoordinateSystem();
            spatial_values = coord.toReference((float[][])spatial_values);
            renderer.setEarthSpatialDisplay(coord, spatial_tuple, display, spatial_value_indices, default_values, null);
        }
        coordinates = new float[3 * nn];
        k = 0;
        int i7 = 0;
        while (i7 < nn) {
            coordinates[k++] = spatial_values[0][i7];
            coordinates[k++] = spatial_values[1][i7];
            coordinates[k++] = spatial_values[2][i7];
            ++i7;
        }
        boolean spatial_all_select = true;
        int i8 = 0;
        while (i8 < 3 * nn) {
            if (coordinates[i8] != coordinates[i8]) {
                spatial_all_select = false;
            }
            ++i8;
        }
        normals = Gridded3DSet.makeNormals(coordinates, nwidth, nheight);
        colors = new byte[3 * nn];
        int i9 = 0;
        while (i9 < 3 * nn) {
            colors[i9] = 127;
            ++i9;
        }
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        float half_width = 0.5f / (float)texture_width;
        float half_height = 0.5f / (float)texture_height;
        float width = 1.0f / (float)texture_width;
        float height = 1.0f / (float)texture_height;
        int mt = 0;
        texCoords = new float[2 * nn];
        int j3 = 0;
        while (j3 < nheight) {
            int i10 = 0;
            while (i10 < nwidth) {
                float isfactor = (float)is[i10] / ((float)data_width - 1.0f);
                float jsfactor = (float)js[j3] / ((float)data_height - 1.0f);
                texCoords[mt++] = (ratiow - width) * isfactor + half_width;
                texCoords[mt++] = 1.0f - (ratioh - height) * jsfactor - half_height;
                ++i10;
            }
            ++j3;
        }
        VisADTriangleStripArray tarray = new VisADTriangleStripArray();
        tarray.stripVertexCounts = new int[nheight - 1];
        int i11 = 0;
        while (i11 < nheight - 1) {
            tarray.stripVertexCounts[i11] = 2 * nwidth;
            ++i11;
        }
        tarray.vertexCount = len = (nheight - 1) * (2 * nwidth);
        tarray.normals = new float[3 * len];
        tarray.coordinates = new float[3 * len];
        tarray.colors = new byte[3 * len];
        tarray.texCoords = new float[2 * len];
        k = 0;
        int kt = 0;
        int nwidth3 = 3 * nwidth;
        int nwidth2 = 2 * nwidth;
        int i12 = 0;
        while (i12 < nheight - 1) {
            int m = i12 * nwidth3;
            mt = i12 * nwidth2;
            int j4 = 0;
            while (j4 < nwidth) {
                tarray.coordinates[k] = coordinates[m];
                tarray.coordinates[k + 1] = coordinates[m + 1];
                tarray.coordinates[k + 2] = coordinates[m + 2];
                tarray.coordinates[k + 3] = coordinates[m + nwidth3];
                tarray.coordinates[k + 4] = coordinates[m + nwidth3 + 1];
                tarray.coordinates[k + 5] = coordinates[m + nwidth3 + 2];
                tarray.normals[k] = normals[m];
                tarray.normals[k + 1] = normals[m + 1];
                tarray.normals[k + 2] = normals[m + 2];
                tarray.normals[k + 3] = normals[m + nwidth3];
                tarray.normals[k + 4] = normals[m + nwidth3 + 1];
                tarray.normals[k + 5] = normals[m + nwidth3 + 2];
                tarray.colors[k] = colors[m];
                tarray.colors[k + 1] = colors[m + 1];
                tarray.colors[k + 2] = colors[m + 2];
                tarray.colors[k + 3] = colors[m + nwidth3];
                tarray.colors[k + 4] = colors[m + nwidth3 + 1];
                tarray.colors[k + 5] = colors[m + nwidth3 + 2];
                tarray.texCoords[kt] = texCoords[mt];
                tarray.texCoords[kt + 1] = texCoords[mt + 1];
                tarray.texCoords[kt + 2] = texCoords[mt + nwidth2];
                tarray.texCoords[kt + 3] = texCoords[mt + nwidth2 + 1];
                k += 6;
                m += 3;
                kt += 4;
                mt += 2;
                ++j4;
            }
            ++i12;
        }
        if (!spatial_all_select) {
            tarray = (VisADTriangleStripArray)tarray.removeMissing();
        }
        tarray = (VisADTriangleStripArray)tarray.adjustLongitude(renderer);
        tarray = (VisADTriangleStripArray)tarray.adjustSeam(renderer);
        BufferedImage image = this.createImage(data_width, data_height, texture_width, texture_height, color_ints);
        this.textureToGroup(group, tarray, image, mode, constant_alpha, constant_color, texture_width, texture_height);
    }

    public void buildLinearTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, int[] color_ints, DisplayImpl display) throws VisADException, DisplayException {
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        Linear1DSet X = null;
        Linear1DSet Y = null;
        if (domain_set instanceof Linear2DSet) {
            X = ((Linear2DSet)domain_set).getX();
            Y = ((Linear2DSet)domain_set).getY();
        } else {
            X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
            Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
        }
        float[][] limits = new float[2][2];
        limits[0][0] = (float)X.getFirst();
        limits[0][1] = (float)X.getLast();
        limits[1][0] = (float)Y.getFirst();
        limits[1][1] = (float)Y.getLast();
        data_width = X.getLength();
        data_height = Y.getLength();
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        float half_width = 0.5f / (float)(data_width - 1);
        float half_height = 0.5f / (float)(data_height - 1);
        half_width = (limits[0][1] - limits[0][0]) * half_width;
        half_height = (limits[1][1] - limits[1][0]) * half_height;
        float[] fArray = limits[0];
        fArray[0] = fArray[0] - half_width;
        float[] fArray2 = limits[0];
        fArray2[1] = fArray2[1] + half_width;
        float[] fArray3 = limits[1];
        fArray3[0] = fArray3[0] - half_height;
        float[] fArray4 = limits[1];
        fArray4[1] = fArray4[1] + half_height;
        limits = Unit.convertTuple(limits, dataUnits, domain_units);
        int[] tuple_index = new int[3];
        if (DomainComponents.length != 2) {
            throw new DisplayException("texture domain dimension != 2:ShadowFunctionOrSetType.doTransform");
        }
        int i = 0;
        while (i < DomainComponents.length) {
            Enumeration maps = DomainComponents[i].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            limits[i] = map.scaleValues(limits[i]);
            DisplayRealType real = map.getDisplayScalar();
            DisplayTupleType tuple = real.getTuple();
            if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple)) {
                throw new DisplayException("texture with bad tuple: ShadowFunctionOrSetType.doTransform");
            }
            tuple_index[i] = real.getTupleIndex();
            if (maps.hasMoreElements()) {
                throw new DisplayException("texture with multiple spatial: ShadowFunctionOrSetType.doTransform");
            }
            ++i;
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)Display.DisplaySpatialCartesianTuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        int i2 = 0;
        while (i2 < valueArrayLength) {
            if (inherited_values[i2] > 0 && real.equals(display.getDisplayScalar(valueToScalar[i2]))) {
                value2 = value_array[i2];
                break;
            }
            ++i2;
        }
        coordinates = new float[12];
        coordinates[tuple_index[0]] = limits[0][0];
        coordinates[tuple_index[1]] = limits[1][0];
        coordinates[tuple_index[2]] = value2;
        coordinates[3 + tuple_index[0]] = limits[0][1];
        coordinates[3 + tuple_index[1]] = limits[1][0];
        coordinates[3 + tuple_index[2]] = value2;
        coordinates[6 + tuple_index[0]] = limits[0][1];
        coordinates[6 + tuple_index[1]] = limits[1][1];
        coordinates[6 + tuple_index[2]] = value2;
        coordinates[9 + tuple_index[0]] = limits[0][0];
        coordinates[9 + tuple_index[1]] = limits[1][1];
        coordinates[9 + tuple_index[2]] = value2;
        this.adjustZ(coordinates);
        texCoords = new float[8];
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        this.setTexCoords(texCoords, ratiow, ratioh);
        normals = new float[12];
        float n0 = (coordinates[5] - coordinates[2]) * (coordinates[7] - coordinates[1]) - (coordinates[4] - coordinates[1]) * (coordinates[8] - coordinates[2]);
        float n1 = (coordinates[3] - coordinates[0]) * (coordinates[8] - coordinates[2]) - (coordinates[5] - coordinates[2]) * (coordinates[6] - coordinates[0]);
        float n2 = (coordinates[4] - coordinates[1]) * (coordinates[6] - coordinates[0]) - (coordinates[3] - coordinates[0]) * (coordinates[7] - coordinates[1]);
        float nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
        normals[0] = n0 /= nlen;
        normals[1] = n1 /= nlen;
        normals[2] = n2 /= nlen;
        normals[3] = n0;
        normals[4] = n1;
        normals[5] = n2;
        normals[6] = n0;
        normals[7] = n1;
        normals[8] = n2;
        normals[9] = n0;
        normals[10] = n1;
        normals[11] = n2;
        colors = new byte[12];
        int i3 = 0;
        while (i3 < 12) {
            colors[i3] = 127;
            ++i3;
        }
        VisADQuadArray qarray = new VisADQuadArray();
        qarray.vertexCount = 4;
        qarray.coordinates = coordinates;
        qarray.texCoords = texCoords;
        qarray.colors = colors;
        qarray.normals = normals;
        BufferedImage image = this.createImage(data_width, data_height, texture_width, texture_height, color_ints);
        this.textureToGroup(group, qarray, image, mode, constant_alpha, constant_color, texture_width, texture_height);
    }

    public BufferedImage createImage(int data_width, int data_height, int texture_width, int texture_height, int[] color_ints) {
        int i;
        BufferedImage image = null;
        ColorModel colorModel = ColorModel.getRGBdefault();
        WritableRaster raster = colorModel.createCompatibleWritableRaster(texture_width, texture_height);
        image = new BufferedImage(colorModel, raster, false, null);
        int[] intData = ((DataBufferInt)raster.getDataBuffer()).getData();
        int k = 0;
        int m = 0;
        int j = 0;
        while (j < data_height) {
            int i2 = 0;
            while (i2 < data_width) {
                intData[m++] = color_ints[k++];
                ++i2;
            }
            i = data_width;
            while (i < texture_width) {
                intData[m++] = 0;
                ++i;
            }
            ++j;
        }
        int j2 = data_height;
        while (j2 < texture_height) {
            i = 0;
            while (i < texture_width) {
                intData[m++] = 0;
                ++i;
            }
            ++j2;
        }
        return image;
    }

    public static void main(String[] args) {
        String mapFile = "OUTLSUPW";
        String areaFile = "AREA2001";
        boolean threeD = true;
        boolean remap = false;
        JFrame frame = new JFrame("Map Display");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        if (args.length > 0 && !args[0].equals("X")) {
            areaFile = args[0];
        }
        if (args.length == 2) {
            threeD = args[1].indexOf("2") < 0;
            remap = args[1].indexOf("2") < 0;
        }
        boolean gif = areaFile.endsWith("gif") || areaFile.endsWith("GIF") || areaFile.endsWith("jpg") || areaFile.endsWith("JPG");
        try {
            Set[] setArray;
            baseMap = mapFile.indexOf("://") > 0 ? new BaseMapAdapter(new URL(mapFile)) : new BaseMapAdapter(mapFile);
            if (gif) {
                display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                lat_map = new ScalarMap(RealType.getRealType("ImageLine"), Display.YAxis);
                lon_map = new ScalarMap(RealType.getRealType("ImageElement"), Display.XAxis);
            } else if (threeD) {
                display = new DisplayImplJ3D("display");
                lat_map = new ScalarMap(RealType.Latitude, Display.Latitude);
                lon_map = new ScalarMap(RealType.Longitude, Display.Longitude);
            } else {
                display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                lat_map = new ScalarMap(RealType.Latitude, Display.YAxis);
                lon_map = new ScalarMap(RealType.Longitude, Display.XAxis);
            }
            display.addMap(lat_map);
            display.addMap(lon_map);
            if (!gif) {
                lat_map.setRange(-90.0, 90.0);
                lon_map.setRange(-180.0, 180.0);
            }
            DataReferenceImpl maplines_ref = new DataReferenceImpl("MapLines");
            maplines_ref.setData(baseMap.getData());
            ConstantMap[] colMap = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.001, Display.Radius)};
            FlatField imaget = null;
            if (gif) {
                GIFForm gif_form = new GIFForm();
                imaget = (FlatField)gif_form.open(areaFile);
            } else {
                AreaAdapter aa = new AreaAdapter(areaFile);
                imaget = aa.getData();
            }
            FunctionType ftype = (FunctionType)imaget.getType();
            RealTupleType dtype = ftype.getDomain();
            RealTupleType rtype = (RealTupleType)ftype.getRange();
            if (remap) {
                int SIZE = 256;
                RealTupleType lat_lon = dtype.getCoordinateSystem().getReference();
                Linear2DSet dset = new Linear2DSet((MathType)lat_lon, -4.0, 70.0, SIZE, -150.0, 5.0, SIZE);
                imaget = (FlatField)imaget.resample(dset, 100, 202);
                ftype = (FunctionType)imaget.getType();
                dtype = ftype.getDomain();
            }
            if (gif) {
                ScalarMap rmap = new ScalarMap((RealType)rtype.getComponent(0), Display.Red);
                display.addMap(rmap);
                ScalarMap gmap = new ScalarMap((RealType)rtype.getComponent(1), Display.Green);
                display.addMap(gmap);
                ScalarMap bmap = new ScalarMap((RealType)rtype.getComponent(2), Display.Blue);
                display.addMap(bmap);
            } else {
                ScalarMap rgbmap = new ScalarMap((RealType)rtype.getComponent(0), Display.RGBA);
                display.addMap(rgbmap);
                BaseColorControl control = (BaseColorControl)rgbmap.getControl();
                control.initGreyWedge();
                float[][] table = control.getTable();
                int i = 0;
                while (i < table[3].length) {
                    table[3][i] = table[0][i];
                    ++i;
                }
                control.setTable(table);
            }
            DataReferenceImpl ref_image = new DataReferenceImpl("ref_image");
            if (gif) {
                Set[] setArray2 = new Set[3];
                setArray2[0] = new Linear1DSet(0.0, 255.0, 255);
                setArray2[1] = new Linear1DSet(0.0, 255.0, 255);
                setArray = setArray2;
                setArray2[2] = new Linear1DSet(0.0, 255.0, 255);
            } else {
                Set[] setArray3 = new Set[1];
                setArray = setArray3;
                setArray3[0] = new Integer1DSet(255);
            }
            Set[] range_sets = setArray;
            FlatField new_field = new FlatField(ftype, imaget.getDomainSet(), null, null, range_sets, null);
            float[][] values = imaget.getFloats(false);
            new_field.setSamples(values);
            imaget = new_field;
            ref_image.setData(imaget);
            display.disableAction();
            display.addReferences((DataRenderer)new ImageRendererJ3D(), ref_image);
            display.addReference(maplines_ref, colMap);
            display.enableAction();
        }
        catch (Exception ne) {
            ne.printStackTrace();
            System.exit(1);
        }
        frame.getContentPane().add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

