/*
 * Decompiled with CFR 0.152.
 */
package visad.aeri;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.ColorControl;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.VisADException;
import visad.bom.WindPolarCoordinateSystem;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.data.netcdf.Plain;
import visad.data.visad.VisADSerialForm;
import visad.java3d.DisplayImplJ3D;
import visad.meteorology.ImageSequence;
import visad.meteorology.ImageSequenceManager;
import visad.meteorology.NavigatedImage;
import visad.meteorology.SingleBandedImage;
import visad.util.AnimationWidget;
import visad.util.ColorMapWidget;
import visad.util.LabeledColorWidget;

public class Aeri
implements ScalarMapListener {
    RealType latitude;
    RealType longitude;
    RealType altitude;
    RealTupleType spatial_domain;
    RealType time;
    RealType stn_idx;
    RealType temp;
    RealType dwpt;
    RealType wvmr;
    RealType RH;
    RealType theta;
    RealType thetaE;
    RealType band1 = null;
    RealTupleType advect_range;
    FunctionType advect_type;
    FunctionType advect_field_type;
    FieldImpl advect_field;
    FieldImpl stations_field;
    ImageSequence image_seq;
    int n_stations = 5;
    double[] station_lat;
    double[] station_lon;
    double[] station_alt;
    double[] station_id;
    BaseMapAdapter baseMap;
    DataReference map_ref;
    DataReference img_ref;
    ScalarMap xmap;
    ScalarMap ymap;
    ScalarMap zmap;
    ScalarMap img_map;
    boolean xmapEvent = false;
    boolean ymapEvent = false;
    boolean imgEvent = false;
    boolean first_xy_Event = false;
    boolean first_img_Event = false;
    float latmin;
    float latmax;
    float lonmin;
    float lonmax;
    float del_lat;
    float del_lon;
    double[] x_range;
    double[] y_range;
    int height_limit = 3000;
    boolean rh = false;
    boolean tm = false;
    boolean pt = false;
    boolean ept = false;
    int start_date = 0;
    double start_time = 0.0;
    double lon_min = Double.MAX_VALUE;
    double lon_max = -1.7976931348623157E308;
    double lat_min = Double.MAX_VALUE;
    double lat_max = -1.7976931348623157E308;
    double hgt_max = -1.7976931348623157E308;

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        Aeri aeri = new Aeri(args);
    }

    public Aeri(String[] args) throws VisADException, RemoteException, IOException {
        String vadfile = null;
        String baseDate = "20000112";
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                if (args[i].endsWith(".vad")) {
                    vadfile = args[i];
                } else if (args[i].equals("-limit") && i + 1 < args.length) {
                    try {
                        this.height_limit = Integer.parseInt(args[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("bad height limit: " + args[i + 1]);
                    }
                    ++i;
                } else if (args[i].equals("-date") && i + 1 < args.length) {
                    baseDate = args[i + 1];
                    ++i;
                } else if (args[i].equals("-rh")) {
                    this.rh = true;
                    this.tm = false;
                } else if (args[i].equals("-temp")) {
                    this.tm = true;
                    this.rh = false;
                } else if (args[i].equals("-theta")) {
                    this.pt = true;
                } else if (args[i].equals("-thetaE")) {
                    this.ept = true;
                }
            }
            ++i;
        }
        if (vadfile != null) {
            this.init_from_vad(vadfile);
        } else {
            this.init_from_cdf(baseDate);
        }
        this.wvmr.alias("MR");
        this.temp.alias("T");
        try {
            String fs = System.getProperty("file.separator");
            this.image_seq = Aeri.init_images("." + fs + "data" + fs + "image" + fs + baseDate);
            this.band1 = (RealType)((RealTupleType)((FunctionType)((FunctionType)this.image_seq.getType()).getRange()).getRange()).getComponent(0);
        }
        catch (Exception e) {
            System.out.println("no AREA image data, proceeding...");
            this.image_seq = null;
        }
        JFrame frame = new JFrame("VisAD AERI Viewer");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        frame.getContentPane().add(panel);
        DisplayImpl display = this.makeDisplay(panel);
        int WIDTH = 1000;
        int HEIGHT = 600;
        frame.setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        frame.setVisible(true);
    }

    void init_from_cdf(String baseDate) throws VisADException, RemoteException, IOException {
        this.station_lat = new double[this.n_stations];
        this.station_lon = new double[this.n_stations];
        this.station_alt = new double[this.n_stations];
        this.station_id = new double[this.n_stations];
        this.longitude = RealType.Longitude;
        this.latitude = RealType.Latitude;
        this.RH = RealType.getRealType("RH", SI.second);
        this.stn_idx = RealType.getRealType("stn_idx");
        this.theta = RealType.getRealType("theta");
        this.thetaE = RealType.getRealType("thetaE");
        String[] wind_files = new String[this.n_stations];
        String[] rtvl_files = new String[this.n_stations];
        String truncatedDate = baseDate;
        wind_files[0] = "./data/" + baseDate + "_lamont_windprof.cdf";
        wind_files[1] = "./data/" + baseDate + "_hillsboro_windprof.cdf";
        wind_files[2] = "./data/" + baseDate + "_morris_windprof.cdf";
        wind_files[3] = "./data/" + baseDate + "_purcell_windprof.cdf";
        wind_files[4] = "./data/" + baseDate + "_vici_windprof.cdf";
        File file = new File("./data/lamont_" + truncatedDate + "AP.cdf");
        rtvl_files[0] = file.exists() ? "./data/lamont_" + truncatedDate + "AP.cdf" : "./data/lamont_" + truncatedDate + "AG.cdf";
        file = new File("./data/hillsboro_" + truncatedDate + "AP.cdf");
        rtvl_files[1] = file.exists() ? "./data/hillsboro_" + truncatedDate + "AP.cdf" : "./data/hillsboro_" + truncatedDate + "AG.cdf";
        file = new File("./data/morris_" + truncatedDate + "AP.cdf");
        rtvl_files[2] = file.exists() ? "./data/morris_" + truncatedDate + "AP.cdf" : "./data/morris_" + truncatedDate + "AG.cdf";
        file = new File("./data/purcell_" + truncatedDate + "AP.cdf");
        rtvl_files[3] = file.exists() ? "./data/purcell_" + truncatedDate + "AP.cdf" : "./data/purcell_" + truncatedDate + "AG.cdf";
        file = new File("./data/vici_" + truncatedDate + "AP.cdf");
        rtvl_files[4] = file.exists() ? "./data/vici_" + truncatedDate + "AP.cdf" : "./data/vici_" + truncatedDate + "AG.cdf";
        FieldImpl[] winds = this.makeWinds(wind_files);
        System.out.println(winds[0].getType().prettyString());
        FieldImpl[] rtvls = this.makeAeri(rtvl_files);
        System.out.println(rtvls[0].getType().prettyString());
        this.spatial_domain = new RealTupleType(this.longitude, this.latitude, this.altitude);
        RealType[] r_types = new RealType[]{this.temp, this.dwpt, this.wvmr, this.RH, this.theta, this.thetaE};
        this.advect_range = new RealTupleType(r_types);
        this.advect_type = new FunctionType(this.spatial_domain, this.advect_range);
        this.advect_field_type = new FunctionType(RealType.Time, this.advect_type);
        this.stations_field = new FieldImpl(new FunctionType(this.stn_idx, this.advect_field_type), new Integer1DSet(this.stn_idx, this.n_stations, null, null, null));
        int kk = 0;
        while (kk < this.n_stations) {
            this.advect_field = this.makeAdvect(winds[kk], rtvls[kk], kk);
            this.stations_field.setSample(kk, (Data)this.advect_field);
            ++kk;
        }
        VisADSerialForm vad_form = new VisADSerialForm();
        vad_form.save("aeri_winds_" + baseDate + "." + this.height_limit + ".vad", this.stations_field, true);
        System.out.println(this.stations_field.getType().prettyString());
    }

    void init_from_vad(String vad_file) throws VisADException, RemoteException, IOException {
        VisADSerialForm vad_form = new VisADSerialForm();
        this.stations_field = (FieldImpl)vad_form.open(vad_file);
        MathType file_type = this.stations_field.getType();
        this.stn_idx = (RealType)((FunctionType)file_type).getDomain().getComponent(0);
        FunctionType f_type0 = (FunctionType)((FunctionType)file_type).getRange();
        this.time = (RealType)f_type0.getDomain().getComponent(0);
        FunctionType f_type1 = (FunctionType)f_type0.getRange();
        this.spatial_domain = f_type1.getDomain();
        this.longitude = (RealType)this.spatial_domain.getComponent(0);
        this.latitude = (RealType)this.spatial_domain.getComponent(1);
        this.altitude = (RealType)this.spatial_domain.getComponent(2);
        RealTupleType rtt = (RealTupleType)f_type1.getRange();
        this.temp = (RealType)rtt.getComponent(0);
        this.dwpt = (RealType)rtt.getComponent(1);
        this.wvmr = (RealType)rtt.getComponent(2);
        this.RH = (RealType)rtt.getComponent(3);
        this.theta = (RealType)rtt.getComponent(4);
        this.thetaE = (RealType)rtt.getComponent(5);
    }

    public static ImageSequence init_images(String image_directory) throws VisADException, RemoteException, IOException {
        String fs = System.getProperty("file.separator");
        if (image_directory == null) {
            image_directory = "." + fs + "data" + fs + "image" + fs + "ir_display";
        }
        File file = new File(image_directory);
        String[] image_files = file.list();
        int n_images = image_files.length;
        SingleBandedImage[] nav_images = new NavigatedImage[n_images];
        int ii = 0;
        while (ii < n_images) {
            AreaAdapter area = new AreaAdapter(image_directory + fs + image_files[ii]);
            FlatField image = area.getData();
            DateTime img_start = area.getImageStartTime();
            nav_images[ii] = new NavigatedImage(image, img_start, "AREA");
            ++ii;
        }
        ImageSequenceManager img_manager = new ImageSequenceManager(nav_images);
        return img_manager.getImageSequence();
    }

    DisplayImpl makeDisplay(JPanel panel) throws VisADException, RemoteException, IOException {
        this.del_lon = 15.0f;
        this.del_lat = 15.0f;
        this.baseMap = new BaseMapAdapter("OUTLUSAM");
        this.map_ref = new DataReferenceImpl("map");
        if (!this.baseMap.isEastPositive()) {
            this.baseMap.setEastPositive(true);
        }
        DataImpl poles = this.makePoles();
        DataReferenceImpl poles_ref = new DataReferenceImpl("poles");
        poles_ref.setData(poles);
        DisplayImplJ3D display = new DisplayImplJ3D("aeri");
        GraphicsModeControl mode = ((DisplayImpl)display).getGraphicsModeControl();
        mode.setScaleEnable(true);
        DisplayRenderer dr = display.getDisplayRenderer();
        dr.setBoxOn(false);
        this.xmap = new ScalarMap(this.longitude, Display.XAxis);
        this.xmap.setScaleEnable(false);
        this.ymap = new ScalarMap(this.latitude, Display.YAxis);
        this.ymap.setScaleEnable(false);
        this.zmap = new ScalarMap(this.altitude, Display.ZAxis);
        display.addMap(this.xmap);
        display.addMap(this.ymap);
        display.addMap(this.zmap);
        ScalarMap cmap = null;
        cmap = this.rh ? new ScalarMap(this.RH, Display.RGB) : (this.tm ? new ScalarMap(this.temp, Display.RGB) : (this.pt ? new ScalarMap(this.theta, Display.RGB) : (this.ept ? new ScalarMap(this.thetaE, Display.RGB) : new ScalarMap(this.wvmr, Display.RGB))));
        display.addMap(cmap);
        ColorMapWidget cmw = new ColorMapWidget(cmap, null, true, false);
        LabeledColorWidget cwidget = new LabeledColorWidget(cmw);
        ScalarMap tmap = new ScalarMap(RealType.Time, Display.Animation);
        display.addMap(tmap);
        AnimationControl control = (AnimationControl)((Object)tmap.getControl());
        control.setStep(50);
        AnimationWidget awidget = new AnimationWidget(tmap);
        if (this.image_seq != null) {
            this.img_map = new ScalarMap(this.band1, Display.RGB);
            this.img_map.addScalarMapListener(this);
            display.addMap(this.img_map);
            ColorControl cc = (ColorControl)this.img_map.getControl();
            cc.initGreyWedge();
        }
        this.zmap.setRange(0.0, this.hgt_max);
        DataReferenceImpl advect_ref = new DataReferenceImpl("advect_ref");
        advect_ref.setData(this.stations_field);
        ConstantMap[] map_constMap = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Blue), new ConstantMap(-0.98, Display.ZAxis)};
        ConstantMap[] img_constMap = new ConstantMap[]{new ConstantMap(-0.99, Display.ZAxis)};
        this.img_ref = new DataReferenceImpl("image");
        display.disableAction();
        display.addReference(poles_ref);
        display.addReference(advect_ref);
        display.addReference(this.map_ref, map_constMap);
        if (this.image_seq != null) {
            display.addReference(this.img_ref, img_constMap);
        }
        this.xmap.addScalarMapListener(this);
        this.ymap.addScalarMapListener(this);
        display.enableAction();
        JPanel dpanel = new JPanel();
        dpanel.setLayout(new BoxLayout(dpanel, 1));
        dpanel.add(display.getComponent());
        JPanel wpanel = new JPanel();
        wpanel.setLayout(new BoxLayout(wpanel, 1));
        cwidget.setMaximumSize(new Dimension(400, 200));
        awidget.setMaximumSize(new Dimension(400, 400));
        wpanel.add(cwidget);
        wpanel.add(awidget);
        Dimension d = new Dimension(400, 600);
        wpanel.setMaximumSize(d);
        panel.add(wpanel);
        panel.add(dpanel);
        return display;
    }

    DataImpl makePoles() throws VisADException, RemoteException {
        SampledSet[] set_s = new SampledSet[this.n_stations];
        int ii = 0;
        float[][] locs = new float[3][2];
        int kk = 0;
        while (kk < this.n_stations) {
            boolean any = false;
            float hgt = -3.4028235E38f;
            FieldImpl station = (FieldImpl)this.stations_field.getSample(kk);
            if (station != null) {
                int len = station.getLength();
                int i = 0;
                while (i < len) {
                    FieldImpl pole = (FieldImpl)station.getSample(i);
                    if (pole != null && pole.getLength() >= 2) {
                        Set set = pole.getDomainSet();
                        float[][] samples = set.getSamples(false);
                        float[] hi = ((SampledSet)set).getHi();
                        if (hi[2] > hgt) {
                            hgt = hi[2];
                        }
                        if (!any && samples[0][0] == samples[0][0] && samples[1][0] == samples[1][0]) {
                            any = true;
                            locs[0][0] = samples[0][0];
                            locs[1][0] = samples[1][0];
                            locs[0][1] = samples[0][0];
                            locs[1][1] = samples[1][0];
                            if ((double)samples[0][0] > this.lat_max) {
                                this.lat_max = samples[0][0];
                            }
                            if ((double)samples[0][0] < this.lat_min) {
                                this.lat_min = samples[0][0];
                            }
                            if ((double)samples[1][0] > this.lon_max) {
                                this.lon_max = samples[1][0];
                            }
                            if ((double)samples[1][0] < this.lon_min) {
                                this.lon_min = samples[1][0];
                            }
                        }
                    }
                    ++i;
                }
                if (any) {
                    locs[2][0] = 0.0f;
                    locs[2][1] = hgt;
                    set_s[ii++] = new Gridded3DSet((MathType)this.spatial_domain, locs, 2, null, null, null);
                    if ((double)hgt > this.hgt_max) {
                        this.hgt_max = hgt;
                    }
                }
            }
            ++kk;
        }
        SampledSet[] set_ss = new SampledSet[ii];
        System.arraycopy(set_s, 0, set_ss, 0, ii);
        return new UnionSet((MathType)this.spatial_domain, set_ss);
    }

    public void mapChanged(ScalarMapEvent e) throws VisADException, RemoteException {
        if (this.xmap.equals(e.getScalarMap())) {
            this.xmapEvent = true;
        } else if (this.ymap.equals(e.getScalarMap())) {
            this.ymapEvent = true;
        } else if (this.img_map.equals(e.getScalarMap())) {
            this.imgEvent = true;
        }
        if (this.xmapEvent && this.ymapEvent && !this.first_xy_Event) {
            this.x_range = this.xmap.getRange();
            this.y_range = this.ymap.getRange();
            this.latmin = (float)this.y_range[0];
            this.latmax = (float)this.y_range[1];
            this.lonmin = (float)this.x_range[0];
            this.lonmax = (float)this.x_range[1];
            this.baseMap.setLatLonLimits(this.latmin - this.del_lat, this.latmax + this.del_lat, this.lonmin - this.del_lon, this.lonmax + this.del_lon);
            UnionSet map = this.baseMap.getData();
            this.map_ref.setData(map);
            this.first_xy_Event = true;
            this.xmap.setRange(this.lonmin, this.lonmax);
            this.ymap.setRange(this.latmin, this.latmax);
            this.img_ref.setData(this.image_seq);
        }
        if (this.imgEvent && !this.first_img_Event) {
            double[] i_range = this.img_map.getRange();
            System.out.println(i_range[0] + " " + i_range[1]);
            this.first_img_Event = true;
            this.img_map.setRange(i_range[1], i_range[0]);
        }
    }

    public void controlChanged(ScalarMapControlEvent e) {
    }

    FieldImpl[] makeWinds(String[] files) throws VisADException, RemoteException, IOException {
        RealType domain_type;
        DataImpl[] file_data = new DataImpl[this.n_stations];
        FieldImpl[] time_field = new FieldImpl[this.n_stations];
        double[][] time_offset = null;
        double[] base_date = new double[this.n_stations];
        double[] base_time = new double[this.n_stations];
        Gridded1DSet d_set = null;
        FlatField new_ff = null;
        RealType u_wind = RealType.getRealType("u_wind");
        RealType v_wind = RealType.getRealType("v_wind");
        Plain plain = new Plain();
        int kk = 0;
        while (kk < this.n_stations) {
            file_data[kk] = plain.open(files[kk]);
            ++kk;
        }
        MathType file_type = file_data[0].getType();
        System.out.println(file_type.prettyString());
        System.out.println();
        FunctionType f_type0 = (FunctionType)((TupleType)file_type).getComponent(2);
        TupleType ttype = (TupleType)f_type0.getRange();
        int p_field_index = ttype.getDimension() - 1;
        FunctionType f_type1 = (FunctionType)ttype.getComponent(p_field_index);
        RealTupleType rng_tuple = (RealTupleType)f_type1.getRange();
        int altitude_index = rng_tuple.getIndex("Altitude");
        this.altitude = (RealType)rng_tuple.getComponent(altitude_index);
        int windSpeed_index = rng_tuple.getIndex("windSpeed");
        RealType spd = (RealType)rng_tuple.getComponent(windSpeed_index);
        int windDir_index = rng_tuple.getIndex("windDir");
        RealType dir = (RealType)rng_tuple.getComponent(windDir_index);
        RealType[] r_types = new RealType[]{dir, spd};
        RealType[] uv_types = new RealType[]{u_wind, v_wind};
        RealTupleType uv = new RealTupleType(uv_types);
        WindPolarCoordinateSystem cs = new WindPolarCoordinateSystem(uv);
        RealTupleType ds = new RealTupleType(r_types, (CoordinateSystem)cs, null);
        FunctionType alt_to_ds = new FunctionType(this.altitude, ds);
        FunctionType alt_to_uv = new FunctionType(this.altitude, uv);
        this.time = domain_type = (RealType)((TupleType)f_type0.getRange()).getComponent(0);
        FunctionType new_type = new FunctionType(RealType.Time, alt_to_uv);
        FieldImpl[] winds = new FieldImpl[this.n_stations];
        int ii = 0;
        while (ii < this.n_stations) {
            base_date[ii] = ((Real)((Tuple)file_data[ii]).getComponent(0)).getValue();
            base_time[ii] = ((Real)((Tuple)file_data[ii]).getComponent(1)).getValue();
            time_field[ii] = (FieldImpl)((Tuple)file_data[ii]).getComponent(2);
            this.station_lat[ii] = ((Real)((Tuple)time_field[ii].getSample(0)).getComponent(6)).getValue();
            this.station_lon[ii] = -((Real)((Tuple)time_field[ii].getSample(0)).getComponent(7)).getValue();
            this.station_alt[ii] = ((Real)((Tuple)time_field[ii].getSample(0)).getComponent(8)).getValue();
            this.station_id[ii] = ((Real)((Tuple)time_field[ii].getSample(0)).getComponent(9)).getValue();
            if (ii == 0) {
                this.start_time = base_time[0];
                this.start_date = (int)base_date[0];
            }
            int length = time_field[ii].getLength();
            time_offset = new double[1][length];
            Data[] range_data = new FlatField[length];
            double[][] samples = null;
            int jj = 0;
            while (jj < length) {
                Tuple range = (Tuple)time_field[ii].getSample(jj);
                time_offset[0][jj] = ((Real)range.getComponent(0)).getValue();
                FlatField p_field = (FlatField)range.getComponent(p_field_index);
                double[][] values = p_field.getValues();
                double[][] new_values = new double[2][values[0].length];
                if (jj == 0) {
                    samples = new double[1][values[0].length];
                    System.arraycopy(values[altitude_index], 0, samples[0], 0, samples[0].length);
                    d_set = new Gridded1DSet((MathType)this.altitude, Set.doubleToFloat(samples), samples[0].length);
                }
                new_ff = new FlatField(alt_to_uv, d_set);
                int n_not_miss = 0;
                int[] not_miss = new int[values[0].length];
                int mm = 0;
                while (mm < values[0].length) {
                    new_values[0][mm] = values[windDir_index][mm] <= -9999.0 ? Double.NaN : values[windDir_index][mm];
                    new_values[1][mm] = values[windSpeed_index][mm] <= -9999.0 ? Double.NaN : values[windSpeed_index][mm];
                    if (new_values[0][mm] == new_values[0][mm] && new_values[1][mm] == new_values[1][mm]) {
                        not_miss[n_not_miss] = mm;
                        ++n_not_miss;
                    }
                    ++mm;
                }
                if (0 < n_not_miss && n_not_miss < values[0].length) {
                    int endlen;
                    int nn = n_not_miss;
                    if (not_miss[0] > 0) {
                        nn += not_miss[0];
                    }
                    if ((endlen = values[0].length - (not_miss[n_not_miss - 1] + 1)) > 0) {
                        nn += endlen;
                    }
                    float[][] newer_values = new float[2][nn];
                    float[][] newer_samples = new float[1][nn];
                    int i = 0;
                    while (i < n_not_miss) {
                        newer_values[0][not_miss[0] + i] = (float)new_values[0][not_miss[i]];
                        newer_values[1][not_miss[0] + i] = (float)new_values[1][not_miss[i]];
                        newer_samples[0][not_miss[0] + i] = (float)samples[0][not_miss[i]];
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < not_miss[0]) {
                        newer_values[0][i2] = (float)new_values[0][not_miss[0]];
                        newer_values[1][i2] = (float)new_values[1][not_miss[0]];
                        newer_samples[0][i2] = (float)samples[0][not_miss[0]];
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < endlen) {
                        newer_values[0][not_miss[0] + n_not_miss + i3] = (float)new_values[0][not_miss[n_not_miss - 1]];
                        newer_values[1][not_miss[0] + n_not_miss + i3] = (float)new_values[1][not_miss[n_not_miss - 1]];
                        newer_samples[0][not_miss[0] + n_not_miss + i3] = (float)samples[0][not_miss[n_not_miss - 1]];
                        ++i3;
                    }
                    Gridded1DSet newer_d_set = new Gridded1DSet((MathType)this.altitude, newer_samples, nn);
                    FlatField newer_ff = new FlatField(alt_to_uv, newer_d_set);
                    newer_ff.setSamples(((CoordinateSystem)cs).toReference(newer_values));
                    new_ff = (FlatField)newer_ff.resample(d_set, 101, 202);
                } else {
                    new_ff.setSamples(((CoordinateSystem)cs).toReference(new_values));
                }
                range_data[jj] = new_ff;
                ++jj;
            }
            double[][] times = new double[1][length];
            int i = 0;
            while (i < length) {
                times[0][i] = base_time[0] + time_offset[0][i];
                ++i;
            }
            Gridded1DSet domain_set = new Gridded1DSet((MathType)RealType.Time, Set.doubleToFloat(times), length);
            winds[ii] = new FieldImpl(new_type, domain_set);
            winds[ii].setSamples(range_data, false);
            ++ii;
        }
        plain = null;
        return winds;
    }

    FieldImpl[] makeAeri(String[] files) throws VisADException, RemoteException, IOException {
        DataImpl[] file_data = new DataImpl[this.n_stations];
        FieldImpl[] time_field = new FieldImpl[this.n_stations];
        double[] station_lat = new double[this.n_stations];
        double[] station_lon = new double[this.n_stations];
        double[] station_alt = new double[this.n_stations];
        double[] station_id = new double[this.n_stations];
        double[][] time_offset = null;
        double[] base_date = new double[this.n_stations];
        double[] base_time = new double[this.n_stations];
        Plain plain = new Plain();
        int kk = 0;
        while (kk < this.n_stations) {
            file_data[kk] = plain.open(files[kk]);
            ++kk;
        }
        System.out.println(file_data[0].getType().prettyString());
        MathType file_type = file_data[0].getType();
        FunctionType f_type0 = (FunctionType)((TupleType)file_type).getComponent(1);
        FunctionType f_type1 = (FunctionType)((TupleType)f_type0.getRange()).getComponent(1);
        RealTupleType rtt = (RealTupleType)f_type1.getRange();
        this.temp = (RealType)rtt.getComponent(1);
        this.dwpt = (RealType)rtt.getComponent(2);
        this.wvmr = (RealType)rtt.getComponent(3);
        RealType domain_type = (RealType)((TupleType)f_type0.getRange()).getComponent(0);
        FunctionType new_type = new FunctionType(RealType.Time, f_type1);
        FieldImpl[] rtvls = new FieldImpl[this.n_stations];
        int ii = 0;
        while (ii < this.n_stations) {
            base_time[ii] = ((Real)((Tuple)file_data[ii]).getComponent(0)).getValue();
            time_field[ii] = (FieldImpl)((Tuple)file_data[ii]).getComponent(1);
            base_date[ii] = ((Real)((Tuple)file_data[ii]).getComponent(2)).getValue();
            int length = time_field[ii].getLength();
            time_offset = new double[1][length];
            Data[] range_data = new Data[length];
            int jj = 0;
            while (jj < length) {
                Tuple range = (Tuple)time_field[ii].getSample(jj);
                time_offset[0][jj] = ((Real)range.getComponent(0)).getValue();
                FlatField p_field = (FlatField)range.getComponent(1);
                double[][] values = p_field.getValues();
                double[][] new_values = new double[4][values[0].length];
                int mm = 0;
                while (mm < values[0].length) {
                    new_values[0][mm] = values[0][mm] == -9999.0 ? Double.NaN : values[0][mm];
                    new_values[1][mm] = values[1][mm] == -9999.0 ? Double.NaN : values[1][mm];
                    new_values[2][mm] = values[2][mm] == -9999.0 ? Double.NaN : values[2][mm];
                    new_values[3][mm] = values[3][mm] == -9999.0 ? Double.NaN : values[3][mm];
                    ++mm;
                }
                p_field.setSamples(new_values);
                if (!f_type1.equals(p_field.getType())) {
                    p_field = (FlatField)p_field.changeMathType(f_type1);
                }
                range_data[jj] = p_field;
                ++jj;
            }
            double[][] times = new double[1][length];
            int i = 0;
            while (i < length) {
                times[0][i] = base_time[0] + time_offset[0][i];
                ++i;
            }
            Gridded1DSet domain_set = new Gridded1DSet((MathType)RealType.Time, Set.doubleToFloat(times), length);
            rtvls[ii] = new FieldImpl(new_type, domain_set);
            rtvls[ii].setSamples(range_data, false);
            ++ii;
        }
        return rtvls;
    }

    FieldImpl makeAdvect(FieldImpl winds, FieldImpl rtvls, int stn_idx) throws VisADException, RemoteException, IOException {
        FieldImpl alt_to_wind;
        float[][] value_s = new float[1][1];
        int[] index_s = new int[1];
        double age_max = 3600.0;
        double rtvl_intvl_min = 476.0;
        int n_advect_pts = 10;
        int n_levels_max = 65;
        float[][] advect_locs = new float[3][n_advect_pts * n_levels_max];
        float[][] rtvl_vals = new float[6][n_advect_pts * n_levels_max];
        boolean idx = false;
        double factor = 4.504504504504505E-6;
        factor *= 1.1;
        FieldImpl advect_field = new FieldImpl(this.advect_field_type, rtvls.getDomainSet());
        Set rtvls_domain = rtvls.getDomainSet();
        FieldImpl wind_to_rtvl_time = (FieldImpl)winds.resample(rtvls_domain, 101, 202);
        int len = rtvls.getLength();
        FlatField[] rtvl_on_wind = new FlatField[len];
        FieldImpl[] wind_on_wind = new FieldImpl[len];
        int tt = 0;
        while (tt < len) {
            FieldImpl alt_to_rtvl = (FieldImpl)rtvls.getSample(tt);
            alt_to_wind = (FieldImpl)wind_to_rtvl_time.getSample(tt);
            Set ds = alt_to_wind.getDomainSet();
            float[][] samples = ds.getSamples();
            float[] ns = new float[samples[0].length];
            int nn = 0;
            int i = 0;
            while (i < samples[0].length) {
                if (samples[0][i] < (float)this.height_limit) {
                    ns[nn] = samples[0][i];
                    ++nn;
                }
                ++i;
            }
            float[][] new_samples = new float[1][nn];
            System.arraycopy(ns, 0, new_samples[0], 0, nn);
            ds = new Gridded1DSet(ds.getType(), new_samples, nn);
            wind_on_wind[tt] = (FieldImpl)alt_to_wind.resample(ds, 101, 202);
            rtvl_on_wind[tt] = (FlatField)alt_to_rtvl.resample(ds, 101, 202);
            ++tt;
        }
        float[][] f_array = rtvls_domain.getSamples();
        float[] rtvl_times = f_array[0];
        int tt2 = n_advect_pts;
        while (tt2 < len) {
            int rtvl_idx = tt2;
            alt_to_wind = wind_on_wind[tt2];
            int alt_len = alt_to_wind.getLength();
            double[][] uv_wind = alt_to_wind.getValues();
            float[][] heights = alt_to_wind.getDomainSet().getSamples();
            int n_samples = 0;
            double rtvl_time_0 = rtvl_times[tt2];
            int jj = 0;
            while (jj < alt_len) {
                float alt = heights[0][jj];
                int ii = 0;
                while (ii < n_advect_pts) {
                    double rtvl_time = rtvl_times[rtvl_idx - ii];
                    double age = rtvl_time - rtvl_time_0;
                    double lat_radians = Math.PI / 180 * this.station_lat[stn_idx];
                    advect_locs[0][n_samples] = (float)(-uv_wind[0][jj] * age * factor / Math.cos(lat_radians) + this.station_lon[stn_idx]);
                    advect_locs[1][n_samples] = (float)(-uv_wind[1][jj] * age * factor + this.station_lat[stn_idx]);
                    advect_locs[2][n_samples] = alt;
                    double[][] vals = rtvl_on_wind[rtvl_idx - ii].getValues();
                    rtvl_vals[0][n_samples] = (float)vals[1][jj];
                    rtvl_vals[1][n_samples] = (float)vals[2][jj];
                    rtvl_vals[2][n_samples] = (float)vals[3][jj];
                    rtvl_vals[3][n_samples] = (float)Aeri.relativeHumidity(vals[1][jj], vals[2][jj]);
                    rtvl_vals[4][n_samples] = (float)Aeri.potentialTemperature(vals[1][jj], vals[0][jj]);
                    rtvl_vals[5][n_samples] = (float)Aeri.equivPotentialTemperature(rtvl_vals[4][n_samples], vals[1][jj], vals[0][jj]);
                    ++n_samples;
                    ++ii;
                }
                ++jj;
            }
            int lengthX = n_samples / alt_len;
            int lengthY = alt_len;
            float[][] samples = new float[3][lengthX * lengthY];
            System.arraycopy(advect_locs[0], 0, samples[0], 0, n_samples);
            System.arraycopy(advect_locs[1], 0, samples[1], 0, n_samples);
            System.arraycopy(advect_locs[2], 0, samples[2], 0, n_samples);
            float[][] range = new float[6][n_samples];
            System.arraycopy(rtvl_vals[0], 0, range[0], 0, n_samples);
            System.arraycopy(rtvl_vals[1], 0, range[1], 0, n_samples);
            System.arraycopy(rtvl_vals[2], 0, range[2], 0, n_samples);
            System.arraycopy(rtvl_vals[3], 0, range[3], 0, n_samples);
            System.arraycopy(rtvl_vals[4], 0, range[4], 0, n_samples);
            System.arraycopy(rtvl_vals[5], 0, range[5], 0, n_samples);
            Gridded3DSet g3d_set = new Gridded3DSet((MathType)this.spatial_domain, samples, lengthX, lengthY);
            FlatField advect = new FlatField(this.advect_type, g3d_set);
            advect.setSamples(range);
            advect_field.setSample(tt2, (Data)advect, false);
            ++tt2;
        }
        return advect_field;
    }

    public static double satVapPres(double t) {
        double tt;
        int inx;
        double[] coef = new double[]{6.1104546, 0.4442351, 0.014302099, 2.6454708E-4, 3.0357098E-6, 2.0972268E-8, 6.0487594E-11, -1.469687E-13};
        double[] escold = new double[]{0.06485546857696639, 0.03783195122560735, 0.02224449342887902, 0.013182892842468312, 0.007874020771412448, 0.004739730494884733, 0.0028751203550435793, 0.001757430376758103, 0.0010824173951885098, 6.717089391856059E-4, 4.199647026320394E-4, 2.645243638634699E-4, 1.6784796373681322E-4, 1.0728539763162038E-4, 6.907426344961356E-5, 4.479404897680843E-5, 2.925704195639373E-5, 1.9245291263499416E-5, 1.2749137241074795E-5, 8.505070102755051E-6, 5.713400253349711E-6, 3.864650296738762E-6, 2.632109719650053E-6, 1.8049107293057043E-6, 1.2460785055581605E-6, 8.660705713468708E-7, 6.059822176688955E-7, 4.2682119794324277E-7, 3.026165085143795E-7, 2.15963854234914E-7, 1.5512895457833687E-7};
        double temp = t - 273.16;
        double retval = temp != temp ? Double.NaN : (temp > -50.0 ? coef[0] + temp * (coef[1] + temp * (coef[2] + temp * (coef[3] + temp * (coef[4] + temp * (coef[5] + temp * (coef[6] + temp * coef[7])))))) : ((inx = (int)(tt = (-temp - 50.0) / 5.0)) < escold.length ? escold[inx] + tt % 1.0 * (escold[inx + 1] - escold[inx]) : 1.0E-7));
        return retval;
    }

    public static double mixingRatio(double t, double p) {
        double e = Aeri.satVapPres(t);
        return 621.97 * e / (p - e);
    }

    public static double relativeHumidity(double t, double td) {
        return Aeri.satVapPres(td) / Aeri.satVapPres(t);
    }

    public static double potentialTemperature(double t, double p) {
        double R_Cp = 0.28585;
        double Ps = 1000.0;
        return t * Math.pow(Ps / p, R_Cp);
    }

    public static double equivPotentialTemperature(double theta, double temp, double press) {
        double Lc = 2500000.0;
        double Cp = 1004.0;
        double Qs = Aeri.mixingRatio(temp, press * 100.0);
        double thetaE = theta * Math.exp(Lc * (Qs /= 1000.0) / (Cp * temp));
        return thetaE;
    }

    public static double equivPotentialTemperatureStar(double theta, double Q, double temp) {
        double Lc = 2500000.0;
        double Cp = 1004.0;
        return theta * Math.exp(Lc * (Q /= 1000.0) / (Cp * temp));
    }
}

