/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.SimpleSet;
import visad.UnimplementedException;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.util.Util;

public class ShapeControl
extends Control {
    private SimpleSet shapeSet = null;
    private VisADGeometryArray[] shapes = null;
    private float scale = 1.0f;
    private boolean autoScale = false;
    private ProjectionControlListener pcl = null;

    public ShapeControl(DisplayImpl d) {
        super(d);
    }

    public synchronized void setShapeSet(SimpleSet set) throws VisADException, RemoteException {
        if (set == null) {
            this.shapeSet = null;
            this.shapes = null;
            return;
        }
        if (set.getDimension() != 1) {
            throw new DisplayException("ShapeControl.setShapeSet: domain dimension must be 1");
        }
        this.shapeSet = set;
        this.shapes = new VisADGeometryArray[this.shapeSet.getLength()];
        this.changeControl(true);
    }

    public synchronized void setShape(int index, VisADGeometryArray shape) throws VisADException, RemoteException {
        if (this.shapes == null) {
            return;
        }
        if (0 <= index && index < this.shapes.length) {
            this.shapes[index] = shape;
        }
        this.changeControl(true);
    }

    public synchronized void setShapes(VisADGeometryArray[] shs) throws VisADException, RemoteException {
        if (this.shapeSet == null) {
            return;
        }
        if (shs != null && shs.length > 0) {
            int len = Math.min(shs.length, this.shapes.length);
            int i = 0;
            while (i < len) {
                this.shapes[i] = shs[i];
                ++i;
            }
            if (this.shapes.length > shs.length) {
                int i2 = shs.length;
                while (i2 < this.shapes.length) {
                    this.shapes[i2] = null;
                    ++i2;
                }
            }
        }
        this.changeControl(true);
    }

    public synchronized VisADGeometryArray[] getShapes(float[] values) throws VisADException {
        int i;
        if (values == null || values.length < 1) {
            return null;
        }
        VisADGeometryArray[] sh = new VisADGeometryArray[values.length];
        if (this.shapeSet == null) {
            return sh;
        }
        float[][] set_values = new float[][]{values};
        int[] indices = null;
        if (this.shapeSet.getLength() < 2) {
            indices = new int[values.length];
            i = 0;
            while (i < indices.length) {
                indices[i] = 0;
                ++i;
            }
        } else {
            indices = this.shapeSet.valueToIndex(set_values);
        }
        if (this.shapes == null) {
            i = 0;
            while (i < indices.length) {
                sh[i] = null;
                ++i;
            }
        } else {
            i = 0;
            while (i < indices.length) {
                sh[i] = 0 <= indices[i] && indices[i] < this.shapes.length && this.shapes[indices[i]] != null ? (VisADGeometryArray)this.shapes[indices[i]].clone() : null;
                ++i;
            }
        }
        return sh;
    }

    public void setScale(float s) throws VisADException, RemoteException {
        if (s == s) {
            this.scale = s;
            this.changeControl(true);
        }
    }

    public float getScale() {
        return this.scale;
    }

    private boolean shapeSetEquals(SimpleSet newShapeSet) {
        if (this.shapeSet == null) {
            if (newShapeSet != null) {
                return false;
            }
        } else {
            if (newShapeSet == null) {
                return false;
            }
            if (!this.shapeSet.equals(newShapeSet)) {
                return false;
            }
        }
        return true;
    }

    private boolean shapesEquals(VisADGeometryArray[] newShapes) {
        if (this.shapes == null) {
            if (newShapes != null) {
                return false;
            }
        } else {
            if (newShapes == null) {
                return false;
            }
            if (this.shapes.length != newShapes.length) {
                return false;
            }
            int i = 0;
            while (i < this.shapes.length) {
                if (this.shapes[i] == null) {
                    if (newShapes[i] != null) {
                        return false;
                    }
                } else {
                    if (newShapes[i] == null) {
                        return false;
                    }
                    if (!this.shapes[i].equals(newShapes[i])) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public String getSaveString() {
        return null;
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        throw new UnimplementedException("Cannot setSaveString on this type of control");
    }

    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof ShapeControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        ShapeControl sc = (ShapeControl)rmt;
        boolean changed = false;
        if (!this.shapeSetEquals(sc.shapeSet)) {
            changed = true;
            this.shapeSet = sc.shapeSet;
        }
        if (!this.shapesEquals(sc.shapes)) {
            changed = true;
            this.shapes = sc.shapes;
        }
        if (!Util.isApproximatelyEqual(this.scale, sc.scale)) {
            changed = true;
            this.scale = sc.scale;
        }
        if (this.autoScale != sc.autoScale) {
            this.setAutoScale(sc.autoScale);
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    public void setAutoScale(boolean auto) throws VisADException {
        if (auto == this.autoScale) {
            return;
        }
        DisplayImpl display = this.getDisplay();
        DisplayRenderer dr = display.getDisplayRenderer();
        MouseBehavior mouse = dr.getMouseBehavior();
        ProjectionControl pc = display.getProjectionControl();
        if (auto) {
            this.pcl = new ProjectionControlListener(mouse, this, pc);
            pc.addControlListener(this.pcl);
        } else {
            pc.removeControlListener(this.pcl);
        }
        this.autoScale = auto;
        try {
            this.changeControl(true);
        }
        catch (RemoteException e) {}
    }

    public void nullControl() {
        try {
            this.setAutoScale(false);
        }
        catch (VisADException e) {
            // empty catch block
        }
        super.nullControl();
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ShapeControl sc = (ShapeControl)o;
        if (!this.shapeSetEquals(sc.shapeSet) || !this.shapesEquals(sc.shapes)) {
            return false;
        }
        return Util.isApproximatelyEqual(this.scale, sc.scale);
    }

    public Object clone() {
        ShapeControl sc = (ShapeControl)super.clone();
        if (this.shapes != null) {
            sc.shapes = (VisADGeometryArray[])this.shapes.clone();
        }
        sc.scale = this.scale;
        return sc;
    }

    class ProjectionControlListener
    implements ControlListener {
        private boolean pfirst = true;
        private MouseBehavior mouse;
        private ProjectionControl pcontrol;
        private ShapeControl shapeControl;
        private double base_scale = 1.0;
        private float last_cscale = 1.0f;
        private double base_size = 1.0;

        ProjectionControlListener(MouseBehavior m, ShapeControl s, ProjectionControl p) {
            this.mouse = m;
            this.shapeControl = s;
            this.pcontrol = p;
        }

        public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
            double[] matrix = this.pcontrol.getMatrix();
            double[] rot = new double[3];
            double[] scale = new double[1];
            double[] trans = new double[3];
            this.mouse.instance_unmake_matrix(rot, scale, trans, matrix);
            if (this.pfirst) {
                this.pfirst = false;
                this.base_scale = scale[0];
                this.last_cscale = 1.0f;
                this.base_size = this.shapeControl.getScale();
            } else {
                float cscale = (float)(this.base_scale / scale[0]);
                float ratio = cscale / this.last_cscale;
                if (ratio < 0.95f || 1.05f < ratio) {
                    this.last_cscale = cscale;
                    this.shapeControl.setScale((float)this.base_size * cscale);
                }
            }
        }
    }
}

