/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealType;
import visad.SI;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class LinearLatLonSet
extends Linear2DSet {
    private boolean LongitudeWrap;
    private double WrapStep;
    private double WrapFactor;
    private int latI;
    private int lonI;
    private double halfPiLat;
    private double halfPiLon;
    private double twoPiLon;
    private Linear1DSet lat;
    private Linear1DSet lon;

    public LinearLatLonSet(MathType type, Linear1DSet[] sets) throws VisADException {
        this(type, sets, null, null, null);
    }

    public LinearLatLonSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException {
        this(type, first1, last1, length1, first2, last2, length2, null, null, null);
    }

    public LinearLatLonSet(MathType type, Linear1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, sets, coord_sys, units, errors, false);
    }

    public LinearLatLonSet(MathType type, Linear1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        super(type, sets, coord_sys, units, errors, cache);
        this.setParameters();
        this.checkWrap();
    }

    public LinearLatLonSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, first1, last1, length1, first2, last2, length2, coord_sys, units, errors, false);
    }

    public LinearLatLonSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        super(type, first1, last1, length1, first2, last2, length2, coord_sys, units, errors, cache);
        this.setParameters();
        this.checkWrap();
    }

    private void setParameters() throws VisADException, UnitException {
        MathType type0 = ((SetType)this.getType()).getDomain().getComponent(0);
        int n = this.latI = RealType.Latitude.equals(type0) ? 0 : 1;
        if (this.latI == 0) {
            this.lonI = 1;
            this.lat = this.X;
            this.lon = this.Y;
        } else {
            this.lonI = 0;
            this.lat = this.Y;
            this.lon = this.X;
        }
        Unit[] units = this.getSetUnits();
        this.halfPiLat = SI.radian.toThat(1.5707963267948966, units[this.latI]);
        this.halfPiLon = SI.radian.toThat(1.5707963267948966, units[this.lonI]);
        this.twoPiLon = 4.0 * this.halfPiLon;
    }

    private void setLatLonUnits() {
    }

    void checkWrap() throws VisADException {
        Unit[] units = this.getSetUnits();
        if ((double)this.Low[this.latI] < -this.halfPiLat || (double)this.Hi[this.latI] > this.halfPiLat || (double)this.Low[this.lonI] < -this.twoPiLon || (double)this.Hi[this.lonI] > this.twoPiLon || (double)(this.Hi[this.lonI] - this.Low[this.lonI]) > this.twoPiLon) {
            throw new SetException("LinearLatLonSet: out of bounds (note Lat and Lon in Radians)");
        }
        boolean bl = this.LongitudeWrap = (double)(this.Hi[this.lonI] - this.Low[this.lonI]) + 2.0 * Math.abs(this.lon.getStep()) >= this.twoPiLon && this.lon.getLength() > 1;
        if (this.LongitudeWrap) {
            this.WrapStep = this.twoPiLon - (double)(this.Hi[this.lonI] - this.Low[this.lonI]);
            this.WrapFactor = Math.abs(this.lon.getStep()) / this.WrapStep;
        }
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != 2) {
            throw new SetException("LinearLatLonSet.gridToValue: grid dimension should be 2, not " + grid.length);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("LinearLatLonSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int length = grid[0].length;
        float[][] gridLat = new float[][]{grid[this.latI]};
        float[][] gridLon = new float[][]{grid[this.lonI]};
        if (this.LongitudeWrap) {
            float len = this.lon.getLength();
            float lenh = len - 0.5f;
            float lenm = len - 1.0f;
            int i = 0;
            while (i < length) {
                if (gridLon[0][i] > lenm) {
                    gridLon[0][i] = (float)((double)lenm + (double)(gridLon[0][i] - lenm) / this.WrapFactor);
                    if (gridLon[0][i] > lenh) {
                        float[] fArray = gridLon[0];
                        int n = i;
                        fArray[n] = fArray[n] - len;
                    }
                } else if ((double)gridLon[0][i] < 0.0) {
                    gridLon[0][i] = (float)((double)gridLon[0][i] / this.WrapFactor);
                    if ((double)gridLon[0][i] < -0.5) {
                        float[] fArray = gridLon[0];
                        int n = i;
                        fArray[n] = fArray[n] + len;
                    }
                }
                ++i;
            }
        }
        float[][] valueLat = this.lat.gridToValue(gridLat);
        float[][] valueLon = this.lon.gridToValue(gridLon);
        float[][] value = new float[2][];
        value[this.latI] = valueLat[0];
        value[this.lonI] = valueLon[0];
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length != 2) {
            throw new SetException("LinearLatLonSet.valueToGrid: value dimension should be 2, not " + value.length);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("LinearLatLonSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int length = value[0].length;
        float[][] valueLat = new float[][]{value[this.latI]};
        float[] valueLon = value[this.lonI];
        float[][] gridLat = this.lat.valueToGrid(valueLat);
        float[] gridLon = new float[length];
        float l = (float)(this.lon.getFirst() - 0.5 * this.lon.getStep());
        float h = (float)(this.lon.getFirst() + ((double)this.lon.getLength() - 0.5) * this.lon.getStep());
        if (h < l) {
            float temp = l;
            l = h;
            h = temp;
        }
        if (this.LongitudeWrap) {
            l = (float)((double)l + 0.5 * Math.abs(this.lon.getStep()) - 0.5 * this.WrapStep);
            h = (float)((double)l + this.twoPiLon);
        }
        int i = 0;
        while (i < length) {
            float v = (float)((double)valueLon[i] % this.twoPiLon);
            if (v <= l) {
                v = (float)((double)v + this.twoPiLon);
            } else if (h <= v) {
                v = (float)((double)v - this.twoPiLon);
            }
            gridLon[i] = (float)(l < v && v < h ? ((double)v - this.lon.getFirst()) * this.lon.getInvstep() : Double.NaN);
            ++i;
        }
        if (this.LongitudeWrap) {
            float len = this.lon.getLength();
            float lenh = len - 0.5f;
            float lenm = len - 1.0f;
            int i2 = 0;
            while (i2 < length) {
                if (gridLon[i2] > lenm) {
                    gridLon[i2] = (float)((double)lenm + (double)(gridLon[i2] - lenm) * this.WrapFactor);
                    if (gridLon[i2] > lenh) {
                        int n = i2;
                        gridLon[n] = gridLon[n] - len;
                    }
                } else if ((double)gridLon[i2] < 0.0) {
                    gridLon[i2] = (float)((double)gridLon[i2] * this.WrapFactor);
                    if ((double)gridLon[i2] < -0.5) {
                        int n = i2;
                        gridLon[n] = gridLon[n] + len;
                    }
                }
                ++i2;
            }
        }
        float[][] grid = new float[2][];
        grid[this.latI] = gridLat[0];
        grid[this.lonI] = gridLon;
        return grid;
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int[] off;
        if (value.length != this.DomainDimension) {
            throw new SetException("LinearLatLonSet Domain dimension should be 2, not " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("LinearLatLonSet.valueToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("LinearLatLonSet.valueToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        float[][] grid = this.valueToGrid(value);
        int[] l = new int[2];
        float[] c = new float[2];
        off = new int[]{1, off[0] * this.Lengths[0]};
        int i = 0;
        while (i < length) {
            float[] cs;
            int[] is;
            int base;
            boolean WrapThis = false;
            int length_is = 1;
            if (Double.isNaN(grid[this.lonI][i])) {
                base = -1;
            } else {
                l[this.lonI] = (int)((double)grid[this.lonI][i] + 0.5);
                c[this.lonI] = grid[this.lonI][i] - (float)l[this.lonI];
                if (!(l[this.lonI] == 0 && (double)c[this.lonI] <= 0.0 || l[this.lonI] == this.Lengths[this.lonI] - 1 && (double)c[this.lonI] >= 0.0)) {
                    length_is *= 2;
                } else if (this.LongitudeWrap) {
                    length_is *= 2;
                    WrapThis = true;
                }
                base = l[this.lonI];
            }
            if (base >= 0) {
                if (Double.isNaN(grid[this.latI][i])) {
                    base = -1;
                } else {
                    l[this.latI] = (int)((double)grid[this.latI][i] + 0.5);
                    c[this.latI] = grid[this.latI][i] - (float)l[this.latI];
                    if (!(l[this.latI] == 0 && (double)c[this.latI] <= 0.0 || l[this.latI] == this.Lengths[this.latI] - 1 && (double)c[this.latI] >= 0.0)) {
                        length_is *= 2;
                    }
                    base = off[this.latI] * l[this.latI] + off[this.lonI] * base;
                }
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                int k;
                float b;
                float a;
                int isoff;
                is = new int[length_is];
                cs = new float[length_is];
                is[0] = base;
                cs[0] = 1.0f;
                int lis = 1;
                if (!(l[this.latI] == 0 && (double)c[this.latI] <= 0.0 || l[this.latI] == this.Lengths[this.latI] - 1 && (double)c[this.latI] >= 0.0)) {
                    if ((double)c[this.latI] >= 0.0) {
                        isoff = off[this.latI];
                        a = 1.0f - c[this.latI];
                        b = c[this.latI];
                    } else {
                        isoff = -off[this.latI];
                        a = 1.0f + c[this.latI];
                        b = -c[this.latI];
                    }
                    k = 0;
                    while (k < lis) {
                        is[k + lis] = is[k] + isoff;
                        cs[k + lis] = cs[k] * b;
                        int n = k++;
                        cs[n] = cs[n] * a;
                    }
                    lis *= 2;
                }
                if (!(!WrapThis && (l[this.lonI] == 0 && (double)c[this.lonI] <= 0.0 || l[this.lonI] == this.Lengths[this.lonI] - 1 && (double)c[this.lonI] >= 0.0))) {
                    if (WrapThis && l[this.lonI] == 0) {
                        isoff = off[this.lonI] * (this.Lengths[this.lonI] - 1);
                        a = 1.0f + c[this.lonI];
                        b = -c[this.lonI];
                    } else if (WrapThis && l[this.lonI] == this.Lengths[this.lonI] - 1) {
                        isoff = -off[this.lonI] * (this.Lengths[this.lonI] - 1);
                        a = 1.0f - c[this.lonI];
                        b = c[this.lonI];
                    } else if ((double)c[this.lonI] >= 0.0) {
                        isoff = off[this.lonI];
                        a = 1.0f - c[this.lonI];
                        b = c[this.lonI];
                    } else {
                        isoff = -off[this.lonI];
                        a = 1.0f + c[this.lonI];
                        b = -c[this.lonI];
                    }
                    k = 0;
                    while (k < lis) {
                        is[k + lis] = is[k] + isoff;
                        cs[k + lis] = cs[k] * b;
                        int n = k++;
                        cs[n] = cs[n] * a;
                    }
                    lis *= 2;
                }
            }
            indices[i] = is;
            weights[i] = cs;
            ++i;
        }
    }

    public boolean equals(Object set) {
        if (!(set instanceof LinearLatLonSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        return this.X.equals(((LinearLatLonSet)set).getX()) && this.Y.equals(((LinearLatLonSet)set).getY());
    }

    public Object cloneButType(MathType type) throws VisADException {
        Linear1DSet[] sets = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone()};
        return new LinearLatLonSet(type, sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String pre) throws VisADException {
        String s = pre + "LinearLatLonSet: Length = " + this.Length + "\n";
        s = s + pre + "  Dimension 1: Length = " + this.X.getLength() + " Range = " + this.X.getFirst() + " to " + this.X.getLast() + "\n";
        s = s + pre + "  Dimension 2: Length = " + this.Y.getLength() + " Range = " + this.Y.getFirst() + " to " + this.Y.getLast() + "\n";
        return s;
    }
}

