/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSetIface;
import visad.LinearSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public class GriddedSet
extends SampledSet
implements GriddedSetIface {
    int[] Lengths;
    float EPS = 1.0E-15f;
    boolean Pos;

    public GriddedSet(MathType type, float[][] samples, int[] lengths) throws VisADException {
        this(type, samples, lengths, null, null, null, true);
    }

    public GriddedSet(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengths, coord_sys, units, errors, true);
    }

    public GriddedSet(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, lengths.length, coord_sys, units, errors);
        this.init_lengths(lengths);
        if (samples == null) {
            this.Samples = null;
        } else {
            this.init_samples(samples, copy);
        }
    }

    private void init_lengths(int[] lengths) throws VisADException {
        this.Lengths = new int[this.ManifoldDimension];
        this.Length = 1;
        int j = 0;
        while (j < this.ManifoldDimension) {
            if (lengths[j] < 1) {
                throw new SetException("GriddedSet: each grid length must be at least 1 (length#" + j + " is " + lengths[j]);
            }
            this.Lengths[j] = lengths[j];
            this.Length *= lengths[j];
            ++j;
        }
    }

    public static GriddedSet create(MathType type, float[][] samples, int[] lengths) throws VisADException {
        return GriddedSet.create(type, samples, lengths, null, null, null);
    }

    public static GriddedSet create(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        return GriddedSet.create(type, samples, lengths, coord_sys, units, errors, true, true);
    }

    public static GriddedSet create(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        return GriddedSet.create(type, samples, lengths, coord_sys, units, errors, copy, true);
    }

    private static GriddedSet create(MathType type, float[][] samples, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, boolean test) throws VisADException {
        int manifold_dimension = lengths.length;
        int domain_dimension = samples.length;
        if (manifold_dimension > domain_dimension) {
            throw new SetException("GriddedSet.create: manifold_dimension " + manifold_dimension + " is greater than" + " domain_dimension " + domain_dimension);
        }
        switch (domain_dimension) {
            case 1: {
                return new Gridded1DSet(type, samples, lengths[0], coord_sys, units, errors, copy);
            }
            case 2: {
                if (manifold_dimension == 1) {
                    return new Gridded2DSet(type, samples, lengths[0], coord_sys, units, errors, copy);
                }
                return new Gridded2DSet(type, samples, lengths[0], lengths[1], coord_sys, units, errors, copy, test);
            }
            case 3: {
                if (manifold_dimension == 1) {
                    return new Gridded3DSet(type, samples, lengths[0], coord_sys, units, errors, copy);
                }
                if (manifold_dimension == 2) {
                    return new Gridded3DSet(type, samples, lengths[0], lengths[1], coord_sys, units, errors, copy);
                }
                return new Gridded3DSet(type, samples, lengths[0], lengths[1], lengths[2], coord_sys, units, errors, copy, test);
            }
        }
        return new GriddedSet(type, samples, lengths, coord_sys, units, errors, copy);
    }

    public Set makeSpatial(SetType type, float[][] samples) throws VisADException {
        return GriddedSet.create(type, samples, this.Lengths, null, null, null, false, false);
    }

    public int getLength(int i) {
        return this.Lengths[i];
    }

    public int[] getLengths() {
        int[] lens = new int[this.Lengths.length];
        int i = 0;
        while (i < this.Lengths.length) {
            lens[i] = this.Lengths[i];
            ++i;
        }
        return lens;
    }

    public int[] getWedge() {
        int[] wedge = new int[this.Length];
        int len = this.Lengths[0];
        int i = 0;
        while (i < len) {
            wedge[i] = i;
            ++i;
        }
        int dim = 1;
        while (dim < this.ManifoldDimension) {
            boolean flip = true;
            int base = len;
            int k = len;
            int j = 1;
            while (j < this.Lengths[dim]) {
                if (flip) {
                    i = len - 1;
                    while (i >= 0) {
                        wedge[k] = wedge[i] + base;
                        ++k;
                        --i;
                    }
                } else {
                    i = 0;
                    while (i < len) {
                        wedge[k] = wedge[i] + base;
                        ++k;
                        ++i;
                    }
                }
                base += len;
                flip = !flip;
                ++j;
            }
            len *= this.Lengths[dim];
            ++dim;
        }
        return wedge;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int[] indexI = new int[this.ManifoldDimension];
        int length = index.length;
        float[][] grid = new float[this.ManifoldDimension][length];
        int i = 0;
        while (i < length) {
            int j;
            if (0 <= index[i] && index[i] < this.Length) {
                int k = index[i];
                j = 0;
                while (j < this.ManifoldDimension - 1) {
                    indexI[j] = k % this.Lengths[j];
                    k /= this.Lengths[j];
                    ++j;
                }
                indexI[this.ManifoldDimension - 1] = k;
            } else {
                j = 0;
                while (j < this.ManifoldDimension) {
                    indexI[j] = -1;
                    ++j;
                }
            }
            j = 0;
            while (j < this.ManifoldDimension) {
                grid[j][i] = indexI[j];
                ++j;
            }
            ++i;
        }
        return this.gridToValue(grid);
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("GriddedSet.valueToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        float[][] grid = this.valueToGrid(value);
        int i = 0;
        while (i < length) {
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                index[i] = -1;
            } else {
                int k = (int)((double)grid[this.ManifoldDimension - 1][i] + 0.5);
                int j = this.ManifoldDimension - 2;
                while (j >= 0) {
                    if (Double.isNaN(grid[j][i])) {
                        k = -1;
                        break;
                    }
                    k = (int)((double)grid[j][i] + 0.5) + this.Lengths[j] * k;
                    --j;
                }
                index[i] = k;
            }
            ++i;
        }
        return index;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (this.Length > 1) {
            int j = 0;
            while (j < this.DomainDimension) {
                if (this.Lengths[j] < 2) {
                    throw new SetException("GriddedSet.gridToValue: requires all grid dimensions to be > 1");
                }
                ++j;
            }
        }
        throw new UnimplementedException("GriddedSet.gridToValue");
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (this.Length > 1) {
            int j = 0;
            while (j < this.DomainDimension) {
                if (this.Lengths[j] < 2) {
                    throw new SetException("GriddedSet.valueToGrid: requires all grid dimensions to be > 1");
                }
                ++j;
            }
        }
        throw new UnimplementedException("GriddedSet.valueToGrid");
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("GriddedSet.valueToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("GriddedSet.valueToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("GriddedSet.valueToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        float[][] grid = this.valueToGrid(value);
        int[] l = new int[this.ManifoldDimension];
        float[] c = new float[this.ManifoldDimension];
        int[] off = new int[this.ManifoldDimension];
        off[0] = 1;
        int j = 1;
        while (j < this.ManifoldDimension) {
            off[j] = off[j - 1] * this.Lengths[j - 1];
            ++j;
        }
        int i = 0;
        while (i < length) {
            float[] cs;
            int[] is;
            int base;
            int length_is = 1;
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                base = -1;
            } else {
                l[this.ManifoldDimension - 1] = (int)((double)grid[this.ManifoldDimension - 1][i] + 0.5);
                if (l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n = this.ManifoldDimension - 1;
                    l[n] = l[n] - 1;
                }
                c[this.ManifoldDimension - 1] = grid[this.ManifoldDimension - 1][i] - (float)l[this.ManifoldDimension - 1];
                if (!(l[this.ManifoldDimension - 1] == 0 && (double)c[this.ManifoldDimension - 1] <= 0.0 || l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && (double)c[this.ManifoldDimension - 1] >= 0.0)) {
                    length_is *= 2;
                }
                if ((base = l[this.ManifoldDimension - 1]) >= this.Lengths[this.ManifoldDimension - 1]) {
                    base = -1;
                }
            }
            j = this.ManifoldDimension - 2;
            while (j >= 0 && base >= 0) {
                if (Double.isNaN(grid[j][i])) {
                    base = -1;
                } else {
                    l[j] = (int)((double)grid[j][i] + 0.5);
                    if (l[j] == this.Lengths[j]) {
                        int n = j;
                        l[n] = l[n] - 1;
                    }
                    c[j] = grid[j][i] - (float)l[j];
                    if (!(l[j] == 0 && (double)c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && (double)c[j] >= 0.0)) {
                        length_is *= 2;
                    }
                    base = l[j] + this.Lengths[j] * base;
                    if (l[j] < 0 || l[j] >= this.Lengths[j]) {
                        base = -1;
                    }
                }
                --j;
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                is = new int[length_is];
                cs = new float[length_is];
                is[0] = base;
                cs[0] = 1.0f;
                int lis = 1;
                j = 0;
                while (j < this.ManifoldDimension) {
                    if (!(l[j] == 0 && (double)c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && (double)c[j] >= 0.0)) {
                        float b;
                        float a;
                        int isoff;
                        if ((double)c[j] >= 0.0) {
                            isoff = off[j];
                            a = 1.0f - c[j];
                            b = c[j];
                        } else {
                            isoff = -off[j];
                            a = 1.0f + c[j];
                            b = -c[j];
                        }
                        int k = 0;
                        while (k < lis) {
                            is[k + lis] = is[k] + isoff;
                            cs[k + lis] = cs[k] * b;
                            int n = k++;
                            cs[n] = cs[n] * a;
                        }
                        lis *= 2;
                    }
                    ++j;
                }
            }
            indices[i] = is;
            weights[i] = cs;
            ++i;
        }
    }

    public void getNeighbors(int[][] neighbors) throws VisADException {
        switch (this.ManifoldDimension) {
            case 1: {
                neighbors[0] = new int[1];
                neighbors[this.Length - 1] = new int[1];
                neighbors[0][0] = 1;
                neighbors[this.Length - 1][0] = this.Length - 2;
                int ii = 1;
                while (ii < this.Length - 1) {
                    neighbors[ii] = new int[2];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    ++ii;
                }
                break;
            }
            case 2: {
                int LengthX = this.Lengths[0];
                int LengthY = this.Lengths[1];
                int ii = 0;
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii + LengthX;
                neighbors[ii][1] = ii + 1;
                ii = this.Length - 1;
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii - LengthX;
                neighbors[ii][1] = ii - 1;
                ii = this.Length - LengthX;
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii - LengthX;
                neighbors[ii][1] = ii + 1;
                ii = LengthX - 1;
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii + LengthX;
                neighbors[ii][1] = ii - 1;
                int iy = 1;
                while (iy < LengthY - 1) {
                    ii = iy * LengthX;
                    neighbors[ii] = new int[3];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii + 1;
                    ii = iy * LengthX + LengthX - 1;
                    neighbors[ii] = new int[3];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii - 1;
                    ++iy;
                }
                int ix = 1;
                while (ix < LengthX - 1) {
                    ii = ix;
                    neighbors[ii] = new int[3];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii + LengthX;
                    ii = (LengthY - 1) * LengthX + ix;
                    neighbors[ii] = new int[3];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii - LengthX;
                    ++ix;
                }
                iy = 1;
                while (iy < LengthY - 1) {
                    ix = 1;
                    while (ix < LengthX - 1) {
                        ii = iy * LengthX + ix;
                        int ii_R = ii + 1;
                        int ii_L = ii - 1;
                        int ii_U = ii + LengthX;
                        int ii_D = ii - LengthX;
                        neighbors[ii] = new int[4];
                        neighbors[ii][0] = ii_R;
                        neighbors[ii][1] = ii_L;
                        neighbors[ii][2] = ii_U;
                        neighbors[ii][3] = ii_D;
                        ++ix;
                    }
                    ++iy;
                }
                break;
            }
            case 3: {
                int LengthX = this.Lengths[0];
                int LengthY = this.Lengths[1];
                int LengthZ = this.Lengths[2];
                int LengthXY = LengthX * LengthY;
                int LengthXYZ = LengthX * LengthY * LengthZ;
                int ii = 0;
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii + LengthX;
                neighbors[ii][1] = ii + 1;
                neighbors[ii][2] = ii + LengthXY;
                ii = LengthX * LengthY * (LengthZ - 1);
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii + 1;
                neighbors[ii][1] = ii + LengthX;
                neighbors[ii][2] = ii - LengthXY;
                ii = LengthX * LengthY - 1;
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii - LengthX;
                neighbors[ii][1] = ii - 1;
                neighbors[ii][2] = ii + LengthXY;
                ii = LengthX * LengthY * LengthZ - 1;
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii - 1;
                neighbors[ii][1] = ii - LengthX;
                neighbors[ii][2] = ii - LengthXY;
                ii = LengthX * (LengthY - 1);
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii - LengthX;
                neighbors[ii][1] = ii + 1;
                neighbors[ii][2] = ii + LengthXY;
                ii = LengthXY * (LengthZ - 1) + LengthX * (LengthY - 1);
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii + 1;
                neighbors[ii][1] = ii - LengthX;
                neighbors[ii][2] = ii - LengthXY;
                ii = LengthX - 1;
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii + LengthX;
                neighbors[ii][1] = ii - 1;
                neighbors[ii][2] = ii + LengthXY;
                ii = LengthXY * (LengthZ - 1) + (LengthX - 1);
                neighbors[ii] = new int[3];
                neighbors[ii][0] = ii - 1;
                neighbors[ii][1] = ii + LengthX;
                neighbors[ii][2] = ii - LengthXY;
                int iy = 1;
                while (iy < LengthY - 1) {
                    ii = iy * LengthX;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii + 1;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = iy * LengthX + LengthX - 1;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii - 1;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = (LengthZ - 1) * LengthXY + iy * LengthY;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii - 1;
                    neighbors[ii][3] = ii - LengthXY;
                    ii = (LengthZ - 1) * LengthXY + iy * LengthX + LengthX - 1;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + LengthX;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii - 1;
                    neighbors[ii][3] = ii - LengthXY;
                    ++iy;
                }
                int ix = 1;
                while (ix < LengthX - 1) {
                    ii = ix;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii + LengthX;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = (LengthY - 1) * LengthX + ix;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii - LengthX;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = (LengthZ - 1) * LengthXY + ix;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii + LengthX;
                    neighbors[ii][3] = ii - LengthXY;
                    ii = (LengthZ - 1) * LengthXY + (LengthY - 1) * LengthX + ix;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + 1;
                    neighbors[ii][2] = ii - LengthX;
                    neighbors[ii][3] = ii - LengthXY;
                    ++ix;
                }
                int iz = 1;
                while (iz < LengthZ - 1) {
                    ii = iz * LengthXY;
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + 1;
                    neighbors[ii][1] = ii + LengthX;
                    neighbors[ii][2] = ii + LengthXY;
                    neighbors[ii][3] = ii - LengthXY;
                    ii = iz * LengthXY + (LengthX - 1);
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii + LengthX;
                    neighbors[ii][2] = ii + LengthXY;
                    neighbors[ii][3] = ii + LengthXY;
                    ii = iz * LengthXY + LengthX * (LengthY - 1);
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii + 1;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii + LengthXY;
                    neighbors[ii][3] = ii - LengthXY;
                    ii = iz * LengthXY + (LengthXY - 1);
                    neighbors[ii] = new int[4];
                    neighbors[ii][0] = ii - 1;
                    neighbors[ii][1] = ii - LengthX;
                    neighbors[ii][2] = ii + LengthXY;
                    neighbors[ii][3] = ii - LengthXY;
                    ++iz;
                }
                iy = 1;
                while (iy < LengthY - 1) {
                    ix = 1;
                    while (ix < LengthX - 1) {
                        ii = iy * LengthX + ix;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii - 1;
                        neighbors[ii][2] = ii + LengthX;
                        neighbors[ii][3] = ii - LengthX;
                        neighbors[ii][4] = ii + LengthXY;
                        ii = (LengthZ - 1) * LengthXY + iy * LengthX + ix;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii - 1;
                        neighbors[ii][2] = ii + LengthX;
                        neighbors[ii][3] = ii - LengthX;
                        neighbors[ii][4] = ii - LengthXY;
                        ++ix;
                    }
                    ++iy;
                }
                iz = 1;
                while (iz < LengthZ - 1) {
                    ix = 1;
                    while (ix < LengthX - 1) {
                        ii = iz * LengthXY + ix;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii - 1;
                        neighbors[ii][2] = ii + LengthX;
                        neighbors[ii][3] = ii + LengthXY;
                        neighbors[ii][4] = ii - LengthXY;
                        ii = iz * LengthXY + LengthX * (LengthY - 1) + ix;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii - 1;
                        neighbors[ii][2] = ii - LengthX;
                        neighbors[ii][3] = ii + LengthXY;
                        neighbors[ii][4] = ii - LengthXY;
                        ++ix;
                    }
                    ++iz;
                }
                iz = 1;
                while (iz < LengthZ - 1) {
                    iy = 1;
                    while (iy < LengthY - 1) {
                        ii = iz * LengthXY + iy * LengthX;
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii + 1;
                        neighbors[ii][1] = ii + LengthX;
                        neighbors[ii][2] = ii - LengthX;
                        neighbors[ii][3] = ii + LengthXY;
                        neighbors[ii][4] = ii - LengthXY;
                        ii = iz * LengthXY + iy * LengthX + (LengthX - 1);
                        neighbors[ii] = new int[5];
                        neighbors[ii][0] = ii - 1;
                        neighbors[ii][1] = ii + LengthX;
                        neighbors[ii][2] = ii - LengthX;
                        neighbors[ii][3] = ii + LengthXY;
                        neighbors[ii][4] = ii - LengthXY;
                        ++iy;
                    }
                    ++iz;
                }
                iz = 1;
                while (iz < LengthZ - 1) {
                    iy = 1;
                    while (iy < LengthY - 1) {
                        ix = 1;
                        while (ix < LengthX - 1) {
                            ii = iz * LengthXY + iy * LengthX + ix;
                            int ii_R = ii + 1;
                            int ii_L = ii - 1;
                            int ii_F = ii + LengthX;
                            int ii_B = ii - LengthX;
                            int ii_U = ii + LengthXY;
                            int ii_D = ii - LengthXY;
                            neighbors[ii] = new int[6];
                            neighbors[ii][0] = ii_R;
                            neighbors[ii][1] = ii_L;
                            neighbors[ii][2] = ii_F;
                            neighbors[ii][3] = ii_B;
                            neighbors[ii][4] = ii_U;
                            neighbors[ii][5] = ii_D;
                            ++ix;
                        }
                        ++iy;
                    }
                    ++iz;
                }
                break;
            }
            default: {
                throw new UnimplementedException("getNeighbors(): ManifoldDimension >" + this.ManifoldDimension + " not currently implemented");
            }
        }
    }

    public int[][] getNeighbors(int manifoldIndex) {
        int[][] neighbors = new int[this.Length][2];
        int[] m_coords = new int[this.ManifoldDimension];
        int[][] indeces = new int[2][this.ManifoldDimension];
        int ii = 0;
        while (ii < this.Length) {
            int ii_tmp = ii;
            int jj = 0;
            while (jj < this.ManifoldDimension - 1) {
                m_coords[jj] = ii_tmp % this.Lengths[jj];
                ii_tmp /= this.Lengths[jj];
                ++jj;
            }
            m_coords[this.ManifoldDimension - 1] = ii_tmp;
            int kk = 0;
            while (kk < 2) {
                jj = 0;
                while (jj < this.ManifoldDimension) {
                    indeces[kk][jj] = m_coords[jj];
                    ++jj;
                }
                ++kk;
            }
            int idx_u = m_coords[manifoldIndex] + 1;
            int idx_d = m_coords[manifoldIndex] - 1;
            indeces[1][manifoldIndex] = idx_u;
            indeces[0][manifoldIndex] = idx_d;
            if (idx_u >= this.Lengths[manifoldIndex]) {
                indeces[1][manifoldIndex] = -1;
            } else if (idx_d < 0) {
                indeces[0][manifoldIndex] = -1;
            }
            kk = 0;
            while (kk < 2) {
                if (indeces[kk][manifoldIndex] != -1) {
                    ii_tmp = 0;
                    int mm = this.ManifoldDimension - 1;
                    while (mm >= 0) {
                        int k = indeces[kk][mm];
                        int tt = 0;
                        while (tt < mm) {
                            k *= this.Lengths[tt];
                            ++tt;
                        }
                        ii_tmp += k;
                        --mm;
                    }
                    neighbors[ii][kk] = ii_tmp;
                } else {
                    neighbors[ii][kk] = -1;
                }
                ++kk;
            }
            ++ii;
        }
        return neighbors;
    }

    public boolean equals(Object set) {
        if (!(set instanceof GriddedSet) || set == null || set instanceof LinearSet || set instanceof Gridded1DDoubleSet) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((GriddedSet)set).getDimension() || this.ManifoldDimension != ((GriddedSet)set).getManifoldDimension() || this.Length != ((GriddedSet)set).getLength()) {
                return false;
            }
            int j = 0;
            while (j < this.ManifoldDimension) {
                if (this.Lengths[j] != ((GriddedSet)set).getLength(j)) {
                    return false;
                }
                ++j;
            }
            float[][] samples = ((GriddedSet)set).getSamples(false);
            if (this.Samples != null) {
                j = 0;
                while (j < this.DomainDimension) {
                    int i = 0;
                    while (i < this.Length) {
                        if (this.Samples[j][i] == this.Samples[j][i] ? this.Samples[j][i] != samples[j][i] : samples[j][i] == samples[j][i]) {
                            this.addNotEqualsCache((Set)set);
                            return false;
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                float[][] this_samples = this.getSamples(false);
                j = 0;
                while (j < this.DomainDimension) {
                    int i = 0;
                    while (i < this.Length) {
                        if (this_samples[j][i] == this_samples[j][i] ? this_samples[j][i] != samples[j][i] : samples[j][i] == samples[j][i]) {
                            this.addNotEqualsCache((Set)set);
                            return false;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode();
            this.hashCode ^= this.DomainDimension ^ this.ManifoldDimension ^ this.Length;
            int j = 0;
            while (j < this.ManifoldDimension) {
                this.hashCode ^= this.Lengths[j];
                ++j;
            }
            if (this.Samples != null) {
                int j2 = 0;
                while (j2 < this.DomainDimension) {
                    int i = 0;
                    while (i < this.Length) {
                        this.hashCode ^= Float.floatToIntBits(this.Samples[j2][i]);
                        ++i;
                    }
                    ++j2;
                }
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new GriddedSet(type, this.Samples, this.Lengths, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String pre) throws VisADException {
        String s;
        if (this.DomainDimension == this.ManifoldDimension) {
            s = pre + this.getClass().getName() + ": Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
            int j = 0;
            while (j < this.DomainDimension) {
                s = s + pre + "  Dimension " + j + ":" + " Length = " + this.Lengths[j] + " Range = " + this.Low[j] + " to " + this.Hi[j] + "\n";
                ++j;
            }
        } else {
            s = pre + this.getClass().getName() + ": DomainDimension = " + this.DomainDimension + " ManifoldDimension = " + this.ManifoldDimension + " Length = " + this.Length + "\n";
            int j = 0;
            while (j < this.ManifoldDimension) {
                s = s + pre + "  ManifoldDimension " + j + ":" + " Length = " + this.Lengths[j] + "\n";
                ++j;
            }
            j = 0;
            while (j < this.DomainDimension) {
                s = s + pre + "  DomainDimension " + j + ":" + " Range = " + this.Low[j] + " to " + this.Hi[j] + "\n";
                ++j;
            }
        }
        return s;
    }
}

