/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AxisScale;
import visad.CommonUnit;
import visad.Control;
import visad.ControlListener;
import visad.DataRenderer;
import visad.DataShadow;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.RendererControl;
import visad.ScalarMap;
import visad.Unit;
import visad.VisADException;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.VisADTriangleArray;

public abstract class DisplayRenderer
implements ControlListener {
    private transient DisplayImpl display;
    private transient RendererControl rendererControl = null;
    private Vector cursorStringVector = new Vector();
    String[] animationString = new String[]{null, null};
    private int[] axisOrdinals = new int[]{-1, -1, -1};
    private boolean waitFlag = false;
    private boolean cursor_string = true;
    private float pickThreshhold = 0.05f;
    private boolean aniStringVisible = true;

    public float getPickThreshhold() {
        return this.pickThreshhold;
    }

    public void setPickThreshhold(float pt) {
        this.pickThreshhold = pt;
    }

    public abstract void setBoxAspect(double[] var1);

    public void setDisplay(DisplayImpl d) throws VisADException {
        if (this.display != null) {
            throw new DisplayException("DisplayRenderer.setDisplay: display already set");
        }
        this.display = d;
        if (this.rendererControl == null) {
            this.rendererControl = new RendererControl(this.display);
            this.initControl(this.rendererControl);
        } else {
            RendererControl rc = new RendererControl(this.display);
            rc.syncControl(this.rendererControl);
            this.rendererControl = rc;
        }
        this.rendererControl.addControlListener(this);
        this.display.addControl(this.rendererControl);
    }

    public abstract void initControl(RendererControl var1);

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public RendererControl getRendererControl() {
        return this.rendererControl;
    }

    public void setWaitFlag(boolean b) {
        this.waitFlag = b;
        try {
            DisplayEvent e = new DisplayEvent(this.display, b ? 22 : 23);
            this.display.notifyListeners(e);
        }
        catch (VisADException e) {
        }
        catch (RemoteException e) {}
    }

    public boolean getWaitFlag() {
        return this.waitFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAxisOrdinal(int axis) {
        int[] nArray = this.axisOrdinals;
        synchronized (this.axisOrdinals) {
            int n = axis;
            this.axisOrdinals[n] = this.axisOrdinals[n] + 1;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.axisOrdinals[axis];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAxisOrdinals() {
        int[] nArray = this.axisOrdinals;
        synchronized (this.axisOrdinals) {
            this.axisOrdinals[0] = -1;
            this.axisOrdinals[1] = -1;
            this.axisOrdinals[2] = -1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.clearScales();
            return;
        }
    }

    public abstract BufferedImage getImage();

    public abstract void setScale(AxisScale var1) throws VisADException;

    public abstract void setScale(int var1, int var2, VisADLineArray var3, float[] var4) throws VisADException;

    public abstract void setScale(int var1, int var2, VisADLineArray var3, VisADTriangleArray var4, float[] var5) throws VisADException;

    public abstract void clearScales();

    public abstract void clearScale(AxisScale var1);

    public abstract void setScaleOn(boolean var1);

    public boolean getMode2D() {
        return false;
    }

    public void setBackgroundColor(Color color) throws RemoteException, VisADException {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.setBackgroundColor(r, g, b);
    }

    public void setBackgroundColor(float r, float g, float b) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setBackgroundColor(r, g, b);
    }

    public void setForegroundColor(Color color) throws RemoteException, VisADException {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.setForegroundColor(r, g, b);
    }

    public void setForegroundColor(float r, float g, float b) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setForegroundColor(r, g, b);
    }

    public boolean getBoxOn() throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        return this.rendererControl.getBoxOn();
    }

    public void setBoxColor(Color color) throws RemoteException, VisADException {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.setBoxColor(r, g, b);
    }

    public void setBoxColor(float r, float g, float b) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setBoxColor(r, g, b);
    }

    public void setBoxOn(boolean on) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setBoxOn(on);
    }

    public float[] getCursorColor() throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        return this.rendererControl.getCursorColor();
    }

    public void setCursorColor(Color color) throws RemoteException, VisADException {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.setCursorColor(r, g, b);
    }

    public void setCursorColor(float r, float g, float b) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setCursorColor(r, g, b);
    }

    public abstract Control makeControl(ScalarMap var1);

    public abstract DataRenderer makeDefaultRenderer();

    public abstract boolean legalDataRenderer(DataRenderer var1);

    public void setAnimationStringVisible(boolean visible) {
        this.aniStringVisible = visible;
    }

    public boolean getAnimationStringVisible() {
        return this.aniStringVisible;
    }

    public String[] getAnimationString() {
        if (this.aniStringVisible) {
            return this.animationString;
        }
        return new String[]{null, null};
    }

    public void setAnimationString(String[] animation) {
        this.animationString[0] = animation[0];
        this.animationString[1] = animation[1];
    }

    public abstract double[] getCursor();

    public abstract void setCursorOn(boolean var1);

    public abstract void depth_cursor(VisADRay var1);

    public abstract void drag_cursor(VisADRay var1, boolean var2);

    public abstract void setDirectOn(boolean var1);

    public abstract void drag_depth(float var1);

    public abstract boolean anyDirects();

    public abstract MouseBehavior getMouseBehavior();

    public abstract DataRenderer findDirect(VisADRay var1, int var2);

    public void setCursorStringOn(boolean on) {
        this.cursor_string = on;
    }

    public Vector getCursorStringVector() {
        if (this.cursor_string) {
            return (Vector)this.cursorStringVector.clone();
        }
        return new Vector();
    }

    public Vector getCursorStringVectorUnconditional() {
        return (Vector)this.cursorStringVector.clone();
    }

    public double getDirectAxisValue(RealType type) {
        return this.getDirectAxisValue(type.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDirectAxisValue(String name) {
        Vector vector = this.cursorStringVector;
        synchronized (vector) {
            if (this.cursorStringVector != null) {
                Enumeration strings = this.cursorStringVector.elements();
                while (strings.hasMoreElements()) {
                    String s = (String)strings.nextElement();
                    if (!s.startsWith(name)) continue;
                    String t = s.substring(s.indexOf("=") + 2);
                    int i = t.indexOf(" ");
                    if (i >= 0) {
                        t = t.substring(0, i);
                    }
                    try {
                        double v = Double.valueOf(t);
                        return v;
                    }
                    catch (NumberFormatException e) {
                        return Double.NaN;
                    }
                }
            }
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorStringVector(Vector vect) {
        Vector vector = this.cursorStringVector;
        synchronized (vector) {
            this.cursorStringVector.removeAllElements();
            if (vect != null) {
                Enumeration strings = vect.elements();
                while (strings.hasMoreElements()) {
                    this.cursorStringVector.addElement(strings.nextElement());
                }
            }
        }
        this.render_trigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorStringVector() {
        Vector vector = this.cursorStringVector;
        synchronized (vector) {
            this.cursorStringVector.removeAllElements();
            float[][] cursor = new float[3][1];
            double[] cur = this.getCursor();
            cursor[0][0] = (float)cur[0];
            cursor[1][0] = (float)cur[1];
            cursor[2][0] = (float)cur[2];
            Enumeration maps = this.display.getMapVector().elements();
            while (maps.hasMoreElements()) {
                try {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    DisplayRealType dreal = map.getDisplayScalar();
                    DisplayTupleType tuple = dreal.getTuple();
                    int index = dreal.getTupleIndex();
                    if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
                    float[] fval = new float[1];
                    if (tuple.equals(Display.DisplaySpatialCartesianTuple)) {
                        fval[0] = cursor[index][0];
                    } else {
                        float[][] new_cursor = tuple.getCoordinateSystem().fromReference(cursor);
                        fval[0] = new_cursor[index][0];
                    }
                    float[] dval = map.inverseScaleValues(fval);
                    RealType real = (RealType)map.getScalar();
                    Real r = new Real(real, (double)dval[0]);
                    Unit overrideUnit = map.getOverrideUnit();
                    Unit rtunit = real.getDefaultUnit();
                    if (overrideUnit != null && (!Unit.canConvert(rtunit, CommonUnit.secondsSinceTheEpoch) || rtunit.getAbsoluteUnit().equals(rtunit))) {
                        dval[0] = (float)overrideUnit.toThis(dval[0], rtunit);
                        r = new Real(real, dval[0], overrideUnit);
                    }
                    String valueString = r.toValueString();
                    String s = map.getScalarName() + " = " + valueString;
                    this.cursorStringVector.addElement(s);
                }
                catch (VisADException e) {
                    // empty catch block
                }
            }
        }
        this.render_trigger();
    }

    public void render_trigger() {
    }

    public boolean legalDisplayScalar(DisplayRealType type) {
        RealTupleType ref;
        int i = 0;
        while (i < Display.DisplayRealArray.length) {
            if (Display.DisplayRealArray[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return type.getTuple() != null && type.getTuple().getCoordinateSystem() != null && ((ref = type.getTuple().getCoordinateSystem().getReference()).equals(Display.DisplaySpatialCartesianTuple) || ref.equals(Display.DisplayRGBTuple) || ref.equals(Display.DisplayFlow1Tuple) || ref.equals(Display.DisplayFlow2Tuple));
    }

    public void prepareAction(Vector temp, Vector tmap, boolean go, boolean initialize) throws VisADException, RemoteException {
        DataShadow shadow = null;
        Enumeration renderers = temp.elements();
        while (renderers.hasMoreElements()) {
            DataRenderer renderer = (DataRenderer)renderers.nextElement();
            shadow = renderer.prepareAction(go, initialize, shadow);
        }
        if (shadow != null) {
            Enumeration maps = tmap.elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                map.setRange(shadow);
            }
        }
        ScalarMap.equalizeFlow(tmap, Display.DisplayFlow1Tuple);
        ScalarMap.equalizeFlow(tmap, Display.DisplayFlow2Tuple);
    }

    public abstract int getTextureWidthMax() throws VisADException;

    public abstract int getTextureHeightMax() throws VisADException;
}

