/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.text.ChoiceFormat;
import java.util.Vector;
import visad.BaseUnit;
import visad.Factor;
import visad.OffsetUnit;
import visad.PromiscuousUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class DerivedUnit
extends Unit
implements Serializable {
    Factor[] factors;
    private static AddPow addPow = new AddPow();
    private static SubPow subPow = new SubPow();

    public DerivedUnit() {
        this(new BaseUnit[0], new int[0], "");
    }

    public DerivedUnit(String identifier) {
        this(new BaseUnit[0], new int[0], identifier);
    }

    public DerivedUnit(BaseUnit baseUnit) {
        this(new BaseUnit[]{baseUnit}, new int[]{1}, baseUnit.getIdentifier());
    }

    public DerivedUnit(BaseUnit[] baseUnits, int[] powers) {
        this(DerivedUnit.newFactors(baseUnits, powers), baseUnits.length == 1 ? baseUnits[0].getIdentifier() : null);
    }

    public DerivedUnit(BaseUnit[] baseUnits, int[] powers, String identifier) {
        this(DerivedUnit.newFactors(baseUnits, powers), identifier);
    }

    protected static Factor[] newFactors(BaseUnit[] baseUnits, int[] powers) {
        Factor[] factors = new Factor[baseUnits.length];
        int i = 0;
        while (i < baseUnits.length) {
            factors[i] = new Factor(baseUnits[i], powers[i]);
            ++i;
        }
        return factors;
    }

    public DerivedUnit(DerivedUnit that, String identifier) {
        this(that.factors, identifier);
    }

    private DerivedUnit(Factor[] facts) {
        this(facts, (String)null);
    }

    private DerivedUnit(Factor[] facts, String identifier) {
        super(identifier);
        int n = 0;
        int i = 0;
        while (i < facts.length) {
            Factor fact = facts[i];
            if (fact != null && fact.power != 0) {
                ++n;
            }
            ++i;
        }
        this.factors = new Factor[n];
        n = 0;
        int i2 = 0;
        while (i2 < facts.length) {
            Factor fact = facts[i2];
            if (fact != null && fact.power != 0) {
                this.factors[n++] = fact;
            }
            ++i2;
        }
    }

    public boolean isDimensionless() {
        int i = 0;
        while (i < this.factors.length) {
            if (this.factors[i].power != 0 && !this.factors[i].baseUnit.isDimensionless()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Unit protectedClone(String identifier) {
        return new DerivedUnit(this, identifier);
    }

    public Unit pow(int power) {
        DerivedUnit result;
        if (power == 1) {
            result = this;
        } else {
            Factor[] newFactors = new Factor[this.factors.length];
            int i = 0;
            while (i < this.factors.length) {
                Factor factor = this.factors[i];
                newFactors[i] = new Factor(factor.baseUnit, factor.power * power);
                ++i;
            }
            result = new DerivedUnit(newFactors);
        }
        return result;
    }

    public Unit root(int root) throws IllegalArgumentException {
        DerivedUnit result;
        if (root == 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ".root(int): zero root");
        }
        if (root == 1) {
            result = this;
        } else {
            Factor[] newFactors = new Factor[this.factors.length];
            int i = 0;
            while (i < this.factors.length) {
                Factor factor = this.factors[i];
                if (factor.power % root != 0) {
                    throw new IllegalArgumentException(this.getClass().getName() + ".root(int): " + "Non-integral resulting dimension");
                }
                newFactors[i] = new Factor(factor.baseUnit, factor.power / root);
                ++i;
            }
            result = new DerivedUnit(newFactors);
        }
        return result;
    }

    public Unit pow(double power) throws IllegalArgumentException {
        Unit result;
        if (this.factors.length == 0) {
            result = this;
        } else if (Math.abs(power) > 1.0) {
            double intVal = Math.rint(power);
            if (power < ChoiceFormat.previousDouble(intVal) || power > ChoiceFormat.nextDouble(intVal)) {
                throw new IllegalArgumentException(this.getClass().getName() + ".pow(double): " + "Non-integral power");
            }
            result = this.pow((int)intVal);
        } else {
            double root = 1.0 / power;
            double intVal = Math.rint(root);
            if (root < ChoiceFormat.previousDouble(intVal) || root > ChoiceFormat.nextDouble(intVal)) {
                throw new IllegalArgumentException(this.getClass().getName() + ".pow(double): " + "Non-integral reciprocal power");
            }
            result = this.root((int)intVal);
        }
        return result;
    }

    public Unit scale(double amount) throws UnitException {
        return new ScaledUnit(amount, this);
    }

    public Unit shift(double offset) throws UnitException {
        return new OffsetUnit(offset, this);
    }

    public String getDefinition() {
        String definition;
        if (this.factors == null) {
            definition = "<unconstructed DerivedUnit>";
        } else {
            StringBuffer buf = new StringBuffer(80);
            int i = 0;
            while (i < this.factors.length) {
                if (this.factors[i].power == 1) {
                    buf.append(this.factors[i].baseUnit.toString() + ".");
                } else if (this.factors[i].power != 0) {
                    buf.append(this.factors[i].baseUnit.toString() + this.factors[i].power + ".");
                }
                ++i;
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            definition = buf.toString();
        }
        return definition;
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit meter = SI.meter;
        BaseUnit second = SI.second;
        DerivedUnit speed = new DerivedUnit(new BaseUnit[]{meter, second}, new int[]{1, -1});
        Unit speed2 = speed.pow(2);
        System.out.println("speed=\"" + speed + "\"");
        System.out.println("speed.pow(2)=\"" + speed.pow(2) + "\"");
        System.out.println("speed.pow(2.0+ULP)=\"" + speed.pow(ChoiceFormat.nextDouble(2.0)) + "\"");
        System.out.println("speed2.root(2)=\"" + speed2.root(2) + "\"");
        System.out.println("speed2.pow(1/(2.0+ULP))=\"" + speed2.pow(1.0 / ChoiceFormat.nextDouble(2.0)) + "\"");
        System.out.println("speed*meter=\"" + speed.multiply(meter) + "\"");
        System.out.println("meter*speed=\"" + meter.multiply(speed) + "\"");
        System.out.println("speed/meter=\"" + speed.divide(meter) + "\"");
        System.out.println("meter/speed=\"" + meter.divide(speed) + "\"");
        System.out.println("speed.toThis(5,speed)=" + speed.toThis(5.0, (Unit)speed));
        System.out.println("speed.toThat(5,speed)=" + speed.toThat(5.0, (Unit)speed));
        double[] values = speed.toThis(new double[]{1.0, 2.0}, speed);
        System.out.println("speed.toThis({1,2},speed)=" + values[0] + "," + values[1]);
        values = speed.toThat(new double[]{1.0, 2.0}, speed);
        System.out.println("speed.toThat({1,2},speed)=" + values[0] + "," + values[1]);
        DerivedUnit energy = (DerivedUnit)speed.pow(2).multiply(SI.kilogram);
        System.out.println("energy=\"" + energy + "\"");
        System.out.println("new DerivedUnit().isConvertible(new DerivedUnit()) = " + new DerivedUnit().isConvertible(new DerivedUnit()));
        System.out.println("Checking exceptions:");
        try {
            speed.toThis(5.0, (Unit)energy);
            System.err.println("ERROR: energy -> speed");
            System.exit(1);
        }
        catch (UnitException e) {
            System.out.println(e.getMessage());
        }
        try {
            System.out.println("speed.pow(2+2*ULP)=\"" + speed.pow(ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(2.0))) + "\"");
            System.err.println("ERROR: IllegalArgumentException not thrown!");
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        try {
            System.out.println("speed2.pow(1/(2+2*ULP))=\"" + speed2.pow(1.0 / ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(2.0))) + "\"");
            System.err.println("ERROR: IllegalArgumentException not thrown!");
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    private Vector[] common(DerivedUnit that) {
        int j;
        Vector[] vector = new Vector[3];
        int max = this.factors.length + that.factors.length;
        vector[0] = new Vector(max);
        vector[1] = new Vector(max);
        vector[2] = new Vector(max);
        int i = 0;
        while (i < this.factors.length) {
            if (this.factors[i].power != 0 && !this.factors[i].baseUnit.isDimensionless()) {
                j = 0;
                while (j < that.factors.length) {
                    if (that.factors[j].power != 0 && this.factors[i].baseUnit.equals(that.factors[j].baseUnit)) {
                        vector[2].addElement(new Factor[]{this.factors[i], that.factors[j]});
                        break;
                    }
                    ++j;
                }
                if (j == that.factors.length) {
                    vector[0].addElement(this.factors[i]);
                }
            }
            ++i;
        }
        j = 0;
        while (j < that.factors.length) {
            if (that.factors[j].power != 0 && !that.factors[j].baseUnit.isDimensionless()) {
                int i2 = 0;
                while (i2 < this.factors.length) {
                    if (this.factors[i2].power != 0 && this.factors[i2].baseUnit.equals(that.factors[j].baseUnit)) break;
                    ++i2;
                }
                if (i2 == this.factors.length) {
                    vector[1].addElement(that.factors[j]);
                }
            }
            ++j;
        }
        return vector;
    }

    public Unit multiply(Unit that) throws UnitException {
        return that instanceof DerivedUnit ? this.multiply((DerivedUnit)that) : that.multiply(this);
    }

    public Unit multiply(DerivedUnit that) {
        return addPow.multOp(this, that);
    }

    public Unit divide(Unit that) throws UnitException {
        return that instanceof DerivedUnit ? this.divide((DerivedUnit)that) : that.divideInto(this);
    }

    Unit divide(DerivedUnit that) {
        return subPow.multOp(this, that);
    }

    protected Unit divideInto(Unit that) throws UnitException {
        return that.divide(this);
    }

    boolean sameDimensionality(DerivedUnit that) {
        Vector[] comm = this.common(that);
        if (comm[0].size() != 0 || comm[1].size() != 0) {
            return false;
        }
        int n2 = comm[2].size();
        int i = 0;
        while (i < n2) {
            Factor[] factors = (Factor[])comm[2].elementAt(i);
            if (factors[0].power != factors[1].power) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean reciprocalDimensionality(DerivedUnit that) {
        Vector[] comm = this.common(that);
        if (comm[0].size() != 0 || comm[1].size() != 0) {
            return false;
        }
        int n2 = comm[2].size();
        int i = 0;
        while (i < n2) {
            Factor[] factors = (Factor[])comm[2].elementAt(i);
            if (factors[0].power != -factors[1].power) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double[] toThis(double[] values, Unit that) throws UnitException {
        if (that instanceof PromiscuousUnit) {
            double[] newValues = (double[])values.clone();
            return newValues;
        }
        return that instanceof DerivedUnit ? this.toThis(values, (DerivedUnit)that) : that.toThat(values, (Unit)this);
    }

    public float[] toThis(float[] values, Unit that) throws UnitException {
        if (that instanceof PromiscuousUnit) {
            float[] newValues = (float[])values.clone();
            return newValues;
        }
        return that instanceof DerivedUnit ? this.toThis(values, (DerivedUnit)that) : that.toThat(values, (Unit)this);
    }

    double[] toThis(double[] values, DerivedUnit that) throws UnitException {
        double[] newValues;
        if (this.sameDimensionality(that)) {
            newValues = new double[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = values[i];
                ++i;
            }
        } else if (this.reciprocalDimensionality(that)) {
            newValues = new double[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = 1.0 / values[i];
                ++i;
            }
        } else {
            throw new UnitException("Attempt to convert from unit \"" + that + "\" to unit \"" + this + "\"");
        }
        return newValues;
    }

    float[] toThis(float[] values, DerivedUnit that) throws UnitException {
        float[] newValues;
        if (this.sameDimensionality(that)) {
            newValues = new float[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = values[i];
                ++i;
            }
        } else if (this.reciprocalDimensionality(that)) {
            newValues = new float[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = 1.0f / values[i];
                ++i;
            }
        } else {
            throw new UnitException("Attempt to convert from unit \"" + that + "\" to unit \"" + this + "\"");
        }
        return newValues;
    }

    public double[] toThat(double[] values, Unit that) throws UnitException {
        if (that instanceof PromiscuousUnit) {
            double[] newValues = (double[])values.clone();
            return newValues;
        }
        return that instanceof DerivedUnit ? this.toThat(values, (DerivedUnit)that) : that.toThis(values, (Unit)this);
    }

    public float[] toThat(float[] values, Unit that) throws UnitException {
        if (that instanceof PromiscuousUnit) {
            float[] newValues = (float[])values.clone();
            return newValues;
        }
        return that instanceof DerivedUnit ? this.toThat(values, (DerivedUnit)that) : that.toThis(values, (Unit)this);
    }

    double[] toThat(double[] values, DerivedUnit that) throws UnitException {
        return that.toThis(values, this);
    }

    float[] toThat(float[] values, DerivedUnit that) throws UnitException {
        return that.toThis(values, this);
    }

    public boolean isConvertible(Unit unit) {
        DerivedUnit that;
        boolean isConvertible = unit == null ? false : (unit instanceof DerivedUnit ? this.sameDimensionality(that = (DerivedUnit)unit) || this.reciprocalDimensionality(that) : unit.isConvertible(this));
        return isConvertible;
    }

    public boolean equals(Unit unit) {
        int j;
        if (unit == null) {
            return false;
        }
        if (unit instanceof BaseUnit) {
            return this.equals(new DerivedUnit((BaseUnit)unit));
        }
        if (!(unit instanceof DerivedUnit)) {
            return unit.equals(this);
        }
        int n = this.factors.length;
        if (n != ((DerivedUnit)unit).factors.length) {
            return false;
        }
        boolean[] mark = new boolean[n];
        int j2 = 0;
        while (j2 < n) {
            mark[j2] = false;
            ++j2;
        }
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                if (!mark[j] && this.factors[i].equals(((DerivedUnit)unit).factors[j])) {
                    mark[j] = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < n) {
            if (!mark[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            int i = 0;
            while (i < this.factors.length) {
                this.hashCode ^= this.factors[i].hashCode();
                ++i;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    private static final class AddPow
    extends Op {
        private AddPow() {
        }

        protected Factor op(Factor factor) {
            return factor;
        }

        protected Factor op(Factor f1, Factor f2) {
            return new Factor(f1.baseUnit, f1.power + f2.power);
        }
    }

    static abstract class Op {
        Op() {
        }

        public DerivedUnit multOp(DerivedUnit d1, DerivedUnit d2) {
            Vector[] comm = d1.common(d2);
            int n0 = comm[0].size();
            int n1 = comm[1].size();
            int n2 = comm[2].size();
            Factor[] factors = new Factor[n0 + n1 + n2];
            int k = 0;
            int i = 0;
            while (i < n0) {
                factors[k++] = (Factor)comm[0].elementAt(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < n1) {
                factors[k++] = this.op((Factor)comm[1].elementAt(i2));
                ++i2;
            }
            int i3 = 0;
            while (i3 < n2) {
                Factor[] facts = (Factor[])comm[2].elementAt(i3);
                factors[k++] = this.op(facts[0], facts[1]);
                ++i3;
            }
            return new DerivedUnit(factors);
        }

        protected abstract Factor op(Factor var1);

        protected abstract Factor op(Factor var1, Factor var2);
    }

    private static final class SubPow
    extends Op {
        private SubPow() {
        }

        protected Factor op(Factor factor) {
            return new Factor(factor.baseUnit, -factor.power);
        }

        protected Factor op(Factor f1, Factor f2) {
            return new Factor(f1.baseUnit, f1.power - f2.power);
        }
    }
}

