/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.DoubleSet;
import visad.FloatSet;
import visad.Set;
import visad.VisADException;

public class DataShadow
implements Serializable {
    double[][] ranges;
    Set animationSampling;

    DataShadow(double[][] r) {
        this.ranges = r;
        this.animationSampling = null;
    }

    boolean isAnimationSampling(boolean domain) {
        if (domain) {
            return false;
        }
        return this.animationSampling != null;
    }

    void setAnimationSampling(Set set, boolean domain) throws VisADException {
        if (set instanceof DoubleSet || set instanceof FloatSet) {
            return;
        }
        if (domain) {
            this.animationSampling = this.animationSampling == null ? set : this.animationSampling.merge1DSets(set);
        }
    }

    public void merge(DataShadow shadow) throws VisADException {
        int n = this.ranges[0].length;
        int i = 0;
        while (i < n) {
            if (shadow.ranges[0][i] < this.ranges[0][i]) {
                this.ranges[0][i] = shadow.ranges[0][i];
            }
            if (shadow.ranges[1][i] > this.ranges[1][i]) {
                this.ranges[1][i] = shadow.ranges[1][i];
            }
            ++i;
        }
        this.setAnimationSampling(shadow.animationSampling, true);
    }
}

