/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.Serializable;
import java.util.Enumeration;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeDictionary;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionDictionary;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.DimensionSet;
import ucar.netcdf.Named;
import ucar.netcdf.NamedDictionary;
import ucar.netcdf.Netcdf;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.ProtoVariableIterator;
import ucar.netcdf.VariableIterator;

public class Schema
implements Serializable {
    private final DimensionDictionary dimensions;
    private final AttributeDictionary attributes;
    private final NamedDictionary variables;

    public Schema() {
        this.variables = new NamedDictionary(0);
        this.dimensions = new DimensionDictionary();
        this.attributes = new AttributeDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema(Schema sc) {
        Schema schema = sc;
        synchronized (schema) {
            this.dimensions = new DimensionDictionary(sc.getDimensions());
            this.variables = new NamedDictionary(sc.size());
            ProtoVariableIterator iter = sc.iterator();
            while (iter.hasNext()) {
                if (this.put(new ProtoVariable(iter.next())) == null) continue;
                throw new IllegalArgumentException("Duplicate variable name");
            }
            this.attributes = new AttributeDictionary(sc.getAttributes());
        }
    }

    public Schema(Netcdf nc) {
        this.dimensions = new DimensionDictionary(nc.getDimensions());
        this.variables = new NamedDictionary(nc.size());
        VariableIterator iter = nc.iterator();
        while (iter.hasNext()) {
            if (this.put(new ProtoVariable(iter.next())) == null) continue;
            throw new IllegalArgumentException("Duplicate variable name");
        }
        this.attributes = new AttributeDictionary(nc.getAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Schema(ProtoVariable[] varArray, Attribute[] attrArray) {
        if (varArray == null) {
            this.variables = new NamedDictionary(0);
            this.dimensions = new DimensionDictionary();
        } else {
            ProtoVariable[] protoVariableArray = varArray;
            // MONITORENTER : varArray
            this.dimensions = new DimensionDictionary(varArray);
            this.variables = new NamedDictionary(varArray);
            // MONITOREXIT : protoVariableArray
        }
        this.attributes = new AttributeDictionary(attrArray);
    }

    public int size() {
        return this.variables.size();
    }

    public ProtoVariableIterator iterator() {
        return new ProtoVariableIterator(){
            final Enumeration ee;
            {
                this.ee = Schema.this.variables.elements();
            }

            public boolean hasNext() {
                return this.ee.hasMoreElements();
            }

            public ProtoVariable next() {
                return (ProtoVariable)this.ee.nextElement();
            }
        };
    }

    public ProtoVariable[] toArray() {
        ProtoVariable[] aa = new ProtoVariable[this.size()];
        ProtoVariableIterator ee = this.iterator();
        int ii = 0;
        while (ee.hasNext()) {
            aa[ii] = ee.next();
            ++ii;
        }
        return aa;
    }

    public ProtoVariable get(String name) {
        return (ProtoVariable)this.variables.get(name);
    }

    public boolean contains(String name) {
        return this.variables.contains(name);
    }

    public boolean contains(Object oo) {
        return this.variables.contains(oo);
    }

    public synchronized ProtoVariable put(ProtoVariable var) {
        ProtoVariable hit = this.get(var.getName());
        if (hit != null) {
            if (hit == var) {
                return null;
            }
            this.remove(hit);
        }
        this.variables.put(var);
        var.connectDims(this.dimensions);
        return hit;
    }

    public synchronized boolean remove(String name) {
        ProtoVariable var = (ProtoVariable)this.variables.remove(name);
        if (var == null) {
            return false;
        }
        DimensionIterator checkiter = var.getDimensionIterator();
        while (checkiter.hasNext()) {
            boolean hit = false;
            Dimension check = checkiter.next();
            String checkStr = check.getName();
            ProtoVariableIterator viter = this.iterator();
            while (viter.hasNext()) {
                DimensionIterator diter = viter.next().getDimensionIterator();
                while (diter.hasNext()) {
                    Dimension ref = diter.next();
                    if (!ref.getName().equals(checkStr)) continue;
                    hit = true;
                    break;
                }
                if (hit) break;
            }
            if (hit) continue;
            this.dimensions.remove(checkStr);
        }
        return true;
    }

    public boolean remove(Object oo) {
        if (this.contains(oo)) {
            return this.remove(((Named)oo).getName());
        }
        return false;
    }

    public DimensionSet getDimensions() {
        return this.dimensions;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Attribute putAttribute(Attribute attr) {
        return this.attributes.put(attr);
    }

    public void toCdl(StringBuffer buf) {
        buf.append("{\n");
        this.dimensions.toCdl(buf);
        buf.append("variables:\n");
        ProtoVariableIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append("\t");
            iter.next().toCdl(buf);
        }
        if (this.attributes.size() > 0) {
            buf.append("\n// global attributes:\n");
            this.attributes.toCdl(buf);
        }
        buf.append("\n}");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toCdl(buf);
        return buf.toString();
    }

    int indexOf(Dimension dim) {
        return this.dimensions.indexOf(dim);
    }

    void putDimension(Dimension dim) {
        this.dimensions.initialPut(dim);
    }
}

