/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ucar.netcdf.Named;

class NamedDictionary
implements Serializable {
    private Vector vector;
    private transient Hashtable table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void init(Named[] na) {
        if (na == null) {
            this.vector = new Vector(0);
        } else {
            Named[] namedArray = na;
            // MONITORENTER : na
            this.vector = new Vector(na.length);
            int ii = 0;
            while (ii < na.length) {
                this.vector.addElement(na[ii]);
                ++ii;
            }
            // MONITOREXIT : namedArray
        }
        int size = this.vector.size();
        if (size < 3) {
            size = 3;
        }
        size *= 4;
        this.table = new Hashtable(size /= 3, 0.75f);
        Enumeration ee = this.vector.elements();
        while (ee.hasMoreElements()) {
            Named value = (Named)ee.nextElement();
            this.table.put(value.getName(), value);
        }
    }

    NamedDictionary(Named[] na) {
        this.init(na);
    }

    NamedDictionary(int size, Enumeration ee) {
        this.vector = new Vector(size);
        this.table = new Hashtable((size < 3 ? 3 : size) * 4 / 3, 0.75f);
        while (ee.hasMoreElements()) {
            Named value = (Named)ee.nextElement();
            this.put(value);
        }
    }

    NamedDictionary(int size) {
        this.vector = new Vector(size);
        this.table = new Hashtable((size < 3 ? 3 : size) * 4 / 3, 0.75f);
    }

    int size() {
        return this.vector.size();
    }

    Enumeration elements() {
        return this.vector.elements();
    }

    Named get(String name) {
        return (Named)this.table.get(name);
    }

    synchronized Named put(Named value) {
        String name = value.getName();
        Named prev = this.get(name);
        if (prev != null) {
            this.vector.remove(prev);
        }
        this.vector.addElement(value);
        return this.table.put(name, value);
    }

    synchronized Named remove(String name) {
        this.vector.removeElement(this.get(name));
        return (Named)this.table.remove(name);
    }

    int indexOf(Named elem) {
        return this.vector.indexOf(elem);
    }

    boolean contains(String name) {
        return this.table.containsKey(name);
    }

    boolean contains(Object oo) {
        return this.table.contains(oo);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int sz = this.size();
        Named[] na = new Named[sz];
        int ii = 0;
        Enumeration ee = this.vector.elements();
        while (ee.hasMoreElements()) {
            na[ii++] = (Named)ee.nextElement();
        }
        out.writeObject(na);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Named[] na = (Named[])in.readObject();
        this.init(na);
    }
}

