/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class ClipMap
extends ConcreteIndexMap {
    private int position_;
    private int low_;
    private int extent_;

    public ClipMap(int position, int low, int extent) {
        this.init(new IMap(), new LengthsMap());
        this.position_ = position;
        this.low_ = low;
        this.extent_ = extent;
    }

    public ClipMap(ConcreteIndexMap prev, int position, int low, int extent) {
        this.link(prev, new IMap(), new LengthsMap());
        this.position_ = position;
        this.low_ = low;
        this.extent_ = extent;
    }

    public static void main(String[] args) {
        int[] shape = new int[]{48, 64};
        MultiArrayImpl delegate = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        int ii = 0;
        while (ii < size) {
            Array.setInt(delegate.storage, ii, ii);
            ++ii;
        }
        ClipMap im = new ClipMap(0, 8, 32);
        MultiArrayProxy ma = new MultiArrayProxy(delegate, im);
        try {
            System.out.println("Rank  " + ma.getRank());
            int[] lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[]{1, 0}));
        }
        catch (IOException ee) {}
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private IMap() {
            super(ClipMap.this);
        }

        public synchronized int get(int key) {
            if (key == ClipMap.this.position_) {
                return super.get(key) + ClipMap.this.low_;
            }
            return super.get(key);
        }
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        private LengthsMap() {
            super(ClipMap.this);
        }

        public synchronized int get(int key) {
            if (key == ClipMap.this.position_) {
                return ClipMap.this.extent_;
            }
            return super.get(key);
        }
    }
}

