/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.util.ArrayFuncs;

public class PrimaryHDU
extends BasicHDU {
    public PrimaryHDU(Header header) throws FitsException {
        super(header);
        if (!this.isHeader()) {
            throw new BadHeaderException("Not a valid primary header or uses random groups");
        }
    }

    public PrimaryHDU(ImageHDU img) throws FitsException {
        super(img.myHeader);
        if (this.myHeader != null && !this.myHeader.imageToPrimary()) {
            throw new FitsException("Couldn't create PrimaryHDU from ImageHDU");
        }
        this.myData = img.myData;
    }

    public PrimaryHDU() throws FitsException {
        super(new Header());
        this.myData = new ImageData();
        this.myHeader.pointToData(this.myData);
    }

    public PrimaryHDU(Object obj) throws FitsException {
        super(new Header());
        this.myData = new ImageData(obj);
        this.myHeader.pointToData(this.myData);
    }

    public static boolean isHeader(Header header) {
        if (header.getBooleanValue("GROUPS") && (header.getIntValue("GCOUNT", 1) > 1 || header.getIntValue("PCOUNT", 0) != 0)) {
            return false;
        }
        String card0 = header.getCard(0);
        return card0 != null && card0.startsWith("SIMPLE  ");
    }

    public boolean isHeader() {
        return PrimaryHDU.isHeader(this.myHeader);
    }

    public Data manufactureData() throws FitsException {
        return new ImageData(this.myHeader);
    }

    public void info() {
        System.out.println("  Primary Image");
        System.out.println("      Header Information:");
        System.out.println("         BITPIX=" + this.myHeader.getIntValue("BITPIX", -1));
        int naxis = this.myHeader.getIntValue("NAXIS", -1);
        System.out.println("         NAXIS=" + naxis);
        int i = 1;
        while (i <= naxis) {
            System.out.println("         NAXIS" + i + "=" + this.myHeader.getIntValue("NAXIS" + i, -1));
            ++i;
        }
        System.out.println("      Data information:");
        if (this.myData.getData() == null) {
            System.out.println("        No Data");
        } else {
            System.out.println("         " + ArrayFuncs.arrayDescription(this.myData.getData()));
        }
    }
}

