/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import visad.Gridded2DSet;
import visad.RealTupleType;

public final class LALOnav
extends AREAnav {
    int rows;
    int cols;
    int latres;
    int lonres;
    int latpoint;
    int lonpoint;
    int numPoints;
    int ulline;
    int ulelem;
    int aux_size;
    int lat_aux_offset;
    int lon_aux_offset;
    int lrlin;
    int lrele;
    double minlat;
    double maxlat;
    double minlon;
    double maxlon;
    float[] latData;
    float[] lonData;
    float LAT_MISSING = 0.0f;
    float LON_MISSING = 0.0f;
    boolean debug = false;
    int count = 0;
    Gridded2DSet gs = null;
    private int gx = -1;
    private int gy = -1;
    boolean Pos;

    public LALOnav(int[] iparms, int[] auxBlock) throws IllegalArgumentException {
        if (iparms[0] != 1279347791) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        if (this.debug) {
            System.out.println("Len of nav = " + iparms.length);
            int i = 0;
            while (i < iparms.length) {
                System.out.println("i=" + i + "  iparm=" + iparms[i]);
                ++i;
            }
        }
        this.rows = iparms[65];
        this.cols = iparms[66];
        this.minlat = Float.intBitsToFloat(iparms[67]);
        this.minlon = Float.intBitsToFloat(iparms[68]);
        this.maxlat = Float.intBitsToFloat(iparms[69]);
        this.maxlon = Float.intBitsToFloat(iparms[70]);
        this.latres = iparms[71];
        this.lonres = iparms[72];
        this.latpoint = iparms[73];
        this.lonpoint = iparms[74];
        this.ulline = iparms[75];
        this.ulelem = iparms[76];
        this.aux_size = iparms[77];
        this.lat_aux_offset = iparms[78];
        this.lon_aux_offset = iparms[79];
        int begLat = this.lat_aux_offset / 4;
        int begLon = this.lon_aux_offset / 4;
        this.lrlin = this.ulline + (this.rows - 1) * this.latres;
        this.lrele = this.ulelem + (this.cols - 1) * this.lonres;
        if (this.debug) {
            System.out.println("rows, cols=" + this.rows + " " + this.cols);
            System.out.println("min/max lat, lon=" + this.minlat + " " + this.maxlat + " / " + this.minlon + " " + this.maxlon);
            System.out.println("latres, lonres=" + this.latres + " " + this.lonres);
            System.out.println("latpoint, lonpoint=" + this.latpoint + " " + this.lonpoint);
            System.out.println("ulline, ulelem=" + this.ulline + " " + this.ulelem);
            System.out.println("size_aux, lat_aux, lon_aux=" + this.aux_size + " " + this.lat_aux_offset + " " + this.lon_aux_offset);
            System.out.println("len of auxBlock" + auxBlock.length);
            System.out.println("begLat/Lon=" + begLat + " " + begLon);
            System.out.println("len of auxBlock=" + auxBlock.length);
        }
        this.numPoints = this.cols * this.rows;
        this.latData = new float[this.numPoints];
        this.lonData = new float[this.numPoints];
        float[][] lalo = new float[2][this.numPoints];
        int k = 0;
        while (k < this.numPoints) {
            this.latData[k] = Float.intBitsToFloat(auxBlock[k + begLat]);
            this.lonData[k] = Float.intBitsToFloat(auxBlock[k + begLon]);
            lalo[0][k] = this.lonData[k];
            lalo[1][k] = this.latData[k];
            if (this.latData[k] < -90.0f || this.latData[k] > 90.0f || this.lonData[k] < -180.0f || this.lonData[k] > 360.0f) {
                this.latData[k] = this.LAT_MISSING;
                this.lonData[k] = this.LON_MISSING;
                lalo[0][k] = Float.NaN;
                lalo[1][k] = Float.NaN;
            }
            ++k;
        }
        this.count = 0;
        try {
            this.gs = new Gridded2DSet(RealTupleType.SpatialEarth2DTuple, lalo, this.cols, this.rows, null, null, null, false, false);
        }
        catch (Exception ge) {
            System.out.println("####  The VisAD library visad.jar is needed for this operation");
            ge.printStackTrace();
        }
        if (this.debug) {
            System.out.println("done coverting");
        }
    }

    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        int point = 0;
        while (point < number) {
            double rlin = imglinele[1][point];
            double rele = imglinele[0][point];
            if (this.debug) {
                ++this.count;
                if (this.count < 20) {
                    System.out.println(" ulline, lrlin, ulelem, lrele=" + this.ulline + " " + this.lrlin + " " + this.ulelem + " " + this.lrele);
                    System.out.println(" rlin, rele= " + rlin + " " + rele);
                }
            }
            if (rlin < (double)this.ulline || rlin > (double)this.lrlin || rele < (double)this.ulelem || rele > (double)this.lrele) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
            } else {
                int tl_entry = ((int)rlin - this.ulline) / this.latres * this.cols + ((int)rele - this.ulelem) / this.lonres;
                int tr_entry = tl_entry + 1;
                int bl_entry = tl_entry + this.cols;
                int br_entry = bl_entry + 1;
                float tl_lats = this.latData[tl_entry];
                float tr_lats = this.latData[tr_entry];
                float bl_lats = this.latData[bl_entry];
                float br_lats = this.latData[br_entry];
                float tl_lons = this.lonData[tl_entry];
                float tr_lons = this.lonData[tr_entry];
                float bl_lons = this.lonData[bl_entry];
                float br_lons = this.lonData[br_entry];
                if (tl_lats == this.LAT_MISSING && tl_lons == this.LON_MISSING || tr_lats == this.LAT_MISSING && tr_lons == this.LON_MISSING || bl_lats == this.LAT_MISSING && bl_lons == this.LON_MISSING || br_lats == this.LAT_MISSING && br_lons == this.LON_MISSING) {
                    latlon[0][point] = Float.NaN;
                    latlon[1][point] = Float.NaN;
                } else {
                    float frac_row = (float)(((int)rlin - this.ulline) % this.latres) / (float)this.latres;
                    float frac_col = (float)(((int)rele - this.ulelem) % this.lonres) / (float)this.lonres;
                    if (this.debug && this.count < 20) {
                        System.out.println(" tl_entry=" + tl_entry);
                        if ((double)linele[1][point] < 0.1) {
                            System.out.println(" lats: tl, tr, bl, br=" + tl_lats + " " + tr_lats + " " + bl_lats + " " + br_lats);
                            System.out.println(" frac_row=" + frac_row + " frac_col=" + frac_col);
                        }
                    }
                    float ax = tr_lats - tl_lats;
                    float bx = bl_lats - tl_lats;
                    float cx = tl_lats + br_lats - (bl_lats + tr_lats);
                    latlon[0][point] = ax * frac_col + bx * frac_row + cx * frac_row * frac_col + tl_lats;
                    ax = tr_lons - tl_lons;
                    bx = bl_lons - tl_lons;
                    cx = tl_lons + br_lons - (bl_lons + tr_lons);
                    latlon[1][point] = ax * frac_col + bx * frac_row + cx * frac_row * frac_col + tl_lons;
                }
            }
            if (this.debug && this.count < 20) {
                System.out.println(" line/ele = " + linele[1][point] + "/" + linele[0][point] + "  rlin/rele=" + rlin + "/" + rele + " Lat/Lon=" + latlon[0][point] + "/" + latlon[1][point]);
            }
            ++point;
        }
        return latlon;
    }

    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        int point = 0;
        while (point < number) {
            double rlin = imglinele[1][point];
            double rele = imglinele[0][point];
            if (this.debug) {
                ++this.count;
                if (this.count < 20) {
                    System.out.println(" ulline, lrlin, ulelem, lrele=" + this.ulline + " " + this.lrlin + " " + this.ulelem + " " + this.lrele);
                    System.out.println(" rlin, rele= " + rlin + " " + rele);
                }
            }
            if (rlin < (double)this.ulline || rlin > (double)this.lrlin || rele < (double)this.ulelem || rele > (double)this.lrele) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
            } else {
                int tl_entry = ((int)rlin - this.ulline) / this.latres * this.cols + ((int)rele - this.ulelem) / this.lonres;
                int tr_entry = tl_entry + 1;
                int bl_entry = tl_entry + this.cols;
                int br_entry = bl_entry + 1;
                float tl_lats = this.latData[tl_entry];
                float tr_lats = this.latData[tr_entry];
                float bl_lats = this.latData[bl_entry];
                float br_lats = this.latData[br_entry];
                float tl_lons = this.lonData[tl_entry];
                float tr_lons = this.lonData[tr_entry];
                float bl_lons = this.lonData[bl_entry];
                float br_lons = this.lonData[br_entry];
                if (tl_lats == this.LAT_MISSING && tl_lons == this.LON_MISSING || tr_lats == this.LAT_MISSING && tr_lons == this.LON_MISSING || bl_lats == this.LAT_MISSING && bl_lons == this.LON_MISSING || br_lats == this.LAT_MISSING && br_lons == this.LON_MISSING) {
                    latlon[0][point] = Double.NaN;
                    latlon[1][point] = Double.NaN;
                } else {
                    float frac_row = (float)(((int)rlin - this.ulline) % this.latres) / (float)this.latres;
                    float frac_col = (float)(((int)rele - this.ulelem) % this.lonres) / (float)this.lonres;
                    if (this.debug && this.count < 20) {
                        System.out.println(" tl_entry=" + tl_entry);
                        if (linele[1][point] < 0.1) {
                            System.out.println(" lats: tl, tr, bl, br=" + tl_lats + " " + tr_lats + " " + bl_lats + " " + br_lats);
                            System.out.println(" frac_row=" + frac_row + " frac_col=" + frac_col);
                        }
                    }
                    float ax = tr_lats - tl_lats;
                    float bx = bl_lats - tl_lats;
                    float cx = tl_lats + br_lats - (bl_lats + tr_lats);
                    latlon[0][point] = ax * frac_col + bx * frac_row + cx * frac_row * frac_col + tl_lats;
                    ax = tr_lons - tl_lons;
                    bx = bl_lons - tl_lons;
                    cx = tl_lons + br_lons - (bl_lons + tr_lons);
                    latlon[1][point] = ax * frac_col + bx * frac_row + cx * frac_row * frac_col + tl_lons;
                }
            }
            if (this.debug && this.count < 20) {
                System.out.println(" line/ele = " + linele[1][point] + "/" + linele[0][point] + "  rlin/rele=" + rlin + "/" + rele + " Lat/Lon=" + latlon[0][point] + "/" + latlon[1][point]);
            }
            ++point;
        }
        return latlon;
    }

    public float[][] toLinEle(float[][] latlon) {
        try {
            float[][] ll = new float[2][latlon[0].length];
            int k = 0;
            while (k < ll[0].length) {
                ll[0][k] = latlon[1][k];
                ll[1][k] = latlon[0][k];
                ++k;
            }
            float[][] linele = this.gs.valueToGrid(ll);
            int k2 = 0;
            while (k2 < linele[0].length) {
                linele[1][k2] = (float)this.ulline + (float)this.latres * linele[1][k2];
                linele[0][k2] = (float)this.ulelem + (float)this.lonres * linele[0][k2];
                ++k2;
            }
            return this.imageCoordToAreaCoord(linele);
        }
        catch (Exception e) {
            return null;
        }
    }

    public double[][] toLinEle(double[][] latlon) {
        try {
            float[][] ll = new float[2][latlon[0].length];
            int k = 0;
            while (k < ll[0].length) {
                ll[0][k] = (float)latlon[1][k];
                ll[1][k] = (float)latlon[0][k];
                ++k;
            }
            float[][] xy = this.gs.valueToGrid(ll);
            double[][] linele = new double[2][xy[0].length];
            int k2 = 0;
            while (k2 < xy[0].length) {
                linele[1][k2] = (float)this.ulline + (float)this.latres * xy[1][k2];
                linele[0][k2] = (float)this.ulelem + (float)this.lonres * xy[0][k2];
                ++k2;
            }
            return this.imageCoordToAreaCoord(linele);
        }
        catch (Exception e) {
            return null;
        }
    }
}

