/*
 * Decompiled with CFR 0.152.
 */
package dods.util;

import dods.util.InvalidSwitch;
import dods.util.OptSwitch;
import java.util.Enumeration;
import java.util.Hashtable;

public class Getopts {
    Hashtable switchtab;
    String[] arglist;

    public OptSwitch getSwitch(Character sw) {
        return (OptSwitch)this.switchtab.get(sw);
    }

    public String getOption(Character sw) {
        return this.getOption(sw);
    }

    public String getOption(int sw) {
        Character opt = new Character((char)sw);
        return this.getOption(opt);
    }

    public Enumeration swList() {
        return this.switchtab.keys();
    }

    public String[] argList() {
        return this.arglist;
    }

    public Getopts(String flags, String[] args) throws InvalidSwitch {
        char cc;
        String throwstring = new String("Invalid Getopts switch(s): ");
        String usage = new String("Usage: Getopts(String flags, String args[])");
        this.switchtab = new Hashtable(1, 1.0f);
        int i = 0;
        while (i < flags.length()) {
            cc = flags.charAt(i);
            Character c = new Character(cc);
            char[] alpha = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
            if (cc == ' ' || cc == '\t' || cc == '\n' || cc == '\r') {
                throw new InvalidSwitch(throwstring + "Spaces not allowed\n" + usage + "\n");
            }
            boolean found = false;
            int j = 0;
            while (j < alpha.length) {
                Character ch = new Character(alpha[j]);
                char uc = Character.toUpperCase(ch.charValue());
                if (alpha[j] == cc || uc == cc) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found && cc != ':') {
                throw new InvalidSwitch(throwstring + "Invalid Character " + c + "\n" + usage + "\n");
            }
            if (cc == ':') {
                if (i > 0) {
                    char prv = flags.charAt(i - 1);
                    if (prv == ':') {
                        throw new InvalidSwitch(throwstring + "Can't have consecutive ':'\n" + usage + "\n");
                    }
                    Character cp = new Character(prv);
                    OptSwitch sw = (OptSwitch)this.switchtab.get(cp);
                    sw.SetHasValue(2);
                }
            } else {
                OptSwitch sw = new OptSwitch((int)cc, 1);
                this.switchtab.put(c, sw);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < args.length) {
            cc = args[i2].charAt(0);
            if (cc != '-') break;
            int j = 1;
            while (j < args[i2].length()) {
                cc = args[i2].charAt(j);
                Character fc = new Character(cc);
                OptSwitch cs = (OptSwitch)this.switchtab.get(fc);
                if (cs == null) {
                    throw new InvalidSwitch(throwstring + "invalid switch " + cc + "\n2 Valid switches are: " + flags + "\n" + usage + "\n");
                }
                if (!cs.acceptVal()) {
                    cs.SetVal(true);
                } else if (j + 1 < args[i2].length()) {
                    cs.SetVal(args[i2].substring(j + 1));
                    j = args[i2].length();
                } else {
                    if (++i2 >= args.length) {
                        throw new InvalidSwitch(throwstring + "missing value from switch " + cc + "\n1 Valid switches are: " + flags + "\n" + usage + "\n");
                    }
                    if (args[i2].charAt(0) == '-') {
                        throw new InvalidSwitch(throwstring + "missing value from switch " + cc + "\n0 Valid switches are: " + flags + "\n" + usage + "\n");
                    }
                    cs.SetVal(args[i2]);
                    j = args[i2].length();
                }
                ++j;
            }
            ++i2;
        }
        this.arglist = new String[args.length - i2];
        System.arraycopy(args, i2, this.arglist, 0, args.length - i2);
    }

    public static void main(String[] args) throws InvalidSwitch {
        String[] args1 = new String[args.length - 1];
        System.arraycopy(args, 1, args1, 0, args.length - 1);
        int i = 0;
        while (i < args.length) {
            System.out.println("args[" + i + "] : " + args[i]);
            ++i;
        }
        try {
            Getopts opts = new Getopts(args[0], args1);
            Enumeration names = opts.swList();
            i = 0;
            while (names.hasMoreElements()) {
                OptSwitch cs = opts.getSwitch((Character)names.nextElement());
                System.out.println("args[" + i + "] : " + (char)cs.sw + " " + cs.type + " " + cs.set + " " + cs.val);
                ++i;
            }
            String[] argp = opts.argList();
            i = 0;
            while (i < argp.length) {
                System.out.println("argv[" + i + "] : " + argp[i]);
                ++i;
            }
        }
        catch (InvalidSwitch e) {
            System.out.print(e);
        }
    }
}

