/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.parser;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.BaseTypeFactory;
import dods.dap.DArray;
import dods.dap.DConstructor;
import dods.dap.DDS;
import dods.dap.DDSException;
import dods.dap.DGrid;
import dods.dap.DVector;
import dods.dap.parser.DDSParserConstants;
import dods.dap.parser.DDSParserTokenManager;
import dods.dap.parser.ParseException;
import dods.dap.parser.SimpleCharStream;
import dods.dap.parser.Token;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class DDSParser
implements DDSParserConstants {
    private DDS dds;
    private BaseTypeFactory factory;
    private Stack ctor;
    private BaseType current;
    private int part;
    private String id;
    private static final String noDDSMsg = "The descriptor object returned from the dataset was null\nCheck that the URL is correct.";
    public DDSParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[22];
    private final int[] jj_la1_0 = new int[]{64, 1048448, 1048448, 1048320, 1046528, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 2097024, 0x2000000, 2097024};
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void addEntry() {
        if (!this.ctor.empty()) {
            if (this.ctor.peek() instanceof DVector) {
                DVector top = (DVector)this.ctor.peek();
                top.addVariable(this.current);
                this.current = (BaseType)this.ctor.pop();
            } else if (this.ctor.peek() instanceof DConstructor) {
                DConstructor top = (DConstructor)this.ctor.peek();
                if (top instanceof DGrid) {
                    top.addVariable(this.current, this.part);
                } else {
                    top.addVariable(this.current);
                }
            }
        } else {
            this.dds.addVariable(this.current);
        }
    }

    private void throwBad(String s1) throws BadSemanticsException {
        throw new BadSemanticsException("In the dataset descriptor object:\n`" + s1 + "' is not a valid declaration.");
    }

    private void throwBad(String s1, String s2) throws BadSemanticsException {
        throw new BadSemanticsException("In the dataset descriptor object:\n`" + s1 + " " + s2 + "' is not a valid declaration");
    }

    private void checkAdd(String s1) throws BadSemanticsException {
        try {
            this.current.checkSemantics();
            this.addEntry();
        }
        catch (BadSemanticsException e) {
            this.throwBad(s1);
        }
    }

    private void checkAdd(String s1, String s2) throws BadSemanticsException {
        try {
            this.current.checkSemantics();
            this.addEntry();
        }
        catch (BadSemanticsException e) {
            this.throwBad(s1, s2);
        }
    }

    private boolean isKeyword(String word, String keyword) {
        return keyword.equalsIgnoreCase(word);
    }

    public final void Dataset(DDS dds, BaseTypeFactory factory) throws ParseException, DDSException {
        this.dds = dds;
        this.factory = factory;
        this.ctor = new Stack();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                this.jj_consume_token(21);
                this.Declarations();
                this.jj_consume_token(22);
                this.Name();
                this.jj_consume_token(23);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.error(noDDSMsg);
            }
        }
    }

    public final void Declarations() throws ParseException, DDSException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.Declaration();
        }
    }

    public final void Declaration() throws ParseException, DDSException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                String s1 = this.List();
                String s2 = this.NonListDecl();
                this.checkAdd(s1, s2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.NonListDecl();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String NonListDecl() throws ParseException, DDSException {
        String s1 = null;
        String s2 = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    s1 = this.BaseType();
                    s2 = this.Var();
                    this.jj_consume_token(23);
                    this.checkAdd(s1, s2);
                    return s2;
                }
                case 9: {
                    this.Structure();
                    this.jj_consume_token(21);
                    this.Declarations();
                    this.jj_consume_token(22);
                    this.current = (BaseType)this.ctor.pop();
                    s1 = this.Var();
                    this.jj_consume_token(23);
                    this.checkAdd(s1);
                    return s1;
                }
                case 8: {
                    this.Sequence();
                    this.jj_consume_token(21);
                    this.Declarations();
                    this.jj_consume_token(22);
                    this.current = (BaseType)this.ctor.pop();
                    s1 = this.Var();
                    this.jj_consume_token(23);
                    this.checkAdd(s1);
                    return s1;
                }
                case 10: {
                    this.Grid();
                    this.jj_consume_token(21);
                    Token t = this.jj_consume_token(20);
                    this.jj_consume_token(24);
                    if (this.isKeyword(t.image, "array")) {
                        this.part = 1;
                    } else {
                        this.error("\nParse error: Expected the keyword \"Array:\"\nbut found: " + t.image + " instead.");
                    }
                    this.Declaration();
                    t = this.jj_consume_token(20);
                    this.jj_consume_token(24);
                    if (this.isKeyword(t.image, "maps")) {
                        this.part = 2;
                    } else {
                        this.error("\nParse error: Expected the keyword \"Maps:\"\nbut found: " + t.image + " instead.");
                    }
                    this.Declarations();
                    this.jj_consume_token(22);
                    this.current = (BaseType)this.ctor.pop();
                    s1 = this.Var();
                    this.jj_consume_token(23);
                    this.checkAdd(s1);
                    return s1;
                }
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (ParseException e) {
            this.error("\nParse Error on token: " + s1 + "\n" + "In the dataset descriptor object:\n" + "Expected a variable declaration (e.g., Int32 i;).");
            throw new Error("Missing return statement in function");
        }
    }

    public final String List() throws ParseException {
        Token t = this.jj_consume_token(7);
        this.ctor.push(this.factory.newDList());
        return t.image;
    }

    public final String Structure() throws ParseException {
        Token t = this.jj_consume_token(9);
        this.ctor.push(this.factory.newDStructure());
        return t.image;
    }

    public final String Sequence() throws ParseException {
        Token t = this.jj_consume_token(8);
        this.ctor.push(this.factory.newDSequence());
        return t.image;
    }

    public final String Grid() throws ParseException {
        Token t = this.jj_consume_token(10);
        this.ctor.push(this.factory.newDGrid());
        return t.image;
    }

    public final String BaseType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                Token t = this.jj_consume_token(11);
                this.current = this.factory.newDByte();
                return t.image;
            }
            case 12: {
                Token t = this.jj_consume_token(12);
                this.current = this.factory.newDInt16();
                return t.image;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                this.current = this.factory.newDUInt16();
                return t.image;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                this.current = this.factory.newDInt32();
                return t.image;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                this.current = this.factory.newDUInt32();
                return t.image;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                this.current = this.factory.newDFloat32();
                return t.image;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                this.current = this.factory.newDFloat64();
                return t.image;
            }
            case 18: {
                Token t = this.jj_consume_token(18);
                this.current = this.factory.newDString();
                return t.image;
            }
            case 19: {
                Token t = this.jj_consume_token(19);
                this.current = this.factory.newDURL();
                return t.image;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Var() throws ParseException, DDSException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                Token t = this.jj_consume_token(20);
                this.current.setName(t.image);
                block58: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            break block58;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 11: {
                Token t = this.jj_consume_token(11);
                this.current.setName(t.image);
                block59: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block59;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 12: {
                Token t = this.jj_consume_token(12);
                this.current.setName(t.image);
                block60: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                            break block60;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                this.current.setName(t.image);
                block61: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block61;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                this.current.setName(t.image);
                block62: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            break block62;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                this.current.setName(t.image);
                block63: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block63;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                this.current.setName(t.image);
                block64: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block64;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                this.current.setName(t.image);
                block65: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block65;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 18: {
                Token t = this.jj_consume_token(18);
                this.current.setName(t.image);
                block66: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block66;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 19: {
                Token t = this.jj_consume_token(19);
                this.current.setName(t.image);
                block67: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block67;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                this.current.setName(t.image);
                block68: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            break block68;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 8: {
                Token t = this.jj_consume_token(8);
                this.current.setName(t.image);
                block69: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block69;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                this.current.setName(t.image);
                block70: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                            break block70;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
            case 7: {
                Token t = this.jj_consume_token(7);
                this.current.setName(t.image);
                block71: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 25: {
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            break block71;
                        }
                    }
                    this.ArrayDecl();
                }
                return t.image;
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void ArrayDecl() throws ParseException, DDSException {
        block11: {
            Token t = new Token();
            try {
                if (this.jj_2_1(3)) {
                    this.jj_consume_token(25);
                    t = this.jj_consume_token(20);
                    this.jj_consume_token(26);
                    if (this.current instanceof DArray) {
                        ((DArray)this.current).appendDim(Integer.parseInt(t.image));
                    } else {
                        DArray a = this.factory.newDArray();
                        a.addVariable(this.current);
                        a.appendDim(Integer.parseInt(t.image));
                        this.current = a;
                    }
                    break block11;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        t = this.jj_consume_token(20);
                        this.id = t.image;
                        this.jj_consume_token(27);
                        t = this.jj_consume_token(20);
                        if (this.current instanceof DArray) {
                            ((DArray)this.current).appendDim(Integer.parseInt(t.image), this.id);
                        } else {
                            DArray a = this.factory.newDArray();
                            a.addVariable(this.current);
                            a.appendDim(Integer.parseInt(t.image), this.id);
                            this.current = a;
                        }
                        this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (NumberFormatException e) {
                this.error("\nThe index: " + t.image + " is not an integer value.\n" + "Index values must be integers.");
            }
            catch (ParseException e) {
                this.error("\nThere was a problem parsing the DDS:\nExpected an array subscript, but didn't find it\n\nThe offending line contains the characters: " + t.image + "\n\n" + "ParseException Message: \n" + e.getMessage() + "\n");
            }
        }
    }

    public final void Name() throws ParseException, DDSException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    Token t = this.jj_consume_token(20);
                    this.dds.setName(t.image);
                    break;
                }
                case 11: {
                    Token t = this.jj_consume_token(11);
                    this.dds.setName(t.image);
                    break;
                }
                case 12: {
                    Token t = this.jj_consume_token(12);
                    this.dds.setName(t.image);
                    break;
                }
                case 13: {
                    Token t = this.jj_consume_token(13);
                    this.dds.setName(t.image);
                    break;
                }
                case 14: {
                    Token t = this.jj_consume_token(14);
                    this.dds.setName(t.image);
                    break;
                }
                case 15: {
                    Token t = this.jj_consume_token(15);
                    this.dds.setName(t.image);
                    break;
                }
                case 16: {
                    Token t = this.jj_consume_token(16);
                    this.dds.setName(t.image);
                    break;
                }
                case 17: {
                    Token t = this.jj_consume_token(17);
                    this.dds.setName(t.image);
                    break;
                }
                case 18: {
                    Token t = this.jj_consume_token(18);
                    this.dds.setName(t.image);
                    break;
                }
                case 19: {
                    Token t = this.jj_consume_token(19);
                    this.dds.setName(t.image);
                    break;
                }
                case 9: {
                    Token t = this.jj_consume_token(9);
                    this.dds.setName(t.image);
                    break;
                }
                case 8: {
                    Token t = this.jj_consume_token(8);
                    this.dds.setName(t.image);
                    break;
                }
                case 10: {
                    Token t = this.jj_consume_token(10);
                    this.dds.setName(t.image);
                    break;
                }
                case 7: {
                    Token t = this.jj_consume_token(7);
                    this.dds.setName(t.image);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.error("Error parsing the dataset name.\nThe name may be missing or may contain an illegal character.");
        }
    }

    void error(String msg) throws ParseException, DDSException {
        throw new DDSException(0, msg);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public DDSParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DDSParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public DDSParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DDSParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public DDSParser(DDSParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(DDSParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[28];
        int i = 0;
        while (i < 28) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 22) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 28) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, DDSParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 1) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

