/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.Server.AbstractClause;
import dods.dap.Server.Operator;
import dods.dap.Server.SDODSException;
import dods.dap.Server.SubClause;
import dods.dap.Server.TopLevelClause;
import dods.dap.parser.ExprParserConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelOpClause
extends AbstractClause
implements TopLevelClause {
    protected boolean value;
    protected int operator;
    protected SubClause lhs;
    protected List rhs;

    protected RelOpClause(int operator, SubClause lhs, List rhs) throws SDODSException {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
        this.children = new ArrayList();
        this.children.add(lhs);
        this.children.addAll(rhs);
        this.constant = true;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            SubClause current = (SubClause)it.next();
            current.setParent(this);
            if (current.isConstant()) continue;
            this.constant = false;
        }
        if (this.constant) {
            this.evaluate();
        }
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean evaluate() throws SDODSException {
        if (this.constant && this.defined) {
            return this.value;
        }
        if (this.rhs.size() == 1) {
            this.value = Operator.op(this.operator, this.lhs.evaluate(), ((SubClause)this.rhs.get(0)).evaluate());
        } else {
            this.value = false;
            Iterator it = this.rhs.iterator();
            while (it.hasNext() && !this.value) {
                if (!Operator.op(this.operator, this.lhs.evaluate(), ((SubClause)it.next()).evaluate())) continue;
                this.value = true;
            }
        }
        this.defined = true;
        return this.value;
    }

    public SubClause getLHS() {
        return this.lhs;
    }

    public List getRHS() {
        return this.rhs;
    }

    public int getOperator() {
        return this.operator;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.lhs.toString());
        buf.append(ExprParserConstants.tokenImage[this.operator].substring(2, 3));
        if (this.rhs.size() == 1) {
            buf.append(this.rhs.get(0).toString());
        } else {
            buf.append("{");
            Iterator it = this.rhs.iterator();
            buf.append(it.next());
            while (it.hasNext()) {
                buf.append(",");
                buf.append(it.next().toString());
            }
            buf.append("}");
        }
        return buf.toString();
    }
}

