/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.BytePrimitiveVector;
import dods.dap.ClientIO;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class DByte
extends BaseType
implements ClientIO {
    private byte val;

    public DByte() {
    }

    public DByte(String n) {
        super(n);
    }

    public final byte getValue() {
        return this.val;
    }

    public final void setValue(byte newVal) {
        this.val = newVal;
    }

    public PrimitiveVector newPrimitiveVector() {
        return new BytePrimitiveVector(this);
    }

    public String getTypeName() {
        return "Byte";
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.println(" = " + (this.val & 0xFF) + ";");
        } else {
            os.print(this.val & 0xFF);
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException {
        int i = 0;
        while (i < 3) {
            byte unused = source.readByte();
            ++i;
        }
        this.val = source.readByte();
        if (statusUI != null) {
            statusUI.incrementByteCount(4);
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        int i = 0;
        while (i < 3) {
            sink.writeByte(0);
            ++i;
        }
        sink.writeByte(this.val);
    }
}

