/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.NVPair;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class SimpleAuthPopup
implements AuthorizationPrompter {
    private static BasicAuthBox inp = null;

    SimpleAuthPopup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NVPair getUsernamePassword(AuthorizationInfo challenge, boolean forProxy) {
        String line3;
        String line2;
        String line1;
        if (challenge.getScheme().equalsIgnoreCase("SOCKS5")) {
            line1 = "Enter username and password for SOCKS server on host";
            line2 = challenge.getHost();
            line3 = "Authentication Method: username/password";
        } else {
            line1 = "Enter username and password for realm `" + challenge.getRealm() + "'";
            line2 = "on host " + challenge.getHost() + ":" + challenge.getPort();
            line3 = "Authentication Scheme: " + challenge.getScheme();
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (inp == null) {
                inp = new BasicAuthBox();
            }
        }
        return inp.getInput(line1, line2, line3, challenge.getScheme());
    }

    private static class BasicAuthBox
    extends Frame {
        private static final String title = "Authorization Request";
        private Dimension screen = this.getToolkit().getScreenSize();
        private Label line1;
        private Label line2;
        private Label line3;
        private TextField user;
        private TextField pass;
        private int done;
        private static final int OK = 1;
        private static final int CANCEL = 0;

        BasicAuthBox() {
            super(title);
            this.addNotify();
            this.addWindowListener(new Close());
            this.setLayout(new BorderLayout());
            Panel p = new Panel(new GridLayout(3, 1));
            this.line1 = new Label();
            p.add(this.line1);
            this.line2 = new Label();
            p.add(this.line2);
            this.line3 = new Label();
            p.add(this.line3);
            this.add("North", p);
            p = new Panel(new GridLayout(2, 1));
            p.add(new Label("Username:"));
            p.add(new Label("Password:"));
            this.add("West", p);
            p = new Panel(new GridLayout(2, 1));
            this.user = new TextField(30);
            p.add(this.user);
            this.pass = new TextField(30);
            p.add(this.pass);
            this.pass.addActionListener(new Ok());
            this.pass.setEchoChar('*');
            this.add("East", p);
            GridBagLayout gb = new GridBagLayout();
            p = new Panel(gb);
            GridBagConstraints constr = new GridBagConstraints();
            Panel pp = new Panel();
            p.add(pp);
            constr.gridwidth = 0;
            gb.setConstraints(pp, constr);
            constr.gridwidth = 1;
            constr.weightx = 1.0;
            Button b = new Button("  OK  ");
            p.add(b);
            b.addActionListener(new Ok());
            constr.weightx = 1.0;
            gb.setConstraints(b, constr);
            b = new Button("Clear");
            p.add(b);
            b.addActionListener(new Clear());
            constr.weightx = 2.0;
            gb.setConstraints(b, constr);
            b = new Button("Cancel");
            p.add(b);
            b.addActionListener(new Cancel());
            constr.weightx = 1.0;
            gb.setConstraints(b, constr);
            this.add("South", p);
            this.pack();
        }

        synchronized NVPair getInput(String l1, String l2, String l3, String scheme) {
            this.line1.setText(l1);
            this.line2.setText(l2);
            this.line3.setText(l3);
            this.line1.invalidate();
            this.line2.invalidate();
            this.line3.invalidate();
            this.setResizable(true);
            this.pack();
            this.setResizable(false);
            this.setLocation((this.screen.width - this.getPreferredSize().width) / 2, (int)((double)((this.screen.height - this.getPreferredSize().height) / 2) * 0.7));
            boolean user_focus = true;
            if (scheme.equalsIgnoreCase("NTLM")) {
                try {
                    this.user.setText(System.getProperty("user.name", ""));
                    user_focus = false;
                }
                catch (SecurityException se) {
                    // empty catch block
                }
            }
            this.setVisible(true);
            if (user_focus) {
                this.user.requestFocus();
            } else {
                this.pass.requestFocus();
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.setVisible(false);
            NVPair result = new NVPair(this.user.getText(), this.pass.getText());
            this.user.setText("");
            this.pass.setText("");
            if (this.done == 0) {
                return null;
            }
            return result;
        }

        private class Cancel
        implements ActionListener {
            private Cancel() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                BasicAuthBox.this.done = 0;
                BasicAuthBox basicAuthBox = BasicAuthBox.this;
                synchronized (basicAuthBox) {
                    BasicAuthBox.this.notifyAll();
                }
            }
        }

        private class Clear
        implements ActionListener {
            private Clear() {
            }

            public void actionPerformed(ActionEvent ae) {
                BasicAuthBox.this.user.setText("");
                BasicAuthBox.this.pass.setText("");
                BasicAuthBox.this.user.requestFocus();
            }
        }

        private class Close
        extends WindowAdapter {
            private Close() {
            }

            public void windowClosing(WindowEvent we) {
                new Cancel().actionPerformed(null);
            }
        }

        private class Ok
        implements ActionListener {
            private Ok() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                BasicAuthBox.this.done = 1;
                BasicAuthBox basicAuthBox = BasicAuthBox.this;
                synchronized (basicAuthBox) {
                    BasicAuthBox.this.notifyAll();
                }
            }
        }
    }
}

