/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrFrameTiming {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrFrameTiming_size = new int[]{56, 56, 56, 56, 56, 56, 56, 56};
    private static final int[] DeltaSeconds_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] Pad_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] ThisFrameSeconds_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] TimewarpPointSeconds_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] NextFrameSeconds_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] ScanoutMidpointSeconds_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] EyeScanoutSeconds_offset = new int[]{40, 40, 40, 40, 40, 40, 40, 40};
    private static final int[] EyeScanoutSeconds_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16};

    public static int size() {
        return ovrFrameTiming_size[mdIdx];
    }

    public static ovrFrameTiming create() {
        return ovrFrameTiming.create(Buffers.newDirectByteBuffer(ovrFrameTiming.size()));
    }

    public static ovrFrameTiming create(ByteBuffer byteBuffer) {
        return new ovrFrameTiming(byteBuffer);
    }

    ovrFrameTiming(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrFrameTiming.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public ovrFrameTiming setDeltaSeconds(float f) {
        this.accessor.setFloatAt(DeltaSeconds_offset[mdIdx], f);
        return this;
    }

    public float getDeltaSeconds() {
        return this.accessor.getFloatAt(DeltaSeconds_offset[mdIdx]);
    }

    public ovrFrameTiming setPad(float f) {
        this.accessor.setFloatAt(Pad_offset[mdIdx], f);
        return this;
    }

    public float getPad() {
        return this.accessor.getFloatAt(Pad_offset[mdIdx]);
    }

    public ovrFrameTiming setThisFrameSeconds(double d) {
        this.accessor.setDoubleAt(ThisFrameSeconds_offset[mdIdx], d);
        return this;
    }

    public double getThisFrameSeconds() {
        return this.accessor.getDoubleAt(ThisFrameSeconds_offset[mdIdx]);
    }

    public ovrFrameTiming setTimewarpPointSeconds(double d) {
        this.accessor.setDoubleAt(TimewarpPointSeconds_offset[mdIdx], d);
        return this;
    }

    public double getTimewarpPointSeconds() {
        return this.accessor.getDoubleAt(TimewarpPointSeconds_offset[mdIdx]);
    }

    public ovrFrameTiming setNextFrameSeconds(double d) {
        this.accessor.setDoubleAt(NextFrameSeconds_offset[mdIdx], d);
        return this;
    }

    public double getNextFrameSeconds() {
        return this.accessor.getDoubleAt(NextFrameSeconds_offset[mdIdx]);
    }

    public ovrFrameTiming setScanoutMidpointSeconds(double d) {
        this.accessor.setDoubleAt(ScanoutMidpointSeconds_offset[mdIdx], d);
        return this;
    }

    public double getScanoutMidpointSeconds() {
        return this.accessor.getDoubleAt(ScanoutMidpointSeconds_offset[mdIdx]);
    }

    public static final int getEyeScanoutSecondsArrayLength() {
        return 2;
    }

    public ovrFrameTiming setEyeScanoutSeconds(int n, double[] dArray) {
        if (n + dArray.length > 2) {
            throw new IndexOutOfBoundsException("offset " + n + " + val.length " + dArray.length + " > array-length " + 2);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (16 > EyeScanoutSeconds_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal 16 > size " + EyeScanoutSeconds_size[mdIdx] + ", elemSize " + 8 + " * " + 2);
        }
        int n2 = EyeScanoutSeconds_offset[mdIdx];
        int n3 = n2 + 16;
        if (n3 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n3 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n2 + ", elemSize " + 8 + " * " + 2);
        }
        this.accessor.setDoublesAt(n2 += 8 * n, dArray);
        return this;
    }

    public DoubleBuffer getEyeScanoutSeconds() {
        return this.accessor.slice(EyeScanoutSeconds_offset[mdIdx], 16).asDoubleBuffer();
    }

    public double[] getEyeScanoutSeconds(int n, double[] dArray) {
        if (n + dArray.length > 2) {
            throw new IndexOutOfBoundsException("offset " + n + " + result.length " + dArray.length + " > array-length " + 2);
        }
        return this.accessor.getDoublesAt(EyeScanoutSeconds_offset[mdIdx] + 8 * n, dArray);
    }
}

