/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.opengl.GLContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.List;

public class MiscUtils {
    public static boolean atob(String string, boolean bl) {
        try {
            return Boolean.parseBoolean(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bl;
        }
    }

    public static int atoi(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n;
        }
    }

    public static long atol(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return l;
        }
    }

    public static float atof(String string, float f) {
        try {
            return Float.parseFloat(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return f;
        }
    }

    public static String toHexString(byte by) {
        return "0x" + Integer.toHexString(by & 0xFF);
    }

    public static String toHexString(short s) {
        return "0x" + Integer.toHexString(s & 0xFFFF);
    }

    public static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    public static void assertFloatBufferEquals(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, float f) {
        String string2;
        if (null == floatBuffer && null == floatBuffer2) {
            return;
        }
        String string3 = string2 = null != string ? string + " " : "";
        if (null == floatBuffer) {
            throw new AssertionError((Object)(string2 + "; Expected is null, but actual not: " + floatBuffer2));
        }
        if (null == floatBuffer2) {
            throw new AssertionError((Object)(string2 + "; Actual is null, but expected not: " + floatBuffer));
        }
        if (floatBuffer.remaining() != floatBuffer2.remaining()) {
            throw new AssertionError((Object)(string2 + "; Expected has " + floatBuffer.remaining() + " remaining, but actual has " + floatBuffer2.remaining()));
        }
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        for (int i = 0; i < floatBuffer.remaining(); ++i) {
            float f2;
            float f3 = floatBuffer.get(n + i);
            float f4 = Math.abs(f3 - (f2 = floatBuffer2.get(n2 + i)));
            if (f4 > f) {
                throw new AssertionError((Object)(string2 + "; Expected @ [" + n + "+" + i + "] has " + f3 + ", but actual @ [" + n2 + "+" + i + "] has " + f2 + ", it's delta " + f4 + " > " + f));
            }
        }
    }

    public static void assertFloatBufferNotEqual(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, float f) {
        if (null == floatBuffer || null == floatBuffer2) {
            return;
        }
        if (floatBuffer.remaining() != floatBuffer2.remaining()) {
            return;
        }
        String string2 = null != string ? string + " " : "";
        int n = floatBuffer.position();
        int n2 = floatBuffer2.position();
        for (int i = 0; i < floatBuffer.remaining(); ++i) {
            float f2;
            float f3 = floatBuffer.get(n + i);
            float f4 = Math.abs(f3 - (f2 = floatBuffer2.get(n2 + i)));
            if (!(f4 > f)) continue;
            return;
        }
        throw new AssertionError((Object)(string2 + "; Expected and actual are equal."));
    }

    public static boolean setFieldIfExists(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            if (object2 instanceof Boolean || field.getType().isInstance(object2)) {
                field.set(object, object2);
                return true;
            }
            System.out.println(object.getClass() + " '" + string + "' field not assignable with " + object2.getClass() + ", it's a: " + field.getType());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return false;
    }

    public static void dumpSharedGLContext(String string, GLContext gLContext) {
        int n = 0;
        int n2 = 0;
        GLContext gLContext2 = gLContext.getSharedMaster();
        int n3 = null != gLContext2 ? gLContext2.hashCode() : 0;
        System.err.println(string + ": hash 0x" + Integer.toHexString(gLContext.hashCode()) + ", \t(isShared " + gLContext.isShared() + ", created " + gLContext.isCreated() + ", master 0x" + Integer.toHexString(n3) + ")");
        List<GLContext> list = gLContext.getCreatedShares();
        for (GLContext gLContext3 : list) {
            System.err.println("  Created   Ctx #" + n++ + ": hash 0x" + Integer.toHexString(gLContext3.hashCode()) + ", \t(created " + gLContext3.isCreated() + ")");
        }
        list = gLContext.getDestroyedShares();
        for (GLContext gLContext3 : list) {
            System.err.println("  Destroyed Ctx #" + n2++ + ": hash 0x" + Integer.toHexString(gLContext3.hashCode()) + ", \t(created " + gLContext3.isCreated() + ")");
        }
        System.err.println("\t Total created " + n + " + destroyed " + n2 + " = " + (n + n2));
        System.err.println();
    }

    public static class StreamDump
    extends InterruptSource.Thread {
        final InputStream is;
        final StringBuilder outString;
        final OutputStream outStream;
        final String prefix;
        final Object sync;
        volatile boolean eos = false;

        public StreamDump(OutputStream outputStream, String string, InputStream inputStream, Object object) {
            this.is = inputStream;
            this.outString = null;
            this.outStream = outputStream;
            this.prefix = string;
            this.sync = object;
        }

        public StreamDump(StringBuilder stringBuilder, String string, InputStream inputStream, Object object) {
            this.is = inputStream;
            this.outString = stringBuilder;
            this.outStream = null;
            this.prefix = string;
            this.sync = object;
        }

        public StreamDump(StringBuilder stringBuilder, InputStream inputStream, Object object) {
            this.is = inputStream;
            this.outString = stringBuilder;
            this.outStream = null;
            this.prefix = null;
            this.sync = object;
        }

        public final boolean eos() {
            return this.eos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (null != this.outString) {
                            this.outString.append(string).append(Platform.getNewline());
                            continue;
                        }
                        if (null == this.outStream) continue;
                        if (null != this.prefix) {
                            this.outStream.write(this.prefix.getBytes());
                        }
                        this.outStream.write(string.getBytes());
                        this.outStream.write(Platform.getNewline().getBytes());
                        this.outStream.flush();
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Caught " + iOException.getClass().getName() + ": " + iOException.getMessage());
                    iOException.printStackTrace();
                }
                finally {
                    this.eos = true;
                    this.sync.notifyAll();
                }
            }
        }
    }
}

