/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.opengl.test.junit.util.InputEventCountAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

public class AWTMouseAdapter
extends MouseAdapter
implements InputEventCountAdapter {
    String prefix;
    int mouseClicked;
    int consumed;
    boolean pressed;
    List<EventObject> queue = new ArrayList<EventObject>();
    boolean verbose = true;

    public AWTMouseAdapter(String string) {
        this.prefix = string;
        this.reset();
    }

    @Override
    public synchronized void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Override
    public synchronized boolean isPressed() {
        return this.pressed;
    }

    @Override
    public synchronized int getCount() {
        return this.mouseClicked;
    }

    @Override
    public synchronized int getConsumedCount() {
        return this.consumed;
    }

    @Override
    public synchronized List<EventObject> copyQueue() {
        return new ArrayList<EventObject>(this.queue);
    }

    @Override
    public synchronized int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public synchronized void reset() {
        this.mouseClicked = 0;
        this.consumed = 0;
        this.pressed = false;
        this.queue.clear();
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseEvent) {
        this.pressed = true;
        this.queue.add(mouseEvent);
        if (this.verbose) {
            System.err.println("MOUSE AWT PRESSED [" + this.pressed + "]: " + this.prefix + ", " + mouseEvent);
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
        this.queue.add(mouseEvent);
        if (this.verbose) {
            System.err.println("MOUSE AWT RELEASED [" + this.pressed + "]: " + this.prefix + ", " + mouseEvent);
        }
    }

    @Override
    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        this.mouseClicked += mouseEvent.getClickCount();
        if (mouseEvent.isConsumed()) {
            ++this.consumed;
        }
        this.queue.add(mouseEvent);
        if (this.verbose) {
            System.err.println("MOUSE AWT CLICKED [" + this.mouseClicked + "]: " + this.prefix + ", " + mouseEvent);
        }
    }

    public String toString() {
        return this.prefix + "[pressed " + this.pressed + ", clicked " + this.mouseClicked + ", consumed " + this.consumed + "]";
    }
}

