/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.common.util.InterruptSource;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.newt.parenting.GLRunnableDummy;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParenting01cSwingAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long waitReparent;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @Test
    public void test01CreateVisibleDestroy1() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        Assert.assertNotNull(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        gLWindow.setTitle("testWindowParenting01CreateVisibleDestroy");
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01cSwingAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        GLDisturbanceAction gLDisturbanceAction = new GLDisturbanceAction(gLWindow);
        new InterruptSource.Thread(null, gLDisturbanceAction).start();
        gLDisturbanceAction.waitUntilRunning();
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        Assert.assertNotNull(newtCanvasAWT);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        final Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)new Button("north"), "North");
        container.add((Component)new Button("south"), "South");
        container.add((Component)new Button("east"), "East");
        container.add((Component)new Button("west"), "West");
        container.add((Component)newtCanvasAWT, "Center");
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new Button("north"), "North");
        jPanel.add((Component)new Button("south"), "South");
        jPanel.add((Component)new Button("east"), "East");
        jPanel.add((Component)new Button("west"), "West");
        jPanel.add((Component)container, "Center");
        final JFrame jFrame = new JFrame("Swing Parent JFrame");
        jFrame.setDefaultCloseOperation(0);
        jFrame.setContentPane(jPanel);
        System.err.println("Demos: 1 - Visible");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setSize(width, height);
                jFrame.validate();
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(gLWindow, true));
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        System.err.println("Demos: 2 - StopAnimator");
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.err.println("Demos: 3 - !Visible");
                jFrame.setVisible(false);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(gLWindow, false));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.err.println("Demos: 4 - Visible");
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(gLWindow, true));
        boolean bl = gLWindow.getChosenCapabilities().isOnscreen();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.err.println("Demos: 5 - X Container");
                jPanel.remove(container);
                jFrame.validate();
            }
        });
        if (bl) {
            Assert.assertEquals(true, gLWindow.isNativeValid());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.err.println("Demos: 6 - X Frame");
                jFrame.dispose();
            }
        });
        if (bl) {
            Assert.assertEquals(true, gLWindow.isNativeValid());
        }
        System.err.println("Demos: 7 - X GLWindow");
        gLWindow.destroy();
        Assert.assertEquals(false, gLWindow.isNativeValid());
        System.err.println("Demos: 8 - X DisturbanceThread");
        gLDisturbanceAction.stopAndWaitUntilDone();
    }

    @Test
    public void test02AWTWinHopFrame2Frame() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        Assert.assertNotNull(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        gLWindow.setTitle("testWindowParenting01CreateVisibleDestroy");
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01cSwingAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        GLDisturbanceAction gLDisturbanceAction = new GLDisturbanceAction(gLWindow);
        new InterruptSource.Thread(null, gLDisturbanceAction).start();
        gLDisturbanceAction.waitUntilRunning();
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        Assert.assertNotNull(newtCanvasAWT);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        final Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)new Button("north"), "North");
        container.add((Component)new Button("south"), "South");
        container.add((Component)new Button("east"), "East");
        container.add((Component)new Button("west"), "West");
        container.add((Component)newtCanvasAWT, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new Button("north"), "North");
        jPanel.add((Component)new Button("south"), "South");
        jPanel.add((Component)new Button("east"), "East");
        jPanel.add((Component)new Button("west"), "West");
        jPanel.add((Component)container, "Center");
        final JFrame jFrame = new JFrame("Swing Parent JFrame");
        jFrame.setDefaultCloseOperation(0);
        jFrame.setContentPane(jPanel);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setLocation(0, 0);
                jFrame.setSize(width, height);
                jFrame.setVisible(true);
            }
        });
        final JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new Button("north"), "North");
        jPanel2.add((Component)new Button("south"), "South");
        jPanel2.add((Component)new Button("east"), "East");
        jPanel2.add((Component)new Button("west"), "West");
        final JFrame jFrame2 = new JFrame("Swing Parent JFrame");
        jFrame2.setDefaultCloseOperation(0);
        jFrame2.setContentPane(jPanel2);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame2.setLocation(640, 480);
                jFrame2.setSize(width, height);
                jFrame2.setVisible(true);
            }
        });
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        boolean bl = gLWindow.getChosenCapabilities().isOnscreen();
        int n = 0;
        while (animator.isAnimating() && animator.getTotalFPSDuration() < 3L * durationPerTest) {
            Thread.sleep(durationPerTest);
            switch (n) {
                case 0: {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            container.remove(newtCanvasAWT);
                            jPanel2.add((Component)newtCanvasAWT, "Center");
                            jFrame.validate();
                            jFrame2.validate();
                        }
                    });
                    break;
                }
                case 1: {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            jPanel2.remove(newtCanvasAWT);
                            container.add((Component)newtCanvasAWT, "Center");
                            jFrame.validate();
                            jFrame2.validate();
                        }
                    });
                }
            }
            ++n;
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.err.println("Demos: 2 - !visible");
                jFrame.setVisible(false);
                System.err.println("Demos: 3 - !visible");
                jFrame2.setVisible(false);
            }
        });
        Assert.assertEquals(true, gLWindow.isNativeValid());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                System.err.println("Demos: 4 - X frame");
                jFrame.dispose();
                System.err.println("Demos: 5 - X frame");
                jFrame2.dispose();
            }
        });
        if (bl) {
            Assert.assertEquals(true, gLWindow.isNativeValid());
        }
        System.err.println("Demos: 6 - X GLWindow");
        gLWindow.destroy();
        Assert.assertEquals(false, gLWindow.isNativeValid());
        System.err.println("Demos: 7 - X DisturbanceThread");
        gLDisturbanceAction.stopAndWaitUntilDone();
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        Window window = gLWindow.getDelegatedWindow();
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", window)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = TestParenting01cSwingAWT.atoi(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitReparent = TestParenting01cSwingAWT.atoi(stringArray[++i]);
        }
        System.err.println("durationPerTest " + durationPerTest);
        System.err.println("waitReparent " + waitReparent);
        JUnitCore.main(TestParenting01cSwingAWT.class.getName());
    }

    static {
        durationPerTest = 800L;
        waitReparent = 0L;
    }

    static class GLDisturbanceAction
    implements Runnable {
        public boolean isRunning = false;
        private volatile boolean shallStop = false;
        private final GLAutoDrawable glad;
        private final GLRunnable glRunnable;

        public GLDisturbanceAction(GLAutoDrawable gLAutoDrawable) {
            this.glad = gLAutoDrawable;
            this.glRunnable = new GLRunnableDummy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilRunning() {
            GLDisturbanceAction gLDisturbanceAction = this;
            synchronized (gLDisturbanceAction) {
                while (!this.isRunning) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAndWaitUntilDone() {
            this.shallStop = true;
            GLDisturbanceAction gLDisturbanceAction = this;
            synchronized (gLDisturbanceAction) {
                while (this.isRunning) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GLDisturbanceAction gLDisturbanceAction = this;
            synchronized (gLDisturbanceAction) {
                this.isRunning = true;
                this.notifyAll();
                System.err.println("$");
            }
            while (!this.shallStop) {
                try {
                    this.glad.invoke(true, this.glRunnable);
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {}
            }
            gLDisturbanceAction = this;
            synchronized (gLDisturbanceAction) {
                this.isRunning = false;
                this.notifyAll();
            }
        }
    }
}

