/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParenting01aAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long waitReparent;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() throws InterruptedException {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @Test
    public void test01WindowParenting01CreateVisibleDestroy1() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        Assert.assertNotNull(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        gLWindow.setTitle("testWindowParenting01CreateVisibleDestroy");
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01aAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        Assert.assertNotNull(newtCanvasAWT);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        final Frame frame = new Frame("AWT Parent Frame");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Button("North"), "North");
        frame.add((Component)new Button("South"), "South");
        frame.add((Component)new Button("East"), "East");
        frame.add((Component)new Button("West"), "West");
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)new Button("north"), "North");
        container.add((Component)new Button("south"), "South");
        container.add((Component)new Button("east"), "East");
        container.add((Component)new Button("west"), "West");
        container.add((Component)newtCanvasAWT, "Center");
        frame.add((Component)container, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLWindow, true));
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals(true, gLWindow.isNativeValid());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, gLWindow.isNativeValid());
        boolean bl = gLWindow.getChosenCapabilities().isOnscreen();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(newtCanvasAWT);
            }
        });
        if (bl) {
            Assert.assertEquals(true, gLWindow.isNativeValid());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        if (bl) {
            Assert.assertEquals(true, gLWindow.isNativeValid());
        }
        gLWindow.destroy();
        Assert.assertEquals(false, gLWindow.isNativeValid());
    }

    @Test
    public void test02WindowParenting02CreateVisibleDestroy2Defered() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        Assert.assertNotNull(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01aAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        Assert.assertNotNull(newtCanvasAWT);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertNull(gLWindow.getParent());
        final Frame frame = new Frame("AWT Parent Frame");
        Assert.assertNotNull(frame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.add(newtCanvasAWT);
                frame.validate();
            }
        });
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        gLWindow.destroy();
    }

    @Test
    public void test03WindowParenting02CreateVisibleDestroy3Odd() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01aAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        final Frame frame = new Frame("AWT Parent Frame");
        Assert.assertNotNull(frame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.add(newtCanvasAWT);
                frame.validate();
            }
        });
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        Assert.assertEquals(true, animator.isStarted());
        Assert.assertEquals(true, animator.isAnimating());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        Assert.assertEquals(true, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        gLWindow.destroy();
    }

    @Test
    public void test04WindowParenting03ReparentNewtWin2Top() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01aAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        final Frame frame = new Frame("AWT Parent Frame");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setLocation(640, 480);
                frame.setVisible(true);
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.add(newtCanvasAWT);
                frame.validate();
            }
        });
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        int n = 0;
        while (animator.isAnimating() && animator.getTotalFPSDuration() < 3L * durationPerTest) {
            Thread.sleep(durationPerTest);
            switch (n) {
                case 0: {
                    System.err.println("Reparent CHILD -> TOP: " + (Object)((Object)gLWindow.reparentWindow(null, -1, -1, 0)));
                    Assert.assertEquals(true, gLWindow.isNativeValid());
                    Assert.assertNull(gLWindow.getParent());
                    break;
                }
                case 1: {
                    System.err.println("Reparent TOP -> CHILD: " + (Object)((Object)gLWindow.reparentWindow(newtCanvasAWT.getNativeWindow(), -1, -1, 0)));
                    Assert.assertEquals(true, gLWindow.isNativeValid());
                    Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
                }
            }
            ++n;
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        gLWindow.destroy();
    }

    @Test
    public void test05WindowParenting04ReparentNewtWin2TopLayouted() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01aAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        final Frame frame = new Frame("AWT Parent Frame");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Button("North"), "North");
        frame.add((Component)new Button("South"), "South");
        frame.add((Component)new Button("East"), "East");
        frame.add((Component)new Button("West"), "West");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setLocation(640, 480);
                frame.setVisible(true);
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.add((Component)newtCanvasAWT, "Center");
                frame.validate();
            }
        });
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        int n = 0;
        while (animator.isAnimating() && animator.getTotalFPSDuration() < 3L * durationPerTest) {
            Thread.sleep(durationPerTest);
            switch (n) {
                case 0: {
                    System.err.println("Reparent CHILD -> TOP: " + (Object)((Object)gLWindow.reparentWindow(null, -1, -1, 0)));
                    Assert.assertEquals(true, gLWindow.isNativeValid());
                    Assert.assertNull(gLWindow.getParent());
                    break;
                }
                case 1: {
                    System.err.println("Reparent TOP -> CHILD: " + (Object)((Object)gLWindow.reparentWindow(newtCanvasAWT.getNativeWindow(), -1, -1, 0)));
                    Assert.assertEquals(true, gLWindow.isNativeValid());
                    Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
                }
            }
            ++n;
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        gLWindow.destroy();
    }

    @Test
    public void test06WindowParenting05ReparentAWTWinHopFrame2Frame() throws InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        gLWindow.setUndecorated(true);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        TestParenting01aAWT.setDemoFields(redSquareES2, gLWindow, false);
        gLWindow.addGLEventListener(redSquareES2);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        final Frame frame = new Frame("AWT Parent Frame");
        frame.setLayout(new BorderLayout());
        frame.add((Component)new Button("North"), "North");
        frame.add((Component)new Button("South"), "South");
        frame.add((Component)new Button("East"), "East");
        frame.add((Component)new Button("West"), "West");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setLocation(0, 0);
                frame.setVisible(true);
            }
        });
        final Frame frame2 = new Frame("AWT Parent Frame");
        frame2.setLayout(new BorderLayout());
        frame2.add((Component)new Button("North"), "North");
        frame2.add((Component)new Button("South"), "South");
        frame2.add((Component)new Button("East"), "East");
        frame2.add((Component)new Button("West"), "West");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setSize(width, height);
                frame2.setLocation(640, 480);
                frame2.setVisible(true);
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.add((Component)newtCanvasAWT, "Center");
                frame.validate();
            }
        });
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), gLWindow.getParent());
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        int n = 0;
        while (animator.isAnimating() && animator.getTotalFPSDuration() < 3L * durationPerTest) {
            Thread.sleep(durationPerTest);
            switch (n) {
                case 0: {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            frame.remove(newtCanvasAWT);
                            frame2.add((Component)newtCanvasAWT, "Center");
                            frame.validate();
                            frame2.validate();
                        }
                    });
                    break;
                }
                case 1: {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            frame2.remove(newtCanvasAWT);
                            frame.add((Component)newtCanvasAWT, "Center");
                            frame2.validate();
                            frame.validate();
                        }
                    });
                }
            }
            ++n;
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
                frame2.dispose();
            }
        });
        gLWindow.destroy();
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", gLWindow.getDelegatedWindow())) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = TestParenting01aAWT.atoi(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitReparent = TestParenting01aAWT.atoi(stringArray[++i]);
        }
        String string = TestParenting01aAWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 800L;
        waitReparent = 0L;
    }
}

