/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode02bNEWT
extends UITestCase {
    static GLProfile glp;
    static int waitTimeShort;
    static int waitTimeLong;

    @BeforeClass
    public static void initClass() {
        TestScreenMode02bNEWT.setResetXRandRIfX11AfterClass();
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) {
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle(string);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener(new GearsES2(1));
        Assert.assertNotNull(gLWindow);
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue(AWTRobotUtil.waitForRealized(window, false));
        }
    }

    @Test
    public void testScreenModeChange01_PreFull() throws InterruptedException {
        this.testScreenModeChangeImpl(true);
    }

    @Test
    public void testScreenModeChange02_PostFull() throws InterruptedException {
        this.testScreenModeChangeImpl(false);
    }

    void testScreenModeChangeImpl(boolean bl) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        screen.createNative();
        int n = screen.getWidth();
        int n2 = screen.getHeight();
        GLWindow gLWindow = TestScreenMode02bNEWT.createWindow(screen, gLCapabilities, "win0", 0, 0, 640, 480);
        if (bl) {
            gLWindow.setVisible(true);
            gLWindow.setFullscreen(true);
        }
        gLWindow.setUndecorated(true);
        Assert.assertNotNull(gLWindow);
        List<MonitorMode> list = screen.getMonitorModes();
        Assert.assertTrue(list.size() > 0);
        if (list.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (all), sorry");
            TestScreenMode02bNEWT.destroyWindow(gLWindow);
            return;
        }
        MonitorDevice monitorDevice = gLWindow.getMainMonitor();
        List<MonitorMode> list2 = monitorDevice.getSupportedModes();
        Assert.assertTrue(list2.size() > 0);
        if (list2.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (monitor), sorry");
            TestScreenMode02bNEWT.destroyWindow(gLWindow);
            return;
        }
        Assert.assertTrue(list.containsAll(list2));
        Animator animator = new Animator(gLWindow);
        animator.start();
        MonitorMode monitorMode = monitorDevice.queryCurrentMode();
        Assert.assertNotNull(monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull(monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals(monitorMode, monitorMode2);
        list2 = MonitorModeUtil.filterByFlags(list2, 0);
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.filterByRotation(list2, 90);
        if (null == list2 || Platform.getOSType() == Platform.OSType.MACOS) {
            System.err.println("Your platform has no rotation support, sorry");
            animator.stop();
            TestScreenMode02bNEWT.destroyWindow(gLWindow);
            return;
        }
        list2 = MonitorModeUtil.filterByResolution(list2, new Dimension(n, n2));
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.filterByRate(list2, monitorMode2.getRefreshRate());
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        list2 = MonitorModeUtil.getHighestAvailableBpp(list2);
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        MonitorMode monitorMode3 = list2.get(0);
        System.err.println("[0] set current: " + monitorMode3);
        boolean bl2 = monitorDevice.setCurrentMode(monitorMode3);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[0] has current: " + monitorMode + ", changeOK " + bl2);
        if (!bl2) {
            System.err.println("ERROR: Full MonitorMode w/ rotation failure - Expected on some platforms (NV driver) - Tolerated for now.");
            animator.stop();
            TestScreenMode02bNEWT.destroyWindow(gLWindow);
            return;
        }
        Assert.assertTrue(monitorDevice.isModeChangedByUs());
        Assert.assertEquals(monitorMode3, monitorMode);
        Assert.assertNotSame(monitorMode2, monitorMode);
        Assert.assertEquals(monitorMode, monitorDevice.queryCurrentMode());
        Assert.assertTrue(bl2);
        if (!bl) {
            gLWindow.setFullscreen(true);
            gLWindow.setVisible(true);
        }
        Thread.sleep(waitTimeLong);
        if (!bl) {
            gLWindow.setFullscreen(false);
        }
        System.err.println("[1] set orig: " + monitorMode2);
        boolean bl3 = monitorDevice.setCurrentMode(monitorMode2);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[1] has orig?: " + monitorMode + ", changeOK " + bl3);
        Assert.assertFalse(monitorDevice.isModeChangedByUs());
        Assert.assertEquals(monitorMode2, monitorMode);
        Assert.assertTrue(bl3);
        Thread.sleep(waitTimeShort);
        if (bl) {
            gLWindow.setFullscreen(false);
        }
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        animator.stop();
        TestScreenMode02bNEWT.destroyWindow(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertTrue(AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(false, display.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestScreenMode02bNEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        waitTimeShort = 2000;
        waitTimeLong = 8000;
    }
}

