/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode02aNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static int waitTimeShort;
    static int waitTimeLong;

    @BeforeClass
    public static void initClass() {
        TestScreenMode02aNEWT.setResetXRandRIfX11AfterClass();
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, int n, int n2, boolean bl, boolean bl2) {
        Assert.assertNotNull(gLCapabilities);
        gLCapabilities.setOnscreen(bl);
        GLWindow gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(n, n2);
        gLWindow.addGLEventListener(new GearsES2(1));
        Assert.assertNotNull(gLWindow);
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue(AWTRobotUtil.waitForRealized(window, false));
        }
    }

    @Test
    public void testScreenRotationChange01_PreWin() throws InterruptedException {
        this.testScreenRotationChangeImpl(true, true, false);
    }

    @Test
    public void testScreenRotationChange02_PreFull() throws InterruptedException {
        this.testScreenRotationChangeImpl(true, true, true);
    }

    @Test
    public void testScreenRotationChange11_PostWin() throws InterruptedException {
        this.testScreenRotationChangeImpl(true, false, false);
    }

    @Test
    public void testScreenRotationChange12_PostFull() throws InterruptedException {
        this.testScreenRotationChangeImpl(true, false, true);
    }

    void testScreenRotationChangeImpl(boolean bl, boolean bl2, boolean bl3) throws InterruptedException {
        MonitorMode monitorMode;
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        GLWindow gLWindow = TestScreenMode02aNEWT.createWindow(screen, gLCapabilities, width, height, true, false);
        Assert.assertNotNull(gLWindow);
        if (bl2) {
            gLWindow.setVisible(true);
            if (bl3) {
                gLWindow.setFullscreen(true);
            }
        } else {
            screen.createNative();
            Assert.assertEquals(true, display.isNativeValid());
            Assert.assertEquals(true, screen.isNativeValid());
        }
        Animator animator = new Animator(gLWindow);
        animator.start();
        MonitorDevice monitorDevice = gLWindow.getMainMonitor();
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull(monitorMode2);
        if (bl) {
            Thread.sleep(waitTimeShort);
            List<MonitorMode> list = monitorDevice.getSupportedModes();
            if (list.size() == 1) {
                System.err.println("Your platform has no ScreenMode change support, sorry");
                animator.stop();
                TestScreenMode02aNEWT.destroyWindow(gLWindow);
                return;
            }
            Assert.assertTrue(list.size() > 0);
            monitorMode = monitorDevice.getCurrentMode();
            Assert.assertNotNull(monitorMode);
            System.err.println("[0] orig   : " + monitorMode2);
            System.err.println("[0] current: " + monitorMode);
            Assert.assertEquals(monitorMode, monitorMode2);
            list = MonitorModeUtil.filterByFlags(list, 0);
            Assert.assertNotNull(list);
            Assert.assertTrue(list.size() > 0);
            list = MonitorModeUtil.filterByRotation(list, 90);
            if (null == list || Platform.getOSType() == Platform.OSType.MACOS) {
                System.err.println("Your platform has no rotation support, sorry");
                animator.stop();
                TestScreenMode02aNEWT.destroyWindow(gLWindow);
                return;
            }
            list = MonitorModeUtil.filterByResolution(list, new Dimension(801, 601));
            Assert.assertNotNull(list);
            Assert.assertTrue(list.size() > 0);
            list = MonitorModeUtil.filterByRate(list, monitorMode2.getRefreshRate());
            Assert.assertNotNull(list);
            Assert.assertTrue(list.size() > 0);
            list = MonitorModeUtil.getHighestAvailableBpp(list);
            Assert.assertNotNull(list);
            Assert.assertTrue(list.size() > 0);
            MonitorMode monitorMode3 = list.get(0);
            System.err.println("[0] set current: " + monitorMode3);
            boolean bl4 = monitorDevice.setCurrentMode(monitorMode3);
            monitorMode = monitorDevice.getCurrentMode();
            System.err.println("[0] has current: " + monitorMode + ", changeOK " + bl4);
            Assert.assertTrue(monitorDevice.isModeChangedByUs());
            Assert.assertEquals(monitorMode3, monitorMode);
            Assert.assertNotSame(monitorMode2, monitorMode);
            Assert.assertEquals(monitorMode, monitorDevice.queryCurrentMode());
            Assert.assertTrue(bl4);
        }
        if (!bl2) {
            if (bl3) {
                gLWindow.setFullscreen(true);
            }
            gLWindow.setVisible(true);
        }
        Thread.sleep(waitTimeLong);
        if (!bl2 && bl3) {
            gLWindow.setFullscreen(false);
        }
        if (bl) {
            Thread.sleep(waitTimeShort);
            System.err.println("[1] set orig: " + monitorMode2);
            boolean bl5 = monitorDevice.setCurrentMode(monitorMode2);
            monitorMode = monitorDevice.getCurrentMode();
            System.err.println("[1] has orig?: " + monitorMode + ", changeOK " + bl5);
            Assert.assertFalse(monitorDevice.isModeChangedByUs());
            Assert.assertEquals(monitorMode2, monitorMode);
            Assert.assertTrue(bl5);
            Thread.sleep(waitTimeShort);
        }
        if (bl2 && bl3) {
            gLWindow.setFullscreen(false);
        }
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        animator.stop();
        TestScreenMode02aNEWT.destroyWindow(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertTrue(AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(false, display.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestScreenMode02aNEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        waitTimeShort = 4000;
        waitTimeLong = 8000;
    }
}

