/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode01cNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long waitTimeShort;
    static long duration;

    @BeforeClass
    public static void initClass() {
        TestScreenMode01cNEWT.setResetXRandRIfX11AfterClass();
        width = 200;
        height = 200;
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) throws InterruptedException {
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities);
        int[] nArray = gLWindow.convertToWindowUnits(new int[]{n, n2});
        gLWindow.setTitle(string);
        gLWindow.setPosition(nArray[0], nArray[1]);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener(new GearsES2());
        Assert.assertNotNull(gLWindow);
        long l = System.currentTimeMillis();
        gLWindow.setVisible(true);
        System.err.println("Time for visible/pos: " + (System.currentTimeMillis() - l) + " ms");
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            AWTRobotUtil.waitForRealized(window, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test01ScreenFullscreenSingleQ1() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        screen.addReference();
        try {
            RectangleImmutable rectangleImmutable = screen.getMonitorDevices().get(0).getViewport();
            this.testScreenFullscreenImpl(screen, rectangleImmutable.getX(), rectangleImmutable.getY(), false, null);
        }
        finally {
            screen.removeReference();
            AWTRobotUtil.waitForRealized(screen, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test02ScreenFullscreenSingleQ2() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        screen.addReference();
        try {
            if (2 > screen.getMonitorDevices().size()) {
                System.err.println("Test Disabled (1): Monitor count < 2: " + screen);
                return;
            }
            RectangleImmutable rectangleImmutable = screen.getMonitorDevices().get(1).getViewport();
            this.testScreenFullscreenImpl(screen, rectangleImmutable.getX(), rectangleImmutable.getY(), false, null);
        }
        finally {
            screen.removeReference();
            AWTRobotUtil.waitForRealized(screen, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test03ScreenFullscreenSpanQ1Q2() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        screen.addReference();
        try {
            if (2 > screen.getMonitorDevices().size()) {
                System.err.println("Test Disabled (2): Spanning monitor count < 2: " + screen);
                return;
            }
            ArrayList<MonitorDevice> arrayList = new ArrayList<MonitorDevice>();
            arrayList.add(screen.getMonitorDevices().get(0));
            arrayList.add(screen.getMonitorDevices().get(1));
            RectangleImmutable rectangleImmutable = screen.getMonitorDevices().get(0).getViewport();
            this.testScreenFullscreenImpl(screen, rectangleImmutable.getX() + 50, rectangleImmutable.getY() + 50, true, arrayList);
        }
        finally {
            screen.removeReference();
            AWTRobotUtil.waitForRealized(screen, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test04ScreenFullscreenSpanALL() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        screen.addReference();
        try {
            if (2 > screen.getMonitorDevices().size()) {
                System.err.println("Test Disabled (3): Monitor count < 2: " + screen);
                return;
            }
            RectangleImmutable rectangleImmutable = screen.getMonitorDevices().get(1).getViewport();
            this.testScreenFullscreenImpl(screen, rectangleImmutable.getX() - 50, rectangleImmutable.getY() + 50, true, null);
        }
        finally {
            screen.removeReference();
            AWTRobotUtil.waitForRealized(screen, false);
        }
    }

    void testScreenFullscreenImpl(Screen screen, int n, int n2, boolean bl, List<MonitorDevice> list) throws InterruptedException {
        Thread.sleep(waitTimeShort);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = screen.getDisplay();
        System.err.println("Test.0: Window screen: " + screen);
        System.err.println("Test.0: Window bounds (pre): screenPos " + n + "/" + n2 + " [pixels], windowSize " + width + "x" + height + " [wu] within " + screen.getViewport() + " [pixels]");
        GLWindow gLWindow = TestScreenMode01cNEWT.createWindow(screen, gLCapabilities, "win0", n, n2, width, height);
        Assert.assertNotNull(gLWindow);
        Rectangle rectangle = gLWindow.getBounds();
        Dimension dimension = new Dimension(gLWindow.getSurfaceWidth(), gLWindow.getSurfaceHeight());
        System.err.println("Test.0: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.0: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.0: Screen viewport  : " + screen.getViewport() + " [pixels]");
        Animator animator = new Animator(gLWindow);
        animator.start();
        List<MonitorMode> list2 = screen.getMonitorModes();
        Assert.assertTrue(list2.size() > 0);
        MonitorDevice monitorDevice = gLWindow.getMainMonitor();
        System.err.println("Test.0: Window monitor: " + monitorDevice);
        if (!bl) {
            gLWindow.setFullscreen(true);
        } else {
            gLWindow.setFullscreen(list);
        }
        monitorDevice = gLWindow.getMainMonitor();
        rectangle = gLWindow.getBounds();
        dimension = new Dimension(gLWindow.getSurfaceWidth(), gLWindow.getSurfaceHeight());
        System.err.println("Test.1: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.1: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.1: Screen viewport  : " + screen.getViewport() + " [pixels]");
        System.err.println("Test.1: Monitor viewport : " + monitorDevice.getViewport() + " [pixels], " + monitorDevice.getViewportInWindowUnits() + " [wu]");
        if (!bl) {
            Assert.assertEquals(monitorDevice.getViewportInWindowUnits(), rectangle);
        } else {
            List<MonitorDevice> list3 = list;
            if (null == list3) {
                list3 = gLWindow.getScreen().getMonitorDevices();
            }
            Rectangle rectangle2 = new Rectangle();
            MonitorDevice.unionOfViewports(null, rectangle2, list3);
            Assert.assertEquals(rectangle2, rectangle);
        }
        Thread.sleep(duration);
        gLWindow.setFullscreen(false);
        rectangle = gLWindow.getBounds();
        dimension = new Dimension(gLWindow.getSurfaceWidth(), gLWindow.getSurfaceHeight());
        monitorDevice = gLWindow.getMainMonitor();
        System.err.println("Test.2: Window bounds    : " + rectangle + " [wu] within " + screen.getViewportInWindowUnits() + " [wu]");
        System.err.println("Test.2: Window size      : " + dimension + " [pixels]");
        System.err.println("Test.2: Screen viewport  : " + screen.getViewport() + " [pixels]");
        System.err.println("Test.2: Monitor viewport : " + monitorDevice.getViewport() + " [pixels], " + monitorDevice.getViewportInWindowUnits() + " [wu]");
        Thread.sleep(duration);
        animator.stop();
        TestScreenMode01cNEWT.destroyWindow(gLWindow);
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, screen.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        String string = TestScreenMode01cNEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        waitTimeShort = 2000L;
        duration = 4000L;
    }
}

