/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.nativewindow.util.SurfaceSize;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.util.List;
import jogamp.newt.MonitorDeviceImpl;
import jogamp.newt.MonitorModeProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode00aNEWT
extends UITestCase {
    static int screenIdx = 0;
    static int width;
    static int height;
    static int waitTimeShort;
    static int waitTimeLong;

    @BeforeClass
    public static void initClass() {
        TestScreenMode00aNEWT.setResetXRandRIfX11AfterClass();
        GLProfile.initSingleton();
        NativeWindowFactory.initSingleton();
        width = 640;
        height = 480;
    }

    @Test
    public void test00ScreenModeStream() throws InterruptedException {
        Dimension dimension = new Dimension(640, 480);
        SurfaceSize surfaceSize = new SurfaceSize(dimension, 32);
        MonitorMode monitorMode = new MonitorMode(surfaceSize, 60.0f, 0, 0);
        System.err.println("00 out: " + monitorMode);
        MonitorModeProps.Cache cache = new MonitorModeProps.Cache();
        cache.monitorModes.add(monitorMode);
        Object object = MonitorModeProps.streamOutMonitorMode(monitorMode);
        Comparable<MonitorMode> comparable = MonitorModeProps.streamInMonitorMode(null, cache, object, 0);
        System.err.println("00 in : " + comparable);
        Assert.assertEquals(monitorMode.getSurfaceSize().getResolution(), comparable.getSurfaceSize().getResolution());
        Assert.assertEquals(monitorMode.getSurfaceSize(), comparable.getSurfaceSize());
        Assert.assertEquals(monitorMode.hashCode(), comparable.hashCode());
        Assert.assertEquals(monitorMode, comparable);
        object = new Dimension(50, 50);
        comparable = new Rectangle(0, 0, 1920, 1080);
        ArrayHashSet<MonitorMode> arrayHashSet = new ArrayHashSet<MonitorMode>(false, 16, 0.75f);
        arrayHashSet.add(monitorMode);
        MonitorDeviceImpl monitorDeviceImpl = new MonitorDeviceImpl(null, -1, false, true, (DimensionImmutable)object, monitorMode, null, (Rectangle)comparable, (Rectangle)comparable, arrayHashSet);
        System.err.println("01 out : " + monitorDeviceImpl);
        cache.monitorDevices.add(monitorDeviceImpl);
        int[] nArray = MonitorModeProps.streamOutMonitorDevice(monitorDeviceImpl);
        MonitorDevice monitorDevice = MonitorModeProps.streamInMonitorDevice(cache, null, null, nArray, 0, null);
        System.err.println("01 in : " + monitorDevice);
        Assert.assertEquals(monitorDeviceImpl.getId(), monitorDevice.getId());
        Assert.assertEquals(monitorDeviceImpl.isClone(), monitorDevice.isClone());
        Assert.assertEquals(monitorDeviceImpl.isPrimary(), monitorDevice.isPrimary());
        Assert.assertEquals(monitorDeviceImpl.getViewport(), monitorDevice.getViewport());
        Assert.assertEquals(monitorDeviceImpl.getViewportInWindowUnits(), monitorDevice.getViewportInWindowUnits());
        Assert.assertEquals(monitorDeviceImpl.getOriginalMode(), monitorDevice.getOriginalMode());
        Assert.assertEquals(monitorDeviceImpl.getCurrentMode(), monitorDevice.getCurrentMode());
        Assert.assertEquals(monitorDeviceImpl.getSupportedModes(), monitorDevice.getSupportedModes());
        Assert.assertEquals(monitorDeviceImpl.getCurrentMode(), monitorDeviceImpl.getOriginalMode());
        Assert.assertEquals(monitorDeviceImpl.hashCode(), monitorDevice.hashCode());
        Assert.assertEquals(monitorDeviceImpl, monitorDevice);
    }

    static void dumpMonitor(String string, String string2, MonitorDevice monitorDevice) {
        System.err.println(string + " " + monitorDevice);
        float[] fArray = monitorDevice.getPixelsPerMM(new float[2]);
        System.err.println(string2 + " pixel/mm [" + fArray[0] + ", " + fArray[1] + "]");
        System.err.println(string2 + " pixel/in [" + fArray[0] * 25.4f + ", " + fArray[1] * 25.4f + "]");
        MonitorMode monitorMode = monitorDevice.getOriginalMode();
        Assert.assertNotNull(monitorMode);
        MonitorMode monitorMode2 = monitorDevice.queryCurrentMode();
        System.err.println(string2 + " orig   : " + monitorMode);
        System.err.println(string2 + " current: " + monitorMode2);
        Assert.assertNotNull(monitorMode2);
        Assert.assertEquals(monitorMode, monitorMode2);
    }

    @Test
    public void test01ScreenAllMonitor() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen(display, screenIdx);
        screen.addReference();
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, screen.getDisplay().isNativeValid());
        List<MonitorDevice> list = screen.getMonitorDevices();
        Assert.assertTrue(list.size() > 0);
        MonitorDevice monitorDevice = screen.getPrimaryMonitor();
        Assert.assertNotNull("Could not retrieve primary monitor", monitorDevice);
        TestScreenMode00aNEWT.dumpMonitor("Primary Device ", "    ", monitorDevice);
        Assert.assertTrue("Tracked primary monitor not flagged as primary", monitorDevice.isPrimary());
        int n = 0;
        for (MonitorDevice object2 : list) {
            TestScreenMode00aNEWT.dumpMonitor("Monitor Index " + n, "    ", object2);
            if (object2.getId() == monitorDevice.getId()) {
                Assert.assertTrue("Primary monitor not flagged as primary", object2.isPrimary());
            } else {
                Assert.assertFalse("Non primary monitor flagged as primary", object2.isPrimary());
            }
            ++n;
        }
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        MonitorDevice.unionOfViewports(rectangle2, rectangle3, list);
        System.err.println("Test.0: Monitor union viewport: " + rectangle2 + " [pu] / " + rectangle3 + " [wu]");
        Assert.assertNotEquals(rectangle, rectangle2);
        Assert.assertNotEquals(rectangle, rectangle3);
        RectangleImmutable rectangleImmutable = screen.getViewport();
        RectangleImmutable rectangleImmutable2 = screen.getViewportInWindowUnits();
        System.err.println("Test.1: Screen viewport: " + rectangleImmutable + " [pu] / " + rectangleImmutable2 + " [wu]");
        Assert.assertNotEquals(rectangle, rectangleImmutable);
        Assert.assertNotEquals(rectangle, rectangleImmutable2);
        screen.removeReference();
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(false, screen.getDisplay().isNativeValid());
    }

    @Test
    public void test02ScreenAllModesInfo() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen(display, screenIdx);
        screen.addReference();
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, screen.getDisplay().isNativeValid());
        System.err.println("Screen: " + screen.toString());
        List<MonitorMode> list = screen.getMonitorModes();
        Assert.assertTrue(list.size() > 0);
        int n = 0;
        MonitorMode object = null;
        for (MonitorMode object2 : list) {
            System.err.println(String.format("All-0[%03d]: %s", n, object2));
            if (null != object) {
                Assert.assertTrue("Wrong order", object.compareTo(object2) >= 0);
            }
            object = object2;
            ++n;
        }
        MonitorModeUtil.sort(list, true);
        n = 0;
        object = null;
        for (MonitorMode monitorMode : list) {
            System.err.println(String.format("All-1[%03d]: %s", n, monitorMode));
            if (null != object) {
                Assert.assertTrue("Wrong order", object.compareTo(monitorMode) <= 0);
            }
            object = monitorMode;
            ++n;
        }
        List<MonitorDevice> list2 = screen.getMonitorDevices();
        Assert.assertTrue(list2.size() > 0);
        int n2 = 0;
        for (MonitorDevice monitorDevice : list2) {
            System.err.println(n2 + ": " + monitorDevice);
            List<MonitorMode> list3 = monitorDevice.getSupportedModes();
            Assert.assertTrue(list3.size() > 0);
            int n3 = 0;
            MonitorMode monitorMode = null;
            for (MonitorMode monitorMode2 : list3) {
                System.err.println(String.format("[%02d][%03d]: %s", n2, n3, monitorMode2));
                if (null != monitorMode) {
                    Assert.assertTrue("Wrong order", monitorMode.compareTo(monitorMode2) >= 0);
                }
                monitorMode = monitorMode2;
                ++n3;
            }
            Assert.assertTrue(list.containsAll(list3));
            ++n2;
        }
        screen.removeReference();
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(false, screen.getDisplay().isNativeValid());
    }

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-screen")) continue;
            screenIdx = TestScreenMode00aNEWT.atoi(stringArray[++i]);
        }
        String string = TestScreenMode00aNEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        waitTimeShort = 4;
        waitTimeLong = 6;
    }
}

