/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.newt.parenting.NewtAWTReparentingKeyAdapter;
import com.jogamp.opengl.test.junit.util.AWTFocusAdapter;
import com.jogamp.opengl.test.junit.util.AWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NEWTFocusAdapter;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import jogamp.newt.driver.DriverClearFocus;
import jogamp.opengl.GLAutoDrawableBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParentingFocus03KeyTraversalAWT
extends UITestCase {
    static Dimension glSize;
    static Dimension fSize;
    static int numFocus;
    static long durationPerTest;
    static GLCapabilities glCaps;
    static boolean manual;
    static boolean forceGL3;

    @BeforeClass
    public static void initClass() {
        glSize = new Dimension(200, 200);
        fSize = new Dimension(300, 300);
        glCaps = new GLCapabilities(forceGL3 ? GLProfile.get("GL3") : null);
    }

    @Test
    public void testWindowParentingAWTFocusTraversal01Onscreen() throws InterruptedException, InvocationTargetException, AWTException {
        this.testWindowParentingAWTFocusTraversal(true);
    }

    @Test
    public void testWindowParentingAWTFocusTraversal02Offscreen() throws InterruptedException, InvocationTargetException, AWTException {
        this.testWindowParentingAWTFocusTraversal(false);
    }

    public void testWindowParentingAWTFocusTraversal(boolean bl) throws InterruptedException, InvocationTargetException, AWTException {
        Robot robot = new Robot();
        Object object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object object2 = ((KeyboardFocusManager)object).getDefaultFocusTraversalKeys(1);
        Object object3 = AWTKeyStroke.getAWTKeyStroke(8, 0, false);
        Assert.assertNotNull(object3);
        Object object4 = new HashSet<AWTKeyStroke>((Collection<AWTKeyStroke>)object2);
        object4.add((AWTKeyStroke)object3);
        ((KeyboardFocusManager)object).setDefaultFocusTraversalKeys(1, (Set<? extends AWTKeyStroke>)object4);
        object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        object2 = ((KeyboardFocusManager)object).getDefaultFocusTraversalKeys(0);
        object3 = ((KeyboardFocusManager)object).getDefaultFocusTraversalKeys(1);
        object4 = object2.iterator();
        while (object4.hasNext()) {
            System.err.println("FTKL.fwd-keys: " + object4.next());
        }
        object4 = object3.iterator();
        while (object4.hasNext()) {
            System.err.println("FTKL.bwd-keys: " + object4.next());
        }
        object = new Frame("AWT Parent Frame");
        object2 = new Button("WEST");
        object3 = new Button("EAST");
        object4 = GLWindow.create(glCaps);
        ((GLAutoDrawableBase)object4).setUpdateFPSFrames(1, null);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((com.jogamp.newt.Window)object4);
        newtCanvasAWT.setPreferredSize(glSize);
        newtCanvasAWT.setShallUseOffscreenLayer(!bl);
        newtCanvasAWT.setFocusable(true);
        NEWTFocusAdapter nEWTFocusAdapter = new NEWTFocusAdapter("GLWindow1");
        ((GLWindow)object4).addWindowListener(nEWTFocusAdapter);
        AWTFocusAdapter aWTFocusAdapter = new AWTFocusAdapter("WEST");
        ((Component)object2).addFocusListener(aWTFocusAdapter);
        AWTFocusAdapter aWTFocusAdapter2 = new AWTFocusAdapter("EAST");
        ((Component)object3).addFocusListener(aWTFocusAdapter2);
        NEWTKeyAdapter nEWTKeyAdapter = new NEWTKeyAdapter("GLWindow1");
        ((GLWindow)object4).addKeyListener(nEWTKeyAdapter);
        AWTKeyAdapter aWTKeyAdapter = new AWTKeyAdapter("West");
        ((Component)object2).addKeyListener(aWTKeyAdapter);
        AWTKeyAdapter aWTKeyAdapter2 = new AWTKeyAdapter("East");
        ((Component)object3).addKeyListener(aWTKeyAdapter2);
        GearsES2 gearsES2 = new GearsES2(1);
        TestParentingFocus03KeyTraversalAWT.setDemoFields(gearsES2, (GLWindow)object4, false);
        ((GLAutoDrawableBase)object4).addGLEventListener(gearsES2);
        ((GLWindow)object4).addKeyListener(new NewtAWTReparentingKeyAdapter((Frame)object, newtCanvasAWT, (GLWindow)object4));
        ((GLWindow)object4).addKeyListener(new KeyAdapter((GLWindow)object4, (Button)object3, (Button)object2){
            final /* synthetic */ GLWindow val$glWindow1;
            final /* synthetic */ Button val$cEast;
            final /* synthetic */ Button val$cWest;
            {
                this.val$glWindow1 = gLWindow;
                this.val$cEast = button;
                this.val$cWest = button2;
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'c') {
                    System.err.println("Focus Clear");
                    if (this.val$glWindow1.getDelegatedWindow() instanceof DriverClearFocus) {
                        ((DriverClearFocus)((Object)this.val$glWindow1.getDelegatedWindow())).clearFocus();
                    }
                } else if (keyEvent.getKeyChar() == 'e') {
                    System.err.println("Focus East");
                    try {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                val$cEast.requestFocusInWindow();
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (keyEvent.getKeyChar() == 'w') {
                    System.err.println("Focus West");
                    try {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                val$cWest.requestFocusInWindow();
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        Animator animator = new Animator((GLAutoDrawable)object4);
        animator.start();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)object2, "West");
        ((Container)object).add((Component)newtCanvasAWT, "Center");
        ((Container)object).add((Component)object3, "East");
        SwingUtilities.invokeAndWait(new Runnable((Frame)object){
            final /* synthetic */ Frame val$frame1;
            {
                this.val$frame1 = frame;
            }

            @Override
            public void run() {
                this.val$frame1.setLocation(0, 0);
                this.val$frame1.setSize(fSize);
                this.val$frame1.validate();
                this.val$frame1.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(object4, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(object4, true));
        Assert.assertEquals(newtCanvasAWT.getNativeWindow(), ((GLWindow)object4).getParent());
        AWTRobotUtil.clearAWTFocus(robot);
        Assert.assertTrue(AWTRobotUtil.toFrontAndRequestFocus(robot, (Window)object));
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertNotNull(animator.getThread());
        if (manual) {
            Thread.sleep(durationPerTest);
        } else {
            AWTRobotUtil.assertRequestFocusAndWait(robot, object2, object2, aWTFocusAdapter, null);
            Thread.sleep(durationPerTest / (long)numFocus);
            AWTRobotUtil.keyType(0, robot, 9, object2, null);
            Assert.assertTrue("Did not gain focus", AWTRobotUtil.waitForFocus(object4, nEWTFocusAdapter, aWTFocusAdapter));
            Assert.assertEquals(true, nEWTFocusAdapter.focusGained());
            Assert.assertEquals(true, aWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            AWTRobotUtil.keyType(0, robot, 9, object4, null);
            Assert.assertTrue("Did not gain focus", AWTRobotUtil.waitForFocus(object3, aWTFocusAdapter2, nEWTFocusAdapter));
            Assert.assertEquals(true, aWTFocusAdapter2.focusGained());
            Assert.assertEquals(true, nEWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            AWTRobotUtil.keyType(0, robot, 8, object3, null);
            Assert.assertTrue("Did not gain focus", AWTRobotUtil.waitForFocus(object4, nEWTFocusAdapter, aWTFocusAdapter2));
            Assert.assertEquals(true, nEWTFocusAdapter.focusGained());
            Assert.assertEquals(true, aWTFocusAdapter2.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            AWTRobotUtil.keyType(0, robot, 8, object4, null);
            Assert.assertTrue("Did not gain focus", AWTRobotUtil.waitForFocus(object2, aWTFocusAdapter, nEWTFocusAdapter));
            Assert.assertEquals(true, aWTFocusAdapter.focusGained());
            Assert.assertEquals(true, nEWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            System.err.println("Test: Direct NewtCanvasAWT focus");
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        newtCanvasAWT.requestFocus();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Assert.assertTrue("Did not gain focus", AWTRobotUtil.waitForFocus(object4, nEWTFocusAdapter, aWTFocusAdapter));
            Assert.assertEquals(true, nEWTFocusAdapter.focusGained());
            Assert.assertEquals(true, aWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            System.err.println("Test: Direct AWT Button-West focus");
            try {
                EventQueue.invokeAndWait(new Runnable((Button)object2){
                    final /* synthetic */ Button val$cWest;
                    {
                        this.val$cWest = button;
                    }

                    @Override
                    public void run() {
                        this.val$cWest.requestFocus();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Assert.assertTrue("Did not gain focus", AWTRobotUtil.waitForFocus(object2, aWTFocusAdapter, nEWTFocusAdapter));
            Assert.assertEquals(true, aWTFocusAdapter.focusGained());
            Assert.assertEquals(true, nEWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            System.err.println("Test: Direct NEWT-Child request focus");
            ((GLWindow)object4).requestFocus();
            boolean bl2 = AWTRobotUtil.waitForFocus(object4, nEWTFocusAdapter, aWTFocusAdapter);
            System.err.println("glWindow hasFocus " + ((GLWindow)object4).hasFocus());
            System.err.println("glWindow1FA " + nEWTFocusAdapter);
            System.err.println("bWestFA " + aWTFocusAdapter);
            Assert.assertTrue("Did not gain focus", bl2);
            Assert.assertEquals(true, nEWTFocusAdapter.focusGained());
            Assert.assertEquals(true, aWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
        }
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(false, animator.isPaused());
        Assert.assertEquals(null, animator.getThread());
        SwingUtilities.invokeAndWait(new Runnable((Frame)object){
            final /* synthetic */ Frame val$frame1;
            {
                this.val$frame1 = frame;
            }

            @Override
            public void run() {
                this.val$frame1.dispose();
            }
        });
        ((GLWindow)object4).destroy();
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        com.jogamp.newt.Window window = gLWindow.getDelegatedWindow();
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", window)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = TestParentingFocus03KeyTraversalAWT.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-manual")) {
                manual = true;
                continue;
            }
            if (!stringArray[i].equals("-gl3")) continue;
            forceGL3 = true;
        }
        String string = TestParentingFocus03KeyTraversalAWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        numFocus = 8;
        durationPerTest = numFocus * 200;
        manual = false;
        forceGL3 = false;
    }
}

