/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.NEWTKeyUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNewtKeyEventOrderAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long awtWaitTimeout;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @AfterClass
    public static void release() {
    }

    @Before
    public void initTest() {
    }

    @After
    public void releaseTest() {
    }

    @Test(timeout=180000L)
    public void test01NEWT() throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        this.testImpl(gLWindow);
        gLWindow.destroy();
    }

    private void testNewtCanvasAWT_Impl(boolean bl) throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        if (!bl) {
            newtCanvasAWT.setShallUseOffscreenLayer(true);
        }
        final JFrame jFrame = new JFrame("Swing AWT Parent Frame: " + gLWindow.getTitle());
        jFrame.getContentPane().add((Component)newtCanvasAWT, "Center");
        jFrame.setSize(width, height);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(jFrame, true));
        this.testImpl(gLWindow);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        gLWindow.destroy();
    }

    @Test(timeout=180000L)
    public void test02NewtCanvasAWT_Onscreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("Platform doesn't support onscreen rendering.");
            return;
        }
        this.testNewtCanvasAWT_Impl(true);
    }

    @Test(timeout=180000L)
    public void test03NewtCanvasAWT_Offsccreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (!JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("Platform doesn't support offscreen rendering.");
            return;
        }
        this.testNewtCanvasAWT_Impl(false);
    }

    static void testKeyEventOrder(Robot robot, NEWTKeyAdapter nEWTKeyAdapter, int n) {
        int n2;
        System.err.println("KEY Event Order Test: " + n);
        nEWTKeyAdapter.reset();
        for (n2 = 0; n2 < n; ++n2) {
            AWTRobotUtil.waitForIdle(robot);
            AWTRobotUtil.keyPress(0, robot, true, 65, 10);
            AWTRobotUtil.keyPress(0, robot, false, 65, 100);
            AWTRobotUtil.waitForIdle(robot);
            AWTRobotUtil.keyPress(0, robot, true, 66, 10);
            AWTRobotUtil.keyPress(0, robot, false, 66, 100);
            AWTRobotUtil.waitForIdle(robot);
            AWTRobotUtil.keyPress(0, robot, true, 65, 10);
            AWTRobotUtil.keyPress(0, robot, true, 66, 10);
            AWTRobotUtil.keyPress(0, robot, false, 65, 10);
            AWTRobotUtil.keyPress(0, robot, false, 66, 10);
            AWTRobotUtil.waitForIdle(robot);
            AWTRobotUtil.keyPress(0, robot, true, 65, 10);
            AWTRobotUtil.keyPress(0, robot, true, 66, 10);
            AWTRobotUtil.keyPress(0, robot, false, 66, 10);
            AWTRobotUtil.keyPress(0, robot, false, 65, 10);
        }
        AWTRobotUtil.waitForIdle(robot);
        robot.delay(250);
        NEWTKeyUtil.validateKeyEventOrder(nEWTKeyAdapter.copyQueue());
        n2 = 6 * n;
        NEWTKeyUtil.validateKeyAdapterStats(nEWTKeyAdapter, n2, n2, 0, 0);
    }

    void testImpl(GLWindow gLWindow) throws AWTException, InterruptedException, InvocationTargetException {
        Robot robot = new Robot();
        robot.setAutoWaitForIdle(true);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        gLWindow.addGLEventListener(redSquareES2);
        NEWTKeyAdapter nEWTKeyAdapter = new NEWTKeyAdapter("GLWindow1");
        nEWTKeyAdapter.setVerbose(false);
        gLWindow.addKeyListener(nEWTKeyAdapter);
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, true));
        Animator animator = new Animator(gLWindow);
        animator.start();
        Thread.sleep(durationPerTest);
        AWTRobotUtil.assertRequestFocusAndWait(null, gLWindow, gLWindow, null, null);
        AWTRobotUtil.requestFocus(robot, gLWindow, false);
        nEWTKeyAdapter.reset();
        TestNewtKeyEventOrderAWT.testKeyEventOrder(robot, nEWTKeyAdapter, 6);
        gLWindow.removeKeyListener(nEWTKeyAdapter);
        animator.stop();
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestNewtKeyEventOrderAWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestNewtKeyEventOrderAWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 100L;
        awtWaitTimeout = 1000L;
    }
}

