/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es1.GearsES1;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRemoteGLWindows01NEWT
extends UITestCase {
    static int width = 640;
    static int height = 480;
    static long durationPerTest = 100L;
    static String remoteDisplay = "localhost:0.0";

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, GLEventListener gLEventListener) throws InterruptedException {
        GLWindow gLWindow;
        Assert.assertNotNull(gLCapabilities);
        if (null != screen) {
            gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull(gLWindow);
        } else {
            gLWindow = GLWindow.create(gLCapabilities);
            Assert.assertNotNull(gLWindow);
        }
        gLWindow.addGLEventListener(gLEventListener);
        gLWindow.setSize(512, 512);
        gLWindow.setVisible(true);
        Assert.assertEquals(true, gLWindow.isVisible());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
            Assert.assertEquals(false, gLWindow.isNativeValid());
        }
    }

    @Test
    public void testRemoteWindow01() throws InterruptedException {
        GLWindow gLWindow;
        Animator animator = new Animator();
        GLProfile gLProfile = GLProfile.getGL2ES1();
        Assert.assertNotNull(gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Assert.assertNotNull(gLCapabilities);
        GearsES1 gearsES1 = new GearsES1(1);
        GLWindow gLWindow2 = TestRemoteGLWindows01NEWT.createWindow(null, gLCapabilities, gearsES1);
        Assert.assertEquals(true, gLWindow2.isNativeValid());
        Assert.assertEquals(true, gLWindow2.isVisible());
        AbstractGraphicsDevice abstractGraphicsDevice = gLWindow2.getScreen().getDisplay().getGraphicsDevice();
        System.err.println("GLProfiles window1: " + abstractGraphicsDevice.getConnection() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice));
        animator.add(gLWindow2);
        GearsES1 gearsES12 = null;
        try {
            Display display = NewtFactory.createDisplay(remoteDisplay);
            display.createNative();
            System.err.println(display);
            AbstractGraphicsDevice abstractGraphicsDevice2 = display.getGraphicsDevice();
            System.err.println(abstractGraphicsDevice2);
            GLProfile.initProfiles(abstractGraphicsDevice2);
            System.err.println();
            System.err.println("GLProfiles window2: " + abstractGraphicsDevice2.getConnection() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice2));
            GLProfile gLProfile2 = GLProfile.get(abstractGraphicsDevice2, "GL2ES1");
            Assert.assertNotNull(gLProfile2);
            GLCapabilities gLCapabilities2 = new GLCapabilities(gLProfile2);
            Assert.assertNotNull(gLCapabilities2);
            Screen screen = NewtFactory.createScreen(display, 0);
            gearsES12 = new GearsES1(0);
            gLWindow = TestRemoteGLWindows01NEWT.createWindow(screen, gLCapabilities2, gearsES12);
        }
        catch (NativeWindowException nativeWindowException) {
            System.err.println(nativeWindowException);
            Assume.assumeNoException(nativeWindowException);
            TestRemoteGLWindows01NEWT.destroyWindow(gLWindow2);
            return;
        }
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        animator.add(gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        if (null != gearsES12) {
            System.err.println("demoLocal VBO: " + gearsES1.getGear1().backFace.isVBO());
            System.err.println("demoRemote VBO: " + gearsES12.getGear1().backFace.isVBO());
        }
        TestRemoteGLWindows01NEWT.destroyWindow(gLWindow2);
        TestRemoteGLWindows01NEWT.destroyWindow(gLWindow);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = TestRemoteGLWindows01NEWT.atoi(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-display")) continue;
            remoteDisplay = stringArray[++i];
        }
        System.out.println("durationPerTest: " + durationPerTest);
        System.out.println("display: " + remoteDisplay);
        String string = TestRemoteGLWindows01NEWT.class.getName();
        JUnitCore.main(string);
    }
}

