/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLWindows01NEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, int n, int n2, boolean bl, boolean bl2) throws InterruptedException {
        GLWindow gLWindow;
        Assert.assertNotNull(gLCapabilities);
        gLCapabilities.setOnscreen(bl);
        if (null != screen) {
            gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull(gLWindow);
        } else {
            gLWindow = GLWindow.create(gLCapabilities);
            Assert.assertNotNull(gLWindow);
        }
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        GearsES2 gearsES2 = new GearsES2();
        TestGLWindows01NEWT.setDemoFields(gearsES2, gLWindow);
        if (!bl2) {
            gLWindow.addGLEventListener(gearsES2);
        }
        gLWindow.addWindowListener(new TraceWindowAdapter());
        gLWindow.setSize(n, n2);
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals(true, gLWindow.isVisible());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        System.out.println("Frames for initial setVisible(true): " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow.getTotalFPSFrames());
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLWindow.getChosenGLCapabilities();
        Assert.assertNotNull(gLCapabilitiesImmutable);
        Assert.assertTrue(gLCapabilitiesImmutable.getGreenBits() >= 5);
        Assert.assertTrue(gLCapabilitiesImmutable.getBlueBits() >= 5);
        Assert.assertTrue(gLCapabilitiesImmutable.getRedBits() >= 5);
        Assert.assertEquals(gLCapabilitiesImmutable.isOnscreen(), bl);
        if (bl2) {
            gLWindow.addGLEventListener(gearsES2);
            gLWindow.display();
        }
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
            Assert.assertEquals(false, gLWindow.isNativeValid());
            Assert.assertEquals(false, gLWindow.isVisible());
        }
    }

    @Test
    public void test01WindowSimple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, false);
        System.out.println("Created: " + gLWindow);
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration: " + gLWindow.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void test02WindowSimple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, true);
        System.out.println("Created: " + gLWindow);
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration: " + gLWindow.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void test10WindowNativeRecreateSimple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, false);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        gLWindow.destroy();
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.display();
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        gLWindow.setVisible(false);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void test11WindowNativeRecreateSimple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, true);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        gLWindow.destroy();
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.display();
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        gLWindow.setVisible(false);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void test21WindowDestroyWinTwiceA() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, false);
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration: " + gLWindow.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void test22WindowTwoWinOneDisplay() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(screen, gLCapabilities, width, height, true, false);
        Assert.assertNotNull(gLWindow);
        GLWindow gLWindow2 = TestGLWindows01NEWT.createWindow(screen, gLCapabilities, width, height, true, false);
        Assert.assertNotNull(gLWindow2);
        Assert.assertEquals(1L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(2L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration1: " + gLWindow.getTotalFPSDuration());
        System.out.println("duration2: " + gLWindow2.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
        TestGLWindows01NEWT.destroyWindow(gLWindow2);
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(false, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
    }

    @Test
    public void test23WindowTwoWinTwoDisplays() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull(gLCapabilities);
        Display display = NewtFactory.createDisplay(null, false);
        Assert.assertNotNull(display);
        Display display2 = NewtFactory.createDisplay(null, false);
        Assert.assertNotNull(display2);
        Assert.assertNotSame(display, display2);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(screen, gLCapabilities, width, height, true, false);
        Assert.assertNotNull(gLWindow);
        Screen screen2 = NewtFactory.createScreen(display2, 0);
        Assert.assertNotNull(screen2);
        GLWindow gLWindow2 = TestGLWindows01NEWT.createWindow(screen2, gLCapabilities, width, height, true, false);
        Assert.assertNotNull(gLWindow2);
        Assert.assertEquals(2L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(1L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(1L, display2.getReferenceCount());
        Assert.assertEquals(true, display2.isNativeValid());
        Assert.assertNotNull(display2.getEDTUtil());
        Assert.assertEquals(true, display2.getEDTUtil().isRunning());
        Assert.assertEquals(1L, screen2.getReferenceCount());
        Assert.assertEquals(true, screen2.isNativeValid());
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration1: " + gLWindow.getTotalFPSDuration());
        System.out.println("duration2: " + gLWindow2.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
        TestGLWindows01NEWT.destroyWindow(gLWindow2);
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(false, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(0L, display2.getReferenceCount());
        Assert.assertEquals(false, display2.isNativeValid());
        Assert.assertNotNull(display2.getEDTUtil());
        Assert.assertEquals(false, display2.getEDTUtil().isRunning());
        Assert.assertEquals(0L, screen2.getReferenceCount());
        Assert.assertEquals(false, screen2.isNativeValid());
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", gLWindow)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestGLWindows01NEWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestGLWindows01NEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 100L;
    }
}

