/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestDisplayLifecycle02NEWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
        caps = new GLCapabilities(glp);
    }

    static GLWindow createWindow(GLCapabilities gLCapabilities, int n, int n2) throws InterruptedException {
        Assert.assertNotNull(gLCapabilities);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setUpdateFPSFrames(1, null);
        GearsES2 gearsES2 = new GearsES2();
        TestDisplayLifecycle02NEWT.setDemoFields(gearsES2, gLWindow);
        gLWindow.addGLEventListener(gearsES2);
        gLWindow.addWindowListener(new TraceWindowAdapter());
        gLWindow.setSize(n, n2);
        return gLWindow;
    }

    private void testDisplayCreate01Impl() throws InterruptedException {
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        GLWindow gLWindow = TestDisplayLifecycle02NEWT.createWindow(caps, width, height);
        Screen screen = gLWindow.getScreen();
        Display display = screen.getDisplay();
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, Screen.getActiveScreenNumber());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(1L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(1L, Screen.getActiveScreenNumber());
        Assert.assertEquals(1L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        System.err.println("Frames for setVisible(true) 1: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow.getTotalFPSFrames());
        while (gLWindow.getTotalFPSDuration() < 1L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.setVisible(false);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.resetFPSCounter();
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        System.err.println("Frames for setVisible(true) 1: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow.getTotalFPSFrames());
        while (gLWindow.getTotalFPSDuration() < 2L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.destroy();
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(false, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, Screen.getActiveScreenNumber());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertNotNull(gLWindow.getScreen());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.resetFPSCounter();
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        gLWindow.display();
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(1L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(1L, Screen.getActiveScreenNumber());
        Assert.assertEquals(1L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        System.err.println("Frames for setVisible(true) 2: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow.getTotalFPSFrames());
        while (gLWindow.getTotalFPSDuration() < 1L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.destroy();
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals(screen, gLWindow.getScreen());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        Display.dumpDisplayList("Post destroy(true)");
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(false, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, Screen.getActiveScreenNumber());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
    }

    @Test
    public void testDisplayCreate01() throws InterruptedException {
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        System.err.println("Pass - 1");
        this.testDisplayCreate01Impl();
        System.err.println("Pass - 2");
        this.testDisplayCreate01Impl();
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
    }

    private void testDisplayCreate02Impl() throws InterruptedException {
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        GLWindow gLWindow = TestDisplayLifecycle02NEWT.createWindow(caps, width, height);
        gLWindow.setPosition(0, 0);
        Screen screen = gLWindow.getScreen();
        Display display = screen.getDisplay();
        GLWindow gLWindow2 = TestDisplayLifecycle02NEWT.createWindow(caps, width, height);
        Assert.assertSame(screen, gLWindow2.getScreen());
        Assert.assertSame(display, gLWindow2.getScreen().getDisplay());
        RectangleImmutable rectangleImmutable = screen.getViewportInWindowUnits();
        gLWindow2.setPosition(rectangleImmutable.getWidth() - width, 0);
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, Screen.getActiveScreenNumber());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(false, gLWindow2.isNativeValid());
        Assert.assertEquals(false, gLWindow2.isVisible());
        Assert.assertEquals(0L, gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals(1L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(1L, Screen.getActiveScreenNumber());
        Assert.assertEquals(1L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(true, gLWindow.isVisible());
        System.err.println("Frames for setVisible(true) 1: " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow.getTotalFPSFrames());
        Assert.assertEquals(0L, gLWindow2.getTotalFPSFrames());
        gLWindow2.setVisible(true);
        Assert.assertEquals(1L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(1L, Screen.getActiveScreenNumber());
        Assert.assertEquals(2L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        Assert.assertEquals(true, gLWindow2.isNativeValid());
        Assert.assertEquals(true, gLWindow2.isVisible());
        System.err.println("Frames for setVisible(true) 2: " + gLWindow2.getTotalFPSFrames());
        Assert.assertTrue(0 < gLWindow2.getTotalFPSFrames());
        while (gLWindow.getTotalFPSDuration() < 1L * durationPerTest) {
            gLWindow.display();
            Thread.sleep(100L);
        }
        System.err.println("duration: " + gLWindow.getTotalFPSDuration());
        gLWindow.setVisible(false);
        Assert.assertEquals(true, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow.destroy();
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertNotNull(gLWindow.getScreen());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        Assert.assertEquals(1L, Display.getActiveDisplayNumber());
        Assert.assertEquals(1L, display.getReferenceCount());
        Assert.assertEquals(true, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(true, display.getEDTUtil().isRunning());
        Assert.assertEquals(1L, Screen.getActiveScreenNumber());
        Assert.assertEquals(1L, screen.getReferenceCount());
        Assert.assertEquals(true, screen.isNativeValid());
        gLWindow2.destroy();
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow2, false));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertNotNull(gLWindow2.getScreen());
        Assert.assertEquals(false, gLWindow2.isNativeValid());
        Assert.assertEquals(false, gLWindow2.isVisible());
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        Assert.assertEquals(0L, display.getReferenceCount());
        Assert.assertEquals(false, display.isNativeValid());
        Assert.assertNotNull(display.getEDTUtil());
        Assert.assertEquals(false, display.getEDTUtil().isRunning());
        Assert.assertEquals(0L, Screen.getActiveScreenNumber());
        Assert.assertEquals(0L, screen.getReferenceCount());
        Assert.assertEquals(false, screen.isNativeValid());
        gLWindow.destroy();
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(false, gLWindow.isVisible());
        gLWindow2.destroy();
        Assert.assertEquals(false, gLWindow2.isNativeValid());
        Assert.assertEquals(false, gLWindow2.isVisible());
    }

    @Test
    public void testDisplayCreate02() throws InterruptedException {
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
        System.err.println("Pass - 1");
        this.testDisplayCreate02Impl();
        System.err.println("Pass - 2");
        this.testDisplayCreate02Impl();
        Assert.assertEquals(0L, Display.getActiveDisplayNumber());
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow) {
        Assert.assertNotNull(gLEventListener);
        Assert.assertNotNull(gLWindow);
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", gLWindow)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestDisplayLifecycle02NEWT.atoi(stringArray[++i]);
        }
        System.err.println("durationPerTest: " + durationPerTest);
        String string = TestDisplayLifecycle02NEWT.class.getName();
        JUnitCore.main(string);
    }

    static {
        durationPerTest = 100L;
    }
}

