/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.TextureDraw01GL2Listener;
import com.jogamp.opengl.test.junit.jogl.util.texture.ImageTstFiles;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.ImageType;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextureIONEWT
extends UITestCase {
    static long duration = 100L;
    ImageTstFiles imageTstFiles;

    @Before
    public void initTest() throws IOException {
        this.imageTstFiles = new ImageTstFiles();
        this.imageTstFiles.init();
    }

    @After
    public void cleanupTest() {
        this.imageTstFiles.clear();
    }

    public void testImpl(List<ImageTstFiles.NamedInputStream> list, ImageType imageType) throws InterruptedException, IOException {
        for (int i = 0; i < list.size(); ++i) {
            ImageTstFiles.NamedInputStream namedInputStream = list.get(i);
            System.err.printf("Test %3d: path %s, exp-type %s%n", i, namedInputStream.basePath, imageType);
            this.testImpl(namedInputStream.stream, imageType);
        }
    }

    public void testImpl(InputStream inputStream, ImageType imageType) throws InterruptedException, IOException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        GLProfile gLProfile = GLProfile.isAvailable("GL2ES2") ? GLProfile.getGL2ES2() : GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(1);
        TextureData textureData = TextureIO.newTextureData(gLProfile, inputStream, false, imageType.type);
        System.err.println("TextureData: " + textureData);
        Assert.assertEquals(imageType, textureData.getSourceImageType());
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle("TestTextureIONEWT." + imageType.type);
        gLWindow.setSize(textureData.getWidth(), textureData.getHeight());
        final GLEventListener gLEventListener = gLProfile.isGL2ES2() ? new TextureDraw01ES2Listener(textureData, 0) : new TextureDraw01GL2Listener(textureData);
        gLWindow.addGLEventListener(gLEventListener);
        gLWindow.addGLEventListener(new GLEventListener(){
            boolean shot = false;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != ((TextureDraw01Accessor)((Object)gLEventListener)).getTexture() && !this.shot) {
                    this.shot = true;
                    TestTextureIONEWT.this.snapshot(0, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(60, null);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.setVisible(true);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test01AllPNG() throws InterruptedException, IOException {
        this.testImpl(this.imageTstFiles.pngStreams, new ImageType("png"));
    }

    @Test
    public void test02AllJPG() throws InterruptedException, IOException {
        this.testImpl(this.imageTstFiles.jpgStreams, new ImageType("jpg"));
    }

    @Test
    public void test03AllTGA() throws InterruptedException, IOException {
        this.testImpl(this.imageTstFiles.tgaStreams, new ImageType("tga"));
    }

    @Test
    public void test04AllDDS() throws InterruptedException, IOException {
        this.testImpl(this.imageTstFiles.ddsStreams, new ImageType("dds"));
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main(TestTextureIONEWT.class.getName());
    }
}

