/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.es1.RedSquareES1;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.jogl.tile.PrintableBase;
import com.jogamp.opengl.test.junit.jogl.tile.TiledPrintingAWTBase;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTiledPrintingGearsSwingAWT
extends TiledPrintingAWTBase {
    static boolean waitForKey = false;
    static boolean allow600dpi = false;
    static GLProfile glp;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2")) {
            glp = GLProfile.get("GL2");
            Assert.assertNotNull(glp);
            width = 640;
            height = 480;
        } else {
            TestTiledPrintingGearsSwingAWT.setTestSupported(false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities, boolean bl, boolean bl2) throws InterruptedException, InvocationTargetException {
        Object object;
        Serializable serializable;
        int n = width / 6;
        int n2 = height / 6;
        Dimension dimension = new Dimension(bl ? width - 2 * n : width / 2, bl ? height - 2 * n2 : height);
        GLJPanel gLJPanel = new GLJPanel(gLCapabilities);
        Assert.assertNotNull(gLJPanel);
        gLJPanel.setSkipGLOrientationVerticalFlip(bl2);
        gLJPanel.setMinimumSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        if (bl) {
            gLJPanel.setBounds(n / 2, n2 / 2, dimension.width, dimension.height);
        } else {
            gLJPanel.setBounds(0, 0, dimension.width, dimension.height);
        }
        Object object2 = new Gears();
        ((Gears)object2).setFlipVerticalInGLOrientation(bl2);
        gLJPanel.addGLEventListener((GLEventListener)object2);
        object2 = new GLJPanel(gLCapabilities);
        Assert.assertNotNull(object2);
        ((GLJPanel)object2).setSkipGLOrientationVerticalFlip(bl2);
        ((JComponent)object2).setMinimumSize(dimension);
        ((JComponent)object2).setPreferredSize(dimension);
        if (bl) {
            ((Component)object2).setBounds(3 * n2, 2 * n2, dimension.width, dimension.height);
        } else {
            ((Component)object2).setBounds(0, 0, dimension.width, dimension.height);
        }
        Object object3 = new RedSquareES1();
        ((RedSquareES1)object3).setFlipVerticalInGLOrientation(bl2);
        ((GLJPanel)object2).addGLEventListener((GLEventListener)object3);
        if (bl) {
            gLJPanel.setOpaque(true);
            ((GLJPanel)object2).setOpaque(false);
            serializable = new Dimension(width, height);
            object3 = new JLayeredPane();
            ((JComponent)object3).setMinimumSize((Dimension)serializable);
            ((JComponent)object3).setPreferredSize((Dimension)serializable);
            ((Component)object3).setBounds(0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height);
            ((JComponent)object3).setBorder(BorderFactory.createTitledBorder("Layered Pane"));
            ((Container)object3).add((Component)gLJPanel, JLayeredPane.DEFAULT_LAYER);
            ((Container)object3).add((Component)object2, (Object)1);
            object = new JButton("On Top");
            ((Component)object).setBounds(4 * n2, 3 * n2, 100, 50);
            ((Container)object3).add((Component)object, (Object)2);
        } else {
            object3 = new JPanel();
            ((Container)object3).add(gLJPanel);
            ((Container)object3).add((Component)object2);
        }
        serializable = new JFrame("Swing Print");
        Assert.assertNotNull(serializable);
        object = new ActionListener((JFrame)serializable){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsSwingAWT.this.doPrintManual(this.val$frame, 72, 0, -1, -1);
            }
        };
        ActionListener actionListener = new ActionListener((JFrame)serializable){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsSwingAWT.this.doPrintManual(this.val$frame, 300, -1, -1, -1);
            }
        };
        ActionListener actionListener2 = new ActionListener((JFrame)serializable){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsSwingAWT.this.doPrintManual(this.val$frame, 600, -1, -1, -1);
            }
        };
        Button button = new Button("72dpi");
        button.addActionListener((ActionListener)object);
        Button button2 = new Button("300dpi");
        button2.addActionListener(actionListener);
        Button button3 = new Button("600dpi");
        button3.addActionListener(actionListener2);
        JPanel jPanel = new JPanel();
        jPanel.add(button);
        jPanel.add(button2);
        jPanel.add(button3);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new Label("South"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new Label("East"));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new Label("West"));
        Animator animator = new Animator();
        animator.add(gLJPanel);
        animator.add((GLAutoDrawable)object2);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter(quitAdapter), (NativeSurfaceHolder)gLJPanel).addTo(gLJPanel);
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter(quitAdapter), (NativeSurfaceHolder)object2).addTo((Component)object2);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)object2).addTo((Component)serializable);
        SwingUtilities.invokeAndWait(new Runnable((JFrame)serializable, jPanel, (JComponent)object3, jPanel2, jPanel3, jPanel4){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JPanel val$printPanel;
            final /* synthetic */ JComponent val$demoPanel;
            final /* synthetic */ JPanel val$southPanel;
            final /* synthetic */ JPanel val$eastPanel;
            final /* synthetic */ JPanel val$westPanel;
            {
                this.val$frame = jFrame;
                this.val$printPanel = jPanel;
                this.val$demoPanel = jComponent;
                this.val$southPanel = jPanel2;
                this.val$eastPanel = jPanel3;
                this.val$westPanel = jPanel4;
            }

            @Override
            public void run() {
                Container container = this.val$frame.getContentPane();
                container.setLayout(new BorderLayout());
                container.add((Component)this.val$printPanel, "North");
                container.add((Component)this.val$demoPanel, "Center");
                container.add((Component)this.val$southPanel, "South");
                container.add((Component)this.val$eastPanel, "East");
                container.add((Component)this.val$westPanel, "West");
                container.validate();
                this.val$frame.pack();
                this.val$frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(serializable, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLJPanel, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(object2, true));
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        Assert.assertEquals(true, animator.isAnimating());
        boolean bl3 = false;
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && (0L == duration || animator.getTotalFPSDuration() < duration)) {
            Thread.sleep(200L);
            if (bl3) continue;
            bl3 = true;
            PrintableBase printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 72, 0, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 72, 8, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 150, -1, 2048, 2048, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 150, -1, -1, -1, true);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 3, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 2, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 1, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 4, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 3, 150, -1, -1, -1, true);
            this.waitUntilPrintJobsIdle(printableBase);
            if (!allow600dpi) continue;
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 600, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
        }
        Assert.assertNotNull(serializable);
        Assert.assertNotNull(gLJPanel);
        Assert.assertNotNull(object2);
        Assert.assertNotNull(animator);
        animator.stop();
        Assert.assertEquals(false, animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable((JFrame)serializable){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void run() {
                this.val$frame.setVisible(false);
            }
        });
        Assert.assertEquals(false, ((Component)serializable).isVisible());
        SwingUtilities.invokeAndWait(new Runnable((JFrame)serializable, (JComponent)object3){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JComponent val$demoPanel;
            {
                this.val$frame = jFrame;
                this.val$demoPanel = jComponent;
            }

            @Override
            public void run() {
                JFrame jFrame = this.val$frame;
                ((Container)jFrame).remove(this.val$demoPanel);
                jFrame.dispose();
            }
        });
    }

    @Test
    public void test01_flip1_aa0() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        this.runTestGL(gLCapabilities, false, false);
    }

    @Test
    public void test01_flip1_aa0_layered() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setAlphaBits(8);
        this.runTestGL(gLCapabilities, true, false);
    }

    @Test
    public void test01_flip1_aa0_bitmap() throws InterruptedException, InvocationTargetException {
        if (Platform.OSType.WINDOWS == Platform.getOSType()) {
            GLCapabilities gLCapabilities = new GLCapabilities(glp);
            gLCapabilities.setBitmap(true);
            this.runTestGL(gLCapabilities, false, false);
        }
    }

    @Test
    public void test01_flip1_aa0_bitmap_layered() throws InterruptedException, InvocationTargetException {
        if (Platform.OSType.WINDOWS == Platform.getOSType()) {
            GLCapabilities gLCapabilities = new GLCapabilities(glp);
            gLCapabilities.setBitmap(true);
            gLCapabilities.setAlphaBits(8);
            this.runTestGL(gLCapabilities, true, false);
        }
    }

    @Test
    public void test02_flip1_aa8() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(8);
        this.runTestGL(gLCapabilities, false, false);
    }

    @Test
    public void test11_flip0_aa0() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        this.runTestGL(gLCapabilities, false, true);
    }

    @Test
    public void test11_flip0_aa0_layered() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setAlphaBits(8);
        this.runTestGL(gLCapabilities, true, true);
    }

    @Test
    public void test11_flip0_aa0_bitmap() throws InterruptedException, InvocationTargetException {
        if (Platform.OSType.WINDOWS == Platform.getOSType()) {
            GLCapabilities gLCapabilities = new GLCapabilities(glp);
            gLCapabilities.setBitmap(true);
            this.runTestGL(gLCapabilities, false, true);
        }
    }

    @Test
    public void test11_flip0_aa0_bitmap_layered() throws InterruptedException, InvocationTargetException {
        if (Platform.OSType.WINDOWS == Platform.getOSType()) {
            GLCapabilities gLCapabilities = new GLCapabilities(glp);
            gLCapabilities.setBitmap(true);
            gLCapabilities.setAlphaBits(8);
            this.runTestGL(gLCapabilities, true, true);
        }
    }

    @Test
    public void test12_flip0_aa8() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(8);
        this.runTestGL(gLCapabilities, false, true);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (stringArray[i].equals("-600dpi")) {
                allow600dpi = true;
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        if (waitForKey) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main(TestTiledPrintingGearsSwingAWT.class.getName());
    }

    static {
        duration = 500L;
    }
}

