/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.newt;

import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Screen;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSwingAWTRobotUsageBeforeJOGLInitBug411
extends UITestCase {
    static long durationPerTest = 150L;
    static Robot robot;
    static Border border;
    static JFrame frame;
    static JButton button;
    static JPanel panel;
    static JPanel colorPanel;
    static boolean windowClosing;
    boolean modLightBrighter = true;

    Color modLight(Color color) {
        Color color2 = this.modLightBrighter ? color.brighter() : color.darker();
        if (color2.equals(color)) {
            this.modLightBrighter = !this.modLightBrighter;
        }
        return color2;
    }

    @BeforeClass
    public static void setup() throws InterruptedException, InvocationTargetException, AWTException {
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.setup(): Start Pre-JOGL-Swing");
        windowClosing = false;
        border = BorderFactory.createLineBorder(Color.yellow, 2);
        panel = new JPanel();
        panel.setLayout(new BorderLayout());
        button = new JButton("Click me");
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                System.err.println("Test: " + mouseEvent);
            }
        });
        panel.add((Component)button, "North");
        colorPanel = new JPanel();
        Dimension dimension = new Dimension(400, 100);
        colorPanel.setPreferredSize(dimension);
        colorPanel.setBorder(border);
        panel.add((Component)colorPanel, "South");
        frame = new JFrame("PRE JOGL");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                windowClosing = true;
            }
        });
        frame.setContentPane(panel);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(512, 512);
                frame.setLocation(0, 0);
                frame.pack();
                frame.setVisible(true);
                colorPanel.setBackground(Color.white);
                colorPanel.repaint();
            }
        });
        robot = new Robot();
        robot.setAutoWaitForIdle(true);
        for (int i = 0; i < 20 && !frame.isVisible(); ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals(true, frame.isVisible());
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.setup(): Before NativeWindow init");
        NativeWindowFactory.initSingleton();
        AWTRobotUtil.clearAWTFocus(robot);
        AWTRobotUtil.toFrontAndRequestFocus(robot, frame);
        AWTRobotUtil.requestFocus(robot, button);
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.setup(): Before JOGL init");
        GLProfile.initSingleton();
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.setup(): End Pre-JOGL-Swing");
    }

    @AfterClass
    public static void release() throws InterruptedException, InvocationTargetException {
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.release(): Start");
        robot = null;
        Assert.assertNotNull(frame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        frame = null;
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.release(): End");
    }

    protected void runTestGL(final Canvas canvas, GLAutoDrawable gLAutoDrawable) throws AWTException, InterruptedException, InvocationTargetException {
        Dimension dimension = new Dimension(400, 400);
        canvas.setPreferredSize(dimension);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                panel.add((Component)canvas, "Center");
                frame.pack();
            }
        });
        AWTRobotUtil.toFrontAndRequestFocus(robot, frame);
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLAutoDrawable, true));
        gLAutoDrawable.addGLEventListener(new GearsES2());
        for (int i = 0; i < 100; ++i) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    colorPanel.setBackground(TestSwingAWTRobotUsageBeforeJOGLInitBug411.this.modLight(colorPanel.getBackground()));
                    colorPanel.repaint();
                }
            });
            gLAutoDrawable.display();
            Thread.sleep(10L);
        }
        colorPanel.setBackground(Color.blue);
        gLAutoDrawable.addGLEventListener(new SwingGLAction());
        Point point = canvas.getLocationOnScreen();
        point.translate(10, 10);
        robot.mouseMove((int)(point.getX() + 0.5), (int)(point.getY() + 0.5));
        robot.mousePress(16);
        int n = 0;
        while (!windowClosing && (long)n < durationPerTest / 10L) {
            point.translate(1, 1);
            robot.mouseMove((int)(point.getX() + 0.5), (int)(point.getY() + 0.5));
            Thread.sleep(10L);
            ++n;
        }
        robot.mouseRelease(16);
        n = 0;
        while (!windowClosing && (long)n < durationPerTest / 100L) {
            Thread.sleep(100L);
            ++n;
        }
        Assert.assertNotNull(canvas);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                panel.remove(canvas);
                frame.pack();
            }
        });
    }

    @Test
    public void test01NewtCanvasAWT() throws AWTException, InterruptedException, InvocationTargetException {
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.test01NewtCanvasAWT(): Start");
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setSize(100, 100);
        gLWindow.setVisible(true);
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, true));
        Screen screen = gLWindow.getScreen();
        RectangleImmutable rectangleImmutable = screen.getViewportInWindowUnits();
        gLWindow.setPosition(rectangleImmutable.getX() - 150, 0);
        gLWindow.addGLEventListener(new GearsES2());
        Animator animator = new Animator(gLWindow);
        animator.start();
        GLWindow gLWindow2 = GLWindow.create(gLCapabilities);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow2);
        animator.add(gLWindow2);
        this.runTestGL(newtCanvasAWT, gLWindow2);
        gLWindow.destroy();
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(true, animator.isAnimating());
        newtCanvasAWT.destroy();
        Assert.assertEquals(false, gLWindow2.isNativeValid());
        Assert.assertEquals(false, gLWindow.isNativeValid());
        Assert.assertEquals(true, animator.isAnimating());
        Assert.assertEquals(true, animator.stop());
        Assert.assertEquals(false, animator.isAnimating());
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.test01NewtCanvasAWT(): End");
    }

    @Test
    public void test02GLCanvas() throws AWTException, InterruptedException, InvocationTargetException {
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.test02GLCanvas(): Start");
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Animator animator = new Animator();
        animator.start();
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        animator.add(gLCanvas);
        this.runTestGL(gLCanvas, gLCanvas);
        animator.remove(gLCanvas);
        Assert.assertEquals(false, animator.isAnimating());
        Assert.assertEquals(true, animator.stop());
        System.err.println("TestSwingAWTRobotUsageBeforeJOGLInitBug411.test02GLCanvas(): End");
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestSwingAWTRobotUsageBeforeJOGLInitBug411.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        JUnitCore.main(TestSwingAWTRobotUsageBeforeJOGLInitBug411.class.getName());
    }

    class SwingGLAction
    implements GLEventListener {
        SwingGLAction() {
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            colorPanel.setBackground(TestSwingAWTRobotUsageBeforeJOGLInitBug411.this.modLight(colorPanel.getBackground()));
            colorPanel.repaint();
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    }
}

