/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.math;

import com.jogamp.common.os.Platform;
import com.jogamp.opengl.math.FloatUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestFloatUtil03InversionNOUI {
    @Test
    public void test01Ident() {
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        FloatUtil.invertMatrix(fArray4, 0, fArray, 0);
        System.err.println(FloatUtil.matrixToString(null, "inv-1: ", "%10.7f", fArray, 0, 4, 4, false));
        TestFloatUtil03InversionNOUI.invertMatrix(fArray4, 0, fArray2, 0, fArray3);
        System.err.println(FloatUtil.matrixToString(null, "inv-2: ", "%10.7f", fArray2, 0, 4, 4, false));
        Assert.assertArrayEquals("I1/I2 failure", fArray, fArray2, 1.0E-5f);
        Assert.assertArrayEquals("I2 failure", fArray4, fArray2, 1.0E-5f);
        Assert.assertArrayEquals("I1 failure", fArray4, fArray, 1.0E-5f);
    }

    private void testImpl(float[] fArray) {
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[16];
        float[] fArray5 = new float[16];
        float[] fArray6 = new float[16];
        float[] fArray7 = new float[16];
        float[] fArray8 = new float[16];
        System.err.println(FloatUtil.matrixToString(null, "orig  : ", "%10.7f", fArray, 0, 4, 4, false));
        TestFloatUtil03InversionNOUI.invertMatrix(fArray, 0, fArray2, 0, fArray8);
        TestFloatUtil03InversionNOUI.invertMatrix(fArray2, 0, fArray5, 0, fArray8);
        System.err.println(FloatUtil.matrixToString(null, "inv1_0: ", "%10.7f", fArray2, 0, 4, 4, false));
        System.err.println(FloatUtil.matrixToString(null, "inv2_0: ", "%10.7f", fArray5, 0, 4, 4, false));
        FloatUtil.invertMatrix(fArray, 0, fArray3, 0);
        FloatUtil.invertMatrix(fArray3, 0, fArray6, 0);
        System.err.println(FloatUtil.matrixToString(null, "inv1_1: ", "%10.7f", fArray3, 0, 4, 4, false));
        System.err.println(FloatUtil.matrixToString(null, "inv2_1: ", "%10.7f", fArray6, 0, 4, 4, false));
        FloatUtil.invertMatrix(fArray, fArray4);
        FloatUtil.invertMatrix(fArray4, fArray7);
        System.err.println(FloatUtil.matrixToString(null, "inv1_2: ", "%10.7f", fArray4, 0, 4, 4, false));
        System.err.println(FloatUtil.matrixToString(null, "inv2_2: ", "%10.7f", fArray7, 0, 4, 4, false));
        Assert.assertArrayEquals("I1_1/I1_2 failure", fArray3, fArray4, 1.0E-5f);
        Assert.assertArrayEquals("I2_1/I2_2 failure", fArray6, fArray7, 1.0E-5f);
        Assert.assertArrayEquals("I1_0/I1_1 failure", fArray2, fArray4, 1.0E-5f);
        Assert.assertArrayEquals("I2_0/I2_1 failure", fArray5, fArray7, 1.0E-5f);
        Assert.assertArrayEquals("I1 failure", fArray, fArray5, 1.0E-5f);
        Assert.assertArrayEquals("I2 failure", fArray, fArray7, 1.0E-5f);
        Assert.assertArrayEquals("I2 failure", fArray, fArray6, 1.0E-5f);
    }

    @Test
    public void test02() {
        float[] fArray = new float[]{2.3464675f, 0.0f, 0.0f, 0.0f, 0.0f, 2.4142134f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0002f, -1.0f, 0.0f, 0.0f, -20.002f, 0.0f};
        this.testImpl(fArray);
    }

    @Test
    public void test03() {
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -200.0f, 1.0f};
        this.testImpl(fArray);
    }

    @Test
    public void test04() {
        float[] fArray = new float[]{2.3464675f, 0.0f, 0.0f, 0.0f, 0.0f, 2.4142134f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0002f, -1.0f, 0.0f, 0.0f, -20.002f, 0.0f};
        this.testImpl(fArray);
    }

    @Test
    public void test05Perf() {
        int n;
        float[] fArray = new float[]{2.3464675f, 0.0f, 0.0f, 0.0f, 0.0f, 2.4142134f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0002f, -1.0f, 0.0f, 0.0f, -20.002f, 0.0f};
        float[] fArray2 = new float[]{26.0f, 59.0f, 143.0f, 71.0f, 59.0f, 174.0f, 730.0f, 386.0f, 143.0f, 730.0f, 9770.0f, 5370.0f, 71.0f, 386.0f, 5370.0f, 2954.0f};
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[16];
        float[] fArray5 = new float[16];
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (n = 0; n < 10; ++n) {
            TestFloatUtil03InversionNOUI.invertMatrix(fArray, 0, fArray4, 0, fArray5);
            FloatUtil.invertMatrix(fArray, 0, fArray3, 0);
            FloatUtil.invertMatrix(fArray, fArray3);
            TestFloatUtil03InversionNOUI.invertMatrix(fArray2, 0, fArray4, 0, fArray5);
            FloatUtil.invertMatrix(fArray2, 0, fArray3, 0);
            FloatUtil.invertMatrix(fArray2, fArray3);
        }
        for (n = 0; n < 1000000; ++n) {
            long l4 = Platform.currentTimeMillis();
            TestFloatUtil03InversionNOUI.invertMatrix(fArray, 0, fArray4, 0, fArray5);
            long l5 = Platform.currentTimeMillis();
            l += l5 - l4;
            FloatUtil.invertMatrix(fArray, 0, fArray3, 0);
            long l6 = Platform.currentTimeMillis();
            l2 += l6 - l5;
            FloatUtil.invertMatrix(fArray, fArray3);
            long l7 = Platform.currentTimeMillis();
            l3 += l7 - l6;
            TestFloatUtil03InversionNOUI.invertMatrix(fArray2, 0, fArray4, 0, fArray5);
            long l8 = Platform.currentTimeMillis();
            l += l8 - l7;
            FloatUtil.invertMatrix(fArray2, 0, fArray3, 0);
            long l9 = Platform.currentTimeMillis();
            l2 += l9 - l8;
            FloatUtil.invertMatrix(fArray2, fArray4);
            long l10 = Platform.currentTimeMillis();
            l3 += l10 - l9;
        }
        System.err.printf("Summary loops %6d: I1 %6d ms total, %f ms/inv%n", 1000000, l, (double)l / 1000000.0);
        System.err.printf("Summary loops %6d: I2 %6d ms total, %f ms/inv%n", 1000000, l2, (double)l2 / 1000000.0);
        System.err.printf("Summary loops %6d: I3 %6d ms total, %f ms/inv%n", 1000000, l3, (double)l3 / 1000000.0);
    }

    public static float[] invertMatrix(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3) {
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < 4; ++n5) {
            n4 = n5 * 4;
            for (n3 = 0; n3 < 4; ++n3) {
                fArray3[n4 + n3] = fArray[n4 + n3 + n];
            }
        }
        FloatUtil.makeIdentity(fArray2, n2);
        for (n5 = 0; n5 < 4; ++n5) {
            float f;
            int n6;
            int n7;
            n4 = n5 * 4;
            int n8 = n5;
            for (n3 = n5 + 1; n3 < 4; ++n3) {
                if (!(Math.abs(fArray3[n3 * 4 + n5]) > Math.abs(fArray3[n4 + n5]))) continue;
                n8 = n3;
            }
            if (n8 != n5) {
                n7 = n8 * 4;
                for (n6 = 0; n6 < 4; ++n6) {
                    f = fArray3[n4 + n6];
                    fArray3[n4 + n6] = fArray3[n7 + n6];
                    fArray3[n7 + n6] = f;
                    f = fArray2[n4 + n6 + n2];
                    fArray2[n4 + n6 + n2] = fArray2[n7 + n6 + n2];
                    fArray2[n7 + n6 + n2] = f;
                }
            }
            if (fArray3[n4 + n5] == 0.0f) {
                return null;
            }
            f = fArray3[n4 + n5];
            for (n6 = 0; n6 < 4; ++n6) {
                int n9 = n4 + n6;
                fArray3[n9] = fArray3[n9] / f;
                int n10 = n4 + n6 + n2;
                fArray2[n10] = fArray2[n10] / f;
            }
            for (n3 = 0; n3 < 4; ++n3) {
                if (n3 == n5) continue;
                n7 = n3 * 4;
                f = fArray3[n7 + n5];
                for (n6 = 0; n6 < 4; ++n6) {
                    int n11 = n7 + n6;
                    fArray3[n11] = fArray3[n11] - fArray3[n4 + n6] * f;
                    int n12 = n7 + n6 + n2;
                    fArray2[n12] = fArray2[n12] - fArray2[n4 + n6 + n2] * f;
                }
            }
        }
        return fArray2;
    }

    public static void main(String[] stringArray) {
        JUnitCore.main(TestFloatUtil03InversionNOUI.class.getName());
    }
}

