/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.awt;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.GLClearOnInitReshape;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jogamp.newt.awt.NewtFactoryAWT;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2GLJPanelAWT
extends UITestCase {
    static Dimension wsize;
    static Dimension rwsize;
    static boolean forceES2;
    static boolean forceES3;
    static boolean forceGL3;
    static boolean forceGLFFP;
    static int demoType;
    static boolean shallUsePBuffer;
    static boolean shallUseBitmap;
    static boolean useMSAA;
    static int msaaNumSamples;
    static int swapInterval;
    static boolean useAnimator;
    static boolean manualTest;
    static boolean skipGLOrientationVerticalFlip;
    static int xpos;
    static int ypos;
    static float[] reqSurfacePixelScale;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    static void setFrameSize(final JFrame jFrame, final boolean bl, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setSize(dimension);
                    if (bl) {
                        jFrame.validate();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    private void setTitle(JFrame jFrame, GLJPanel gLJPanel, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        String string = gLCapabilitiesImmutable.isBackgroundOpaque() ? "opaque" : "transl";
        java.awt.Rectangle rectangle = gLJPanel.getBounds();
        float[] fArray = gLJPanel.getMinimumSurfaceScale(new float[2]);
        float[] fArray2 = gLJPanel.getMaximumSurfaceScale(new float[2]);
        float[] fArray3 = gLJPanel.getRequestedSurfaceScale(new float[2]);
        float[] fArray4 = gLJPanel.getCurrentSurfaceScale(new float[2]);
        jFrame.setTitle("GLJPanel[" + string + "], swapI " + swapInterval + ", win: [" + rectangle.x + "/" + rectangle.y + " " + rectangle.width + "x" + rectangle.height + "], pix: " + gLJPanel.getSurfaceWidth() + "x" + gLJPanel.getSurfaceHeight() + ", scale[min " + fArray[0] + "x" + fArray[1] + ", max " + fArray2[0] + "x" + fArray2[1] + ", req " + fArray3[0] + "x" + fArray3[1] + " -> has " + fArray4[0] + "x" + fArray4[1] + "]");
    }

    protected GLEventListener createDemo(GLCapabilities gLCapabilities) {
        GLEventListener gLEventListener;
        if (1 == demoType) {
            if (gLCapabilities.isBitmap() || gLCapabilities.getGLProfile().isGL2()) {
                Gears gears = new Gears(swapInterval);
                gears.setFlipVerticalInGLOrientation(skipGLOrientationVerticalFlip);
                gLEventListener = gears;
            } else {
                GearsES2 gearsES2 = new GearsES2(swapInterval);
                gearsES2.setFlipVerticalInGLOrientation(skipGLOrientationVerticalFlip);
                gLEventListener = gearsES2;
            }
        } else {
            gLEventListener = 0 == demoType ? new GLClearOnInitReshape() : null;
        }
        return gLEventListener;
    }

    protected GLJPanel newGLJPanel(final JFrame jFrame, final GLCapabilities gLCapabilities, FPSAnimator fPSAnimator, UITestCase.SnapshotGLEventListener snapshotGLEventListener) throws AWTException, InterruptedException, InvocationTargetException {
        final GLJPanel gLJPanel = new GLJPanel(gLCapabilities);
        Assert.assertNotNull(gLJPanel);
        gLJPanel.setSkipGLOrientationVerticalFlip(skipGLOrientationVerticalFlip);
        gLJPanel.setMinimumSize(wsize);
        gLJPanel.setPreferredSize(wsize);
        gLJPanel.setSize(wsize);
        gLJPanel.setSurfaceScale(reqSurfacePixelScale);
        Object object = this.createDemo(gLCapabilities);
        if (null != object) {
            gLJPanel.addGLEventListener((GLEventListener)object);
        }
        if (null != snapshotGLEventListener) {
            gLJPanel.addGLEventListener(snapshotGLEventListener);
        }
        gLJPanel.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                TestGearsES2GLJPanelAWT.this.setTitle(jFrame, gLJPanel, gLCapabilities);
            }
        });
        this.setTitle(jFrame, gLJPanel, gLCapabilities);
        jFrame.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                TestGearsES2GLJPanelAWT.this.setTitle(jFrame, gLJPanel, gLCapabilities);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                TestGearsES2GLJPanelAWT.this.setTitle(jFrame, gLJPanel, gLCapabilities);
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        if (SwingUtilities.isEventDispatchThread()) {
            jFrame.getContentPane().add((Component)gLJPanel, "Center");
            jFrame.getContentPane().validate();
            jFrame.pack();
            jFrame.setVisible(true);
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.getContentPane().add((Component)gLJPanel, "Center");
                    jFrame.getContentPane().validate();
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
            Assert.assertEquals(true, AWTRobotUtil.waitForVisible(jFrame, true));
            Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLJPanel, true));
            object = gLJPanel.getMinimumSurfaceScale(new float[2]);
            float[] fArray = gLJPanel.getMaximumSurfaceScale(new float[2]);
            float[] fArray2 = gLJPanel.getRequestedSurfaceScale(new float[2]);
            float[] fArray3 = gLJPanel.getCurrentSurfaceScale(new float[2]);
            System.err.println("HiDPI PixelScale: min " + (float)object[0] + "x" + (float)object[1] + ", max " + fArray[0] + "x" + fArray[1] + ", req " + reqSurfacePixelScale[0] + "x" + reqSurfacePixelScale[1] + " -> val " + fArray2[0] + "x" + fArray2[1] + " -> has " + fArray3[0] + "x" + fArray3[1]);
            this.setTitle(jFrame, gLJPanel, gLCapabilities);
        }
        if (null != fPSAnimator) {
            fPSAnimator.add(gLJPanel);
            fPSAnimator.setUpdateFPSFrames(60, System.err);
        }
        return gLJPanel;
    }

    protected void destroy(final JFrame jFrame, final GLJPanel gLJPanel) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                if (null != jFrame) {
                    jFrame.setVisible(false);
                    if (null != gLJPanel) {
                        jFrame.getContentPane().remove(gLJPanel);
                    }
                    jFrame.remove(gLJPanel);
                }
                if (null != gLJPanel) {
                    gLJPanel.destroy();
                }
                if (null != jFrame) {
                    jFrame.dispose();
                }
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (null != jFrame) {
                            jFrame.setVisible(false);
                            if (null != gLJPanel) {
                                jFrame.getContentPane().remove(gLJPanel);
                            }
                            jFrame.remove(gLJPanel);
                        }
                        if (null != gLJPanel) {
                            gLJPanel.destroy();
                        }
                        if (null != jFrame) {
                            jFrame.dispose();
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void runTestGL(final GLCapabilities gLCapabilities) throws AWTException, InterruptedException, InvocationTargetException {
        long l;
        final JFrame jFrame = new JFrame("Swing GLJPanel");
        jFrame.setLocation(xpos, ypos);
        Assert.assertNotNull(jFrame);
        final FPSAnimator fPSAnimator = useAnimator ? new FPSAnimator(60) : null;
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        final GLJPanel gLJPanel = this.newGLJPanel(jFrame, gLCapabilities, fPSAnimator, snapshotGLEventListener);
        if (null != fPSAnimator) {
            fPSAnimator.start();
            Assert.assertEquals(true, fPSAnimator.isAnimating());
        }
        final Screen screen = NewtFactoryAWT.createScreen(gLJPanel, true);
        screen.addReference();
        System.err.println("GetPixelScale: AWT -> Screen: " + screen);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter(quitAdapter), (NativeSurfaceHolder)gLJPanel).addTo(gLJPanel);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)gLJPanel).addTo(jFrame);
        final JFrame[] jFrameArray = new JFrame[]{null};
        final GLJPanel[] gLJPanelArray = new GLJPanel[]{null};
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeySymbol() == 80) {
                    boolean bl;
                    System.err.println();
                    Object object = gLJPanel.getLocationOnScreen();
                    Object object2 = new Rectangle(((Point)object).x, ((Point)object).y, gLJPanel.getWidth(), gLJPanel.getHeight());
                    System.err.printf("GetPixelScale: Panel Bounds: %s window-units%n", object2.toString());
                    System.err.printf("GetPixelScale: Panel Resolution: %d x %d pixel-units%n", gLJPanel.getSurfaceWidth(), gLJPanel.getSurfaceHeight());
                    object = NewtFactoryAWT.getMonitorDevice(screen, gLJPanel);
                    System.err.printf("GetPixelScale: %s%n", ((MonitorDevice)object).toString());
                    if (keyEvent.isShiftDown()) {
                        object2 = ((MonitorDevice)object).getPixelsPerMM(((MonitorDevice)object).queryCurrentMode(), new float[2]);
                        bl = false;
                    } else {
                        object2 = ((MonitorDevice)object).getPixelsPerMM(new float[2]);
                        bl = true;
                    }
                    System.err.println("  pixel/mm [" + (float)object2[0] + ", " + (float)object2[1] + "], cached-mode " + bl);
                    System.err.println("  pixel/in [" + (float)(object2[0] * 25.4f) + ", " + (float)(object2[1] * 25.4f) + "], cached-mode " + bl);
                    System.err.println();
                } else if (keyEvent.getKeyChar() == 'x') {
                    float[] fArray = gLJPanel.getCurrentSurfaceScale(new float[2]);
                    float[] fArray2 = fArray[0] == 1.0f ? new float[]{0.0f, 0.0f} : new float[]{1.0f, 1.0f};
                    System.err.println("[set PixelScale pre]: had " + fArray[0] + "x" + fArray[1] + " -> req " + fArray2[0] + "x" + fArray2[1]);
                    gLJPanel.setSurfaceScale(fArray2);
                    float[] fArray3 = gLJPanel.getRequestedSurfaceScale(new float[2]);
                    float[] fArray4 = gLJPanel.getCurrentSurfaceScale(new float[2]);
                    System.err.println("[set PixelScale post]: " + fArray[0] + "x" + fArray[1] + " (had) -> " + fArray2[0] + "x" + fArray2[1] + " (req) -> " + fArray3[0] + "x" + fArray3[1] + " (val) -> " + fArray4[0] + "x" + fArray4[1] + " (has)");
                    TestGearsES2GLJPanelAWT.this.setTitle(jFrame, gLJPanel, gLCapabilities);
                } else if (keyEvent.getKeyChar() == 'm') {
                    boolean bl;
                    GLCapabilitiesImmutable gLCapabilitiesImmutable = gLJPanel.getChosenGLCapabilities();
                    GLCapabilities gLCapabilities2 = new GLCapabilities(gLCapabilitiesImmutable.getGLProfile());
                    gLCapabilities2.copyFrom(gLCapabilitiesImmutable);
                    if (gLCapabilitiesImmutable.getSampleBuffers()) {
                        gLCapabilities2.setSampleBuffers(false);
                        bl = false;
                    } else {
                        gLCapabilities2.setSampleBuffers(true);
                        gLCapabilities2.setNumSamples(4);
                        bl = true;
                    }
                    System.err.println("[set MSAA " + bl + " Caps had]: " + gLCapabilitiesImmutable);
                    System.err.println("[set MSAA " + bl + " Caps new]: " + gLCapabilities2);
                    System.err.println("XXX-A1: " + fPSAnimator.toString());
                    gLJPanel.setRequestedGLCapabilities(gLCapabilities2);
                    System.err.println("XXX-A2: " + fPSAnimator.toString());
                    System.err.println("XXX: " + gLJPanel.toString());
                } else if (keyEvent.getKeyChar() == 'n') {
                    System.err.println("XXX: frame2: " + jFrameArray[0]);
                    if (null != jFrameArray[0]) {
                        System.err.println("XXX: frame2.isShowing: " + jFrameArray[0].isShowing());
                    }
                    System.err.println("XXX: glJPanel2: " + gLJPanelArray[0]);
                    if (null != jFrameArray[0] && jFrameArray[0].isShowing()) {
                        TestGearsES2GLJPanelAWT.this.destroy(jFrameArray[0], gLJPanelArray[0]);
                        jFrameArray[0] = null;
                        gLJPanelArray[0] = null;
                    } else {
                        FPSAnimator fPSAnimator3;
                        jFrameArray[0] = new JFrame("GLJPanel2");
                        jFrameArray[0].setLocation(jFrame.getX() + jFrame.getWidth() + 64, jFrame.getY());
                        FPSAnimator fPSAnimator2 = fPSAnimator3 = useAnimator ? new FPSAnimator(60) : null;
                        if (null != fPSAnimator3) {
                            fPSAnimator3.start();
                        }
                        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(TestGearsES2GLJPanelAWT.this);
                        try {
                            gLJPanelArray[0] = TestGearsES2GLJPanelAWT.this.newGLJPanel(jFrameArray[0], gLCapabilities, fPSAnimator3, snapshotGLEventListener);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            TestGearsES2GLJPanelAWT.this.destroy(jFrameArray[0], gLJPanelArray[0]);
                            jFrameArray[0] = null;
                            gLJPanelArray[0] = null;
                        }
                    }
                }
            }
        };
        new AWTKeyAdapter((KeyListener)keyAdapter, (NativeSurfaceHolder)gLJPanel).addTo(gLJPanel);
        snapshotGLEventListener.setMakeSnapshot();
        if (null != rwsize) {
            Thread.sleep(500L);
            TestGearsES2GLJPanelAWT.setFrameSize(jFrame, true, rwsize);
            System.err.println("window resize pos/siz: " + gLJPanel.getX() + "/" + gLJPanel.getY() + " " + gLJPanel.getSurfaceWidth() + "x" + gLJPanel.getSurfaceHeight());
        }
        snapshotGLEventListener.setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        boolean bl = false;
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
            snapshotGLEventListener.getDisplayCount();
            if (bl || snapshotGLEventListener.getDisplayCount() <= 1) continue;
            snapshotGLEventListener.setMakeSnapshot();
            bl = true;
        }
        Assert.assertNotNull(jFrame);
        Assert.assertNotNull(gLJPanel);
        if (useAnimator) {
            Assert.assertNotNull(fPSAnimator);
            fPSAnimator.stop();
            Assert.assertEquals(false, fPSAnimator.isAnimating());
        } else {
            Assert.assertNull(fPSAnimator);
        }
        screen.removeReference();
        this.destroy(jFrame, gLJPanel);
        if (null != jFrameArray[0]) {
            this.destroy(jFrameArray[0], gLJPanelArray[0]);
        }
    }

    @Test
    public void test01_DefaultNorm() throws AWTException, InterruptedException, InvocationTargetException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get("GL3") : (forceES3 ? GLProfile.get("GLES3") : (forceES2 ? GLProfile.get("GLES2") : (forceGLFFP ? GLProfile.getMaxFixedFunc(true) : GLProfile.getDefault())));
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (useMSAA) {
            gLCapabilities.setNumSamples(msaaNumSamples);
            gLCapabilities.setSampleBuffers(true);
        }
        if (shallUsePBuffer) {
            gLCapabilities.setPBuffer(true);
        }
        if (shallUseBitmap) {
            gLCapabilities.setBitmap(true);
        }
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test02_DefaultMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test03_PbufferNorm() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setPBuffer(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test04_PbufferMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setPBuffer(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test05_BitmapNorm() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setBitmap(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test06_BitmapMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setBitmap(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test20_GLES2() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GLES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test30_GLES3() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GLES3")) {
            System.err.println("GLES3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GLES3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test40_GL3() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable("GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get("GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test99_PixelScale1_DefaultNorm() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        TestGearsES2GLJPanelAWT.reqSurfacePixelScale[0] = 1.0f;
        TestGearsES2GLJPanelAWT.reqSurfacePixelScale[1] = 1.0f;
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        int n = 640;
        int n2 = 480;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                forceES3 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-glFFP")) {
                forceGLFFP = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                xpos = MiscUtils.atoi(stringArray[++i], xpos);
                continue;
            }
            if (stringArray[i].equals("-y")) {
                ypos = MiscUtils.atoi(stringArray[++i], ypos);
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-pixelScale")) {
                float f;
                TestGearsES2GLJPanelAWT.reqSurfacePixelScale[0] = f = MiscUtils.atof(stringArray[++i], reqSurfacePixelScale[0]);
                TestGearsES2GLJPanelAWT.reqSurfacePixelScale[1] = f;
                continue;
            }
            if (stringArray[i].equals("-userVFlip")) {
                skipGLOrientationVerticalFlip = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-msaa")) {
                useMSAA = true;
                msaaNumSamples = MiscUtils.atoi(stringArray[++i], msaaNumSamples);
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-pbuffer")) {
                shallUsePBuffer = true;
                continue;
            }
            if (stringArray[i].equals("-bitmap")) {
                shallUseBitmap = true;
                continue;
            }
            if (stringArray[i].equals("-manual")) {
                manualTest = true;
                continue;
            }
            if (!stringArray[i].equals("-demo")) continue;
            demoType = MiscUtils.atoi(stringArray[++i], 0);
        }
        wsize = new Dimension(n, n2);
        if (0 < n3 && 0 < n4) {
            rwsize = new Dimension(n3, n4);
        }
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("userVFlip " + skipGLOrientationVerticalFlip);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("forceGLFFP " + forceGLFFP);
        System.err.println("useMSAA " + useMSAA + ", msaaNumSamples " + msaaNumSamples);
        System.err.println("useAnimator " + useAnimator);
        System.err.println("shallUsePBuffer " + shallUsePBuffer);
        System.err.println("shallUseBitmap " + shallUseBitmap);
        System.err.println("manualTest " + manualTest);
        System.err.println("demoType " + demoType);
        JUnitCore.main(TestGearsES2GLJPanelAWT.class.getName());
    }

    static {
        rwsize = null;
        forceES2 = false;
        forceES3 = false;
        forceGL3 = false;
        forceGLFFP = false;
        demoType = 1;
        shallUsePBuffer = false;
        shallUseBitmap = false;
        useMSAA = false;
        msaaNumSamples = 4;
        swapInterval = 0;
        useAnimator = true;
        manualTest = false;
        skipGLOrientationVerticalFlip = false;
        xpos = 10;
        ypos = 10;
        reqSurfacePixelScale = new float[]{0.0f, 0.0f};
        duration = 500L;
    }
}

