/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.av;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.junit.util.JunitTracer;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.graph.TextRendererGLELBase;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.FloatBuffer;

public class MovieSimple
implements GLEventListener {
    public static final int EFFECT_NORMAL = 0;
    public static final int EFFECT_GRADIENT_BOTTOM2TOP = 2;
    public static final int EFFECT_TRANSPARENT = 8;
    public static final String WINDOW_KEY = "window";
    public static final String PLAYER = "player";
    private static boolean waitForKey = false;
    private int surfWidth;
    private int surfHeight;
    private int prevMouseX;
    private int rotate = 0;
    private boolean orthoProjection = true;
    private float nearPlaneNormalized;
    private float zoom0;
    private float zoom1;
    private float zoom;
    private long startTime;
    private int effects = 0;
    private float alpha = 1.0f;
    private int swapInterval = 1;
    private boolean swapIntervalSet = true;
    private GLMediaPlayer mPlayer;
    private final boolean mPlayerShared;
    private boolean mPlayerScaleOrig;
    private float[] verts = null;
    private GLArrayDataServer interleavedVBO;
    private volatile boolean resetGLState = false;
    private ShaderState st;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private static final String shaderBasename = "texsequence_xxx";
    private static final String myTextureLookupName = "myTexture2D";
    public static final Uri defURI;
    final int[] textSampleCount = new int[]{4};
    private InfoTextRendererGLELBase textRendererGLEL = null;
    private boolean displayOSD = true;
    private final MouseListener mouseAction = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getY() <= MovieSimple.this.surfHeight / 2 && null != MovieSimple.this.mPlayer && 1 == mouseEvent.getClickCount()) {
                if (GLMediaPlayer.State.Playing == MovieSimple.this.mPlayer.getState()) {
                    MovieSimple.this.mPlayer.pause(false);
                } else {
                    MovieSimple.this.mPlayer.play();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getY() <= MovieSimple.this.surfHeight / 2) {
                MovieSimple.this.rotate = -1;
                MovieSimple.this.zoom = MovieSimple.this.zoom0;
                System.err.println("zoom: " + MovieSimple.this.zoom);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MovieSimple.this.prevMouseX = mouseEvent.getX();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n2 > MovieSimple.this.surfHeight / 2) {
                float f = (float)(n - MovieSimple.this.prevMouseX) / (float)MovieSimple.this.surfWidth;
                int n3 = -2 != MovieSimple.this.mPlayer.getVID() ? MovieSimple.this.mPlayer.getVideoPTS() : MovieSimple.this.mPlayer.getAudioPTS();
                MovieSimple.this.mPlayer.seek(n3 + (int)((float)MovieSimple.this.mPlayer.getDuration() * f));
            } else {
                MovieSimple.this.mPlayer.play();
                MovieSimple.this.rotate = 1;
                MovieSimple.this.zoom = MovieSimple.this.zoom1;
            }
            MovieSimple.this.prevMouseX = n;
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isShiftDown()) {
                MovieSimple.this.zoom = MovieSimple.this.zoom + mouseEvent.getRotation()[1] / 10.0f;
                System.err.println("zoom: " + MovieSimple.this.zoom);
            }
        }
    };
    private final KeyListener keyAction = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.isAutoRepeat()) {
                return;
            }
            System.err.println("MC " + keyEvent);
            int n = -2 != MovieSimple.this.mPlayer.getVID() ? MovieSimple.this.mPlayer.getVideoPTS() : MovieSimple.this.mPlayer.getAudioPTS();
            int n2 = 0;
            switch (keyEvent.getKeySymbol()) {
                case 86: {
                    switch (MovieSimple.this.swapInterval) {
                        case 0: {
                            MovieSimple.this.swapInterval = -1;
                            break;
                        }
                        case -1: {
                            MovieSimple.this.swapInterval = 1;
                            break;
                        }
                        case 1: {
                            MovieSimple.this.swapInterval = 0;
                            break;
                        }
                        default: {
                            MovieSimple.this.swapInterval = 1;
                        }
                    }
                    MovieSimple.this.swapIntervalSet = true;
                    break;
                }
                case 79: {
                    MovieSimple.this.displayOSD = !MovieSimple.this.displayOSD;
                    break;
                }
                case 151: {
                    n2 = n + 1000;
                    break;
                }
                case 150: {
                    n2 = n + 10000;
                    break;
                }
                case 16: {
                    n2 = n + 30000;
                    break;
                }
                case 149: {
                    n2 = n - 1000;
                    break;
                }
                case 152: {
                    n2 = n - 10000;
                    break;
                }
                case 11: {
                    n2 = n - 30000;
                    break;
                }
                case 2: 
                case 8: 
                case 27: {
                    MovieSimple.this.mPlayer.seek(0);
                    break;
                }
                case 32: {
                    if (GLMediaPlayer.State.Paused == MovieSimple.this.mPlayer.getState()) {
                        MovieSimple.this.mPlayer.play();
                        break;
                    }
                    MovieSimple.this.mPlayer.pause(false);
                    break;
                }
                case 141: {
                    MovieSimple.this.mPlayer.setPlaySpeed(1.0f);
                    break;
                }
                case 140: {
                    float f = MovieSimple.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f /= 2.0f) : (f -= 0.1f);
                    MovieSimple.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 139: {
                    float f = MovieSimple.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f *= 2.0f) : (f += 0.1f);
                    MovieSimple.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 77: {
                    float f = MovieSimple.this.mPlayer.getAudioVolume();
                    f = f > 0.5f ? 0.0f : 1.0f;
                    MovieSimple.this.mPlayer.setAudioVolume(f);
                }
            }
            if (0 != n2) {
                MovieSimple.this.mPlayer.seek(n2);
            }
        }
    };
    private final float zNear = 1.0f;
    private final float zFar = 10.0f;
    long lastPerfPos = 0L;
    public static final MyGLMediaEventListener myGLMediaEventListener;
    static boolean loopEOS;
    static boolean origSize;

    public MovieSimple() {
        this(null);
        this.mPlayer.addEventListener(new GLMediaPlayer.GLMediaEventListener(){

            @Override
            public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
            }

            @Override
            public void attributesChanged(GLMediaPlayer gLMediaPlayer, int n, long l) {
                System.err.println("MovieCube AttributesChanges: events_mask 0x" + Integer.toHexString(n) + ", when " + l);
                System.err.println("MovieCube State: " + gLMediaPlayer);
                if (0 != (0x40000 & n)) {
                    MovieSimple.this.resetGLState();
                }
                if (0 != (0x10 & n)) {
                    new InterruptSource.Thread(){

                        @Override
                        public void run() {
                            MovieSimple.this.mPlayer.seek(0);
                            MovieSimple.this.mPlayer.play();
                        }
                    }.start();
                }
            }
        });
        this.initStream(defURI, -1, -1, 3);
        Throwable throwable = null;
        while (null == throwable && GLMediaPlayer.State.Initialized != this.mPlayer.getState()) {
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throwable = this.mPlayer.getStreamException();
        }
        if (null != throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    public MovieSimple(GLMediaPlayer gLMediaPlayer) throws IllegalStateException {
        this.mPlayer = gLMediaPlayer;
        this.mPlayerScaleOrig = false;
        boolean bl = this.mPlayerShared = null != this.mPlayer;
        if (!this.mPlayerShared) {
            this.mPlayer = GLMediaPlayerFactory.createDefault();
            this.mPlayer.attachObject(PLAYER, this);
        }
        System.out.println("pC.1a shared " + this.mPlayerShared + ", " + this.mPlayer);
    }

    public void initStream(Uri uri, int n, int n2, int n3) {
        this.mPlayer.initStream(uri, n, n2, n3);
        System.out.println("pC.1b " + this.mPlayer);
    }

    public void setSwapInterval(int n) {
        this.swapInterval = n;
    }

    public GLMediaPlayer getGLMediaPlayer() {
        return this.mPlayer;
    }

    public void setScaleOrig(boolean bl) {
        this.mPlayerScaleOrig = bl;
    }

    public void setOrthoProjection(boolean bl) {
        this.orthoProjection = bl;
    }

    public boolean getOrthoProjection() {
        return this.orthoProjection;
    }

    public boolean hasEffect(int n) {
        return 0 != (this.effects & n);
    }

    public void setEffects(int n) {
        this.effects = n;
    }

    public void setTransparency(float f) {
        this.effects |= 8;
        this.alpha = f;
    }

    public void resetGLState() {
        this.resetGLState = true;
    }

    private void initShader(GL2ES2 gL2ES2) {
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, MovieSimple.class, "../shader", "../shader/bin", shaderBasename, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, MovieSimple.class, "../shader", "../shader/bin", shaderBasename, true);
        boolean bl = true;
        if (36197 == this.mPlayer.getTextureTarget()) {
            if (!gL2ES2.isExtensionAvailable("GL_OES_EGL_image_external")) {
                throw new GLException("GL_OES_EGL_image_external requested but not available");
            }
            if (Platform.OSType.ANDROID == Platform.getOSType() && gL2ES2.isGLES3()) {
                bl = false;
            }
        }
        shaderCode.defaultShaderCustomization(gL2ES2, bl, true);
        int n = bl ? shaderCode2.addGLSLVersion(gL2ES2) : 0;
        n = shaderCode2.insertShaderSource(0, n, this.mPlayer.getRequiredExtensionsShaderStub());
        shaderCode2.addDefaultShaderPrecision(gL2ES2, n);
        String string = this.mPlayer.getTextureLookupFunctionName(myTextureLookupName);
        shaderCode2.replaceInShaderSource(myTextureLookupName, string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("uniform ").append(this.mPlayer.getTextureSampler2DType()).append(" mgl_ActiveTexture;\n");
        stringBuilder.append(this.mPlayer.getTextureLookupFragmentShaderImpl());
        shaderCode2.insertShaderSource(0, "TEXTURE-SEQUENCE-CODE-BEGIN", 0, stringBuilder);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram(gL2ES2, shaderProgram, false);
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        Texture texture;
        Object object;
        if (null == this.mPlayer) {
            throw new InternalError("mPlayer null");
        }
        if (GLMediaPlayer.State.Uninitialized == this.mPlayer.getState()) {
            throw new IllegalStateException("mPlayer in uninitialized state: " + this.mPlayer);
        }
        boolean bl = -2 != this.mPlayer.getVID();
        this.resetGLState = false;
        this.zoom0 = this.orthoProjection ? 0.0f : -2.5f;
        this.zoom1 = this.orthoProjection ? 0.0f : -5.0f;
        this.zoom = this.zoom0;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println(JoglVersion.getGLInfo(gL2ES2, null));
        System.err.println("Alpha: " + this.alpha + ", opaque " + gLAutoDrawable.getChosenGLCapabilities().isBackgroundOpaque() + ", " + gLAutoDrawable.getClass().getName() + ", " + gLAutoDrawable);
        if (waitForKey) {
            JunitTracer.waitForKey("Init>");
        }
        try {
            System.out.println("p0 " + this.mPlayer + ", shared " + this.mPlayerShared);
            if (!this.mPlayerShared && GLMediaPlayer.State.Initialized == this.mPlayer.getState()) {
                this.mPlayer.initGL(gL2ES2);
            }
            System.out.println("p1 " + this.mPlayer + ", shared " + this.mPlayerShared);
            object = this.mPlayer.getLastTexture();
            if (null != object) {
                if (!bl) {
                    throw new InternalError("XXX: " + this.mPlayer);
                }
                texture = ((TextureSequence.TextureFrame)object).getTexture();
                if (null == texture) {
                    throw new InternalError("XXX: " + this.mPlayer);
                }
            } else {
                texture = null;
                if (bl) {
                    throw new InternalError("XXX: " + this.mPlayer);
                }
            }
            if (!this.mPlayerShared) {
                this.mPlayer.setTextureMinMagFilter(new int[]{9728, 9729});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (!this.mPlayerShared && null != this.mPlayer) {
                this.mPlayer.destroy(gL2ES2);
                this.mPlayer = null;
            }
            throw new GLException(exception);
        }
        if (bl) {
            float f;
            float f2;
            this.initShader(gL2ES2);
            this.st.useProgram(gL2ES2, true);
            object = new int[]{0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight()};
            this.pmvMatrix = new PMVMatrix();
            this.reshapePMV((int)object[2], (int)object[3]);
            this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, this.pmvMatrix.glGetPMvMatrixf());
            if (!this.st.uniform(gL2ES2, this.pmvMatrixUniform)) {
                throw new GLException("Error setting PMVMatrix in shader: " + this.st);
            }
            if (!this.st.uniform(gL2ES2, new GLUniformData("mgl_ActiveTexture", this.mPlayer.getTextureUnit()))) {
                throw new GLException("Error setting mgl_ActiveTexture in shader: " + this.st);
            }
            float f3 = gLAutoDrawable.getSurfaceWidth();
            float f4 = gLAutoDrawable.getSurfaceHeight();
            float f5 = this.mPlayer.getWidth();
            float f6 = this.mPlayer.getHeight();
            float f7 = f5 / f6;
            System.err.println("XXX0: mov aspect: " + f7);
            if (this.orthoProjection) {
                if (this.mPlayerScaleOrig && f5 < f3 && f6 < f4) {
                    f2 = f5 / 2.0f;
                    f = f2 / f7;
                } else {
                    f2 = f3 / 2.0f;
                    f = f2 / f7;
                }
            } else if (this.mPlayerScaleOrig && f5 < f3 && f6 < f4) {
                f2 = f7 * (f5 / f3);
                f = f2 / f7;
            } else {
                f2 = f7;
                f = 1.0f;
            }
            this.verts = new float[]{-1.0f * f2, -1.0f * f, 0.0f, 1.0f * f2, 1.0f * f, 0.0f};
            System.err.println("XXX0: pixel  LB: " + this.verts[0] + ", " + this.verts[1] + ", " + this.verts[2]);
            System.err.println("XXX0: pixel  RT: " + this.verts[3] + ", " + this.verts[4] + ", " + this.verts[5]);
            float[] fArray = new float[3];
            float[] fArray2 = new float[3];
            this.pmvMatrix.gluProject(this.verts[0], this.verts[1], this.verts[2], (int[])object, 0, fArray, 0);
            this.pmvMatrix.gluProject(this.verts[3], this.verts[4], this.verts[5], (int[])object, 0, fArray2, 0);
            System.err.println("XXX0: win   LB: " + fArray[0] + ", " + fArray[1] + ", " + fArray[2]);
            System.err.println("XXX0: win   RT: " + fArray2[0] + ", " + fArray2[1] + ", " + fArray2[2]);
            this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved(9, 5126, false, 12, 35044);
            this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
            this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
            this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
            this.updateInterleavedVBO(gL2ES2, texture);
            this.st.ownAttribute(this.interleavedVBO, true);
            gL2ES2.glClearColor(0.3f, 0.3f, 0.3f, 0.3f);
            gL2ES2.glEnable(2929);
            this.st.useProgram(gL2ES2, false);
            System.out.println("iVBO: " + this.interleavedVBO);
            System.out.println(this.st);
        }
        if (!this.mPlayerShared) {
            this.mPlayer.play();
            System.out.println("play.0 " + this.mPlayer);
        }
        this.startTime = System.currentTimeMillis();
        object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            window.addMouseListener(this.mouseAction);
            window.addKeyListener(this.keyAction);
            this.surfWidth = window.getSurfaceWidth();
            this.surfHeight = window.getSurfaceHeight();
        }
        int n = gLAutoDrawable.getChosenGLCapabilities().getSampleBuffers() ? 0 : 2;
        boolean bl2 = gL2ES2.isGLES();
        this.textRendererGLEL = new InfoTextRendererGLELBase(n, bl2);
        gLAutoDrawable.addGLEventListener(this.textRendererGLEL);
    }

    protected void updateInterleavedVBO(GL gL, Texture texture) {
        boolean bl = this.interleavedVBO.enabled();
        this.interleavedVBO.seal(gL, false);
        this.interleavedVBO.rewind();
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        TextureCoords textureCoords = texture.getImageTexCoords();
        System.err.println("XXX0: " + textureCoords);
        System.err.println("XXX0: tex aspect: " + texture.getAspectRatio());
        System.err.println("XXX0: tex y-flip: " + texture.getMustFlipVertically());
        floatBuffer.put(this.verts[0]);
        floatBuffer.put(this.verts[1]);
        floatBuffer.put(this.verts[2]);
        if (this.hasEffect(2)) {
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(this.alpha);
        } else {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        }
        floatBuffer.put(textureCoords.left() * 1.0f);
        floatBuffer.put(textureCoords.bottom() * 1.0f);
        floatBuffer.put(this.verts[3]);
        floatBuffer.put(this.verts[1]);
        floatBuffer.put(this.verts[2]);
        if (this.hasEffect(2)) {
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(this.alpha);
        } else {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        }
        floatBuffer.put(textureCoords.right() * 1.0f);
        floatBuffer.put(textureCoords.bottom() * 1.0f);
        floatBuffer.put(this.verts[0]);
        floatBuffer.put(this.verts[4]);
        floatBuffer.put(this.verts[2]);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(this.alpha);
        floatBuffer.put(textureCoords.left() * 1.0f);
        floatBuffer.put(textureCoords.top() * 1.0f);
        floatBuffer.put(this.verts[3]);
        floatBuffer.put(this.verts[4]);
        floatBuffer.put(this.verts[2]);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(1.0f);
        floatBuffer.put(this.alpha);
        floatBuffer.put(textureCoords.right() * 1.0f);
        floatBuffer.put(textureCoords.top() * 1.0f);
        this.interleavedVBO.seal(gL, true);
        if (!bl) {
            this.interleavedVBO.enableBuffer(gL, false);
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null == this.mPlayer) {
            return;
        }
        this.surfWidth = n3;
        this.surfHeight = n4;
        if (null != this.st) {
            this.reshapePMV(n3, n4);
            this.st.useProgram(gL2ES2, true);
            this.st.uniform(gL2ES2, this.pmvMatrixUniform);
            this.st.useProgram(gL2ES2, false);
        }
        System.out.println("pR " + this.mPlayer);
    }

    private void reshapePMV(int n, int n2) {
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        if (this.orthoProjection) {
            float f = (float)n / 2.0f;
            float f2 = (float)n2 / 2.0f;
            this.pmvMatrix.glOrthof(-f, f, -f2, f2, -1.0f, 1.0f);
            this.nearPlaneNormalized = 0.0f;
        } else {
            this.pmvMatrix.gluPerspective(45.0f, (float)n / (float)n2, 1.0f, 10.0f);
            this.nearPlaneNormalized = 0.11111111f;
        }
        System.err.println("XXX0: Perspective nearPlaneNormalized: " + this.nearPlaneNormalized);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom0);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.disposeGLEventListener(this.textRendererGLEL, true);
        this.textRendererGLEL = null;
        this.disposeImpl(gLAutoDrawable, true);
    }

    private void disposeImpl(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Object object;
        if (null == this.mPlayer) {
            return;
        }
        Object object2 = gLAutoDrawable.getUpstreamWidget();
        if (object2 instanceof Window) {
            object = (Window)object2;
            object.removeMouseListener(this.mouseAction);
            object.removeKeyListener(this.keyAction);
        }
        System.out.println("pD.1 " + this.mPlayer + ", disposePlayer " + bl);
        object = gLAutoDrawable.getGL().getGL2ES2();
        if (bl) {
            if (!this.mPlayerShared) {
                this.mPlayer.destroy((GL)object);
            }
            System.out.println("pD.X " + this.mPlayer);
            this.mPlayer = null;
        }
        this.pmvMatrixUniform = null;
        if (null != this.pmvMatrix) {
            this.pmvMatrix = null;
        }
        if (null != this.st) {
            this.st.destroy((GL2ES2)object);
            this.st = null;
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        TextureSequence.TextureFrame textureFrame;
        long l;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.swapIntervalSet) {
            int n = this.swapInterval;
            gL2ES2.setSwapInterval(n);
            gLAutoDrawable.getAnimator().resetFPSCounter();
            this.swapInterval = gL2ES2.getSwapInterval();
            System.err.println("Swap Interval: " + n + " -> " + this.swapInterval);
            this.swapIntervalSet = false;
        }
        if (null == this.mPlayer) {
            return;
        }
        if (this.resetGLState) {
            this.resetGLState = false;
            System.err.println("XXX resetGLState");
            this.disposeImpl(gLAutoDrawable, false);
            this.init(gLAutoDrawable);
            this.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        }
        if ((l = System.currentTimeMillis()) - this.lastPerfPos > 2000L) {
            System.err.println(this.mPlayer.getPerfString());
            this.lastPerfPos = l;
        }
        gL2ES2.glClear(16640);
        if (null == this.st) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom);
        if (this.rotate > 0) {
            float f = (float)(System.currentTimeMillis() - this.startTime) * 360.0f / 8000.0f;
            this.pmvMatrix.glRotatef(f, 0.0f, 0.0f, 1.0f);
        } else {
            this.rotate = 0;
        }
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.interleavedVBO.enableBuffer(gL2ES2, true);
        Texture texture = null;
        if (null != this.mPlayer && null != (textureFrame = this.mPlayerShared ? this.mPlayer.getLastTexture() : this.mPlayer.getNextTexture(gL2ES2))) {
            texture = textureFrame.getTexture();
            gL2ES2.glActiveTexture(33984 + this.mPlayer.getTextureUnit());
            texture.enable(gL2ES2);
            texture.bind(gL2ES2);
        }
        gL2ES2.glDrawArrays(5, 0, 4);
        if (null != texture) {
            texture.disable(gL2ES2);
        }
        this.interleavedVBO.enableBuffer(gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
    }

    public static void main(String[] stringArray) throws IOException, URISyntaxException {
        Uri uri;
        int n = 1;
        int n2 = 800;
        int n3 = 600;
        int n4 = 3;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n5 = -1;
        int n6 = -1;
        int n7 = 1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-windows")) continue;
            n7 = MiscUtils.atoi(stringArray[++i], n7);
        }
        int n8 = n7;
        String[] stringArray2 = new String[n8];
        String string = null;
        String string2 = null;
        boolean bl7 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-vid")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-aid")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-osize")) {
                bl7 = true;
                continue;
            }
            if (stringArray[i].equals("-textureCount")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-gldef")) {
                bl6 = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                continue;
            }
            if (stringArray[i].equals("-projection")) {
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-zoom")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-loop")) {
                loopEOS = true;
                continue;
            }
            if (stringArray[i].equals("-urlN")) {
                int n9 = MiscUtils.atoi(stringArray[++i], 0);
                stringArray2[n9] = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-url")) {
                stringArray2[0] = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-file1")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-file2")) {
                string2 = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        origSize = bl7;
        if (null != stringArray2[0]) {
            uri = Uri.cast(stringArray2[0]);
        } else if (null != string) {
            File file = new File(string);
            uri = Uri.valueOf(file);
        } else {
            uri = null != string2 ? Uri.valueOf(new File(string2)) : defURI;
        }
        System.err.println("url_s " + stringArray2[0]);
        System.err.println("file_s 1: " + string + ", 2: " + string2);
        System.err.println("stream0 " + uri);
        System.err.println("vid " + n5 + ", aid " + n6);
        System.err.println("textureCount " + n4);
        System.err.println("forceES2   " + bl3);
        System.err.println("forceES3   " + bl4);
        System.err.println("forceGL3   " + bl5);
        System.err.println("forceGLDef " + bl6);
        System.err.println("swapInterval " + n);
        GLProfile gLProfile = bl6 ? GLProfile.getDefault() : (bl5 ? GLProfile.get("GL3") : (bl4 ? GLProfile.get("GLES3") : (bl3 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2())));
        System.err.println("GLProfile: " + gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        MovieSimple[] movieSimpleArray = new MovieSimple[n8];
        GLWindow[] gLWindowArray = new GLWindow[n8];
        for (int i = 0; i < n8; ++i) {
            final Animator animator = new Animator();
            animator.start();
            gLWindowArray[i] = GLWindow.create(gLCapabilities);
            gLWindowArray[i].addWindowListener(new WindowAdapter(){

                @Override
                public void windowDestroyed(WindowEvent windowEvent) {
                    animator.stop();
                }
            });
            movieSimpleArray[i] = new MovieSimple(null);
            movieSimpleArray[i].setSwapInterval(n);
            movieSimpleArray[i].setScaleOrig(!bl2);
            movieSimpleArray[i].setOrthoProjection(bl);
            movieSimpleArray[i].mPlayer.attachObject(WINDOW_KEY, gLWindowArray[i]);
            movieSimpleArray[i].mPlayer.addEventListener(myGLMediaEventListener);
            gLWindowArray[i].setTitle("Player " + i);
            gLWindowArray[i].setSize(n2, n3);
            gLWindowArray[i].setVisible(true);
            animator.add(gLWindowArray[i]);
            Uri uri2 = 0 == i ? uri : (null != stringArray2[i] ? Uri.cast(stringArray2[i]) : defURI);
            System.err.println("Win #" + i + ": stream " + uri2);
            movieSimpleArray[i].initStream(uri2, n5, n6, n4);
        }
    }

    static {
        Uri uri = null;
        try {
            uri = Uri.cast("http://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        defURI = uri;
        myGLMediaEventListener = new MyGLMediaEventListener();
        loopEOS = false;
    }

    static class MyGLMediaEventListener
    implements GLMediaPlayer.GLMediaEventListener {
        MyGLMediaEventListener() {
        }

        void destroyWindow(final Window window) {
            new InterruptSource.Thread(){

                @Override
                public void run() {
                    window.destroy();
                }
            }.start();
        }

        @Override
        public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
        }

        @Override
        public void attributesChanged(final GLMediaPlayer gLMediaPlayer, int n, long l) {
            System.err.println("MovieSimple AttributesChanges: events_mask 0x" + Integer.toHexString(n) + ", when " + l);
            System.err.println("MovieSimple State: " + gLMediaPlayer);
            GLWindow gLWindow = (GLWindow)gLMediaPlayer.getAttachedObject(MovieSimple.WINDOW_KEY);
            MovieSimple movieSimple = (MovieSimple)gLMediaPlayer.getAttachedObject(MovieSimple.PLAYER);
            if (0 != (0x40000 & n)) {
                System.err.println("MovieSimple State: CHANGE_SIZE");
                if (origSize) {
                    gLWindow.setSurfaceSize(gLMediaPlayer.getWidth(), gLMediaPlayer.getHeight());
                }
                movieSimple.resetGLState();
            }
            if (0 != (1 & n)) {
                System.err.println("MovieSimple State: INIT");
                gLWindow.addGLEventListener(movieSimple);
                GLAnimatorControl gLAnimatorControl = gLWindow.getAnimator();
                gLAnimatorControl.setUpdateFPSFrames(60, null);
                gLAnimatorControl.resetFPSCounter();
            }
            if (0 != (4 & n)) {
                gLWindow.getAnimator().resetFPSCounter();
            }
            boolean bl = false;
            GLMediaPlayer.StreamException streamException = null;
            if (0 != (0x10 & n)) {
                streamException = movieSimple.mPlayer.getStreamException();
                if (null != streamException) {
                    System.err.println("MovieSimple State: EOS + Exception");
                    bl = true;
                } else {
                    System.err.println("MovieSimple State: EOS");
                    if (loopEOS) {
                        new InterruptSource.Thread(){

                            @Override
                            public void run() {
                                gLMediaPlayer.setPlaySpeed(1.0f);
                                gLMediaPlayer.seek(0);
                                gLMediaPlayer.play();
                            }
                        }.start();
                    } else {
                        bl = true;
                    }
                }
            }
            if (0 != (0x20 & n)) {
                streamException = movieSimple.mPlayer.getStreamException();
                if (null != streamException) {
                    System.err.println("MovieSimple State: ERR + Exception");
                } else {
                    System.err.println("MovieSimple State: ERR");
                }
                bl = true;
            }
            if (bl) {
                if (null != streamException) {
                    streamException.printStackTrace();
                }
                this.destroyWindow(gLWindow);
            }
        }
    }

    private final class InfoTextRendererGLELBase
    extends TextRendererGLELBase {
        private final Font font;
        private final float fontSize = 10.0f;
        private final GLRegion regionFPS;

        InfoTextRendererGLELBase(int n, boolean bl) {
            super(n, MovieSimple.this.textSampleCount);
            this.font = InfoTextRendererGLELBase.getFont(0, 0, 0);
            this.fontSize = 10.0f;
            this.setRendererCallbacks(RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
            if (bl) {
                this.regionFPS = null;
            } else {
                this.regionFPS = GLRegion.create(this.renderModes, null);
                System.err.println("RegionFPS " + Region.getRenderModeString(this.renderModes) + ", sampleCount " + MovieSimple.this.textSampleCount[0] + ", class " + this.regionFPS.getClass().getName());
            }
            this.staticRGBAColor[0] = 0.9f;
            this.staticRGBAColor[1] = 0.9f;
            this.staticRGBAColor[2] = 0.9f;
            this.staticRGBAColor[3] = 1.0f;
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            if (null != this.regionFPS) {
                this.regionFPS.destroy(gLAutoDrawable.getGL().getGL2ES2());
            }
            super.dispose(gLAutoDrawable);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            float f = null != gLAnimatorControl ? gLAnimatorControl.getLastFPS() : 0.0f;
            float f2 = null != gLAnimatorControl ? gLAnimatorControl.getTotalFPS() : 0.0f;
            boolean bl = -2 != MovieSimple.this.mPlayer.getVID();
            float f3 = (float)(bl ? MovieSimple.this.mPlayer.getVideoPTS() : MovieSimple.this.mPlayer.getAudioPTS()) / 1000.0f;
            int n = gLAutoDrawable.getSurfaceHeight();
            float f4 = (float)MovieSimple.this.mPlayer.getWidth() / (float)MovieSimple.this.mPlayer.getHeight();
            String string = null != this.regionFPS ? "3.1" : "3.0";
            String string2 = String.format("%0" + string + "f/%0" + string + "f s, %s (%01.2fx, vol %01.2f), a %01.2f, fps %02.1f -> %02.1f / %02.1f, v-sync %b", Float.valueOf(f3), Float.valueOf((float)MovieSimple.this.mPlayer.getDuration() / 1000.0f), MovieSimple.this.mPlayer.getState().toString().toLowerCase(), Float.valueOf(MovieSimple.this.mPlayer.getPlaySpeed()), Float.valueOf(MovieSimple.this.mPlayer.getAudioVolume()), Float.valueOf(f4), Float.valueOf(MovieSimple.this.mPlayer.getFramerate()), Float.valueOf(f), Float.valueOf(f2), MovieSimple.this.swapIntervalSet);
            String string3 = String.format("audio: id %d, kbps %d, codec %s", MovieSimple.this.mPlayer.getAID(), MovieSimple.this.mPlayer.getAudioBitrate() / 1000, MovieSimple.this.mPlayer.getAudioCodec());
            String string4 = String.format("video: id %d, kbps %d, codec %s", MovieSimple.this.mPlayer.getVID(), MovieSimple.this.mPlayer.getVideoBitrate() / 1000, MovieSimple.this.mPlayer.getVideoCodec());
            String string5 = ((MovieSimple)MovieSimple.this).mPlayer.getUri().path.decode();
            if (MovieSimple.this.displayOSD && null != this.renderer) {
                float f5 = this.font.getPixelSize(10.0f, this.dpiH);
                if (null != this.regionFPS) {
                    this.renderString(gLAutoDrawable, this.font, f5, string2, 1, 1, 0.0f, 0.0f, -1.0f, this.regionFPS);
                } else {
                    this.renderString(gLAutoDrawable, this.font, f5, string2, 1, 1, 0.0f, 0.0f, -1.0f, true);
                }
                this.renderString(gLAutoDrawable, this.font, f5, string3, 1, -4, 0.0f, (float)n, -1.0f, true);
                this.renderString(gLAutoDrawable, this.font, f5, string4, 1, -3, 0.0f, (float)n, -1.0f, true);
                this.renderString(gLAutoDrawable, this.font, f5, string5, 1, -2, 0.0f, (float)n, -1.0f, true);
            }
        }
    }
}

