/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2;

import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.FloatBuffer;

public class LandscapeES2
implements GLEventListener {
    private int swapInterval = 0;
    private boolean verbose = true;
    public static final int TARGET_FPS = 120;
    private long millisOffset;
    private int frameCount;
    private float frameRate;
    private ShaderCode vertShader;
    private ShaderCode fragShader;
    private ShaderProgram shaderProg;
    private ShaderState shaderState;
    private float[] resolution;
    private GLUniformData resolutionUni;
    private GLUniformData timeUni;
    private GLArrayDataServer vertices;
    private int fcount = 0;
    private int lastm = 0;
    private final int fint = 1;
    boolean confinedFixedCenter = false;

    public LandscapeES2(int n) {
        this.swapInterval = n;
    }

    public LandscapeES2() {
        this.swapInterval = 1;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println(Thread.currentThread() + " LandscapeES2.init ...");
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.verbose) {
            System.err.println("LandscapeES2 init on " + Thread.currentThread());
            System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
            System.err.println("INIT GL IS: " + gL2ES2.getClass().getName());
            System.err.println("GL_VENDOR: " + gL2ES2.glGetString(7936));
            System.err.println("GL_RENDERER: " + gL2ES2.glGetString(7937));
            System.err.println("GL_VERSION: " + gL2ES2.glGetString(7938));
            System.err.println("GL GLSL: " + gL2ES2.hasGLSL() + ", has-compiler-func: " + gL2ES2.isFunctionAvailable("glCompileShader") + ", version " + (gL2ES2.hasGLSL() ? gL2ES2.glGetString(35724) : "none") + ", " + gL2ES2.getContext().getGLSLVersionNumber());
            System.err.println("GL FBO: basic " + gL2ES2.hasBasicFBOSupport() + ", full " + gL2ES2.hasFullFBOSupport());
            System.err.println("GL Profile: " + gL2ES2.getGLProfile());
            System.err.println("GL Renderer Quirks:" + gL2ES2.getContext().getRendererQuirks().toString());
            System.err.println("GL:" + gL2ES2 + ", " + gL2ES2.getContext().getGLVersion());
        }
        this.vertShader = ShaderCode.create(gL2ES2, 35633, this.getClass(), "shader", "shader/bin", "landscape", true);
        this.fragShader = ShaderCode.create(gL2ES2, 35632, this.getClass(), "shader", "shader/bin", "landscape", true);
        this.vertShader.defaultShaderCustomization(gL2ES2, true, true);
        this.fragShader.defaultShaderCustomization(gL2ES2, true, true);
        this.shaderProg = new ShaderProgram();
        this.shaderProg.add(gL2ES2, this.vertShader, System.err);
        this.shaderProg.add(gL2ES2, this.fragShader, System.err);
        this.shaderState = new ShaderState();
        this.shaderState.attachShaderProgram(gL2ES2, this.shaderProg, true);
        this.resolution = new float[]{gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), 0.0f};
        this.resolutionUni = new GLUniformData("iResolution", 3, FloatBuffer.wrap(this.resolution));
        this.shaderState.ownUniform(this.resolutionUni);
        this.shaderState.uniform(gL2ES2, this.resolutionUni);
        this.timeUni = new GLUniformData("iGlobalTime", 0.0f);
        this.shaderState.ownUniform(this.timeUni);
        this.vertices = GLArrayDataServer.createGLSL("inVertex", 2, 5126, false, 4, 35044);
        this.vertices.putf(-1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(1.0f);
        this.vertices.seal(gL2ES2, true);
        this.shaderState.ownAttribute(this.vertices, true);
        this.shaderState.useProgram(gL2ES2, false);
        this.millisOffset = System.currentTimeMillis();
        System.err.println(Thread.currentThread() + " LandscapeES2.init FIN");
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        System.err.println(Thread.currentThread() + " LandscapeES2.reshape " + n + "/" + n2 + " " + n3 + "x" + n4 + ", swapInterval " + this.swapInterval + ", drawable 0x" + Long.toHexString(gLAutoDrawable.getHandle()));
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.setSwapInterval(this.swapInterval);
        this.shaderState.useProgram(gL2ES2, true);
        this.resolution[0] = gLAutoDrawable.getSurfaceWidth();
        this.resolution[1] = gLAutoDrawable.getSurfaceHeight();
        this.shaderState.uniform(gL2ES2, this.resolutionUni);
        this.shaderState.useProgram(gL2ES2, false);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println(Thread.currentThread() + " LandscapeES2.dispose ... ");
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.shaderState.useProgram(gL2ES2, false);
        this.shaderState.destroy(gL2ES2);
        this.shaderState = null;
        System.err.println(Thread.currentThread() + " LandscapeES2.dispose FIN");
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.shaderState.useProgram(gL2ES2, true);
        this.timeUni.setData((float)(System.currentTimeMillis() - this.millisOffset) / 1000.0f);
        this.shaderState.uniform(gL2ES2, this.timeUni);
        this.vertices.enableBuffer(gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.vertices.enableBuffer(gL2ES2, false);
        this.shaderState.useProgram(gL2ES2, false);
        ++this.frameCount;
        ++this.fcount;
        int n = (int)(System.currentTimeMillis() - this.millisOffset);
        if (n - this.lastm > 1000) {
            this.frameRate = (float)this.fcount / 1.0f;
            this.fcount = 0;
            this.lastm = n;
        }
        if (this.frameCount % 120 == 0) {
            System.out.println("FrameCount: " + this.frameCount + " - " + "FrameRate: " + this.frameRate);
        }
    }

    public void setConfinedFixedCenter(boolean bl) {
        this.confinedFixedCenter = bl;
    }
}

